/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.integeractivity.nsActivity;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class IntegrationShopNSActivityRedisServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(IntegrationShopNSActivityRedisServiceImpl.class);
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    private static final String NS_ACTIVITY_REDIS_KEY_PREFIX = "IntegralNSActivity_";
    private static final String NS_ACTIVITY_GOODS_REDIS_KEY_PREFIX = "IntegralNSActivityGoods_";
    private static final String NS_ACTIVITY_COUPON_REDIS_KEY_PREFIX = "IntegralNSActivityCoupon_";

    public void saveNSActivity(JSONObject activity, Long brandId, Long activityId) {
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(NS_ACTIVITY_REDIS_KEY_PREFIX + brandId + "_" + activityId), (Object)String.valueOf(activity), 60000L);
    }

    public JSONObject getNSActivity(Long brandId, Long activityId) {
        String activityStr = (String)this.redisTemplateService.stringGetStringByKey((Object)(NS_ACTIVITY_REDIS_KEY_PREFIX + brandId + "_" + activityId));
        if (StringUtils.isNotEmpty((CharSequence)activityStr)) {
            return JSON.parseObject((String)activityStr);
        }
        return null;
    }

    public void deleteNSActivity(Long brandId, Long activityId) {
        log.info("132");
        this.redisTemplateService.deleteFromRedis((Object)(NS_ACTIVITY_REDIS_KEY_PREFIX + brandId + "_" + activityId));
    }

    public void saveNSActivityGoods(Long activityId, JSONArray goods) {
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(NS_ACTIVITY_GOODS_REDIS_KEY_PREFIX + activityId), (Object)String.valueOf(goods), 604800000L);
    }

    public JSONArray getNSActivityGoods(Long activityId) {
        String activityStr = (String)this.redisTemplateService.stringGetStringByKey((Object)(NS_ACTIVITY_GOODS_REDIS_KEY_PREFIX + activityId));
        if (StringUtils.isNotEmpty((CharSequence)activityStr)) {
            return JSON.parseArray((String)activityStr);
        }
        return null;
    }

    public void deleteNSActivityGoods(Long activityId) {
        this.redisTemplateService.deleteFromRedis((Object)(NS_ACTIVITY_GOODS_REDIS_KEY_PREFIX + activityId));
    }

    public void saveNSActivityCoupons(Long activityId, JSONArray goods) {
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(NS_ACTIVITY_COUPON_REDIS_KEY_PREFIX + activityId), (Object)String.valueOf(goods), 604800000L);
    }

    public JSONArray getNSActivityCoupons(Long activityId) {
        String activityStr = (String)this.redisTemplateService.stringGetStringByKey((Object)(NS_ACTIVITY_COUPON_REDIS_KEY_PREFIX + activityId));
        if (StringUtils.isNotEmpty((CharSequence)activityStr)) {
            return JSON.parseArray((String)activityStr);
        }
        return null;
    }

    public void deleteNSActivityCoupons(Long activityId) {
        this.redisTemplateService.deleteFromRedis((Object)(NS_ACTIVITY_COUPON_REDIS_KEY_PREFIX + activityId));
    }

    @Async
    public void saveNSActivity2Redis(JSONObject activity, Long brandId) {
        Long integralActivityId = activity.getLong("integralActivityId");
        JSONArray goods = activity.getJSONArray("goodsList");
        if (CollectionUtils.isNotEmpty((Collection)goods)) {
            this.saveNSActivityGoods(integralActivityId, goods);
        }
        activity.remove((Object)"goodsList");
        JSONArray coupons = activity.getJSONArray("couponList");
        if (CollectionUtils.isNotEmpty((Collection)coupons)) {
            this.saveNSActivityCoupons(integralActivityId, coupons);
        }
        activity.remove((Object)"couponList");
        this.saveNSActivity(activity, brandId, integralActivityId);
    }

    public ResponseData deleteNSActivityAll(Long brandId, Long activityId) {
        this.deleteNSActivity(brandId, activityId);
        this.deleteNSActivityCoupons(activityId);
        this.deleteNSActivityGoods(activityId);
        return new ResponseData();
    }
}

