/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.alipay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.alipayfacade.interfaces.AlipayChannelMembersFeign;
import com.bizvane.alipayfacade.models.enums.AlipayPublicTypeEnum;
import com.bizvane.alipayfacade.models.vo.AlipayChannelInfoVo;
import com.bizvane.appletservice.interfaces.FitmentService;
import com.bizvane.appletservice.interfaces.MembershipCardService;
import com.bizvane.appletservice.interfaces.alipay.AlipayMemberCenterService;
import com.bizvane.appletservice.models.bo.AppletBrandMenberBo;
import com.bizvane.appletservice.models.bo.AppletBtfBo;
import com.bizvane.appletservice.models.bo.MemberCardLevelModelBo;
import com.bizvane.appletservice.models.po.AppletVipCartPO;
import com.bizvane.appletserviceimpl.mappers.AppletBrandTemplateRelPOMapper;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.members.facade.models.MemberCardLevelModel;
import com.bizvane.members.facade.models.MembersSysModel;
import com.bizvane.members.facade.service.api.MemberCardProgramApiService;
import com.bizvane.members.facade.service.api.MemberLevelApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlipayMemberCenterServiceImpl
implements AlipayMemberCenterService {
    private static final Logger log = LoggerFactory.getLogger(AlipayMemberCenterServiceImpl.class);
    @Resource
    private AppletBrandTemplateRelPOMapper appletBrandTemplateRelPoMapper;
    @Autowired
    private MembershipCardService membershipCardService;
    @Autowired
    private MemberCardProgramApiService memberCardProgramApiService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private MemberLevelApiService memberLevelApiService;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private FitmentService fitmentService;
    @Autowired
    private AlipayChannelMembersFeign alipayChannelMembersFeign;

    public ResponseData<AppletBtfBo> getHomePage(AppletBrandMenberBo appletBrandMenberBo, HttpServletRequest request) {
        log.info("AlipayMemberCenterServiceImpl#getHomePage#appletBrandMenberBo:{}", (Object)JSON.toJSONString((Object)appletBrandMenberBo));
        ResponseData responseData = new ResponseData();
        AppletBtfBo appletBtfBo = new AppletBtfBo();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        log.info("AlipayMemberCenterServiceImpl#getHomePage#bizvaneSessionId={}", (Object)bizvaneSessionId);
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode) && StringUtils.isNotBlank((CharSequence)appletBrandMenberBo.getOderMemberCode())) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        log.info("AlipayMemberCenterServiceImpl#getHomePage#memberCode:{}", (Object)memberCode);
        appletBrandMenberBo.setMemberCode(memberCode);
        if (appletBrandMenberBo.getSysBrandId() == 0L) {
            return this.returnMessage(false, null);
        }
        appletBtfBo = this.appletBrandTemplateRelPoMapper.selectTemplateCode(appletBrandMenberBo.getSysBrandId());
        if (StringUtils.isNotBlank((CharSequence)memberCode)) {
            String userId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getUserId" + bizvaneSessionId));
            String appid = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
            String sysBrandId = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "sysBrandId"));
            log.info("AlipayMemberCenterServiceImpl#userId={},appid={},sysBrandId={},memberCode={}", new Object[]{userId, appid, sysBrandId, appletBrandMenberBo.getMemberCode()});
            String phoneRedis = (String)this.redisTemplateService.stringGetStringByKey((Object)("Phone:" + memberCode));
            log.info("Phone:" + phoneRedis + "||\u4f1a\u5458code:" + memberCode + "||bizvaneSessionId:" + bizvaneSessionId);
            if (StringUtils.isBlank((CharSequence)userId) || StringUtils.isBlank((CharSequence)appid)) {
                responseData.setMessage("\u6307\u6807\u5931\u6548");
                responseData.setCode(-100);
                return responseData;
            }
            ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(appletBrandMenberBo.getMemberCode());
            MemberCardLevelModel data = (MemberCardLevelModel)modelResponseData.getData();
            if (data == null) {
                responseData.setMessage("\u67e5\u8be2\u4f1a\u5458\u5361\u4f1a\u5458\u7b49\u7ea7\u5f02\u5e38");
                responseData.setCode(-100);
                return responseData;
            }
            Long levelId = data.getLevelId();
            if (levelId == null) {
                responseData.setMessage("\u6ca1\u6709\u5f00\u5361\u7b49\u7ea7");
                responseData.setCode(100);
                return responseData;
            }
            AlipayChannelInfoVo alipayChannelInfoVo = new AlipayChannelInfoVo();
            alipayChannelInfoVo.setAppid(appid);
            alipayChannelInfoVo.setSysBrandId(appletBrandMenberBo.getSysBrandId());
            alipayChannelInfoVo.setUserId(userId);
            alipayChannelInfoVo.setAlipayPublicType(AlipayPublicTypeEnum.MINI.getCode());
            ResponseData alipayChannelInfoVoResponseData = this.alipayChannelMembersFeign.getAlipayChannelMemberInfo(alipayChannelInfoVo);
            log.info("AlipayLoginServiceImpl#getHomePage#alipayChannelInfoVoResponseData:{}", (Object)JSONObject.toJSONString((Object)alipayChannelInfoVoResponseData));
            if (((AlipayChannelInfoVo)alipayChannelInfoVoResponseData.getData()).getAlipayChannelMembersId() == null) {
                responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
                responseData.setCode(-100);
                return responseData;
            }
            MemberCardLevelModelBo memberCardLevelModelBo = new MemberCardLevelModelBo();
            BeanUtils.copyProperties((Object)data, (Object)memberCardLevelModelBo);
            memberCardLevelModelBo.setWxHeadPortraits(((AlipayChannelInfoVo)alipayChannelInfoVoResponseData.getData()).getAvatar());
            memberCardLevelModelBo.setWxNick(((AlipayChannelInfoVo)alipayChannelInfoVoResponseData.getData()).getNickname());
            ResponseData listResponseData = this.membershipCardService.selectByPrimaryKey(levelId);
            if (listResponseData.getData() != null) {
                for (AppletVipCartPO appletVipCartPo : (List)listResponseData.getData()) {
                    if (appletVipCartPo.getCardStyle() != null) {
                        if (appletVipCartPo.getIsImg().booleanValue()) {
                            appletBtfBo.setImg(appletVipCartPo.getIsImg());
                            appletBtfBo.setCardStyle(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)appletVipCartPo.getCardStyle()));
                        } else {
                            appletBtfBo.setCardStyle(appletVipCartPo.getCardStyle());
                        }
                    }
                    appletBtfBo.setFontColor(appletVipCartPo.getFontColor());
                }
            }
            appletBtfBo.setMemberCardLevelModelBo(memberCardLevelModelBo);
        } else {
            ResponseData queryMemberSys = this.memberLevelApiService.queryMemberSys(appletBrandMenberBo.getSysBrandId());
            Long levelId = queryMemberSys.getData() == null || ((MembersSysModel)queryMemberSys.getData()).getNewLevelId() == null ? Long.valueOf(0L) : ((MembersSysModel)queryMemberSys.getData()).getNewLevelId();
            ResponseData listResponseData = this.membershipCardService.selectByPrimaryKey(levelId);
            for (AppletVipCartPO appletVipCartPo : (List)listResponseData.getData()) {
                if (appletVipCartPo.getCardStyle() == null) continue;
                if (appletVipCartPo.getIsImg().booleanValue()) {
                    appletBtfBo.setImg(appletVipCartPo.getIsImg());
                    appletBtfBo.setCardStyle(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)appletVipCartPo.getCardStyle()));
                    continue;
                }
                appletBtfBo.setCardStyle(appletVipCartPo.getCardStyle());
            }
        }
        ResponseData appletResources = this.fitmentService.getIsShareImg(appletBrandMenberBo.getSysBrandId());
        log.info("AlipayMemberCenterServiceImpl#getHomePage#appletResources \u51fa\u53c2\uff1a{}", appletResources.getData());
        if (appletResources.getData() != null) {
            appletBtfBo.setModularContent(this.qiNiuConfig.getDomain() + appletResources.getData().toString());
        }
        appletBtfBo.setMemberCode(memberCode);
        log.info("AlipayMemberCenterServiceImpl#getHomePage#appletBtfBo:{}", (Object)JSON.toJSONString((Object)appletBtfBo));
        return this.returnMessage(true, (Object)appletBtfBo);
    }

    private ResponseData returnMessage(boolean isSuccess, Object data) {
        ResponseData responseData = new ResponseData();
        if (isSuccess) {
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData(data);
        } else {
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setData(data);
        }
        return responseData;
    }
}

