/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.alipay;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.common.HttpUtil;
import com.bizvane.appletservice.interfaces.AliPayService;
import com.bizvane.appletservice.models.po.SysRechargeOrderPoExample;
import com.bizvane.appletservice.models.po.SysRechargeOrderPoWithBLOBs;
import com.bizvane.appletservice.models.vo.AlipayCallBackVO;
import com.bizvane.appletservice.models.vo.CreateRechargeVO;
import com.bizvane.appletservice.models.vo.UnionPay2MQVo;
import com.bizvane.appletserviceimpl.common.PayOrderStatusEnum;
import com.bizvane.appletserviceimpl.common.RechargeTypeEnum;
import com.bizvane.appletserviceimpl.controllers.yw.StandardBSRechargeBrandIds;
import com.bizvane.appletserviceimpl.enums.OrderNoGeneratePrefixEnum;
import com.bizvane.appletserviceimpl.impl.alipay.FusionPayService;
import com.bizvane.appletserviceimpl.mappers.SysRechargeOrderPoMapper;
import com.bizvane.appletserviceimpl.utils.MD5Utils;
import com.bizvane.appletserviceimpl.utils.WxConfig;
import com.bizvane.base.common.bean.PayBusinessTypeEnum;
import com.bizvane.base.common.bean.PayPackageResult;
import com.bizvane.base.common.bean.ResultBean;
import com.bizvane.base.remote.service.IRemoteBusinessPayService;
import com.bizvane.base.remote.service.IRemotePayService;
import com.bizvane.centercontrolservice.models.enums.FusionPayBusinessChannelEnum;
import com.bizvane.centercontrolservice.models.enums.FusionPayBusinessTypeEnum;
import com.bizvane.centercontrolservice.models.po.SysFusionPayBusinessPlatformHistoryPo;
import com.bizvane.centercontrolservice.models.vo.BrandBusinessFusionPayAppletRequestVo;
import com.bizvane.centercontrolservice.models.vo.BrandBusinessFusionPayAppletVo;
import com.bizvane.centercontrolservice.rpc.BrandBusinessFusionPayRpcService;
import com.bizvane.centercontrolservice.rpc.SysCompanyFusionPayRecordServiceRpc;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.customized.facade.utils.UUIDUtil;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.serviceCard.interfaces.GiftCardStandardServiceFeign;
import com.bizvane.serviceCard.models.dto.giftCard.ReqGiftCardInfoDTO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.redisutils.RedissonTemplate;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatenterprise.service.common.DateUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AliPayServiceImpl
implements AliPayService {
    private static final Logger log = LoggerFactory.getLogger(AliPayServiceImpl.class);
    @Autowired
    private FusionPayService fusionPayService;
    @Autowired
    private IRemotePayService iRemotePayService;
    @Autowired
    private StandardBSRechargeBrandIds standardBSRechargeBrandIds;
    private static final String PRIVATE_PURCHASE = "\u79c1\u4eba\u8d2d\u4e70";
    private static final String CALLBACK_FAIL = "FAIL";
    private static final String CALLBACK_SUCCESS = "SUCCESS";
    private static final String TIME_FORMATTER = "yyyy-MM-dd HH:mm:ss";
    @Autowired
    private WxConfig wxConfig;
    @Autowired
    MemberInfoApiService memberInfoApiService;
    @Autowired
    RocketMQTemplate rocketMQTemplate;
    @Autowired
    BrandServiceRpc brandServiceRpc;
    @Autowired
    private GiftCardStandardServiceFeign giftCardStandardServiceFeign;
    @Autowired
    private RedissonTemplate redissonTemplate;
    @Autowired
    private SysRechargeOrderPoMapper sysRechargeOrderPoMapper;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private SysCompanyFusionPayRecordServiceRpc sysCompanyFusionPayRecordServiceRpc;
    @Autowired
    private BrandBusinessFusionPayRpcService brandBusinessFusionPayRpcService;
    @Autowired
    private IRemoteBusinessPayService iRemoteBusinessPayService;
    @Value(value="${wxStore.baseUrl}")
    private String DOMAINNAME;
    private static final String WX_CALL_BACK = "api/notifyCallBackUnion/payGateway";

    private Integer getCentAmount(String amount, String appId) {
        Integer value = null;
        String testBrand = this.wxConfig.getTestBrand();
        if (StringUtils.isNotEmpty((CharSequence)testBrand)) {
            List<String> ids = Arrays.asList(testBrand.split(","));
            if (ids.contains(appId)) {
                value = Integer.parseInt(amount);
            } else {
                Integer integer = Integer.valueOf(amount);
                value = integer * this.wxConfig.getMoneyCode();
            }
        }
        return value;
    }

    private String getAttach(CreateRechargeVO vo, MemberInfoModel model) {
        HashMap<String, String> attachMap = new HashMap<String, String>();
        attachMap.put("m", vo.getGiveMoney());
        attachMap.put("mC", model.getMemberCode());
        attachMap.put("aid", vo.getActivityId());
        attachMap.put("bid", model.getBrandId().toString());
        attachMap.put("cid", model.getSysCompanyId().toString());
        if (vo.getMbrRechargeExplainId() != null) {
            attachMap.put("mbrRechargeExplainId", vo.getMbrRechargeExplainId().toString());
        }
        return JSONObject.toJSONString(attachMap);
    }

    public ResponseData createRechargeOrder(CreateRechargeVO vo, SysBrandPo brandPo, MemberInfoModel model, String appId) {
        BrandBusinessFusionPayAppletRequestVo brandBusinessFusionPayAppletRequestVo = new BrandBusinessFusionPayAppletRequestVo();
        brandBusinessFusionPayAppletRequestVo.setSysBrandId(brandPo.getSysBrandId());
        brandBusinessFusionPayAppletRequestVo.setBusinessMethodCode(FusionPayBusinessTypeEnum.ALIPAY.getCode());
        if (brandPo.getOrganizationWithdrawSwitch().booleanValue() && Integer.valueOf(2).equals(brandPo.getOrganizationWithdrawType())) {
            brandBusinessFusionPayAppletRequestVo.setSourceType(vo.getPetCardSourceType());
            brandBusinessFusionPayAppletRequestVo.setOrganizationCode(vo.getPetCardOrgCode());
        } else {
            brandBusinessFusionPayAppletRequestVo.setSourceType(Integer.valueOf(1));
            brandBusinessFusionPayAppletRequestVo.setOrganizationCode(null);
        }
        if (brandPo.getNewPayConfigSwitch().booleanValue()) {
            log.info("\u8fdb\u5165\u65b0\u652f\u4ed8\u914d\u7f6e,\u54c1\u724c\u540d\u79f0:{}", (Object)brandPo.getBrandName());
            brandBusinessFusionPayAppletRequestVo.setBusinessChannelCode(FusionPayBusinessChannelEnum.CRM_PAY.getCode());
        } else {
            brandBusinessFusionPayAppletRequestVo.setBusinessChannelCode(FusionPayBusinessChannelEnum.RECHARGE.getCode());
        }
        ResponseData brandBusinessFusionPayAppletVoRes = this.brandBusinessFusionPayRpcService.getBrandBusinessFusionPayAppletVo(brandBusinessFusionPayAppletRequestVo);
        log.info("brandBusinessFusionPayAppletVoRes:{}", (Object)JacksonUtil.bean2Json((Object)brandBusinessFusionPayAppletVoRes));
        if (SysResponseEnum.SUCCESS.getCode() != brandBusinessFusionPayAppletVoRes.getCode()) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u652f\u4ed8\u7e41\u5fd9,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        if (brandBusinessFusionPayAppletVoRes.getData() == null) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u5145\u503c\u652f\u4ed8\u8fd8\u6ca1\u6709\u542f\u7528,\u65e0\u6cd5\u5145\u503c");
        }
        BrandBusinessFusionPayAppletVo businessFusionPayAppletVo = (BrandBusinessFusionPayAppletVo)brandBusinessFusionPayAppletVoRes.getData();
        String bizvaneMerchantId = businessFusionPayAppletVo.getBizvaneMerchantId();
        String PAY_TYPE = businessFusionPayAppletVo.getPlatformPayTypeCode();
        String salt = businessFusionPayAppletVo.getBizvaneSecretKey();
        String buyerUserId = vo.getUserId();
        String cryptData = MD5Utils.encode((String)(bizvaneMerchantId + PAY_TYPE), (String)salt).toUpperCase();
        String serialNumber = AliPayServiceImpl.getSerialNumber((OrderNoGeneratePrefixEnum)OrderNoGeneratePrefixEnum.CHUZHI_CARD_ONLINE_NEW);
        Integer totalFee = this.getCentAmount(vo.getMoney(), appId);
        String attach = this.getAttach(vo, model);
        String detail = "\u8d2d\u4e70\u50a8\u503c\u5361";
        String spbillCreateIp = "";
        String subject = "\u50a8\u503c\u5361";
        log.info("createRechargeOrder cryptData:{},totalFee:{},attach:{}", new Object[]{cryptData, totalFee, attach});
        ResultBean preOrderResult = this.iRemoteBusinessPayService.createPreOrder(bizvaneMerchantId, serialNumber, "", model.getName(), "\u79c1\u4eba\u8d2d\u4e70", buyerUserId, subject, totalFee, spbillCreateIp, detail, PAY_TYPE, attach, cryptData, PayBusinessTypeEnum.MBR_CENTER_RECHARGE_CARD.getType());
        log.info("createRechargeOrder resp:{}", (Object)JSONObject.toJSONString((Object)preOrderResult));
        if (Boolean.FALSE.equals(preOrderResult.getSuccess()) || Boolean.TRUE.equals(preOrderResult.getSuccess()) && "FAIL".equals(((PayPackageResult)preOrderResult.getResult()).getResultCode())) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u8c03\u7528\u652f\u4ed8\u670d\u52a1\u5f02\u5e38,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        PayPackageResult result = (PayPackageResult)preOrderResult.getResult();
        this.insertRechargeOrder(vo, model, serialNumber, totalFee, result, attach, buyerUserId, businessFusionPayAppletVo);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("payPackageResult", result);
        map.put("billNumber", serialNumber);
        String redisAttchKey = "recharge_attch" + result.getTransactionId();
        this.redisTemplateService.stringSetValueAndExpireTime((Object)redisAttchKey, (Object)attach, 10800000L);
        return new ResponseData(map);
    }

    private void insertRechargeOrder(CreateRechargeVO vo, MemberInfoModel model, String serialNumber, Integer totalFee, PayPackageResult result, String attach, String userId, BrandBusinessFusionPayAppletVo businessFusionPayAppletVo) {
        SysRechargeOrderPoWithBLOBs preOrder = new SysRechargeOrderPoWithBLOBs();
        preOrder.setBizvaneTradeNo(result.getBizvaneTradeNo());
        preOrder.setCreateDate(new Date());
        preOrder.setGiveMoney(new BigDecimal(vo.getGiveMoney()));
        preOrder.setOutTradeNo(serialNumber);
        preOrder.setMemberCode(model.getMemberCode());
        preOrder.setOpenId(userId);
        preOrder.setPayType(RechargeTypeEnum.ALI_PAY.getCode());
        preOrder.setRechargeMoney(new BigDecimal(vo.getMoney()));
        preOrder.setStatus(PayOrderStatusEnum.WAIT_PAY.getCode());
        preOrder.setSysCompanyId(model.getSysCompanyId());
        preOrder.setSysBrandId(model.getBrandId());
        preOrder.setAttach(attach);
        preOrder.setTotalFee(totalFee);
        preOrder.setAppId(result.getAppid());
        preOrder.setBizvaneMerchantId(businessFusionPayAppletVo.getBizvaneMerchantId());
        preOrder.setMbrPetCardNo(vo.getPetCardNo());
        preOrder.setMbrPetCardSourceType(vo.getPetCardSourceType());
        preOrder.setMbrPetCardOrgCode(vo.getPetCardOrgCode());
        RechargeTypeEnum rechargeTypeEnum = RechargeTypeEnum.getRechargeTypeEnumByPayChannelCode((String)businessFusionPayAppletVo.getPlatformPayTypeCode());
        if (rechargeTypeEnum != null) {
            log.info("\u652f\u4ed8\u7c7b\u578b\u679a\u4e3e:{}", (Object)rechargeTypeEnum.toString());
            preOrder.setPayType(rechargeTypeEnum.getCode());
        }
        this.sysRechargeOrderPoMapper.insertSelective(preOrder);
    }

    private static String getSerialNumber(OrderNoGeneratePrefixEnum enu) {
        String format = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        return enu.getSufixValue() + format + UUIDUtil.getUUID().substring(0, 4);
    }

    private static boolean isGitfCard(String outTradeNo) {
        if (StringUtils.isNotEmpty((CharSequence)outTradeNo)) {
            String sufixValue = outTradeNo.substring(0, 2);
            return sufixValue.equals(OrderNoGeneratePrefixEnum.SERVICE_GIFT.getSufixValue());
        }
        throw new RuntimeException("\u8ba2\u5355\u53f7\u662f\u7a7a\u7684");
    }

    public ResponseData<String> execGitfCardService(String out_trade_no, String total_fee, String transaction_id, String attachStr) {
        ResponseData responseData = new ResponseData();
        com.alibaba.fastjson.JSONObject attach = JSON.parseObject((String)attachStr);
        String serviceDefinitionId = attach.getString("did");
        String cardNo = attach.getString("Co");
        String sysBrandId = attach.getString("bid");
        String sysCompanyId = attach.getString("cid");
        String memberCode = attach.getString("mC");
        ReqGiftCardInfoDTO dto = new ReqGiftCardInfoDTO();
        dto.setSysCompanyId(Long.valueOf(Long.parseLong(sysCompanyId)));
        dto.setSysBrandId(Long.valueOf(Long.parseLong(sysBrandId)));
        dto.setMemberCode(memberCode);
        dto.setCardGiftDefinitionId(Long.valueOf(Long.parseLong(serviceDefinitionId)));
        dto.setGiftCardNo(cardNo);
        dto.setGiftCardId(attach.getLong("gfcid"));
        log.info("\u8bf7\u6c42service-card\u66f4\u65b0\u8ba2\u5355\u72b6\u6001:{}", (Object)JSON.toJSONString((Object)dto));
        ResponseData paied = this.giftCardStandardServiceFeign.paied(dto);
        if (paied.getCode() != 0) {
            log.info("\u4fee\u6539service-card \u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u4ed8\u6b3e \u5931\u8d25:{}", (Object)paied.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setData((Object)"FAIL");
            return responseData;
        }
        responseData.setData((Object)"SUCCESS");
        return responseData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseData<String> alipayRechargeCallBack(AlipayCallBackVO vo) throws Exception {
        ResponseData responseData = new ResponseData();
        if (PayBusinessTypeEnum.MBR_CENTER_INTEGRAL_MALL.getType().equals(vo.getPayBusinessType())) {
            return this.getBizvaneMallCallBack(vo);
        }
        ResponseData fusionPayHistoryByMerchantIdAndPayType = this.sysCompanyFusionPayRecordServiceRpc.getFusionPayHistoryByMerchantIdAndPayType(vo.getBizvaneMid(), vo.getPayType());
        int code = fusionPayHistoryByMerchantIdAndPayType.getCode();
        SysFusionPayBusinessPlatformHistoryPo data = (SysFusionPayBusinessPlatformHistoryPo)fusionPayHistoryByMerchantIdAndPayType.getData();
        if (code != SysResponseEnum.SUCCESS.getCode() || data == null) {
            log.info("alipayRechargeCallBack \u67e5\u8be2\u652f\u4ed8\u7f51\u5173\u914d\u7f6e\u5931\u8d25!");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setData((Object)"FAIL");
            return responseData;
        }
        String bizvaneSecretKey = data.getBizvaneSecretKey();
        String payType = vo.getPayType();
        String sign = MD5Utils.encode((String)(vo.getBizvaneMid() + payType), (String)bizvaneSecretKey).toUpperCase();
        if (!vo.getCryptData().equals(sign)) {
            log.info("alipayRechargeCallBack \u9a8c\u7b7e\u5931\u8d25");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setData((Object)"FAIL");
            return responseData;
        }
        Long sysBrandId = data.getSysBrandId();
        try {
            List<String> ids;
            String redisAttchKey = "recharge_attch" + vo.getTransactionid();
            String attch = (String)this.redisTemplateService.stringGetStringByKey((Object)redisAttchKey);
            JSONObject attachObj = JSONObject.parseObject((String)attch);
            ResponseData brandResp = this.brandServiceRpc.getBrandByID(sysBrandId);
            if (brandResp.getCode() == SysResponseEnum.FAILED.getCode() || brandResp.getData() == null) {
                log.info("alipayRechargeCallBack \u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u9519\u8bef");
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(SysResponseEnum.FAILED.getMessage());
                responseData.setData((Object)"FAIL");
                ResponseData responseData2 = responseData;
                return responseData2;
            }
            SysBrandPo brandInfo = (SysBrandPo)brandResp.getData();
            log.info("\u8ba2\u5355\u53f7\u662f:{}", (Object)vo.getOutTradeNo());
            if (AliPayServiceImpl.isGitfCard((String)vo.getOutTradeNo())) {
                ResponseData responseData3 = this.execGitfCardService(vo.getOutTradeNo(), vo.getTotalFee(), vo.getTransactionid(), vo.getAttach());
                return responseData3;
            }
            this.redissonTemplate.getRLock(sysBrandId + vo.getTransactionid(), 90L, TimeUnit.SECONDS);
            SysRechargeOrderPoExample example = new SysRechargeOrderPoExample();
            example.createCriteria().andBizvaneTradeNoEqualTo(vo.getBizvaneTradeNo()).andOutTradeNoEqualTo(vo.getOutTradeNo()).andSysBrandIdEqualTo(sysBrandId);
            List poWithBLOBs = this.sysRechargeOrderPoMapper.selectByExampleWithBLOBs(example);
            if (CollectionUtils.isEmpty((Collection)poWithBLOBs)) {
                log.info("unionRechargeCallBack \u67e5\u8be2\u9884\u5145\u503c\u5355\u6d41\u6c34\u5931\u8d25");
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(SysResponseEnum.FAILED.getMessage());
                responseData.setData((Object)"FAIL");
                ResponseData responseData4 = responseData;
                return responseData4;
            }
            SysRechargeOrderPoWithBLOBs po = (SysRechargeOrderPoWithBLOBs)poWithBLOBs.get(0);
            if (!PayOrderStatusEnum.WAIT_PAY.getCode().equals(po.getStatus())) {
                log.info("unionRechargeCallBack \u5df2\u652f\u4ed8 \u652f\u4ed8\u670d\u52a1\u91cd\u590d\u8c03\u7528");
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(SysResponseEnum.FAILED.getMessage());
                responseData.setData((Object)"FAIL");
                ResponseData responseData5 = responseData;
                return responseData5;
            }
            Double money = Double.parseDouble(vo.getTotalFee()) / (double)this.wxConfig.getMoneyCode().intValue();
            String testBrand = this.wxConfig.getTestBrand();
            if (StringUtils.isNotEmpty((CharSequence)testBrand) && (ids = Arrays.asList(testBrand.split(","))).contains(po.getAppId())) {
                money = money * 100.0;
            }
            String memberCode = String.valueOf(attachObj.get((Object)"mC"));
            MemberInfoModel member = this.getMemberInfoModel(brandInfo, memberCode);
            Integer status = null;
            for (PayOrderStatusEnum value : PayOrderStatusEnum.values()) {
                if (!value.getMessage().equals(vo.getPayStatus())) continue;
                status = value.getCode();
            }
            Object mbrRechargeExplainIdObj = attachObj.get((Object)"mbrRechargeExplainId");
            Long mbrRechargeExplainId = null;
            if (mbrRechargeExplainIdObj != null && StringUtils.isNotBlank((CharSequence)mbrRechargeExplainIdObj.toString()) && !"null".equals(mbrRechargeExplainIdObj.toString())) {
                mbrRechargeExplainId = Long.valueOf(attachObj.get((Object)"mbrRechargeExplainId").toString());
            }
            po.setPlatSerialNum(vo.getTransactionid());
            po.setStatus(status);
            po.setModifiedDate(new Date());
            po.setPayServiceStatus(vo.getPayStatus());
            int count = this.sysRechargeOrderPoMapper.updateByPrimaryKeySelective(po);
            if (count == 0) {
                PayOrderStatusEnum value;
                log.info("unionRechargeCallBack \u66f4\u65b0\u5145\u503c\u6d41\u6c34\u72b6\u6001\u5931\u8d25");
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(SysResponseEnum.FAILED.getMessage());
                responseData.setData((Object)"FAIL");
                value = responseData;
                return value;
            }
            if (PayOrderStatusEnum.PAY_SUCCESS.getMessage().equals(vo.getPayStatus())) {
                String activityId = String.valueOf(attachObj.get((Object)"aid"));
                UnionPay2MQVo mqMessage = UnionPay2MQVo.builder().cardNo(member.getCardNo()).createDate(DateUtil.parse((String)vo.getTimeEnd(), (String)"yyyy-MM-dd HH:mm:ss")).erpId(member.getErpId()).giveMoney((Double)ObjectUtils.defaultIfNull((Object)po.getGiveMoney().doubleValue(), (Object)0.0)).rechargeMoney(money).levelId(member.getLevelId()).memberCode(member.getMemberCode()).paymentDate(DateUtil.parse((String)vo.getTimeEnd(), (String)"yyyy-MM-dd HH:mm:ss")).name(member.getName()).payId(StringUtils.isBlank((CharSequence)activityId) || "null".equals(activityId) ? null : Integer.valueOf(activityId)).state(Long.valueOf(0L)).sysBrandId(sysBrandId).payVoucherNo(vo.getTransactionid()).bizvaneMerchantId(po.getBizvaneMerchantId()).mbrPetCardSourceType(po.getMbrPetCardSourceType()).mbrPetCardOrgCode(po.getMbrPetCardOrgCode()).rechargeType(po.getPayType()).outTradeNo(vo.getOutTradeNo()).mbrRechargeExplainId(mbrRechargeExplainId).build();
                SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic("public_ali_pay_recharge_record").build(), (Object)JSON.toJSONString((Object)mqMessage));
                log.info("alipayRechargeCallBack sendResult:{}", (Object)JSONObject.toJSONString((Object)sendResult));
            }
        }
        finally {
            this.redissonTemplate.getRUnLook(sysBrandId + vo.getTransactionid());
        }
        responseData.setData((Object)"SUCCESS");
        return responseData;
    }

    private MemberInfoModel getMemberInfoModel(SysBrandPo brandInfo, String memberCode) {
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        memberInfoModel.setSysCompanyId(brandInfo.getSysCompanyId());
        memberInfoModel.setBrandId(brandInfo.getSysBrandId());
        ResponseData memberInfoModelResponseData = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        return (MemberInfoModel)memberInfoModelResponseData.getData();
    }

    private ResponseData<String> getBizvaneMallCallBack(AlipayCallBackVO vo) {
        log.info("\u8c03\u7528\u5fae\u5546\u57ce\u652f\u4ed8\u5b9d\u652f\u4ed8\u56de\u8c03\u63a5\u53e3");
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", "application/json; charset=UTF-8");
        try {
            String resultStr = HttpUtil.post((String)(this.DOMAINNAME + "api/notifyCallBackUnion/payGateway"), (String)JacksonUtil.bean2Json((Object)vo), headerMap);
            if (StringUtils.isBlank((CharSequence)resultStr)) {
                log.info("\u8c03\u7528\u5fae\u5546\u57ce\u652f\u4ed8\u5b9d\u652f\u4ed8\u56de\u8c03\u63a5\u53e3\u8fd4\u56de\u4e3anull");
                return new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage(), (Object)"FAIL");
            }
            log.info("\u8c03\u7528\u5fae\u5546\u57ce\u652f\u4ed8\u5b9d\u652f\u4ed8\u56de\u8c03\u63a5\u53e3\u8fd4\u56de\u4e3a:{}", (Object)resultStr);
            JSONObject resultJson = JSONObject.parseObject((String)resultStr);
            return new ResponseData(resultJson.getInteger("code").intValue(), resultJson.getString("message"), (Object)resultJson.getString("data"));
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5fae\u5546\u57ce\u652f\u4ed8\u5b9d\u652f\u4ed8\u56de\u8c03\u63a5\u53e3\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage(), (Object)"FAIL");
        }
    }
}

