/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.bizvane.appletservice.interfaces.MktActivityPointsLootService;
import com.bizvane.mktcenterservice.models.vo.MktActivityPointsLootRequestVo;
import com.bizvane.mktcenterservice.models.vo.MktActivityPrizeRecordVO;
import com.bizvane.mktcenterservice.rpc.MktActivityPointsLootServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MktActivityPointsLootServiceImpl
implements MktActivityPointsLootService {
    @Autowired
    private MktActivityPointsLootServiceRpc mktActivityPointsLootServiceRpc;

    public ResponseData<PageInfo<MktActivityPrizeRecordVO>> selectDrawPrizeRecord(MktActivityPointsLootRequestVo vo) {
        ResponseData responseData = this.mktActivityPointsLootServiceRpc.selectDrawPrizeRecord(vo);
        if (responseData != null && SysResponseEnum.SUCCESS.getCode() == responseData.getCode() && null != responseData.getData()) {
            PageInfo data = (PageInfo)responseData.getData();
            String rg = "(\\d{3})\\d{4}(\\d{4})";
            if (CollectionUtils.isNotEmpty((Collection)data.getList())) {
                for (MktActivityPrizeRecordVO po : data.getList()) {
                    String newStr;
                    String name;
                    int size;
                    String phoneNumber;
                    if (StringUtils.isNotBlank((CharSequence)po.getMemberPhone())) {
                        phoneNumber = po.getMemberPhone().replaceAll(rg, "$1****$2");
                        po.setMemberPhone(phoneNumber);
                    }
                    if (StringUtils.isNotBlank((CharSequence)po.getLinkmanPhone())) {
                        phoneNumber = po.getLinkmanPhone().replaceAll(rg, "$1****$2");
                        po.setLinkmanPhone(phoneNumber);
                    }
                    if (StringUtils.isNotBlank((CharSequence)po.getMemberName())) {
                        int end = 1;
                        int n = size = po.getMemberName().length() >= 5 ? 5 : po.getMemberName().length();
                        if (po.getMemberName().length() > 2) {
                            end = po.getMemberName().length() - 2;
                        } else if (po.getMemberName().length() < 2) {
                            end = 0;
                        }
                        name = StringUtils.substring((String)po.getMemberName(), (int)0, (int)end);
                        newStr = StringUtils.rightPad((String)name, (int)size, (String)"*");
                        po.setMemberName(newStr);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)po.getLinkmanName())) continue;
                    int end = 1;
                    int n = size = po.getLinkmanName().length() >= 5 ? 5 : po.getLinkmanName().length();
                    if (po.getLinkmanName().length() > 2) {
                        end = po.getLinkmanName().length() - 2;
                    } else if (po.getLinkmanName().length() < 2) {
                        end = 0;
                    }
                    name = StringUtils.substring((String)po.getLinkmanName(), (int)0, (int)end);
                    newStr = StringUtils.rightPad((String)name, (int)size, (String)"*");
                    po.setLinkmanName(newStr);
                }
            }
        }
        return responseData;
    }
}

