/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.interfaces.MemberPrivilegeService;
import com.bizvane.appletservice.models.bo.AppletVipCardBo;
import com.bizvane.appletservice.models.po.AppletVipCartPO;
import com.bizvane.appletservice.models.po.AppletVipCartPOExample;
import com.bizvane.appletservice.models.po.AppletVipPrivilegeConfigPO;
import com.bizvane.appletservice.models.po.AppletVipPrivilegeConfigPOExample;
import com.bizvane.appletservice.models.po.AppletVipPrivilegePO;
import com.bizvane.appletservice.models.po.AppletVipPrivilegePOExample;
import com.bizvane.appletservice.models.vo.AppletBrandPrivilegeConfigVO;
import com.bizvane.appletservice.models.vo.AppletBrandVipPrivilegeVO;
import com.bizvane.appletserviceimpl.constant.Constant;
import com.bizvane.appletserviceimpl.mappers.AppletVipCardPrivilegePOMapper;
import com.bizvane.appletserviceimpl.mappers.AppletVipCartPOMapper;
import com.bizvane.appletserviceimpl.mappers.AppletVipPrivilegeConfigPOMapper;
import com.bizvane.appletserviceimpl.mappers.AppletVipPrivilegePOMapper;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.fitmentservice.models.Rpc.AppletResourcesRpc;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.service.api.MemberCardProgramApiService;
import com.bizvane.members.facade.service.api.MemberLevelApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MemberPrivilegeServiceImpl
implements MemberPrivilegeService {
    private static final Logger log = LoggerFactory.getLogger(MemberPrivilegeServiceImpl.class);
    @Autowired
    private MemberCardProgramApiService memberCardProgramApiService;
    @Autowired
    private AppletVipCartPOMapper appletVipCartPOMapper;
    @Autowired
    private AppletVipPrivilegePOMapper appletVipPrivilegePOMapper;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private MemberLevelApiService memberLevelApiService;
    @Autowired
    private AppletVipCardPrivilegePOMapper appletVipCardPrivilegePOMapper;
    @Autowired
    private AppletVipPrivilegeConfigPOMapper appletVipPrivilegeConfigPOMapper;
    @Autowired
    private AppletResourcesRpc appletResourcesRpc;
    @Value(value="#{'${privatizationBrand.mengjie}'.split(',')}")
    private List<Long> mJBrandList;

    public ResponseData<List<AppletVipCardBo>> getMemberPrivilege(Byte roundingMode, Long sysBrandId, Integer appletVipPrivilegeVersion) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        if (sysBrandId == null) {
            responseData.setMessage("\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (null != sysBrandId && CollectionUtils.isNotEmpty((Collection)this.mJBrandList) && this.mJBrandList.contains(sysBrandId)) {
            roundingMode = null == roundingMode || roundingMode == 0 ? (byte)3 : roundingMode;
        }
        ArrayList<AppletVipCardBo> appletVipCardBoList = new ArrayList<AppletVipCardBo>();
        List mbrLevelModelList = (List)this.appletResourcesRpc.getAppletLevelCardList(sysBrandId).getData();
        if (mbrLevelModelList.size() > 0) {
            for (MbrLevelModel mbrLevelModel : mbrLevelModelList) {
                AppletVipCardBo appletVipCardBo = new AppletVipCardBo();
                appletVipCardBo.setMbrLevelId(mbrLevelModel.getMbrLevelId());
                appletVipCardBo.setLevelName(mbrLevelModel.getLevelName());
                appletVipCardBo.setLevelValue(mbrLevelModel.getLevelValue());
                Long mbrLevelId = mbrLevelModel.getMbrLevelId();
                ResponseData modelResponseData = this.memberLevelApiService.queryLevelModel(mbrLevelId);
                MbrLevelModel levelModel = (MbrLevelModel)modelResponseData.getData();
                if (StringUtils.isNotBlank((CharSequence)levelModel.getLevelRemark())) {
                    appletVipCardBo.setUpgradeInfo(levelModel.getLevelRemark());
                } else {
                    appletVipCardBo.setUpgradeInfo("");
                }
                if (StringUtils.isNotBlank((CharSequence)mbrLevelModel.getUpGradeCondition())) {
                    JSONObject upGradeConditionJson = JSONObject.parseObject((String)mbrLevelModel.getUpGradeCondition());
                    appletVipCardBo.setUpGradeSinglemonetary(upGradeConditionJson.getBigDecimal("singlemonetary"));
                    if (Integer.valueOf(0).equals(mbrLevelModel.getUpMonthNum())) {
                        BigDecimal totalmonetary = upGradeConditionJson.getBigDecimal("totalmonetary");
                        if (null != totalmonetary) {
                            if (null != roundingMode && roundingMode == 4) {
                                totalmonetary = totalmonetary.setScale(0, 1);
                            } else if (null != roundingMode && roundingMode == 3) {
                                totalmonetary = totalmonetary.setScale(0, 0);
                            } else if (null != roundingMode && roundingMode == 2) {
                                totalmonetary = totalmonetary.setScale(0, 5);
                            }
                        }
                        appletVipCardBo.setUpGradeTotalmonetary(totalmonetary);
                    }
                }
                AppletVipCartPOExample appletVipCartPOExample = new AppletVipCartPOExample();
                appletVipCartPOExample.createCriteria().andGradeIdEqualTo(mbrLevelModel.getMbrLevelId()).andSysBrandIdEqualTo(sysBrandId).andValidEqualTo(Boolean.valueOf(true));
                List appletVipCartPOList = this.appletVipCartPOMapper.selectByExample(appletVipCartPOExample);
                for (AppletVipCartPO appletVipCartPO : appletVipCartPOList) {
                    if (appletVipCartPO.getIsImg().booleanValue()) {
                        appletVipCardBo.setImg(appletVipCartPO.getIsImg());
                        appletVipCardBo.setCardStyle(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)appletVipCartPO.getCardStyle()));
                    } else {
                        appletVipCardBo.setCardStyle(appletVipCartPO.getCardStyle());
                    }
                    appletVipCardBo.setFontColor(appletVipCartPO.getFontColor());
                    appletVipCardBo.setCardDefaultColor(appletVipCartPO.getCardDefaultColor());
                    if (appletVipCartPOList.size() <= 0) continue;
                    ResponseData appletBrandVipPrivilegeVOListRes = this.getMemberPrivilegebyGrderNew(sysBrandId, appletVipCartPO.getAppletVipCardId(), appletVipCartPO.getGradeId(), appletVipPrivilegeVersion);
                    appletVipCardBo.setAppletVipPrivilegePOList((List)appletBrandVipPrivilegeVOListRes.getData());
                }
                appletVipCardBoList.add(appletVipCardBo);
            }
        }
        log.info("appletVipCardBoList:{}", (Object)JacksonUtil.bean2Json(appletVipCardBoList));
        responseData.setData(appletVipCardBoList);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    @Deprecated
    public ResponseData<List<AppletVipPrivilegePO>> getMemberPrivilegebyGrder(Long appletVipCardId) {
        ResponseData responseData = new ResponseData();
        if (appletVipCardId == null) {
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        AppletVipPrivilegePOExample appletVipPrivilegePOExample = new AppletVipPrivilegePOExample();
        appletVipPrivilegePOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andAppletVipCardIdEqualTo(appletVipCardId);
        List list = this.appletVipPrivilegePOMapper.selectByExample(appletVipPrivilegePOExample);
        for (AppletVipPrivilegePO appletVipPrivilegePO : list) {
            appletVipPrivilegePO.setPrivilegeLogo(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)appletVipPrivilegePO.getPrivilegeLogo()));
            if (appletVipPrivilegePO.getJumpInfo() == null) continue;
            appletVipPrivilegePO.setJumpInfoJson(JSONObject.parseObject((String)appletVipPrivilegePO.getJumpInfo()));
            appletVipPrivilegePO.setJumpInfo(null);
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)list);
        return responseData;
    }

    @Deprecated
    public ResponseData<List<AppletVipPrivilegePO>> getMemberPrivilegeAll(Long appletVipPrivilegeId) {
        ResponseData responseData = new ResponseData();
        if (appletVipPrivilegeId == null) {
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        AppletVipPrivilegePOExample appletVipPrivilegePOExample = new AppletVipPrivilegePOExample();
        appletVipPrivilegePOExample.createCriteria().andAppletVipPrivilegeIdEqualTo(appletVipPrivilegeId).andValidEqualTo(Boolean.valueOf(true));
        List list = this.appletVipPrivilegePOMapper.selectByExample(appletVipPrivilegePOExample);
        for (AppletVipPrivilegePO appletVipPrivilegePO : list) {
            appletVipPrivilegePO.setPrivilegeLogo(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)appletVipPrivilegePO.getPrivilegeLogo()));
            if (appletVipPrivilegePO.getJumpInfo() == null) continue;
            appletVipPrivilegePO.setJumpInfoJson(JSONObject.parseObject((String)appletVipPrivilegePO.getJumpInfo()));
            appletVipPrivilegePO.setJumpInfo(null);
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)list);
        return responseData;
    }

    public ResponseData<List<AppletBrandVipPrivilegeVO>> getMemberPrivilegebyGrderNew(Long sysBrandId, Long appletVipCardId, Long gradeId, Integer version) {
        if (Constant.APPLET_VIP_PRIVILEGE_VERSION_2.equals(version)) {
            return this.getMemberPrivilegebyGrderVersion2(sysBrandId, gradeId);
        }
        return this.getMemberPrivilegebyGrderVersion1(appletVipCardId);
    }

    public ResponseData<List<AppletBrandVipPrivilegeVO>> getMemberPrivilegeAllNew(Long sysBrandId, Long appletVipPrivilegeId, Integer version) {
        if (Constant.APPLET_VIP_PRIVILEGE_VERSION_2.equals(version)) {
            return this.getMemberPrivilegeAllVersion2(sysBrandId, appletVipPrivilegeId);
        }
        return this.getMemberPrivilegeAllVersion1(appletVipPrivilegeId);
    }

    public ResponseData<List<AppletBrandPrivilegeConfigVO>> getMemberPrivilegeAllConfigList(Long sysBrandId) {
        ResponseData levelModelResponseData = this.memberLevelApiService.queryAllLevelList(sysBrandId);
        if (levelModelResponseData == null || SysResponseEnum.SUCCESS.getCode() != levelModelResponseData.getCode()) {
            log.info("levelModelResponseData:{}", (Object)JacksonUtil.bean2Json((Object)levelModelResponseData));
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u83b7\u53d6\u7b49\u7ea7\u4fe1\u606f\u5931\u8d25");
        }
        List mbrLevelModelList = (List)levelModelResponseData.getData();
        if (CollectionUtils.isEmpty((Collection)mbrLevelModelList)) {
            return new ResponseData(SysResponseEnum.SUCCESS.getCode(), "\u83b7\u53d6\u7b49\u7ea7\u4fe1\u606f\u4e3a\u7a7a");
        }
        HashMap mbrLevelIdToNameMap = new HashMap();
        ArrayList mbrLevelIdList = new ArrayList();
        mbrLevelModelList.stream().forEach(level -> {
            mbrLevelIdToNameMap.put(level.getMbrLevelId(), level.getLevelName());
            mbrLevelIdList.add(level.getMbrLevelId());
        });
        List appletBrandPrivilegeConfigVOList = this.appletVipPrivilegeConfigPOMapper.getMemberPrivilegeAllConfigList(sysBrandId, mbrLevelIdList);
        if (CollectionUtils.isEmpty((Collection)appletBrandPrivilegeConfigVOList)) {
            return new ResponseData(SysResponseEnum.SUCCESS.getCode(), "\u83b7\u53d6\u7279\u6743\u4fe1\u606f\u4e3a\u7a7a");
        }
        for (AppletBrandPrivilegeConfigVO configVO : appletBrandPrivilegeConfigVOList) {
            if (CollectionUtils.isEmpty((Collection)configVO.getVipCardPrivilegeVOList())) continue;
            configVO.getVipCardPrivilegeVOList().stream().forEach(vo -> {
                if (vo.getGradeId() != null) {
                    vo.setGradeName((String)mbrLevelIdToNameMap.get(vo.getGradeId()));
                }
            });
        }
        return new ResponseData((Object)appletBrandPrivilegeConfigVOList);
    }

    private ResponseData<List<AppletBrandVipPrivilegeVO>> getMemberPrivilegebyGrderVersion1(Long appletVipCardId) {
        if (appletVipCardId == null) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage());
        }
        AppletVipPrivilegePOExample appletVipPrivilegePOExample = new AppletVipPrivilegePOExample();
        appletVipPrivilegePOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andAppletVipCardIdEqualTo(appletVipCardId);
        List list = this.appletVipPrivilegePOMapper.selectByExample(appletVipPrivilegePOExample);
        ArrayList<AppletBrandVipPrivilegeVO> appletBrandVipPrivilegeVOList = new ArrayList<AppletBrandVipPrivilegeVO>();
        for (AppletVipPrivilegePO appletVipPrivilegePO : list) {
            appletVipPrivilegePO.setPrivilegeLogo(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)appletVipPrivilegePO.getPrivilegeLogo()));
            if (appletVipPrivilegePO.getJumpInfo() != null) {
                appletVipPrivilegePO.setJumpInfoJson(JSONObject.parseObject((String)appletVipPrivilegePO.getJumpInfo()));
                appletVipPrivilegePO.setJumpInfo(null);
            }
            AppletBrandVipPrivilegeVO appletBrandVipPrivilegeVO = new AppletBrandVipPrivilegeVO();
            BeanUtils.copyProperties((Object)appletVipPrivilegePO, (Object)appletBrandVipPrivilegeVO);
            appletBrandVipPrivilegeVOList.add(appletBrandVipPrivilegeVO);
        }
        return new ResponseData(appletBrandVipPrivilegeVOList);
    }

    private ResponseData<List<AppletBrandVipPrivilegeVO>> getMemberPrivilegebyGrderVersion2(Long sysBrandId, Long levelId) {
        log.info("getMemberPrivilegebyGrderVersion2 method sysBrandId:{},levelId:{}", (Object)sysBrandId, (Object)levelId);
        if (sysBrandId == null || levelId == null) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage());
        }
        List appletBrandVipPrivilegeVOList = this.appletVipCardPrivilegePOMapper.selectAppletBrandVipPrivilegeVOByLevelId(sysBrandId, levelId);
        return new ResponseData((Object)appletBrandVipPrivilegeVOList);
    }

    private ResponseData<List<AppletBrandVipPrivilegeVO>> getMemberPrivilegeAllVersion1(Long appletVipPrivilegeId) {
        if (appletVipPrivilegeId == null) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage());
        }
        AppletVipPrivilegePOExample appletVipPrivilegePOExample = new AppletVipPrivilegePOExample();
        appletVipPrivilegePOExample.createCriteria().andAppletVipPrivilegeIdEqualTo(appletVipPrivilegeId).andValidEqualTo(Boolean.valueOf(true));
        List list = this.appletVipPrivilegePOMapper.selectByExample(appletVipPrivilegePOExample);
        ArrayList<AppletBrandVipPrivilegeVO> appletBrandVipPrivilegeVOList = new ArrayList<AppletBrandVipPrivilegeVO>();
        for (AppletVipPrivilegePO appletVipPrivilegePO : list) {
            appletVipPrivilegePO.setPrivilegeLogo(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)appletVipPrivilegePO.getPrivilegeLogo()));
            if (appletVipPrivilegePO.getJumpInfo() != null) {
                appletVipPrivilegePO.setJumpInfoJson(JSONObject.parseObject((String)appletVipPrivilegePO.getJumpInfo()));
                appletVipPrivilegePO.setJumpInfo(null);
            }
            AppletBrandVipPrivilegeVO appletBrandVipPrivilegeVO = new AppletBrandVipPrivilegeVO();
            BeanUtils.copyProperties((Object)appletVipPrivilegePO, (Object)appletBrandVipPrivilegeVO);
            appletBrandVipPrivilegeVOList.add(appletBrandVipPrivilegeVO);
        }
        return new ResponseData(appletBrandVipPrivilegeVOList);
    }

    private ResponseData<List<AppletBrandVipPrivilegeVO>> getMemberPrivilegeAllVersion2(Long sysBrandId, Long appletVipPrivilegeId) {
        log.info("getMemberPrivilegeAllVersion2 method sysBrandId:{},appletVipPrivilegeId:{}", (Object)sysBrandId, (Object)appletVipPrivilegeId);
        if (sysBrandId == null || appletVipPrivilegeId == null) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage());
        }
        AppletVipPrivilegeConfigPOExample appletVipPrivilegeConfigPOExample = new AppletVipPrivilegeConfigPOExample();
        appletVipPrivilegeConfigPOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andAppletVipPrivilegeConfigIdEqualTo(appletVipPrivilegeId).andValidEqualTo(Boolean.TRUE);
        List appletVipPrivilegeConfigPOList = this.appletVipPrivilegeConfigPOMapper.selectByExample(appletVipPrivilegeConfigPOExample);
        if (CollectionUtils.isEmpty((Collection)appletVipPrivilegeConfigPOList)) {
            return new ResponseData(new ArrayList());
        }
        ArrayList<AppletBrandVipPrivilegeVO> appletBrandVipPrivilegeVOList = new ArrayList<AppletBrandVipPrivilegeVO>();
        for (AppletVipPrivilegeConfigPO po : appletVipPrivilegeConfigPOList) {
            AppletBrandVipPrivilegeVO vo = new AppletBrandVipPrivilegeVO();
            vo.setPrivilegeName(po.getPrivilegeName());
            vo.setPrivilegeLogo(po.getPrivilegeLogo());
            vo.setValid(po.getValid());
            appletBrandVipPrivilegeVOList.add(vo);
        }
        return new ResponseData(appletBrandVipPrivilegeVOList);
    }
}

