/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.interfaces.MemberLotteryService;
import com.bizvane.appletservice.interfaces.mktp.FissionActivityService;
import com.bizvane.appletservice.models.vo.ActivityCommonRequestVO;
import com.bizvane.appletserviceimpl.impl.DataQueryService;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.mktcenterservice.common.ActivityRuleTypeEnum;
import com.bizvane.mktcenterservice.models.po.MktActivityPOWithBLOBs;
import com.bizvane.mktcenterservice.models.po.MktActivityPrizePO;
import com.bizvane.mktcenterservice.models.po.MktActivityPrizeRecordPO;
import com.bizvane.mktcenterservice.models.vo.ActivityPrizeBO;
import com.bizvane.mktcenterservice.models.vo.ActivityPrizeRecordDetailBO;
import com.bizvane.mktcenterservice.models.vo.JudgeMemberVO;
import com.bizvane.mktcenterservice.models.vo.LotteryRecordCommonRequestVO;
import com.bizvane.mktcenterservice.models.vo.ProbabilityVO;
import com.bizvane.mktcenterservice.models.vo.mktp.FissionActivityParamsVO;
import com.bizvane.mktcenterservice.models.vo.mktp.PrizeRecordCommonRequestVO;
import com.bizvane.mktcenterservice.rpc.ActivityCommonServiceRpc;
import com.bizvane.mktcenterservice.rpc.ActivityPrizeServiceRpc;
import com.bizvane.mktcenterservice.rpc.ActivityServiceRpc;
import com.bizvane.mktcenterservice.rpc.TaskServiceForWXRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisClient;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.bizvane.wechatenterprise.service.entity.vo.WxqyOpengidToGroupChatIdRequestVO;
import com.bizvane.wechatenterprise.service.entity.vo.WxqyOpengidToGroupChatIdResponseVO;
import com.bizvane.wechatenterprise.service.rpc.WxqyGroupChatApiService;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MemberLotteryServiceImpl
implements MemberLotteryService {
    @Autowired
    private ActivityPrizeServiceRpc activityPrizeServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private ActivityServiceRpc activityServiceRpc;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private ActivityCommonServiceRpc activityCommonServiceRpc;
    @Autowired
    private DataQueryService dataQueryService;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private TaskServiceForWXRpc taskServiceForWxRpc;
    @Autowired
    private FissionActivityService fissionActivityService;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private WxqyGroupChatApiService wxqyGroupChatApiService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    public ResponseData<MktActivityPrizeRecordPO> winningRecord(MktActivityPrizeRecordPO mktActivityPrizeRecordPO) {
        return this.record(mktActivityPrizeRecordPO);
    }

    public ResponseData winningRecordNew(PrizeRecordCommonRequestVO requestVO) {
        return this.recordNew(requestVO);
    }

    public ResponseData<ActivityPrizeBO> activityRules(String activePriceCode) {
        ResponseData responseData = new ResponseData();
        ActivityPrizeBO rules = this.rules(activePriceCode);
        if (rules == null) {
            responseData.setMessage("\u65e0\u89c4\u5219");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
        }
        MktActivityPOWithBLOBs activityPO = rules.getActivityPO();
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)activityPO.getActivityRule());
        return responseData;
    }

    public ResponseData activityRulesNew(ActivityCommonRequestVO activityCommonRequestVO) {
        MktActivityPOWithBLOBs activityPO;
        ResponseData responseData = new ResponseData();
        if (2 == activityCommonRequestVO.getMktType()) {
            FissionActivityParamsVO paramsVO = new FissionActivityParamsVO();
            paramsVO.setActivityCode(activityCommonRequestVO.getActivePriceCode());
            return this.fissionActivityService.getActivityRuleByCode(paramsVO);
        }
        ActivityPrizeBO rules = this.rules(activityCommonRequestVO.getActivePriceCode());
        if (rules == null) {
            responseData.setMessage("\u65e0\u89c4\u5219");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
        }
        if (null != (activityPO = rules.getActivityPO()) && ActivityRuleTypeEnum.IMG_SHOW.getType().equals(activityPO.getActivityRuleType())) {
            activityPO.setActivityRule(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)activityPO.getActivityRule()));
        }
        if (StringUtils.isNotBlank((CharSequence)activityPO.getShareImg())) {
            activityPO.setShareImg(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)activityPO.getShareImg()));
        }
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)activityPO);
        return responseData;
    }

    public ResponseData lotteryDoIng(String activePriceCode, String memberCode, Long clientBaseInfoId) {
        return this.activityPrizeServiceRpc.executeActivityPrize(activePriceCode, memberCode, clientBaseInfoId);
    }

    public ResponseData<ActivityPrizeBO> theWayToAcquireIntegral(String activePriceCode) {
        ResponseData responseData = new ResponseData();
        ActivityPrizeBO rules = this.rules(activePriceCode);
        if (rules == null) {
            responseData.setMessage("\u65e0\u79ef\u5206\u83b7\u53d6\u9014\u5f84");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
        }
        MktActivityPOWithBLOBs activityPO = rules.getActivityPO();
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)activityPO.getActivityInfo());
        return responseData;
    }

    public ResponseData<ActivityPrizeBO> luckDraw(String activePriceCode, String memberCode) throws ParseException {
        ResponseData responseData = new ResponseData();
        ActivityPrizeBO rules = this.rules(activePriceCode);
        if (rules == null) {
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
        }
        List prizePOList = rules.getActivityPrizePOList();
        for (MktActivityPrizePO mktActivityPrizePO : prizePOList) {
            if (mktActivityPrizePO.getPrizeType() != 50) continue;
            mktActivityPrizePO.setPrizeName("\u8c22\u8c22\u60e0\u987e");
        }
        Collections.sort(prizePOList, new /* Unavailable Anonymous Inner Class!! */);
        MktActivityPOWithBLOBs activityPOWithBLOBsData = rules.getActivityPO();
        logger.info("activityPOWithBLOBsData:{}", (Object)JSON.toJSONString((Object)activityPOWithBLOBsData));
        if (StringUtils.isNotBlank((CharSequence)activityPOWithBLOBsData.getShareImg())) {
            activityPOWithBLOBsData.setShareImg(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)activityPOWithBLOBsData.getShareImg()));
        }
        Integer triesLimit = activityPOWithBLOBsData.getTriesLimit();
        ProbabilityVO probabilityVO = new ProbabilityVO();
        probabilityVO.setMemberCode(memberCode);
        probabilityVO.setTriesLimit(triesLimit);
        probabilityVO.setMktActivityId(activityPOWithBLOBsData.getMktActivityId());
        ResponseData integerResponseData = this.activityPrizeServiceRpc.residueMemberNumber(probabilityVO);
        Map dataMap = (Map)integerResponseData.getData();
        if (dataMap != null) {
            logger.info("integerResponseData={}", integerResponseData.getData());
            activityPOWithBLOBsData.setTriesLimit((Integer)dataMap.get("triesLimit"));
        }
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)rules);
        return responseData;
    }

    public ResponseData<MktActivityPrizeRecordPO> rotation(MktActivityPrizeRecordPO mktActivityPrizeRecordPO) {
        return this.record(mktActivityPrizeRecordPO);
    }

    public ResponseData countIntegral(String memberCode) {
        Integer countIntegral = this.countIntegrals(memberCode);
        logger.info("\u6211\u7684\u79ef\u5206\u4f1a\u5458\u4fe1\u606f={}", (Object)memberCode);
        ResponseData responseData = new ResponseData();
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)(countIntegral != null ? countIntegral : 0));
        return responseData;
    }

    public ResponseData scanningLottery(String memberCode, String activityCode) {
        Long serviceStoreId;
        logger.info("\u626b\u7801\u62bd\u5956\u5165\u53c2={} acode={}", (Object)JSON.toJSONString((Object)memberCode), (Object)JSON.toJSONString((Object)activityCode));
        ResponseData responseData = new ResponseData();
        ResponseData storeId = this.wxAppletApiService.getServiceStoreId(memberCode);
        JudgeMemberVO judgeMemberVO = new JudgeMemberVO();
        judgeMemberVO.setActivityCode(activityCode);
        judgeMemberVO.setMemberCode(memberCode);
        if (storeId != null && (serviceStoreId = (Long)storeId.getData()) != null) {
            Integer integer = new Long(serviceStoreId).intValue();
            judgeMemberVO.setStoreId(integer);
        }
        ResponseData judgeMember = this.activityServiceRpc.judgeMember(judgeMemberVO);
        logger.info("\u626b\u7801\u62bd\u5956\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)judgeMember.getData()));
        if (judgeMember != null) {
            Integer data = (Integer)judgeMember.getData();
            if (data == 100) {
                responseData.setMessage("\u53c2\u6570\u4e0d\u5408\u683c");
                responseData.setCode(100);
            }
            if (data == 101) {
                responseData.setMessage("\u6d3b\u52a8\u5df2\u8fc7\u671f");
                responseData.setCode(0);
                responseData.setData((Object)"101");
            }
            if (data == 102) {
                responseData.setMessage("\u4f1a\u5458\u4e0d\u5728\u8303\u56f4\u5185");
                responseData.setCode(0);
                responseData.setData((Object)"102");
            }
            if (data == 103) {
                responseData.setMessage("\u6d3b\u52a8\u8fd8\u672a\u5f00\u59cb");
                responseData.setCode(0);
                responseData.setData((Object)"103");
            }
            if (data == 0) {
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setData((Object)"0");
            }
        } else {
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        logger.info("\u626b\u7801\u62bd\u5956\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)judgeMember.getData()), (Object)JSON.toJSONString((Object)responseData.getMessage()));
        return responseData;
    }

    public void addressLotteryRecord(MktActivityPrizeRecordPO mktActivityPrizeRecordPO) {
        this.activityCommonServiceRpc.addPrizeAddress(mktActivityPrizeRecordPO);
    }

    public ResponseData addressLotteryRecordNew(LotteryRecordCommonRequestVO requestVO) {
        return this.activityCommonServiceRpc.addPrizeAddressNew(requestVO);
    }

    public ResponseData<ActivityPrizeRecordDetailBO> winningRecordDetail(PrizeRecordCommonRequestVO requestVO) {
        ResponseData recordDetailBOResponseData = new ResponseData();
        ActivityPrizeRecordDetailBO activityPrizeRecordDetailBO = (ActivityPrizeRecordDetailBO)this.activityPrizeServiceRpc.winningRecordDetail(requestVO).getData();
        if (null != activityPrizeRecordDetailBO && StringUtils.isNotBlank((CharSequence)activityPrizeRecordDetailBO.getImageUrl())) {
            activityPrizeRecordDetailBO.setImageUrl(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)activityPrizeRecordDetailBO.getImageUrl()));
        }
        recordDetailBOResponseData.setData((Object)activityPrizeRecordDetailBO);
        return recordDetailBOResponseData;
    }

    public ResponseData selectGivenGameNum(Long sysBrandId, String activityCode, String memberCode) {
        return this.activityServiceRpc.selectGivenGameNum(sysBrandId, memberCode, activityCode);
    }

    public ResponseData taskScanningLottery(String memberCode, Long taskId, Integer taskType) {
        Long serviceStoreId;
        logger.info("taskScanningLottery#memberCode:{},taskId:{},taskType:{}", new Object[]{JSON.toJSONString((Object)memberCode), taskId, taskType});
        ResponseData responseData = new ResponseData();
        ResponseData storeIdResp = this.wxAppletApiService.getServiceStoreId(memberCode);
        JudgeMemberVO judgeMemberVO = new JudgeMemberVO();
        judgeMemberVO.setMemberCode(memberCode);
        judgeMemberVO.setTaskId(taskId);
        judgeMemberVO.setTaskType(taskType);
        if (storeIdResp != null && (serviceStoreId = (Long)storeIdResp.getData()) != null) {
            Integer integer = new Long(serviceStoreId).intValue();
            judgeMemberVO.setStoreId(integer);
        }
        ResponseData judgeMember = this.taskServiceForWxRpc.judgeMember(judgeMemberVO);
        logger.info("\u4efb\u52a1\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)judgeMember.getData()));
        if (judgeMember != null) {
            Integer data = (Integer)judgeMember.getData();
            if (data == 100) {
                responseData.setMessage("\u53c2\u6570\u4e0d\u5408\u683c");
                responseData.setCode(100);
            }
            if (data == 101) {
                responseData.setMessage("\u6d3b\u52a8\u5df2\u8fc7\u671f");
                responseData.setCode(0);
                responseData.setData((Object)"101");
            }
            if (data == 102) {
                responseData.setMessage("\u4f1a\u5458\u4e0d\u5728\u8303\u56f4\u5185");
                responseData.setCode(0);
                responseData.setData((Object)"102");
            }
            if (data == 103) {
                responseData.setMessage("\u6d3b\u52a8\u8fd8\u672a\u5f00\u59cb");
                responseData.setCode(0);
                responseData.setData((Object)"103");
            }
            if (data == 0) {
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setData((Object)"0");
            }
        } else {
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        logger.info("\u6700\u7ec8\u4efb\u52a1\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)judgeMember.getData()), (Object)JSON.toJSONString((Object)responseData.getMessage()));
        return responseData;
    }

    public ResponseData<WxqyOpengidToGroupChatIdResponseVO> checkAndGetActivityGroupChatId(WxqyOpengidToGroupChatIdRequestVO requestVO) {
        logger.info("MemberLotteryServiceImpl-checkAndGetActivityGroupChatId-info,requestVO:{}", (Object)JacksonUtil.bean2Json((Object)requestVO));
        ResponseData responseData = new ResponseData();
        if (requestVO.getMktActivityId() == null) {
            return responseData;
        }
        ResponseData activityRes = this.activityServiceRpc.selectMktActivity(requestVO.getMktActivityId());
        logger.info("MemberLotteryServiceImpl-checkAndGetActivityGroupChatId-info,activityRes:{}", (Object)JacksonUtil.bean2Json((Object)activityRes));
        if (activityRes == null || activityRes.getCode() != SysResponseEnum.SUCCESS.getCode() || activityRes.getData() == null) {
            return responseData;
        }
        MktActivityPOWithBLOBs activityPO = (MktActivityPOWithBLOBs)activityRes.getData();
        ResponseData clientBaseInfoIdRes = this.wxqyGroupChatApiService.getClientBaseInfoIdByOpengid(requestVO);
        logger.info("MemberLotteryServiceImpl-checkAndGetActivityGroupChatId-info,clientBaseInfoIdRes:{}", (Object)JacksonUtil.bean2Json((Object)clientBaseInfoIdRes));
        if (clientBaseInfoIdRes == null || clientBaseInfoIdRes.getCode() != SysResponseEnum.SUCCESS.getCode() || clientBaseInfoIdRes.getData() == null || ((WxqyOpengidToGroupChatIdResponseVO)clientBaseInfoIdRes.getData()).getWxqyClientBaseInfoId() == null) {
            return responseData;
        }
        WxqyOpengidToGroupChatIdResponseVO clientInfoVO = (WxqyOpengidToGroupChatIdResponseVO)clientBaseInfoIdRes.getData();
        if (Objects.equals(activityPO.getGroupChatRangeType(), 2)) {
            if (StringUtils.isBlank((CharSequence)activityPO.getClientBaseInfoIds())) {
                return responseData;
            }
            List<String> clientBaseInfoIdList = Arrays.asList(activityPO.getClientBaseInfoIds().split(","));
            logger.info("MemberLotteryServiceImpl-checkAndGetActivityGroupChatId-info,clientBaseInfoIdList:{}", (Object)JacksonUtil.list2Json(clientBaseInfoIdList));
            Boolean isContains = clientBaseInfoIdList.contains(String.valueOf(clientInfoVO.getWxqyClientBaseInfoId()));
            if (!isContains.booleanValue()) {
                return responseData;
            }
        }
        WxqyOpengidToGroupChatIdResponseVO resultVO = WxqyOpengidToGroupChatIdResponseVO.builder().wxqyClientBaseInfoId(clientInfoVO.getWxqyClientBaseInfoId()).build();
        responseData.setData((Object)resultVO);
        logger.info("MemberLotteryServiceImpl-checkAndGetActivityGroupChatId-info,responseData:{}", (Object)JacksonUtil.bean2Json((Object)responseData));
        return responseData;
    }

    private ResponseData<MktActivityPrizeRecordPO> record(MktActivityPrizeRecordPO mktActivityPrizeRecordPO) {
        logger.info("\u62bd\u5956\u8bb0\u5f55\u5165\u53c2={}", (Object)JSON.toJSONString((Object)mktActivityPrizeRecordPO));
        ResponseData responseData = new ResponseData();
        List mktActivityPrizeRecordPOList = this.dataQueryService.getPrizeRecordListRpc(mktActivityPrizeRecordPO);
        logger.info("\u62bd\u5956\u8bb0\u5f55\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)mktActivityPrizeRecordPOList));
        List recordPOListSubList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)mktActivityPrizeRecordPOList)) {
            recordPOListSubList = mktActivityPrizeRecordPOList.size() > 30 ? mktActivityPrizeRecordPOList.subList(0, 29) : mktActivityPrizeRecordPOList;
        }
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData(recordPOListSubList);
        return responseData;
    }

    private ResponseData recordNew(PrizeRecordCommonRequestVO requestVO) {
        logger.info("\u62bd\u5956\u8bb0\u5f55\u5165\u53c2={}", (Object)JSON.toJSONString((Object)requestVO));
        ResponseData responseData = new ResponseData();
        if (2 == requestVO.getMktType()) {
            List mktpActivityAwardRecordBOList = this.dataQueryService.getMktpAwardRecordList(requestVO);
            logger.info("\u4e2d\u5956\u8bb0\u5f55\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)mktpActivityAwardRecordBOList));
            List recordBOListSubList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)mktpActivityAwardRecordBOList)) {
                recordBOListSubList = mktpActivityAwardRecordBOList.size() > 30 ? mktpActivityAwardRecordBOList.subList(0, 29) : mktpActivityAwardRecordBOList;
            }
            responseData.setData(recordBOListSubList);
        } else {
            List mktActivityPrizeRecordBOList = this.dataQueryService.getPrizeRecordListRpcNew(requestVO);
            logger.info("\u62bd\u5956\u8bb0\u5f55\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)mktActivityPrizeRecordBOList));
            List recordBOListSubList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)mktActivityPrizeRecordBOList)) {
                recordBOListSubList = mktActivityPrizeRecordBOList.size() > 30 ? mktActivityPrizeRecordBOList.subList(0, 29) : mktActivityPrizeRecordBOList;
            }
            responseData.setData(recordBOListSubList);
        }
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    private ActivityPrizeBO rules(String activePriceCode) {
        logger.info("\u62bd\u5956\u8be6\u60c5={}", (Object)JSON.toJSONString((Object)activePriceCode));
        ActivityPrizeBO bo = this.dataQueryService.selectPrizeList(activePriceCode);
        logger.info("\u62bd\u5956\u8be6\u60c5={}", (Object)JSON.toJSONString((Object)bo));
        return bo;
    }

    private Integer countIntegrals(String memberCode) {
        ResponseData countIntegralByMemberCode = this.memberInfoApiService.getCountIntegralByMemberCode(memberCode);
        logger.info("\u79ef\u5206={}", countIntegralByMemberCode.getData());
        return (Integer)countIntegralByMemberCode.getData();
    }
}

