/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.bizvane.appletservice.interfaces.IncreaseByTransferringService;
import com.bizvane.appletservice.models.bo.CouponDetailResponseBo;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.couponfacade.interfaces.CouponQueryServiceFeign;
import com.bizvane.couponfacade.models.vo.CouponDetailModelVO;
import com.bizvane.couponfacade.models.vo.CouponEntityVO;
import com.bizvane.members.facade.models.MemberCardLevelModel;
import com.bizvane.members.facade.service.api.MemberCardProgramApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IncreaseByTransferringServiceImpl
implements IncreaseByTransferringService {
    @Autowired
    private CouponQueryServiceFeign couponQueryServiceFeign;
    @Autowired
    private MemberCardProgramApiService memberCardProgramApiService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    public ResponseData<CouponDetailResponseBo> increaseByTransferring(String couponCode, String oldMemberCode, String transferDate, String bizvaneSessionId, Long companyId, Long brandId) {
        ResponseData responseData = new ResponseData();
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setCode(-100);
            responseData.setMessage("\u4f1a\u5458 code \u672a\u5f97\u5230");
            return responseData;
        }
        CouponDetailResponseBo couponDetailResponseBo = new CouponDetailResponseBo();
        ResponseData couponByCouponCode = this.couponQueryServiceFeign.findCouponByCouponCode(couponCode);
        if (couponByCouponCode.getData() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8be5\u5238\u5df2\u88ab\u5546\u5bb6\u6536\u56de");
            return responseData;
        }
        if (((CouponDetailModelVO)couponByCouponCode.getData()).getCouponEntityPO().getSendType() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u6765\u6e90\u4fe1\u606f\u672a\u5f97\u5230");
            return responseData;
        }
        if ("25".equals(((CouponDetailModelVO)couponByCouponCode.getData()).getCouponEntityPO().getCouponStatus())) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u6b64\u52b5\u5df2\u8fc7\u671f");
            return responseData;
        }
        BeanUtils.copyProperties((Object)((CouponDetailModelVO)couponByCouponCode.getData()).getCouponEntityPO(), (Object)couponDetailResponseBo);
        long longValue = ((CouponDetailModelVO)couponByCouponCode.getData()).getCouponDefinitionPO().getMinConsume().longValue();
        couponDetailResponseBo.setUseBusinessAmount(Long.valueOf(longValue));
        CouponDetailModelVO couponByCouponCodeData = (CouponDetailModelVO)couponByCouponCode.getData();
        if (couponByCouponCodeData == null) {
            responseData.setMessage("\u52b5\u672a\u8fd4\u56de");
            responseData.setCode(100);
            return responseData;
        }
        if (couponByCouponCodeData.getCouponEntityPO().getGive() == null) {
            responseData.setMessage("\u8f6c\u589e\u72b6\u6001\u672a\u8fd4\u56de");
            responseData.setCode(100);
            return responseData;
        }
        CouponEntityVO entityVo = new CouponEntityVO();
        entityVo.setSysCompanyId(companyId);
        entityVo.setSysBrandId(brandId);
        entityVo.setTransferMemberCode(oldMemberCode);
        entityVo.setCouponCode(couponCode);
        try {
            entityVo.setDtStart(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(transferDate));
        }
        catch (Exception e) {
            logger.info("increaseByTransferring transferDate \u65f6\u95f4\u683c\u5f0f\u9519\u8bef! :{}", (Object)transferDate);
        }
        ResponseData isCouponRecordBack = this.couponQueryServiceFeign.getIsCouponRecordBack(entityVo);
        if (isCouponRecordBack.getCode() == SysResponseEnum.SUCCESS.getCode() && ((Boolean)isCouponRecordBack.getData()).booleanValue()) {
            couponDetailResponseBo.setBack(Boolean.valueOf(true));
        } else {
            couponDetailResponseBo.setBack(Boolean.valueOf(false));
        }
        Boolean give = couponByCouponCodeData.getCouponEntityPO().getGive();
        logger.info("give={}", (Object)give);
        logger.info("getGive={}", (Object)couponDetailResponseBo.getGive());
        if (give.booleanValue()) {
            couponDetailResponseBo.setReceiveState(Integer.valueOf(0));
        } else {
            ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(couponByCouponCodeData.getCouponEntityPO().getMemberCode());
            couponDetailResponseBo.setWxHeadPortraits(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)((MemberCardLevelModel)modelResponseData.getData()).getWxHeadPortraits()));
            couponDetailResponseBo.setWxNick(((MemberCardLevelModel)modelResponseData.getData()).getWxNick());
            String receiveTime = (String)this.redisTemplateService.stringGetStringByKey((Object)(couponByCouponCodeData.getCouponEntityPO().getMemberCode() + couponCode));
            couponDetailResponseBo.setReceiveTime(receiveTime);
            couponDetailResponseBo.setReceiveState(Integer.valueOf(1));
        }
        if (((CouponDetailModelVO)couponByCouponCode.getData()).getCouponEntityPO().getIsUse().booleanValue()) {
            couponDetailResponseBo.setUse(((CouponDetailModelVO)couponByCouponCode.getData()).getCouponEntityPO().getIsUse());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u6b64\u52b5\u5df2\u4f7f\u7528");
            responseData.setData((Object)couponDetailResponseBo);
            return responseData;
        }
        couponDetailResponseBo.setUse(((CouponDetailModelVO)couponByCouponCode.getData()).getCouponEntityPO().getIsUse());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)couponDetailResponseBo);
        return responseData;
    }
}

