/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.alibaba.fastjson.JSON;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.ActivityService;
import com.bizvane.members.facade.models.MemberCardLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberCardProgramApiService;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.members.facade.vo.MemberInfoApiModel;
import com.bizvane.mktcenterservice.models.vo.InviteSuccessVO;
import com.bizvane.mktcenterservice.models.vo.MemberInfoModelVOActivity;
import com.bizvane.mktcenterservice.rpc.ActivityServiceRpc;
import com.bizvane.mktcenterservice.rpc.TaskInviteServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.bizvane.wechatenterprise.service.rpc.WxqyInteractHistoryServiceRpc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ActivityServiceImpl
implements ActivityService {
    @Autowired
    private ActivityServiceRpc activityServiceRpc;
    @Autowired
    private MemberCardProgramApiService memberCardProgramApiService;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private TaskInviteServiceRpc taskInviteServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private WxqyInteractHistoryServiceRpc wxqyInteractHistoryServiceRpc;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    public ResponseData executeActivity(Long brand, String memberCode, Integer operateType) {
        logger.info("open card executeActivity memberCode {}", (Object)memberCode);
        ResponseData responseData = new ResponseData();
        MemberInfoModelVOActivity memberInfoModel = new MemberInfoModelVOActivity();
        ResponseData memberCardLevelModelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        Long levelId = ((MemberCardLevelModel)memberCardLevelModelResponseData.getData()).getLevelId();
        logger.info("levelId\u6d3b\u52a8={}", (Object)levelId);
        Long openCardStoreId = (Long)this.wxAppletApiService.getOpenCardStoreId(memberCode).getData();
        Long serviceStoreId = (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
        logger.info("openCardStoreId={} , serviceStoreId={} , operateType={}", new Object[]{openCardStoreId, serviceStoreId, operateType});
        memberInfoModel.setBrandId(brand);
        memberInfoModel.setMemberCode(memberCode);
        memberInfoModel.setLevelId(levelId);
        memberInfoModel.setOpenCardStoreId(openCardStoreId);
        memberInfoModel.setServiceStoreId(serviceStoreId);
        if (operateType == null) {
            responseData.setMessage("\u5f00\u5361\u72b6\u6001\u672a\u8fd4\u56de");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        if (operateType == 2) {
            memberInfoModel.setOfflineCardStatus(Integer.valueOf(1));
        }
        if (operateType == 1) {
            memberInfoModel.setOfflineCardStatus(Integer.valueOf(2));
        }
        logger.info("\u8c03\u7528\u6d3b\u52a8\u5f00\u5361={}", (Object)("time:" + System.currentTimeMillis()));
        ResponseData integerResponseData = this.activityServiceRpc.executeActivity(memberInfoModel);
        logger.info("open card executeActivity result {}", (Object)JSON.toJSONString((Object)integerResponseData));
        int responseDataData = integerResponseData.getCode();
        if (responseDataData != 0) {
            logger.info("\u5f00\u5361\u6d3b\u52a8\u901a\u77e5\u5931\u8d25");
            return responseData;
        }
        logger.info("\u5f00\u5361\u6d3b\u52a8\u901a\u77e5\u6210\u529f");
        return responseData;
    }

    @Async
    public ResponseData inviteOpenCoder(String memberCode, String oderMemberCode, String mktTaskId) {
        ResponseData responseData = new ResponseData();
        logger.info("open card inviteOpenCoder memberCode {}, oldMemberCode {}", (Object)memberCode, (Object)oderMemberCode);
        if (StringUtils.isNotBlank((CharSequence)oderMemberCode)) {
            MemberInfoApiModel members = new MemberInfoApiModel();
            members.setMemberCode(memberCode);
            ResponseData memberModel = this.memberInfoApiService.getMemberModel((MemberInfoModel)members);
            MemberInfoModel memberInfoModel = (MemberInfoModel)memberModel.getData();
            InviteSuccessVO inviteSuccessVO = new InviteSuccessVO();
            inviteSuccessVO.setInviteMemberCode(oderMemberCode);
            inviteSuccessVO.setMemberCode(memberCode);
            Long aLong = mktTaskId == null || "null".equals(mktTaskId) ? Long.valueOf(0L) : Long.valueOf(mktTaskId);
            inviteSuccessVO.setTaskType(Integer.valueOf(3));
            inviteSuccessVO.setMktTaskId(aLong);
            inviteSuccessVO.setOpenCardTime(memberInfoModel.getOpenCardTime());
            this.taskInviteServiceRpc.doAwardInvite(inviteSuccessVO);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        logger.info("\u975e\u9080\u8bf7\u5f00\u5361");
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    @Async
    public ResponseData changeFansToMember(String openId, String appId, String memberCode, Long sysCompanyId, Long sysBrandId) {
        ResponseData responseData = new ResponseData();
        logger.info("changeFansToMember openId {}, appId {}, memberCode {}", new Object[]{openId, appId, memberCode});
        this.wxqyInteractHistoryServiceRpc.changeFansToMember(openId, appId, memberCode, sysCompanyId, sysBrandId);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }
}

