/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.filter;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class RequestWrapper
extends HttpServletRequestWrapper {
    private final byte[] body;
    private Map<String, String> customHeaders;

    public RequestWrapper(HttpServletRequest request) {
        super(request);
        String sessionStream = this.getBodyString((ServletRequest)request);
        this.body = sessionStream.getBytes(Charset.forName("UTF-8"));
        this.customHeaders = new HashMap();
    }

    public void putHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public String getHeader(String name) {
        String value = (String)this.customHeaders.get(name);
        if (value != null) {
            return value;
        }
        return ((HttpServletRequest)this.getRequest()).getHeader(name);
    }

    public Enumeration<String> getHeaderNames() {
        HashSet set = new HashSet(this.customHeaders.keySet());
        Enumeration enumeration = ((HttpServletRequest)this.getRequest()).getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            set.add(name);
        }
        return Collections.enumeration(set);
    }

    public String getBodyString(ServletRequest request) {
        StringBuilder sb = new StringBuilder();
        try (InputStream inputStream = this.cloneInputStream(request.getInputStream());
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("UTF-8")));){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public InputStream cloneInputStream(ServletInputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int len;
            while ((len = inputStream.read(buffer)) > -1) {
                byteArrayOutputStream.write(buffer, 0, len);
            }
            byteArrayOutputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.body);
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

