/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers.wechatmall;

import com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.models.vo.GetDistributorNameByMemberCodeListRequestVO;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.customized.facade.utils.ResponseUtils;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.query.CouponMemberPo;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/IntegralOrder"})
public class IntegralOrderDistributorNameService {
    private static final Logger log = LoggerFactory.getLogger(IntegralOrderDistributorNameService.class);
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;

    @GetMapping(value={"/getDistributorNameByStoreId"})
    public ResponseData getDistributorNameByStoreCode(@RequestParam String memberCode) {
        log.info("IntegralOrderDistributorNameService#getDistributorNameByStoreCode storeId:{}", (Object)JSON.toJSONString((Object)memberCode));
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        log.info("singleMemberModel:{}", (Object)JSON.toJSONString((Object)singleMemberModel.getData()));
        MemberInfoModel data = (MemberInfoModel)singleMemberModel.getData();
        return this.storeServiceRpc.getDistributorName(data.getServiceStoreId());
    }

    @PostMapping(value={"/getDistributorNameByMemberCodeList"})
    public ResponseData getDistributorNameByMemberCodeList(@RequestBody GetDistributorNameByMemberCodeListRequestVO requestVO) {
        log.info("IntegralOrderDistributorNameService#getDistributorNameByMemberCodeList#MemberCodeListStr:{}", (Object)JSON.toJSONString((Object)requestVO.getMemberCodeListStr()));
        if (StringUtils.isEmpty((Object)requestVO.getMemberCodeListStr())) {
            return ResponseUtils.getFailedData((String)"\u4f20\u5165\u7684\u4f1a\u5458\u552f\u4e00\u6807\u5fd7\u4e3a\u7a7a");
        }
        requestVO.setMemberCodeList(JSON.parseArray((String)requestVO.getMemberCodeListStr(), String.class));
        if (CollectionUtils.isEmpty((Collection)requestVO.getMemberCodeList())) {
            return ResponseUtils.getFailedData((String)"\u4f20\u5165\u7684\u4f1a\u5458\u552f\u4e00\u6807\u5fd7\u96c6\u5408\u4e3a\u7a7a");
        }
        CouponMemberPo searchPo = new CouponMemberPo();
        searchPo.setMemberCodeList(requestVO.getMemberCodeList());
        ResponseData responseData = new ResponseData();
        ResponseData memberInfoByCodeList = this.memberInfoApiService.getMemberInfoByCodeList(searchPo);
        log.info("singleMemberModel:{}", (Object)JSON.toJSONString((Object)memberInfoByCodeList));
        if (memberInfoByCodeList == null || CollectionUtils.isEmpty((Collection)((Collection)memberInfoByCodeList.getData()))) {
            return ResponseUtils.getFailedData((String)"\u4f20\u5165\u7684\u4f1a\u5458\u83b7\u53d6\u7684\u8d44\u6599\u4e3a\u7a7a");
        }
        List storeList = ((List)memberInfoByCodeList.getData()).stream().filter(item -> !ObjectUtils.isEmpty((Object)item.getServiceStoreId())).map(MemberInfoModel::getServiceStoreId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(storeList)) {
            return ResponseUtils.getFailedData((String)"\u4f1a\u5458\u5f52\u5c5e\u95e8\u5e97\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        ResponseData distributorNameMap = this.storeServiceRpc.getDistributorNameMap(storeList);
        if (MapUtils.isEmpty((Map)((Map)distributorNameMap.getData()))) {
            return ResponseUtils.getFailedData((String)"\u4f1a\u5458\u5f52\u5c5e\u6e20\u9053\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        HashMap resultMap = new HashMap();
        ((List)memberInfoByCodeList.getData()).forEach(item -> resultMap.put(item.getMemberCode(), ((Map)distributorNameMap.getData()).get(item.getServiceStoreId())));
        responseData.setData(resultMap);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }
}

