/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers.mj;

import com.bizvane.appletservice.interfaces.MemberCenterService;
import com.bizvane.appletservice.models.bo.MemberResoucreBO;
import com.bizvane.appletservice.models.vo.MemberPersonalDataVo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.messagebase.common.constants.SysResponseEnum;
import com.bizvane.mktcenterservice.models.bo.TaskDetailBO;
import com.bizvane.utils.commonutils.DateUtils;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u68a6\u6d01\u4f1a\u5458\u4e2d\u5fc3"})
@RestController
@RequestMapping(value={"mjMemberCenter"})
public class MjMemberCenterController {
    private static final Logger log = LoggerFactory.getLogger(MjMemberCenterController.class);
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private MemberCenterService memberCenterService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;

    @RequestMapping(value={"getMemberData"}, method={RequestMethod.GET})
    public ResponseData<MemberPersonalDataVo> getMemberData(@RequestParam(value="memberCode", required=false) String memberCode, @RequestParam(value="sysBrandId", required=false) Long sysBrandId, @RequestParam(value="sysCompanyId", required=false) Long sysCompanyId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData(SysResponseEnum.SUCCESS.getCode(), SysResponseEnum.SUCCESS.getMessage());
        MemberPersonalDataVo vo = new MemberPersonalDataVo();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null || "".equals(memberCode)) {
            return responseData;
        }
        sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        long day = 0L;
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        memberInfoModel.setSysCompanyId(sysCompanyId);
        memberInfoModel.setBrandId(sysBrandId);
        ResponseData modelResponseData = this.memberInfoApiService.getMemberModel(memberInfoModel);
        if (modelResponseData != null && SysResponseEnum.SUCCESS.getCode() == modelResponseData.getCode() && null != modelResponseData.getData()) {
            MemberInfoModel data = (MemberInfoModel)modelResponseData.getData();
            Date openCardTime = data.getOpenCardTime();
            Date nowDate = new Date();
            try {
                day = DateUtils.daysBetween((Date)openCardTime, (Date)nowDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            ++day;
        }
        vo.setOpenCardDay(Long.valueOf(day));
        MemberResoucreBO memberResoucreBO = new MemberResoucreBO();
        memberResoucreBO.setMemberCode(memberCode);
        memberResoucreBO.setBrandId(sysBrandId);
        memberResoucreBO.setSysCompanyId(sysCompanyId);
        ResponseData accordWithProfileTask = this.memberCenterService.getAccordWithProfileTask(memberResoucreBO);
        if (accordWithProfileTask != null && SysResponseEnum.SUCCESS.getCode() == accordWithProfileTask.getCode() && CollectionUtils.isNotEmpty((Collection)((Collection)accordWithProfileTask.getData()))) {
            List data = (List)accordWithProfileTask.getData();
            TaskDetailBO taskDetailBO = (TaskDetailBO)data.get(0);
            vo.setProfileTaskId(taskDetailBO.getMktTaskId());
            vo.setPoints(taskDetailBO.getPoints());
        }
        responseData.setData((Object)vo);
        return responseData;
    }

    @RequestMapping(value={"getOenCardDay"}, method={RequestMethod.POST})
    public ResponseData<Long> getOenCardDay(@RequestParam(value="memberCode", required=false) String memberCode, @RequestParam(value="sysBrandId", required=false) Long sysBrandId, @RequestParam(value="sysCompanyId", required=false) Long sysCompanyId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData(SysResponseEnum.SUCCESS.getCode(), SysResponseEnum.SUCCESS.getMessage());
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null || "".equals(memberCode)) {
            return responseData;
        }
        sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        long day = 0L;
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        memberInfoModel.setSysCompanyId(sysCompanyId);
        memberInfoModel.setBrandId(sysBrandId);
        ResponseData modelResponseData = this.memberInfoApiService.getMemberModel(memberInfoModel);
        if (modelResponseData != null && SysResponseEnum.SUCCESS.getCode() == modelResponseData.getCode() && null != modelResponseData.getData()) {
            MemberInfoModel data = (MemberInfoModel)modelResponseData.getData();
            Date openCardTime = data.getOpenCardTime();
            Date nowDate = new Date();
            try {
                day = DateUtils.daysBetween((Date)openCardTime, (Date)nowDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            ++day;
        }
        responseData.setData((Object)day);
        return responseData;
    }
}

