/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.interfaces.WeChatAppletSubscribeMsgService;
import com.bizvane.appletservice.models.vo.SubscribeMessageCloseRequestVO;
import com.bizvane.appletservice.models.vo.SubscribeMessageRequestVO;
import com.bizvane.appletservice.models.vo.SubscribeMsgAuthRequestVO;
import com.bizvane.appletservice.models.vo.SubscribeMsgAuthResponseVO;
import com.bizvane.messagefacade.models.vo.WeChatAppletSubscribeResponseVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/subscribeMsg"})
public class WeChatAppletSubscribeMsgController {
    private static final Logger log = LoggerFactory.getLogger(WeChatAppletSubscribeMsgController.class);
    @Autowired
    private WeChatAppletSubscribeMsgService weChatAppletSubscribeMsgService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;

    @PostMapping(value={"/querySubscribeMsgAuth"})
    public ResponseData<? extends WeChatAppletSubscribeResponseVO> queryBrandWeChatAppletSubscribe(@RequestBody @Valid SubscribeMsgAuthRequestVO subscribeMsgAuthRequestVO, HttpServletRequest request) {
        log.info("queryBrandWeChatAppletSubscribe#subscribeMsgAuthRequestVO:{}", (Object)JSON.toJSONString((Object)subscribeMsgAuthRequestVO));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u672a\u83b7\u53d6bizvaneSessionId");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        String sysBrandId = request.getHeader("sysBrandId");
        if (StringUtils.isBlank((CharSequence)sysBrandId)) {
            responseData.setCode(100);
            responseData.setMessage("\u83b7\u53d6\u54c1\u724cid\u9519\u8bef");
            return responseData;
        }
        subscribeMsgAuthRequestVO.setBrandId(Long.valueOf(sysBrandId));
        SubscribeMsgAuthResponseVO subscribeMsgAuthResponseVO = this.weChatAppletSubscribeMsgService.queryBrandWeChatAppletSubscribeData(subscribeMsgAuthRequestVO);
        responseData.setData((Object)subscribeMsgAuthResponseVO);
        return responseData;
    }

    @PostMapping(value={"subscribeMessageRequest"})
    public ResponseData subscribeMessageRequest(@RequestBody @Valid SubscribeMessageRequestVO subscribeMessageRequestVO, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u672a\u83b7\u53d6bizvaneSessionId");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        subscribeMessageRequestVO.setMemberCode(memberCode);
        return this.weChatAppletSubscribeMsgService.subscribeMessageRequest(subscribeMessageRequestVO);
    }

    @PostMapping(value={"closeSubscribeMessage"})
    public ResponseData closeSubscribeMessage(@RequestBody @Valid SubscribeMessageCloseRequestVO subscribeMessageCloseRequestVO, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u672a\u83b7\u53d6bizvaneSessionId");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        String sysBrandId = request.getHeader("sysBrandId");
        if (StringUtils.isBlank((CharSequence)sysBrandId)) {
            responseData.setCode(100);
            responseData.setMessage("\u83b7\u53d6\u54c1\u724cid\u9519\u8bef");
            return responseData;
        }
        subscribeMessageCloseRequestVO.setBrandId(Long.valueOf(sysBrandId));
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.weChatAppletSubscribeMsgService.closeSubscribeMessage(subscribeMessageCloseRequestVO);
    }
}

