/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.interfaces.LoginService;
import com.bizvane.appletservice.models.bo.MemberResoucreBO;
import com.bizvane.appletservice.models.bo.PayLevelCardBo;
import com.bizvane.appletservice.models.vo.PayLevelCardShowVo;
import com.bizvane.appletservice.models.vo.UpgradeAmountVO;
import com.bizvane.appletservice.utils.MathUtils;
import com.bizvane.fitmentservice.models.Rpc.AppletVipCardRpc;
import com.bizvane.fitmentservice.models.vo.AppletPayVipCardRequestVO;
import com.bizvane.fitmentservice.models.vo.AppletPayVipCardResponseVO;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.MembersSysModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MemberLevelApiService;
import com.bizvane.members.facade.service.api.MemberLevelRechargeApiService;
import com.bizvane.members.facade.vo.MemberRechargeLevelRespVo;
import com.bizvane.members.facade.vo.PayLevelCardRequestVO;
import com.bizvane.members.facade.vo.PayLevelCardResponseVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import io.jsonwebtoken.lang.Collections;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/payLevelCard"})
public class PayLevelCardController {
    private static final Logger log = LoggerFactory.getLogger(PayLevelCardController.class);
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private MemberLevelApiService memberLevelApiService;
    @Autowired
    private AppletVipCardRpc appletVipCardRpc;
    @Autowired
    private MemberLevelRechargeApiService memberLevelRechargeApiService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private LoginService loginService;

    @PostMapping(value={"/getPayLevelCardShow"})
    public ResponseData<PayLevelCardShowVo> getPayLevelCardShow(HttpServletRequest request) {
        MemberResoucreBO memberResoucreBO = this.loginService.getMemberResourceBO();
        Long sysBrandId = memberResoucreBO.getBrandId();
        Long sysCompanyId = memberResoucreBO.getSysCompanyId();
        String memberCode = memberResoucreBO.getMemberCode();
        ResponseData responseData = new ResponseData();
        MemberInfoModel searchModel = new MemberInfoModel();
        searchModel.setMemberCode(memberCode);
        searchModel.setSysCompanyId(sysCompanyId);
        searchModel.setBrandId(sysBrandId);
        ResponseData memberResponse = this.memberInfoApiService.getSingleMemberModel(searchModel);
        if (memberResponse == null || memberResponse.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u67e5\u8be2\u4f1a\u5458\u72b6\u6001\u5931\u8d25");
            return responseData;
        }
        MemberInfoModel member = (MemberInfoModel)memberResponse.getData();
        PayLevelCardRequestVO payLevelCardRequestVO = new PayLevelCardRequestVO();
        payLevelCardRequestVO.setSysCompanyId(sysCompanyId);
        payLevelCardRequestVO.setBrandId(sysBrandId);
        ResponseData payLevelCardResponseVOResponseData = this.memberLevelApiService.queryPayLevelCard(payLevelCardRequestVO);
        if (payLevelCardResponseVOResponseData == null || SysResponseEnum.SUCCESS.getCode() != payLevelCardResponseVOResponseData.getCode()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u67e5\u8be2\u4ed8\u8d39\u5361\u4fe1\u606f\u5931\u8d25");
            return responseData;
        }
        PayLevelCardResponseVO payLevelCardResponseVO = (PayLevelCardResponseVO)payLevelCardResponseVOResponseData.getData();
        if (payLevelCardResponseVO == null || Collections.isEmpty((Collection)payLevelCardResponseVO.getPayLevelCardBos())) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u65e0\u4ed8\u8d39\u5361\u4fe1\u606f");
            return responseData;
        }
        List mbrLevelIds = payLevelCardResponseVO.getPayLevelCardBos().stream().map(x -> x.getMbrLevelId()).collect(Collectors.toList());
        AppletPayVipCardRequestVO appletPayVipCardRequestVO = new AppletPayVipCardRequestVO();
        appletPayVipCardRequestVO.setSysCompanyId(sysCompanyId);
        appletPayVipCardRequestVO.setSysBrandId(sysBrandId);
        appletPayVipCardRequestVO.setGradeIdList(mbrLevelIds);
        ResponseData cardResponseData = this.appletVipCardRpc.queryAppletPayVipCard(appletPayVipCardRequestVO);
        if (cardResponseData == null || cardResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u67e5\u8be2\u4ed8\u8d39\u5361\u8be6\u60c5\u5931\u8d25");
            return responseData;
        }
        Map map = ((List)cardResponseData.getData()).stream().collect(Collectors.toMap(AppletPayVipCardResponseVO::getGradeId, Function.identity()));
        Long payLevel = null;
        if (mbrLevelIds.contains(member.getLevelId())) {
            log.info("\u5f53\u524d\u4f1a\u5458\u662f\u4ed8\u8d39\u5361\u7b49\u7ea7:{}", (Object)member.getLevelId());
            payLevel = member.getLevelId();
        }
        Map payLevelCardBoMap = payLevelCardResponseVO.getPayLevelCardBos().stream().collect(Collectors.toMap(com.bizvane.members.facade.models.bo.PayLevelCardBo::getMbrLevelId, Function.identity()));
        com.bizvane.members.facade.models.bo.PayLevelCardBo memberCard = (com.bizvane.members.facade.models.bo.PayLevelCardBo)payLevelCardBoMap.get(payLevel);
        ResponseData membersSysModel = this.memberLevelApiService.queryMemberSys(sysBrandId);
        boolean paidMembershipUpgradeSwitch = ((MembersSysModel)membersSysModel.getData()).getPaidMembershipUpgradeSwitch();
        Long finalPayLevel = payLevel;
        List payLevelCardBoList = mbrLevelIds.stream().map(level -> {
            com.bizvane.members.facade.models.bo.PayLevelCardBo payLevelCardSource = (com.bizvane.members.facade.models.bo.PayLevelCardBo)payLevelCardBoMap.get(level);
            PayLevelCardBo payLevelCardBo = new PayLevelCardBo();
            payLevelCardBo.setMbrLevelId(level);
            payLevelCardBo.setLevelName(payLevelCardSource.getLevelName());
            payLevelCardBo.setPayMoney(payLevelCardSource.getPayMoney());
            AppletPayVipCardResponseVO vipCardResponseVO = (AppletPayVipCardResponseVO)map.get(level);
            payLevelCardBo.setSlogan(vipCardResponseVO != null ? vipCardResponseVO.getSlogan() : null);
            payLevelCardBo.setDescription(vipCardResponseVO != null ? vipCardResponseVO.getDescription() : null);
            if (finalPayLevel == null) {
                payLevelCardBo.setStatus(Integer.valueOf(0));
            } else if (level.equals(finalPayLevel)) {
                payLevelCardBo.setStatus(Integer.valueOf(1));
            } else if (paidMembershipUpgradeSwitch) {
                boolean payMoneyMatch = memberCard.getPayMoney().doubleValue() <= payLevelCardSource.getPayMoney().doubleValue();
                boolean effectiveYearMatch = payLevelCardSource.getEffectiveYear().equals(memberCard.getEffectiveYear());
                if (!payMoneyMatch) {
                    log.info("A\u5361\u652f\u4ed8\u91d1\u989d\u5927\u4e8eB\u5361\u652f\u4ed8\u91d1\u989d\uff0c\u65e0\u6cd5\u5347\u7ea7\uff0cA\u5361\u652f\u4ed8\u91d1\u989d\uff1a{}\uff0cB\u5361\u652f\u4ed8\u91d1\u989d\uff1a{}", (Object)memberCard.getPayMoney().doubleValue(), (Object)payLevelCardSource.getPayMoney().doubleValue());
                } else if (!effectiveYearMatch) {
                    log.info("A\u5361\u6709\u6548\u5929\u6570\u548cB\u5361\u6709\u6548\u5929\u6570\u4e0d\u76f8\u7b49\uff0c\u65e0\u6cd5\u5347\u7ea7\uff0cA\u5361\u6709\u6548\u5929\u6570\uff1a{}\uff0cB\u5361\u6709\u6548\u5929\u6570\uff1a{}", (Object)memberCard.getEffectiveYear(), (Object)payLevelCardSource.getEffectiveYear());
                } else {
                    ResponseData memberRechargeLevelRes = this.memberLevelRechargeApiService.getMemberRechargeLevel(sysBrandId, memberCode, member.getLevelId());
                    log.info("\u5f53\u524d\u5361\u8bb0\u5f55:{}", (Object)JSONObject.toJSONString((Object)memberRechargeLevelRes.getData()));
                    UpgradeAmountVO upgradeAmountVO = MathUtils.calculateUpgradeAmount((com.bizvane.members.facade.models.bo.PayLevelCardBo)memberCard, (com.bizvane.members.facade.models.bo.PayLevelCardBo)payLevelCardSource, (Date)((MemberRechargeLevelRespVo)memberRechargeLevelRes.getData()).getEffectiveDate());
                    if (upgradeAmountVO != null) {
                        payLevelCardBo.setStatus(Integer.valueOf(2));
                        payLevelCardBo.setUpgradeAmount(upgradeAmountVO);
                    }
                }
            }
            if (payLevelCardBo.getStatus() == null) {
                payLevelCardBo.setStatus(Integer.valueOf(3));
            }
            return payLevelCardBo;
        }).collect(Collectors.toList());
        PayLevelCardShowVo payLevelCardShowVo = new PayLevelCardShowVo();
        payLevelCardShowVo.setPayLevelCardBos(payLevelCardBoList);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)payLevelCardShowVo);
        return responseData;
    }
}

