/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.interfaces.IntegrationShopService;
import com.bizvane.appletservice.interfaces.LoginService;
import com.bizvane.appletservice.interfaces.MemberPrivilegeService;
import com.bizvane.appletservice.interfaces.MembershipCardService;
import com.bizvane.appletservice.models.bo.AppletCardLevelPrivLegeBo;
import com.bizvane.appletservice.models.bo.MemberResoucreBO;
import com.bizvane.appletservice.models.po.AppletVipCartPO;
import com.bizvane.appletservice.models.vo.MemberInfoIntegralVo;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.fitmentservice.models.Rpc.AppletResourcesRpc;
import com.bizvane.fitmentservice.models.po.AppletResourcesPO;
import com.bizvane.members.facade.models.IntegralRecordModel;
import com.bizvane.members.facade.models.MbrIntegralModel;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.models.MemberCardLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberCardProgramApiService;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MemberLevelApiService;
import com.bizvane.members.facade.vo.IntegralRecordVo;
import com.bizvane.messagefacade.interfaces.SendPointMsgServiceFeign;
import com.bizvane.unifiedreg.model.vo.MbrConsumeBehaviorVo;
import com.bizvane.unifiedreg.rpc.MemberBehaviorApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/memberCardProgram"})
public class MenberCenterGradeController {
    @Autowired
    private MemberCardProgramApiService memberCardProgramApiService;
    @Autowired
    private MemberPrivilegeService memberPrivilegeService;
    @Autowired
    private MembershipCardService membershipCardService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private MemberLevelApiService memberLevelApiService;
    @Autowired
    private AppletResourcesRpc appletResourcesRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    private DecimalFormat df = new DecimalFormat("###,###.00");
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    @Autowired
    private MemberBehaviorApiService memberBehaviorApiService;
    @Autowired
    private LoginService loginService;
    @Value(value="#{'${privatizationBrand.mengjie}'.split(',')}")
    private List<Long> mJBrandList;
    @Autowired
    private SendPointMsgServiceFeign sendPointMsgServiceFeign;
    @Autowired
    private IntegrationShopService integrationShopService;

    @RequestMapping(value={"/queryMemberCardInfo"}, method={RequestMethod.POST})
    public ResponseData<MemberCardLevelModel> queryMemberCardInfo(@RequestParam(required=false, name="roundingMode", defaultValue="0") Byte roundingMode, @RequestParam(required=false, name="appletVipPrivilegeVersion") Integer appletVipPrivilegeVersion, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        MemberResoucreBO memberResoucreBO = this.loginService.getMemberResourceBO();
        ResponseData memberCardLevelModelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        AppletCardLevelPrivLegeBo appletCardLevelPrivLegeBo = new AppletCardLevelPrivLegeBo();
        appletCardLevelPrivLegeBo.setAdditionalDiscount(((MemberCardLevelModel)memberCardLevelModelResponseData.getData()).getAdditionalDiscount());
        appletCardLevelPrivLegeBo.setBarCode(((MemberCardLevelModel)memberCardLevelModelResponseData.getData()).getBarCode());
        appletCardLevelPrivLegeBo.setCardNo(((MemberCardLevelModel)memberCardLevelModelResponseData.getData()).getCardNo());
        Integer countIntegral = ((MemberCardLevelModel)memberCardLevelModelResponseData.getData()).getCountIntegral();
        appletCardLevelPrivLegeBo.setCountIntegral(String.valueOf(ObjectUtils.defaultIfNull((Object)countIntegral, (Object)"0")));
        appletCardLevelPrivLegeBo.setLevelId(((MemberCardLevelModel)memberCardLevelModelResponseData.getData()).getLevelId());
        appletCardLevelPrivLegeBo.setLevelName(((MemberCardLevelModel)memberCardLevelModelResponseData.getData()).getLevelName());
        appletCardLevelPrivLegeBo.setMemberDiscount(((MemberCardLevelModel)memberCardLevelModelResponseData.getData()).getMemberDiscount());
        appletCardLevelPrivLegeBo.setOfflineCardNo(((MemberCardLevelModel)memberCardLevelModelResponseData.getData()).getOfflineCardNo());
        appletCardLevelPrivLegeBo.setWxHeadPortraits(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)((MemberCardLevelModel)memberCardLevelModelResponseData.getData()).getWxHeadPortraits()));
        appletCardLevelPrivLegeBo.setWxNick(((MemberCardLevelModel)memberCardLevelModelResponseData.getData()).getWxNick());
        ResponseData mbrConsumeBehaviorVoResponseData = this.memberBehaviorApiService.selectModelByMemberCode(memberResoucreBO.getSysCompanyId(), memberResoucreBO.getBrandId(), memberResoucreBO.getMemberCode());
        if (mbrConsumeBehaviorVoResponseData != null && mbrConsumeBehaviorVoResponseData.getData() != null) {
            appletCardLevelPrivLegeBo.setMbrConsumeAllMoney(((MbrConsumeBehaviorVo)mbrConsumeBehaviorVoResponseData.getData()).getConsumeAmountAll());
        }
        BigDecimal mbrConsumeAllMoney = appletCardLevelPrivLegeBo.getMbrConsumeAllMoney();
        Long brandId = memberResoucreBO.getBrandId();
        if (null != brandId && CollectionUtils.isNotEmpty((Collection)this.mJBrandList) && this.mJBrandList.contains(brandId)) {
            roundingMode = null == roundingMode || roundingMode == 0 ? (byte)4 : roundingMode;
            BigDecimal bigDecimal = mbrConsumeAllMoney = null == mbrConsumeAllMoney ? new BigDecimal(0.0) : mbrConsumeAllMoney;
        }
        if (null != roundingMode && roundingMode == 4) {
            mbrConsumeAllMoney = mbrConsumeAllMoney.setScale(0, 1);
        } else if (null != roundingMode && roundingMode == 3) {
            mbrConsumeAllMoney = mbrConsumeAllMoney.setScale(0, 0);
        } else if (null != roundingMode && roundingMode == 2) {
            mbrConsumeAllMoney = mbrConsumeAllMoney.setScale(0, 5);
        }
        appletCardLevelPrivLegeBo.setMbrConsumeAllMoney(mbrConsumeAllMoney);
        Long levelId = ((MemberCardLevelModel)memberCardLevelModelResponseData.getData()).getLevelId();
        ResponseData modelResponseData = this.memberLevelApiService.queryLevelModel(levelId);
        MbrLevelModel levelModel = (MbrLevelModel)modelResponseData.getData();
        if (modelResponseData.getData() == null) {
            appletCardLevelPrivLegeBo.setDiscountMethod(Integer.valueOf(1));
        } else if (levelModel.getDiscountMethod() == null) {
            appletCardLevelPrivLegeBo.setDiscountMethod(Integer.valueOf(1));
        } else {
            appletCardLevelPrivLegeBo.setDiscountMethod(levelModel.getDiscountMethod());
        }
        ResponseData appletVipCartPo = this.membershipCardService.selectByPrimaryKey(levelId);
        if (appletVipCartPo != null || appletVipCartPo.getData() != null) {
            for (AppletVipCartPO vipCartPO : (List)appletVipCartPo.getData()) {
                if (vipCartPO.getCardStyle() != null) {
                    if (vipCartPO.getIsImg().booleanValue()) {
                        appletCardLevelPrivLegeBo.setImg(vipCartPO.getIsImg());
                        appletCardLevelPrivLegeBo.setCardStyle(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)vipCartPO.getCardStyle()));
                    } else {
                        appletCardLevelPrivLegeBo.setCardStyle(vipCartPO.getCardStyle());
                    }
                }
                appletCardLevelPrivLegeBo.setFontColor(vipCartPO.getFontColor());
                if (vipCartPO.getAppletVipCardId() != null) {
                    ResponseData listCardId = this.memberPrivilegeService.getMemberPrivilegebyGrderNew(memberResoucreBO.getBrandId(), vipCartPO.getAppletVipCardId(), vipCartPO.getGradeId(), appletVipPrivilegeVersion);
                    List listCardIdData = (List)listCardId.getData();
                    appletCardLevelPrivLegeBo.setAppletVipPrivilegePOList(listCardIdData);
                    continue;
                }
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u4f1a\u5458\u5361 id \u4e3a\u7a7a");
                responseData.setData(null);
                return responseData;
            }
        } else {
            responseData.setMessage("\u9ed8\u8ba4\u4f1a\u5458\u5361\u672a\u83b7\u53d6");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        logger.info("\u4fdd\u5b58\u95ee\u5377 \u67e5\u8be2\u4f1a\u5458\u4fe1\u606f={}", (Object)JSON.toJSONString((Object)singleMemberModel));
        MemberInfoModel member = (MemberInfoModel)singleMemberModel.getData();
        JSONObject result = (JSONObject)JSON.toJSON((Object)appletCardLevelPrivLegeBo);
        logger.info("\u89e3\u6790\u540e\u7684\u503c={}    memberdata={}", (Object)result.toJSONString(), (Object)member);
        if (member != null) {
            logger.info("\u8c03\u7528fitment\u4f1a\u5458\u5361\u88c5\u4fee\u4fe1\u606f");
            ResponseData vipCardInfo = this.appletResourcesRpc.getAppletResourcesPO("M007", member.getBrandId(), member.getSysCompanyId());
            logger.info("\u8c03\u7528fitment\u4f1a\u5458\u5361\u88c5\u4fee\u4fe1\u606f\u6570\u636e={}", (Object)JSON.toJSONString((Object)vipCardInfo));
            if (vipCardInfo.getCode() == 0) {
                result.put("codeType", (Object)((AppletResourcesPO)vipCardInfo.getData()).getModularContent());
            } else {
                result.put("codeType", (Object)"1");
            }
            logger.info("\u4f1a\u5458\u5361\u57fa\u672c\u4fe1\u606f={}", (Object)JSON.toJSONString((Object)appletCardLevelPrivLegeBo));
        }
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)result);
        return responseData;
    }

    @RequestMapping(value={"/queryMemberIntegral"}, method={RequestMethod.POST})
    public ResponseData<MbrIntegralModel> queryMemberIntegral(HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        logger.info("queryMemberIntegral param={}", (Object)memberCode);
        ResponseData memberInfoModelResponseData = this.memberCardProgramApiService.queryMemberIntegral(memberCode);
        MbrIntegralModel modelResponseDataData = (MbrIntegralModel)memberInfoModelResponseData.getData();
        logger.info("queryMemberIntegral \u51fa\u53c2={}", (Object)JacksonUtil.bean2Json((Object)modelResponseDataData));
        logger.info("queryMemberIntegral \u79ef\u5206={}", (Object)modelResponseDataData.getCountIntegral());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)modelResponseDataData);
        return responseData;
    }

    @RequestMapping(value={"/queryMemberIntegralNew"}, method={RequestMethod.GET})
    public ResponseData<MemberInfoIntegralVo> queryMemberIntegralNew(HttpServletRequest request) {
        MemberResoucreBO memberResoucreBO = this.loginService.getMemberResourceBO();
        logger.info("queryMemberIntegralNew#memberResoucreBO:{}", (Object)JacksonUtil.bean2Json((Object)memberResoucreBO));
        ResponseData memberInfoModelResponseData = this.memberCardProgramApiService.queryMemberIntegral(memberResoucreBO.getMemberCode());
        MbrIntegralModel memberInfoModel = (MbrIntegralModel)memberInfoModelResponseData.getData();
        MemberInfoIntegralVo memberInfoIntegralVo = new MemberInfoIntegralVo();
        if (memberInfoModel != null) {
            logger.info("queryMemberIntegralNew#queryMemberIntegral,memberCode:{},countIntegral:{},aboutExpireIntegral:{}", new Object[]{memberInfoModel.getMemberCode(), memberInfoModel.getCountIntegral(), memberInfoModel.getAboutExpireIntegral()});
            BeanUtils.copyProperties((Object)memberInfoModel, (Object)memberInfoIntegralVo);
        }
        if (!CollectionUtils.isEmpty((Collection)this.mJBrandList) && this.mJBrandList.contains(memberResoucreBO.getBrandId())) {
            Long mjExpirePoints = this.integrationShopService.getMjExpirePoints(memberResoucreBO.getSysCompanyId(), memberResoucreBO.getBrandId(), memberResoucreBO.getMemberCode());
            memberInfoIntegralVo.setMemberMonthExpirePoints(mjExpirePoints);
        }
        return new ResponseData((Object)memberInfoIntegralVo);
    }

    @RequestMapping(value={"/queryMemberIntegralRecord"}, method={RequestMethod.POST})
    public ResponseData<PageInfo<IntegralRecordModel>> queryMemberIntegralRecord(IntegralRecordVo vo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        vo.setMemberCode(memberCode);
        logger.info("\u4f1a\u5458\u79ef\u5206\u6d41\u6c34\u5165\u53c2={}", (Object)JSON.toJSONString((Object)vo));
        return this.memberCardProgramApiService.queryMemberIntegralRecord(vo);
    }

    @RequestMapping(value={"/queryLevelList"}, method={RequestMethod.POST})
    public ResponseData<List<MbrLevelModel>> queryLevelList(@RequestParam(value="brandId") Long brandId, @RequestParam(value="source") String source) {
        ResponseData responseData = new ResponseData();
        if (brandId == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u54c1\u724c\u7f16\u53f7");
            return responseData;
        }
        if (source == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u6765\u6e90\u4fe1\u606f");
            return responseData;
        }
        return this.memberCardProgramApiService.queryLevelList(brandId, source);
    }
}

