/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.models.bo.CouponEntityAndDefinitionBo;
import com.bizvane.appletservice.models.vo.FindStoreVo;
import com.bizvane.appletservice.models.vo.SubscribeMsgAuthResponseVO;
import com.bizvane.appletserviceimpl.impl.WeChatAppletSubscribeCommonServiceImpl;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.vo.SysStoreVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.couponfacade.interfaces.CouponAuthTmallServiceFeign;
import com.bizvane.couponfacade.interfaces.CouponQueryServiceFeign;
import com.bizvane.couponfacade.interfaces.CouponServiceFeign;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.vo.CouponByTransferVO;
import com.bizvane.couponfacade.models.vo.CouponDetailResponseVO;
import com.bizvane.couponfacade.models.vo.CouponEntityAndDefinitionVO;
import com.bizvane.couponfacade.models.vo.CouponEntityVO;
import com.bizvane.couponfacade.models.vo.CouponListByMemberCodeRequestVO;
import com.bizvane.couponfacade.models.vo.CouponOnlineUseRequestVO;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.messagefacade.enums.WeChatSubscribeMenuEnum;
import com.bizvane.mktcenterservice.models.vo.ActivityManualVO;
import com.bizvane.mktcenterservice.models.vo.ActivityPointsDistributeVO;
import com.bizvane.mktcenterservice.models.vo.ActivityVO;
import com.bizvane.mktcenterservice.models.vo.MktRedPortRecordVO;
import com.bizvane.mktcenterservice.rpc.ActivityCommonServiceRpc;
import com.bizvane.mktcenterservice.rpc.ActivityManualServiceRpc;
import com.bizvane.mktcenterservice.rpc.ActivityPointsDistributeServiceRpc;
import com.bizvane.mktcenterservice.rpc.ActivityRedPortServiceRpc;
import com.bizvane.utils.commonutils.DateUtils;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.catalina.servlet4preview.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/activity"})
public class MenberCenterActivityController {
    @Autowired
    private ActivityManualServiceRpc activityManualServiceRpc;
    @Autowired
    private CouponQueryServiceFeign couponQueryServiceFeign;
    @Autowired
    private CouponServiceFeign couponServiceFeign;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private ActivityRedPortServiceRpc activityRedPortServiceRpc;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private CouponAuthTmallServiceFeign couponAuthTmallServiceFeign;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private ActivityPointsDistributeServiceRpc activityPointsDistributeServiceRpc;
    @Autowired
    private WeChatAppletSubscribeCommonServiceImpl weChatAppletSubscribeCommonService;
    @Autowired
    private ActivityCommonServiceRpc activityCommonServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Value(value="#{'${customized.hongqingting.sysBrandIds:}'.split(',')}")
    private List<Long> cSysBrandIdList;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/getActivityRecordPOList"}, method={RequestMethod.POST})
    public ResponseData<List<ActivityVO>> getActivityRecordPOList(ActivityManualVO vo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        if (vo.getMemberInfoModel().getBrandId() == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u54c1\u724cID");
            return responseData;
        }
        if (vo.getActivityCode() == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u6d3b\u52a8\u7f16\u53f7");
            return responseData;
        }
        if (vo.getActivityType() == null) {
            responseData.setMessage("\u9886\u52b5\u7c7b\u522b\u672a\u8f93\u5165");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        Long openCardStoreId = (Long)this.wxAppletApiService.getOpenCardStoreId(memberCode).getData();
        Long serviceStoreId = (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
        logger.info("openCardStoreId={} , serviceStoreId={}", (Object)openCardStoreId, (Object)serviceStoreId);
        vo.getMemberInfoModel().setOpenCardStoreId(openCardStoreId);
        vo.getMemberInfoModel().setServiceStoreId(serviceStoreId);
        vo.getMemberInfoModel().setMemberCode(memberCode);
        logger.info("\u626b\u7801\u9886\u52b5\u5165\u53c2={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)vo));
        ResponseData byQrcode = this.activityManualServiceRpc.getActivityByQrcode(vo);
        responseData.setData(byQrcode.getData());
        return responseData;
    }

    @RequestMapping(value={"/executeActivity"}, method={RequestMethod.POST})
    public ResponseData<ActivityManualVO> executeActivity(ActivityManualVO vo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        vo.getMemberInfoModel().setMemberCode(memberCode);
        logger.info("\u626b\u7801\u9886\u53d6\u5165\u53c2={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)vo));
        return this.activityManualServiceRpc.executeActivity(vo);
    }

    @RequestMapping(value={"/getActivityByMemberInfo"}, method={RequestMethod.POST})
    public ResponseData<List<ActivityVO>> getActivityByMemberInfo(ActivityManualVO vo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        if (vo.getMemberInfoModel().getBrandId() == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u54c1\u724cID");
            return responseData;
        }
        if (vo.getActivityType() == null) {
            responseData.setMessage("\u9886\u52b5\u7c7b\u522b\u672a\u8f93\u5165");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        vo.getMemberInfoModel().setMemberCode(memberCode);
        Long openCardStoreId = (Long)this.wxAppletApiService.getOpenCardStoreId(memberCode).getData();
        Long serviceStoreId = (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
        logger.info("openCardStoreId={} , serviceStoreId={}", (Object)openCardStoreId, (Object)serviceStoreId);
        vo.getMemberInfoModel().setOpenCardStoreId(openCardStoreId);
        vo.getMemberInfoModel().setServiceStoreId(serviceStoreId);
        logger.info("\u9886\u5238\u4e2d\u5fc3\u5217\u8868={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)vo));
        ResponseData brandByID = this.brandServiceRpc.getBrandByID(vo.getMemberInfoModel().getBrandId());
        Long sysCompanyId = ((SysBrandPo)brandByID.getData()).getSysCompanyId();
        String mktActivityId = (String)this.redisTemplateService.stringGetStringByKey((Object)(memberCode + vo.getMemberInfoModel().getBrandId() + 2));
        MktRedPortRecordVO mktRedPortRecordVO = new MktRedPortRecordVO();
        mktRedPortRecordVO.setType(Integer.valueOf(2));
        mktRedPortRecordVO.setMemberCode(memberCode);
        mktRedPortRecordVO.setSysCompanyId(sysCompanyId);
        mktRedPortRecordVO.setSysBrandId(vo.getMemberInfoModel().getBrandId());
        if (StringUtils.isNotBlank((CharSequence)mktActivityId)) {
            mktRedPortRecordVO.setMktActivityId(Long.valueOf(mktActivityId));
        }
        mktRedPortRecordVO.setServiceStoreId(serviceStoreId);
        logger.info("updateRedPort={}", (Object)JSON.toJSONString((Object)mktRedPortRecordVO));
        this.activityRedPortServiceRpc.updateRedPort(mktRedPortRecordVO);
        return this.activityManualServiceRpc.getActivityByMemberInfo(vo);
    }

    @RequestMapping(value={"/onlyexecuteActivity"}, method={RequestMethod.POST})
    public ResponseData<ActivityManualVO> onlyexecuteActivity(ActivityManualVO vo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        vo.getMemberInfoModel().setMemberCode(memberCode);
        return this.activityManualServiceRpc.executeActivity(vo);
    }

    @RequestMapping(value={"/getCouponListByCondition"}, method={RequestMethod.POST})
    public ResponseData getCouponListByCondition(CouponListByMemberCodeRequestVO vo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        if (vo.getCouponStatus() == null) {
            responseData.setMessage("\u52b5\u7c7b\u578b\u672a\u8f93\u5165");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String companyId = request.getHeader("sysCompanyId");
        String brandId = request.getHeader("sysBrandId");
        if (StringUtils.isEmpty((CharSequence)bizvaneSessionId) || StringUtils.isEmpty((CharSequence)companyId) || StringUtils.isEmpty((CharSequence)brandId)) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId\u6216\u4f01\u4e1aid\u6216\u54c1\u724cid");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        vo.setMemberCode(memberCode);
        vo.setSysCompanyId(Long.valueOf(Long.parseLong(companyId)));
        vo.setSysBrandId(Long.valueOf(Long.parseLong(brandId)));
        if (this.cSysBrandIdList.contains(Long.parseLong(brandId))) {
            MemberInfoModel infoModel = new MemberInfoModel();
            infoModel.setMemberCode(memberCode);
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(infoModel);
            if (singleMemberModel == null || singleMemberModel.getCode() != SysResponseEnum.SUCCESS.getCode() || singleMemberModel.getData() == null) {
                responseData.setMessage("\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u4e3a\u7a7a");
                responseData.setCode(-100);
                return responseData;
            }
            MemberInfoModel model = (MemberInfoModel)singleMemberModel.getData();
            ResponseData modelListRes = this.memberInfoApiService.listMemberInfoByErpId(Collections.singletonList(model.getErpId()), model.getSysCompanyId(), this.cSysBrandIdList);
            if (modelListRes == null || modelListRes.getCode() != SysResponseEnum.SUCCESS.getCode() || CollectionUtils.isEmpty((Collection)((Collection)modelListRes.getData()))) {
                responseData.setMessage("\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u4e3a\u7a7a");
                responseData.setCode(-100);
                return responseData;
            }
            vo.setMemberCode(null);
            vo.setSysBrandId(null);
            vo.setMembersCodeList(((List)modelListRes.getData()).stream().map(MemberInfoModel::getMemberCode).collect(Collectors.toList()));
        }
        logger.info("MenberCenterActivityController-getCouponListByCondition-info,request:{}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)vo));
        ResponseData couponListByMemeberCode = this.couponQueryServiceFeign.getCouponListByMemeberCode(vo);
        logger.info("MenberCenterActivityController-getCouponListByCondition-info,result:{}", (Object)JacksonUtil.bean2Json((Object)couponListByMemeberCode));
        com.bizvane.utils.responseinfo.PageInfo couponListByMemeberCodeData = (com.bizvane.utils.responseinfo.PageInfo)couponListByMemeberCode.getData();
        couponListByMemeberCode.getData();
        com.bizvane.utils.responseinfo.PageInfo boPageInfo = new com.bizvane.utils.responseinfo.PageInfo();
        BeanUtils.copyProperties((Object)couponListByMemeberCodeData, (Object)boPageInfo);
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        ArrayList<CouponEntityAndDefinitionBo> entityAndDefinitionBoList = new ArrayList<CouponEntityAndDefinitionBo>();
        for (CouponEntityAndDefinitionVO couponEntityAndDefinitionVO : couponListByMemeberCodeData.getList()) {
            CouponEntityAndDefinitionBo couponEntityAndDefinitionBo = new CouponEntityAndDefinitionBo();
            BeanUtils.copyProperties((Object)couponEntityAndDefinitionVO, (Object)couponEntityAndDefinitionBo);
            SubscribeMsgAuthResponseVO subscribeMsgAuthResponseVO = this.weChatAppletSubscribeCommonService.queryCouponDetailWeChatAppletSubscribeData(Long.valueOf(Long.parseLong(brandId)), openId, WeChatSubscribeMenuEnum.FIELD_1, couponEntityAndDefinitionVO.getCouponCode());
            couponEntityAndDefinitionBo.setSubscribeMsgAuthResponseVO(subscribeMsgAuthResponseVO);
            if (couponEntityAndDefinitionVO.getTransfer() == null) {
                couponEntityAndDefinitionBo.setOldMemberCode(null);
            } else if (couponEntityAndDefinitionVO.getTransfer().booleanValue()) {
                couponEntityAndDefinitionBo.setOldMemberCode(memberCode);
            }
            Date currentTime = new Date();
            if (couponEntityAndDefinitionVO.getValidDateStart().compareTo(currentTime) < 0 && couponEntityAndDefinitionVO.getValidDateEnd().compareTo(currentTime) > 0) {
                couponEntityAndDefinitionBo.setCurrentTimeAvailable(Boolean.TRUE);
            } else {
                couponEntityAndDefinitionBo.setCurrentTimeAvailable(Boolean.FALSE);
            }
            couponEntityAndDefinitionBo.setLinkShowFlag(this.handleLinkShowFlag(couponEntityAndDefinitionVO));
            entityAndDefinitionBoList.add(couponEntityAndDefinitionBo);
        }
        boPageInfo.setList(entityAndDefinitionBoList);
        logger.info("\u6211\u7684\u4f18\u60e0\u5238\u51fa\u53c2={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)boPageInfo));
        responseData.setData((Object)boPageInfo);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    @RequestMapping(value={"/getCouponListByTransfer"}, method={RequestMethod.POST})
    public ResponseData getCouponListByTransfer(CouponListByMemberCodeRequestVO vo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        logger.info("MenberCenterActivityController getCouponListByTransfer start");
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String companyId = request.getHeader("sysCompanyId");
        String brandId = request.getHeader("sysBrandId");
        if (StringUtils.isEmpty((CharSequence)bizvaneSessionId) || StringUtils.isEmpty((CharSequence)companyId) || StringUtils.isEmpty((CharSequence)brandId)) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId\u6216\u4f01\u4e1aid\u6216\u54c1\u724cid");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isEmpty((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        vo.setMemberCode(memberCode);
        vo.setSysCompanyId(Long.valueOf(Long.parseLong(companyId)));
        vo.setSysBrandId(Long.valueOf(Long.parseLong(brandId)));
        logger.info("MenberCenterActivityController getCouponListByTransfer memberCode={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)vo));
        ResponseData couponListByTransfer = this.couponQueryServiceFeign.getCouponListByTransfer(vo);
        PageInfo couponListByMemeberCodeData = (PageInfo)couponListByTransfer.getData();
        PageInfo boPageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)couponListByMemeberCodeData, (Object)boPageInfo);
        ArrayList<CouponEntityAndDefinitionBo> entityAndDefinitionBoList = new ArrayList<CouponEntityAndDefinitionBo>();
        for (CouponByTransferVO couponByTransferVo : couponListByMemeberCodeData.getList()) {
            CouponEntityAndDefinitionBo couponEntityAndDefinitionBo = new CouponEntityAndDefinitionBo();
            BeanUtils.copyProperties((Object)couponByTransferVo, (Object)couponEntityAndDefinitionBo);
            if (couponByTransferVo.getTransfer() == null) {
                couponEntityAndDefinitionBo.setOldMemberCode(null);
            } else if (couponByTransferVo.getTransfer().booleanValue()) {
                couponEntityAndDefinitionBo.setOldMemberCode(memberCode);
            }
            entityAndDefinitionBoList.add(couponEntityAndDefinitionBo);
        }
        boPageInfo.setList(entityAndDefinitionBoList);
        logger.info("\u6211\u7684\u4f18\u60e0\u5238\u51fa\u53c2={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)boPageInfo));
        responseData.setData((Object)boPageInfo);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    @RequestMapping(value={"/findCouponDetailByCouponId"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<CouponDetailResponseVO> findCouponDetailByCouponId(Long couponEntityId) {
        ResponseData responseData = new ResponseData();
        if (couponEntityId == null) {
            responseData.setMessage(" \u672a\u8f93\u5165\u8868 id");
            return responseData;
        }
        logger.info("\u4f18\u60e0\u5238\u8be6\u60c5={}", (Object)couponEntityId);
        ResponseData couponDetail = this.couponQueryServiceFeign.getCouponDetail(couponEntityId);
        Date validDateStart = ((CouponDetailResponseVO)couponDetail.getData()).getCouponEntityPO().getValidDateStart();
        Date validDateEnd = ((CouponDetailResponseVO)couponDetail.getData()).getCouponEntityPO().getValidDateEnd();
        ((CouponDetailResponseVO)couponDetail.getData()).getCouponDefinitionPO().setValidDateStart(validDateStart);
        ((CouponDetailResponseVO)couponDetail.getData()).getCouponDefinitionPO().setValidDateEnd(validDateEnd);
        logger.info("\u4f18\u60e0\u5238\u8be6\u60c5\u51fa\u53c2={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)couponDetail.getData()));
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData(couponDetail.getData());
        return responseData;
    }

    @RequestMapping(value={"/findStoreByCoupon"}, method={RequestMethod.POST})
    public ResponseData findStoreByCoupon(FindStoreVo vo) {
        logger.info("\u83b7\u53d6\u5238\u9002\u7528\u95e8\u5e97\u5165\u53c2\uff1a" + com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)vo));
        ResponseData responseData = new ResponseData();
        try {
            if (vo.getCouponEntityId() == null) {
                responseData.setMessage(" \u52b5id\u4e0d\u80fd\u4e3a\u7a7a");
                return responseData;
            }
            ResponseData couponDetail = this.couponQueryServiceFeign.getCouponDetail(vo.getCouponEntityId());
            if (couponDetail.getCode() != 0) {
                return couponDetail;
            }
            CouponDetailResponseVO cVo = (CouponDetailResponseVO)couponDetail.getData();
            SysStoreVo sysStoreVo = new SysStoreVo();
            if (cVo != null) {
                CouponDefinitionPOWithBLOBs cp = cVo.getCouponDefinitionPOWithBLOBs();
                sysStoreVo.setSysCompanyId(cp.getSysCompanyId());
                sysStoreVo.setSysBrandId(cp.getSysBrandId());
                sysStoreVo.setProvinceName(vo.getProvinceName());
                sysStoreVo.setCityName(vo.getCityName());
                sysStoreVo.setAreaName(vo.getAreaName());
                sysStoreVo.setPageNumber(vo.getPageNum());
                sysStoreVo.setPageSize(vo.getPageSize());
                sysStoreVo.setLng(vo.getLng());
                sysStoreVo.setLat(vo.getLat());
                sysStoreVo.setSearchName(vo.getSearchName());
                if (cp != null && null != cp.getApplianceStoreType() && cp.getApplianceStoreType() == 2) {
                    String[] split;
                    if (StringUtils.isNotEmpty((CharSequence)cp.getStoreWhitelist())) {
                        split = cp.getStoreWhitelist().split(",");
                        sysStoreVo.setStoreWhitelist(Arrays.asList(split));
                    } else if (StringUtils.isNotEmpty((CharSequence)cp.getStoreBlacklist())) {
                        split = cp.getStoreBlacklist().split(",");
                        sysStoreVo.setStoreBlacklist(Arrays.asList(split));
                    }
                }
                ResponseData rs = this.storeServiceRpc.listStoreByCondition(sysStoreVo);
                responseData.setData(rs.getData());
            }
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        }
        catch (Exception e) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            logger.info("\u83b7\u53d6\u5238\u9002\u7528\u95e8\u5e97\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return responseData;
    }

    @RequestMapping(value={"/onlineUse"}, method={RequestMethod.POST})
    public ResponseData<Object> findCouponDetailByCouponId(CouponOnlineUseRequestVO vo) {
        ResponseData responseData = new ResponseData();
        if (vo.getCouponCode() == null) {
            responseData.setMessage("\u672a\u8f93\u5165\u52b5 code");
            return responseData;
        }
        return this.couponServiceFeign.onlineUse(vo);
    }

    @RequestMapping(value={"/lock"}, method={RequestMethod.POST})
    public ResponseData<Object> lock(CouponEntityVO vo) {
        ResponseData responseData = new ResponseData();
        if (vo.getCouponCode() == null) {
            responseData.setMessage("\u672a\u8f93\u5165\u52b5 code");
            return responseData;
        }
        return this.couponServiceFeign.lock(vo);
    }

    @RequestMapping(value={"/unlock"}, method={RequestMethod.POST})
    public ResponseData<Object> unlock(CouponEntityVO vo) {
        ResponseData responseData = new ResponseData();
        if (vo.getCouponCode() == null) {
            responseData.setMessage("\u672a\u8f93\u5165\u52b5 code");
            return responseData;
        }
        return this.couponServiceFeign.unlock(vo);
    }

    @RequestMapping(value={"/getTaobaoName"})
    ResponseData<String> getTaobaoName(ActivityManualVO requestVO, HttpServletRequest request) {
        logger.info("enter MenberCenterActivityController getTaobaoName method! ");
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        requestVO.getMemberInfoModel().setMemberCode(memberCode);
        return this.couponAuthTmallServiceFeign.getTaobaoName(requestVO);
    }

    @RequestMapping(value={"/getActivityPointsDistribute"}, method={RequestMethod.POST})
    public ResponseData<ActivityPointsDistributeVO> getActivityPointsDistribute(ActivityPointsDistributeVO vo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        if (vo.getActivityCode() == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u6d3b\u52a8\u7f16\u53f7");
            return responseData;
        }
        if (vo.getActivityType() == null) {
            responseData.setMessage("\u83b7\u53d6\u7c7b\u522b\u672a\u8f93\u5165");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        Long sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        Long sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        vo.setSysBrandId(sysBrandId);
        vo.setSysCompanyId(sysCompanyId);
        vo.setMemberCode(memberCode);
        responseData = this.activityPointsDistributeServiceRpc.getActivityPointsDistribute(vo);
        return responseData;
    }

    @RequestMapping(value={"/executePointsDistributeActivity"}, method={RequestMethod.POST})
    public ResponseData<ActivityPointsDistributeVO> executePointsDistributeActivity(ActivityPointsDistributeVO vo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        Long sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        Long sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        vo.setSysBrandId(sysBrandId);
        vo.setSysCompanyId(sysCompanyId);
        vo.setMemberCode(memberCode);
        logger.info("\u626b\u7801\u9886\u53d6\u5165\u53c2={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)vo));
        responseData = this.activityPointsDistributeServiceRpc.executePointsDistributeActivity(vo);
        return responseData;
    }

    private Boolean handleLinkShowFlag(CouponEntityAndDefinitionVO couponEntityAndDefinitionVO) {
        block15: {
            logger.info("handleLinkShowFlag#couponEntityAndDefinitionVO:{},definitionPO:{}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)couponEntityAndDefinitionVO));
            if (20 != couponEntityAndDefinitionVO.getCouponStatus()) {
                return Boolean.FALSE;
            }
            if (null == couponEntityAndDefinitionVO.getLinkType() || !couponEntityAndDefinitionVO.getLinkType().booleanValue()) {
                return Boolean.FALSE;
            }
            Integer buttonShowType = couponEntityAndDefinitionVO.getButtonShowType();
            if (null != buttonShowType && 0 == buttonShowType) {
                return Boolean.TRUE;
            }
            if (null != buttonShowType && 1 == buttonShowType) {
                try {
                    Date currentTime = new Date();
                    Date validDateEnd = couponEntityAndDefinitionVO.getValidDateEnd();
                    Date customizeStartTime = couponEntityAndDefinitionVO.getCustomizeStartTime();
                    Date customizeEndTime = couponEntityAndDefinitionVO.getCustomizeEndTime();
                    if (validDateEnd.compareTo(currentTime) <= 0) break block15;
                    if (null != customizeStartTime && null != customizeEndTime && customizeStartTime.compareTo(currentTime) < 0 && customizeEndTime.compareTo(currentTime) > 0) {
                        return Boolean.TRUE;
                    }
                    if (null == customizeStartTime && null != customizeEndTime && customizeEndTime.compareTo(currentTime) > 0) {
                        return Boolean.TRUE;
                    }
                    if (null != customizeStartTime && null == customizeEndTime && customizeStartTime.compareTo(currentTime) < 0) {
                        return Boolean.TRUE;
                    }
                }
                catch (Exception e) {
                    logger.error("handleLinkShowFlag-1", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                }
            } else if (null != buttonShowType && 2 == buttonShowType) {
                try {
                    Integer beforeCouponExpireDay = couponEntityAndDefinitionVO.getBeforeCouponExpireDay();
                    if (null != beforeCouponExpireDay) {
                        Date currentTime = new Date();
                        Date validDateEnd = couponEntityAndDefinitionVO.getValidDateEnd();
                        if (validDateEnd.compareTo(currentTime) > 0 && DateUtils.getSpecifiedDayBefore((Date)DateUtils.getTodayStartTime((Date)validDateEnd), (int)beforeCouponExpireDay).compareTo(currentTime) < 0) {
                            return Boolean.TRUE;
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("handleLinkShowFlag-2", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        return Boolean.FALSE;
    }

    @RequestMapping(value={"/listActivitySign"}, method={RequestMethod.POST})
    public ResponseData<List<ActivityVO>> listActivitySign(@RequestBody ActivityVO vo) {
        logger.info("MenberCenterActivityController-listActivitySign-info,request:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        ResponseData response = this.activityCommonServiceRpc.listActivitySign(vo);
        logger.info("MenberCenterActivityController-listActivitySign-info,response:{}", (Object)JacksonUtil.bean2Json((Object)response));
        return response;
    }
}

