/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.LoginService;
import com.bizvane.appletservice.models.bo.AppletRefreshtoInterfaceBo;
import com.bizvane.appletservice.models.bo.AppletSysStoreBo;
import com.bizvane.appletservice.models.bo.MemberResoucreBO;
import com.bizvane.appletservice.models.po.AppletResourcesPO;
import com.bizvane.appletservice.models.po.AppletResourcesPOExample;
import com.bizvane.appletserviceimpl.controllers.MenberCenterActivityController;
import com.bizvane.appletserviceimpl.mappers.AppletResourcesPOMapper;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.centerstageservice.models.bo.StoreStaffRelBo;
import com.bizvane.centerstageservice.models.bo.SysStoreBo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.models.po.SysStorePrivilegePo;
import com.bizvane.centerstageservice.models.vo.GetOnlineOrgStoresRequestVo;
import com.bizvane.centerstageservice.models.vo.OnlineOrgStoreInfoResponseVo;
import com.bizvane.centerstageservice.models.vo.StaffAndAccountInfoVO;
import com.bizvane.centerstageservice.models.vo.StaffVo;
import com.bizvane.centerstageservice.models.vo.SysAccountVo;
import com.bizvane.centerstageservice.models.vo.SysStoreVo;
import com.bizvane.centerstageservice.rpc.StaffServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreStaffRelServiceRpc;
import com.bizvane.centerstageservice.rpc.SysAccountServiceRpc;
import com.bizvane.centerstageservice.rpc.SysOnlineOrgServcieRpc;
import com.bizvane.couponfacade.interfaces.CouponQueryServiceFeign;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.vo.CouponDetailResponseVO;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.bizvane.wechatenterprise.service.common.PageFormUtil;
import com.github.pagehelper.PageInfo;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/memberStore"})
public class MemberStoreController {
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private StaffServiceRpc staffServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private AppletResourcesPOMapper appletResourcesPOMapper;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private MenberCenterActivityController menberCenterActivityController;
    @Autowired
    private CouponQueryServiceFeign couponQueryServiceFeign;
    @Autowired
    private LoginService loginService;
    @Autowired
    private StoreStaffRelServiceRpc storeStaffRelServiceRpc;
    @Autowired
    private SysOnlineOrgServcieRpc sysOnlineOrgServcieRpc;
    @Autowired
    private SysAccountServiceRpc sysAccountServiceRpc;
    @Value(value="#{'${privatizationBrand.mengjie}'.split(',')}")
    private List<Long> mJBrandList;
    @Value(value="${defaultSysStaffId.mengjie}")
    private Long defaultMengjieSysStaffId;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    DecimalFormat df = new DecimalFormat("###.#");
    private static final List<String> appletMunicipalityCityList = Arrays.asList("\u5317\u4eac\u5e02", "\u4e0a\u6d77\u5e02", "\u6df1\u5733\u5e02", "\u91cd\u5e86\u5e02", "\u5929\u6d25\u5e02");

    @RequestMapping(value={"/getBrandByIdSysStoreList"}, method={RequestMethod.POST})
    public ResponseData getBrandByIdSysStoreList(SysStoreBo bo, HttpServletRequest request) {
        logger.info("\u95e8\u5e97\u5bfc\u822a\u5165\u53c2={}", (Object)JSON.toJSONString((Object)bo));
        Boolean needMember = Boolean.FALSE;
        return this.getBrandByIdSysStoreListOld(bo, request, Boolean.FALSE);
    }

    private ResponseData getBrandByIdSysStoreListOld(SysStoreBo bo, HttpServletRequest request, Boolean needMember) {
        ResponseData responseData = new ResponseData();
        if (needMember.booleanValue()) {
            String bizvaneSessionId = request.getHeader("bizvaneSessionId");
            if (bizvaneSessionId == null) {
                responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
                return responseData;
            }
            String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
            if (memberCode == null) {
                responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
                responseData.setCode(-100);
                return responseData;
            }
            Long storeId = (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
            bo.setSysStoreId(storeId);
        } else {
            bo.setSysStoreId(Long.valueOf(0L));
        }
        if (bo.getSysBrandId() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u54c1\u724c id\u672a\u83b7\u53d6");
        }
        if (bo.getPageSize() == null || bo.getPageSize() == 0) {
            bo.setPageSize(Integer.valueOf(20));
        }
        if (bo.getPageNum() == null || bo.getPageNum() == 0) {
            bo.setPageNum(Integer.valueOf(1));
        }
        if (StringUtils.isNotEmpty((CharSequence)bo.getStoreIds())) {
            List storeIdList = Arrays.asList(bo.getStoreIds().split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            bo.setStoreIdList(storeIdList);
        }
        AppletResourcesPOExample appletResourcesPOExample = new AppletResourcesPOExample();
        appletResourcesPOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andModularCodeEqualTo("M001").andSysBrandIdEqualTo(bo.getSysBrandId()).andModularTypeEqualTo("2");
        List resourcesPOS = this.appletResourcesPOMapper.selectByExample(appletResourcesPOExample);
        for (AppletResourcesPO appletResourcesPO : resourcesPOS) {
            appletResourcesPO.setModularContent(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)appletResourcesPO.getModularContent()));
        }
        if (StringUtils.isNotEmpty((CharSequence)bo.getCouponEntityId()) && NumberUtils.isCreatable((String)bo.getCouponEntityId())) {
            long couponId = Long.parseLong(bo.getCouponEntityId());
            ResponseData couponDetail = this.couponQueryServiceFeign.getCouponDetail(Long.valueOf(couponId));
            if (couponDetail.getCode() != 0) {
                responseData.setData((Object)couponDetail);
                return responseData;
            }
            CouponDetailResponseVO cVo = (CouponDetailResponseVO)couponDetail.getData();
            if (cVo != null) {
                ResponseData storeVORes;
                GetOnlineOrgStoresRequestVo queryStoreVO;
                ResponseData accountRes;
                Object accountOnlineOrgCode = null;
                List<Long> accountSysStoreIdList = null;
                CouponDefinitionPOWithBLOBs cp = cVo.getCouponDefinitionPOWithBLOBs();
                if (cp.getCreateUserId() != null && (accountRes = this.sysAccountServiceRpc.getByAccountId(cp.getCreateUserId())) != null && accountRes.getCode() == SysResponseEnum.SUCCESS.getCode() && accountRes.getData() != null) {
                    accountOnlineOrgCode = ((SysAccountVo)accountRes.getData()).getOnlineOrgCode();
                }
                if (StringUtils.isNotBlank(accountOnlineOrgCode)) {
                    queryStoreVO = new GetOnlineOrgStoresRequestVo();
                    queryStoreVO.setSysCompanyId(cp.getSysCompanyId());
                    queryStoreVO.setBrandId(cp.getSysBrandId());
                    queryStoreVO.setOnlineOrgCodes(Collections.singletonList(accountOnlineOrgCode));
                    storeVORes = this.sysOnlineOrgServcieRpc.listStoreVOByOnlineOrgCodes(queryStoreVO);
                    accountSysStoreIdList = storeVORes != null && storeVORes.getCode() == SysResponseEnum.SUCCESS.getCode() && CollectionUtils.isNotEmpty((Collection)((Collection)storeVORes.getData())) ? ((List)storeVORes.getData()).stream().map(OnlineOrgStoreInfoResponseVo::getSysStoreId).collect(Collectors.toList()) : Collections.singletonList(-1L);
                }
                logger.info("MemberStoreController-getBrandByIdSysStoreListOld-info,couponDefinitionId:{},accountOnlineOrgCode:{},accountSysStoreIdList:{}", new Object[]{cp.getCouponDefinitionId(), accountOnlineOrgCode, accountSysStoreIdList});
                if (null != cp.getApplianceStoreType() && cp.getApplianceStoreType() == 2) {
                    String[] split;
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)cp.getStoreWhitelist())) {
                        split = cp.getStoreWhitelist().split(",");
                        bo.setStoreWhitelist(Arrays.asList(split));
                    } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)cp.getStoreBlacklist())) {
                        split = cp.getStoreBlacklist().split(",");
                        bo.setStoreBlacklist(Arrays.asList(split));
                    }
                } else if (Objects.equals(cp.getApplianceOrgType(), 2) && StringUtils.isNotBlank((CharSequence)cp.getApplianceOrgCodes())) {
                    queryStoreVO = new GetOnlineOrgStoresRequestVo();
                    queryStoreVO.setSysCompanyId(cp.getSysCompanyId());
                    queryStoreVO.setBrandId(cp.getSysBrandId());
                    queryStoreVO.setOnlineOrgCodes(Arrays.asList(cp.getApplianceOrgCodes().split(",")));
                    storeVORes = this.sysOnlineOrgServcieRpc.listStoreVOByOnlineOrgCodes(queryStoreVO);
                    if (storeVORes != null && storeVORes.getCode() == SysResponseEnum.SUCCESS.getCode() && CollectionUtils.isNotEmpty((Collection)((Collection)storeVORes.getData()))) {
                        List sysStoreIdList = ((List)storeVORes.getData()).stream().map(OnlineOrgStoreInfoResponseVo::getSysStoreId).collect(Collectors.toList());
                        bo.setStoreIdList(sysStoreIdList);
                    } else {
                        bo.setStoreIdList(Collections.singletonList(-1L));
                    }
                } else if (CollectionUtils.isNotEmpty(accountSysStoreIdList)) {
                    bo.setStoreIdList(accountSysStoreIdList);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)appletMunicipalityCityList) && StringUtils.isNotBlank((CharSequence)bo.getSearchProvinceName()) && appletMunicipalityCityList.contains(bo.getSearchProvinceName())) {
            bo.setSearchProvinceName(bo.getSearchProvinceName().replace("\u5e02", ""));
        }
        logger.info("\u83b7\u53d6\u95e8\u5e97\u5165\u53c2{}", (Object)JSON.toJSONString((Object)bo));
        ResponseData storeListPage = this.storeServiceRpc.getBrandByIdSysStoreListPage(bo);
        List storeList = ((PageInfo)storeListPage.getData()).getList();
        if (CollectionUtils.isEmpty((Collection)storeList)) {
            AppletRefreshtoInterfaceBo appletRefreshtoInterfaceBo = new AppletRefreshtoInterfaceBo();
            appletRefreshtoInterfaceBo.setAppletSysStoreBos(new ArrayList());
            appletRefreshtoInterfaceBo.setResourcesPOS(resourcesPOS);
            responseData.setData((Object)appletRefreshtoInterfaceBo);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        int isShowImgFlag = ((SysStoreBo)storeList.get(0)).getIsShowImg();
        ArrayList<AppletSysStoreBo> AppletSysStoreBos = new ArrayList<AppletSysStoreBo>();
        for (SysStoreBo sysStoreBo : storeList) {
            AppletSysStoreBo appletSysStoreBo = new AppletSysStoreBo();
            String distance = sysStoreBo.getDistance();
            if (distance == null) {
                sysStoreBo.setDistance(distance);
            } else {
                Double aDouble = Double.valueOf(distance);
                if (aDouble == null) {
                    sysStoreBo.setDistance(distance);
                }
                double lod = aDouble / 1000.0;
                String format = this.df.format(lod);
                sysStoreBo.setDistance(format);
            }
            BeanUtils.copyProperties((Object)sysStoreBo, (Object)appletSysStoreBo);
            if (appletSysStoreBo != null) {
                AppletSysStoreBos.add(appletSysStoreBo);
                continue;
            }
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        AppletRefreshtoInterfaceBo appletRefreshtoInterfaceBo = new AppletRefreshtoInterfaceBo();
        ArrayList<AppletSysStoreBo> sysStoreBos = new ArrayList<AppletSysStoreBo>();
        ArrayList<AppletSysStoreBo> appletSysStoreBos = new ArrayList<AppletSysStoreBo>();
        ArrayList<AppletSysStoreBo> bos = new ArrayList<AppletSysStoreBo>();
        if (AppletSysStoreBos != null) {
            for (AppletSysStoreBo appletSysStoreBo : AppletSysStoreBos) {
                if (appletSysStoreBo.getDistance() == null && !"1".equals(appletSysStoreBo.getIsExclusive())) {
                    sysStoreBos.add(appletSysStoreBo);
                }
                if (appletSysStoreBo.getDistance() != null && !"1".equals(appletSysStoreBo.getIsExclusive())) {
                    appletSysStoreBos.add(appletSysStoreBo);
                }
                if (!"1".equals(appletSysStoreBo.getIsExclusive())) continue;
                bos.add(appletSysStoreBo);
            }
        }
        if (appletSysStoreBos != null) {
            Collections.sort(appletSysStoreBos, new /* Unavailable Anonymous Inner Class!! */);
        }
        ArrayList<AppletSysStoreBo> appletSysStoreBoList = new ArrayList<AppletSysStoreBo>();
        appletSysStoreBoList.addAll(bos);
        appletSysStoreBoList.addAll(appletSysStoreBos);
        appletSysStoreBoList.addAll(sysStoreBos);
        appletRefreshtoInterfaceBo.setAppletSysStoreBos(appletSysStoreBoList);
        appletRefreshtoInterfaceBo.setResourcesPOS(resourcesPOS);
        appletRefreshtoInterfaceBo.setTotal(Long.valueOf(((PageInfo)storeListPage.getData()).getTotal()));
        appletRefreshtoInterfaceBo.setIsShowImg(Integer.valueOf(isShowImgFlag));
        logger.info("\u95e8\u5e97\u5bfc\u822a\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)appletRefreshtoInterfaceBo));
        responseData.setData((Object)appletRefreshtoInterfaceBo);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    @RequestMapping(value={"/queryStoreMainGuideByStoreId"}, method={RequestMethod.GET})
    public ResponseData<StoreStaffRelBo> queryStoreMainGuideByStoreId(@RequestParam(value="sysStoreId") Long sysStoreId, HttpServletRequest request) {
        MemberResoucreBO memberResoucreBO = this.loginService.getMemberResourceBO();
        ResponseData storeStaffRelBoResponseData = this.storeStaffRelServiceRpc.queryStoreMainGuideByStoreId(memberResoucreBO.getSysCompanyId(), sysStoreId);
        if (storeStaffRelBoResponseData != null && storeStaffRelBoResponseData.getData() != null && StringUtils.isNotBlank((CharSequence)((StoreStaffRelBo)storeStaffRelBoResponseData.getData()).getContactWayQrCode())) {
            return storeStaffRelBoResponseData;
        }
        logger.info("\u83b7\u53d6\u54c1\u724c\u4e0b\u9ed8\u8ba4\u5bfc\u8d2d\u6b22\u8fce\u7801");
        return this.getBrandDefaultContactWayQrCode(memberResoucreBO);
    }

    private ResponseData<StoreStaffRelBo> getBrandDefaultContactWayQrCode(MemberResoucreBO memberResoucreBO) {
        if (CollectionUtils.isEmpty((Collection)this.mJBrandList) || !this.mJBrandList.contains(memberResoucreBO.getBrandId()) || this.defaultMengjieSysStaffId == null) {
            return new ResponseData();
        }
        ResponseData staffAndAccountInfoRes = this.staffServiceRpc.getStaffAndAccountInfo(this.defaultMengjieSysStaffId);
        if (staffAndAccountInfoRes == null) {
            return new ResponseData();
        }
        StaffAndAccountInfoVO staffAndAccountInfoVO = (StaffAndAccountInfoVO)staffAndAccountInfoRes.getData();
        if (staffAndAccountInfoVO == null || StringUtils.isBlank((CharSequence)staffAndAccountInfoVO.getContactWayQrCode())) {
            return new ResponseData();
        }
        StoreStaffRelBo storeStaffRelBo = new StoreStaffRelBo();
        storeStaffRelBo.setContactWayQrCode(staffAndAccountInfoVO.getContactWayQrCode());
        storeStaffRelBo.setSysStaffId(this.defaultMengjieSysStaffId);
        storeStaffRelBo.setSysCompanyId(memberResoucreBO.getSysCompanyId());
        return new ResponseData((Object)storeStaffRelBo);
    }

    @RequestMapping(value={"/getStoreStaffList"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<com.bizvane.utils.responseinfo.PageInfo<StaffVo>> getBrandByIdSysStoreList(Long sysStoreId, Long sysCompanyId, Long sysBrandId, PageFormUtil formUtil) {
        ResponseData responseData = new ResponseData();
        ResponseData sysStoreVoResponseData = this.storeServiceRpc.getSysStoreById(sysStoreId);
        SysStoreVo storeVo = (SysStoreVo)sysStoreVoResponseData.getData();
        ResponseData staffVOResult = this.staffServiceRpc.getStoreStaffListByStatus(storeVo.getSysStoreOfflineCode(), sysCompanyId, formUtil.getPageNumber(), formUtil.getPageSize());
        logger.info("\u67e5\u8be2\u5e97\u94fa\u4e0b\u7684\u5bfc\u8d2d={}", (Object)JSON.toJSONString((Object)staffVOResult));
        responseData.setData((Object)staffVOResult);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    @RequestMapping(value={"/getStorePrivilegeInfoById"}, method={RequestMethod.POST})
    public ResponseData<SysStorePrivilegePo> getStorePrivilegeInfoById(@RequestParam(value="sysStorePrivilegeId") Long sysStorePrivilegeId) {
        return this.storeServiceRpc.getStorePrivilegeInfoById(sysStorePrivilegeId);
    }

    @RequestMapping(value={"/getSysStoreById"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<SysStoreVo> getSysStoreById(@RequestParam(value="sysStoreId") Long sysStoreId) {
        return this.storeServiceRpc.getSysStoreById(sysStoreId);
    }

    @RequestMapping(value={"/getStoreById"}, method={RequestMethod.POST})
    public ResponseData<SysStorePo> getOfflineStoreById(Long sysStoreId) {
        return this.storeServiceRpc.getStoreById(sysStoreId);
    }
}

