/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.LoginService;
import com.bizvane.appletservice.interfaces.MemberRechargeService;
import com.bizvane.appletservice.interfaces.MembershipCardService;
import com.bizvane.appletservice.models.bo.MbrRechargeRecordBo;
import com.bizvane.appletservice.models.bo.MemberResoucreBO;
import com.bizvane.appletservice.models.vo.HqtSmallAmountRechargeRequestVO;
import com.bizvane.appletservice.models.vo.HqtSpecialRechargeResponseVO;
import com.bizvane.appletservice.models.vo.MbrCarBarCodeVO;
import com.bizvane.appletservice.models.vo.MbrRechargeRecordNewVO;
import com.bizvane.appletservice.models.vo.MbrRechargeRuleAppletVo;
import com.bizvane.appletservice.models.vo.MbrRechargeStatusVO;
import com.bizvane.appletservice.models.vo.RechargeReCordNewVo;
import com.bizvane.appletservice.models.vo.RechargeReCordVo;
import com.bizvane.appletservice.models.vo.RechargeStatusRequestVO;
import com.bizvane.appletserviceimpl.utils.QRCodeUtil;
import com.bizvane.centerstageservice.models.po.MbrQuickRechargePo;
import com.bizvane.centerstageservice.models.po.MbrRechargeMenuPo;
import com.bizvane.centerstageservice.models.po.MbrRechargeRecordPo;
import com.bizvane.centerstageservice.models.vo.AppletMbrRechargeResponseVO;
import com.bizvane.centerstageservice.models.vo.SmallAmountRechargeRequestVO;
import com.bizvane.centerstageservice.models.vo.SmallAmountRechargeResponseVO;
import com.bizvane.centerstageservice.rpc.MbrRechargeServiceRpc;
import com.bizvane.couponfacade.interfaces.UtilsServiceFeign;
import com.bizvane.members.facade.models.MbrRechargeCardVo;
import com.bizvane.members.facade.models.MemberCardLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MbrRechargeCardRpcService;
import com.bizvane.members.facade.service.api.MemberCardProgramApiService;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.mktcenterservice.models.bo.ActivityGameBO;
import com.bizvane.mktcenterservice.models.vo.MktActivityPayVo;
import com.bizvane.mktcenterservice.rpc.ActivityPayServiceRpc;
import com.bizvane.mktcenterservice.rpc.ActivityServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/memberRecharge"}, method={RequestMethod.POST})
public class MemberRechargeController {
    @Autowired
    private MbrRechargeServiceRpc mbrRechargeServiceRpc;
    @Autowired
    private MemberCardProgramApiService memberCardProgramApiService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    @Autowired
    private ActivityPayServiceRpc activityPayServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private UtilsServiceFeign utilsServiceFeign;
    @Autowired
    private MembershipCardService membershipCardService;
    @Autowired
    private LoginService loginService;
    @Autowired
    private MbrRechargeCardRpcService mbrRechargeCardRpcService;
    @Autowired
    private MemberRechargeService memberRechargeService;
    @Autowired
    private ActivityServiceRpc activityServiceRpc;
    @Value(value="#{'${customized.hongqingting.sysBrandIds:}'.split(',')}")
    private List<Long> cSysBrandIdList;

    @RequestMapping(value={"/menuQuery"}, method={RequestMethod.POST})
    public ResponseData menuQuery(MbrRechargeMenuPo mbrRechargeMenuPo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        logger.info("\u83dc\u5355\u67e5\u8be2={}", (Object)JSON.toJSONString((Object)mbrRechargeMenuPo));
        return this.mbrRechargeServiceRpc.getMbrRechargeMenu(mbrRechargeMenuPo);
    }

    @RequestMapping(value={"/getMbrQuickRecharge"}, method={RequestMethod.POST})
    public ResponseData<MbrRechargeRuleAppletVo> getMbrQuickRecharge(MbrRechargeRecordBo mbrRechargeRecordBo, HttpServletRequest request) {
        logger.info("MemberRechargeController-getMbrQuickRecharge-info,request:{}", (Object)JacksonUtil.bean2Json((Object)mbrRechargeRecordBo));
        ResponseData response = this.memberRechargeService.getMbrQuickRecharge(mbrRechargeRecordBo);
        logger.info("MemberRechargeController-getMbrQuickRecharge-info,response:{}", (Object)JacksonUtil.bean2Json((Object)response));
        return response;
    }

    @RequestMapping(value={"/getBrandIdGiveMoney"}, method={RequestMethod.POST})
    public ResponseData getBrandIdGiveMoney(MbrRechargeRecordBo mbrRechargeRecordBo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        MbrQuickRechargePo mbrQuickRechargePo = new MbrQuickRechargePo();
        mbrQuickRechargePo.setSysBrandId(mbrRechargeRecordBo.getSysBrandId());
        mbrQuickRechargePo.setRechargeMoney(mbrRechargeRecordBo.getRechargeMoney());
        logger.info("\u6839\u636e\u91d1\u989d\u67e5\u8be2\u8d60\u9001\u91d1\u989d\u5165\u53c2={}", (Object)JSON.toJSONString((Object)mbrRechargeRecordBo));
        return this.mbrRechargeServiceRpc.getBrandIdGiveMoney(mbrQuickRechargePo);
    }

    @RequestMapping(value={"/selectRechargeStatus"}, method={RequestMethod.POST})
    public ResponseData<MbrRechargeStatusVO> selectRechargeStatus(@RequestBody RechargeStatusRequestVO requestVO, HttpServletRequest request) {
        logger.info("selectRechargeStatus#requestVO:{}", (Object)JacksonUtil.bean2Json((Object)requestVO));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        Long sysBrandId = null;
        try {
            sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        }
        catch (NumberFormatException e) {
            logger.error("\u54c1\u724cID\u83b7\u53d6\u9519\u8bef\uff0cerror:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            responseData.setMessage("\u54c1\u724cID\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        logger.info("selectRechargeStatus#modelResponseData:{}", (Object)JacksonUtil.bean2Json((Object)modelResponseData));
        if (null == modelResponseData || SysResponseEnum.SUCCESS.getCode() != modelResponseData.getCode() || null == modelResponseData.getData()) {
            responseData.setMessage("\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u5931\u8d25");
            responseData.setCode(-100);
            return responseData;
        }
        MemberCardLevelModel data = (MemberCardLevelModel)modelResponseData.getData();
        String cardNo = data.getCardNo();
        MbrRechargeStatusVO mbrRechargeStatusVO = new MbrRechargeStatusVO();
        ResponseData rechargeStatusResp = this.mbrRechargeServiceRpc.selectRechargeStatus(sysBrandId, cardNo, requestVO.getBillNumber(), requestVO.getRechargeType());
        logger.info("selectRechargeStatus#rechargeStatusResp:{}", (Object)JacksonUtil.bean2Json((Object)rechargeStatusResp));
        if (null == rechargeStatusResp || SysResponseEnum.SUCCESS.getCode() != rechargeStatusResp.getCode()) {
            responseData.setMessage("\u83b7\u53d6\u8ba2\u5355\u72b6\u6001\u5931\u8d25");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        Integer rechargeStatus = (Integer)rechargeStatusResp.getData();
        mbrRechargeStatusVO.setRechargeStatus(rechargeStatus);
        if (null != rechargeStatus && 1 == rechargeStatus) {
            ResponseData gameBOResponseData = this.activityServiceRpc.selectOldGivenGameActivity(sysBrandId, memberCode, requestVO.getBillNumber());
            logger.info("selectRechargeStatus#selectOldGivenGameActivity#gameBOResponseData:{}", (Object)JSON.toJSONString((Object)gameBOResponseData));
            if (null != gameBOResponseData && null != gameBOResponseData.getData()) {
                mbrRechargeStatusVO.setActivityGameBO((ActivityGameBO)gameBOResponseData.getData());
            }
        }
        responseData.setData((Object)mbrRechargeStatusVO);
        return responseData;
    }

    @RequestMapping(value={"/getCardNoRechargeRecordList"}, method={RequestMethod.POST})
    public ResponseData getCardNoRechargeRecordList(MbrRechargeRecordBo mbrRechargeRecordBo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        MemberCardLevelModel data = (MemberCardLevelModel)modelResponseData.getData();
        String cardNo = data.getCardNo();
        MbrRechargeRecordPo mbrRechargeRecordPo = new MbrRechargeRecordPo();
        mbrRechargeRecordPo.setSysBrandId(mbrRechargeRecordBo.getSysBrandId());
        mbrRechargeRecordPo.setCardNo(cardNo);
        mbrRechargeRecordPo.setMbrPetCardNo(mbrRechargeRecordBo.getPetCard());
        logger.info("\u6839\u636e\u4f1a\u5458\u5361\u53f7\u67e5\u8be2\u5145\u503c\u8bb0\u5f55\u5165\u53c2={}", (Object)JSON.toJSONString((Object)mbrRechargeRecordPo));
        ResponseData cardNoRechargeRecordList = this.mbrRechargeServiceRpc.getCardNoRechargeRecordList(mbrRechargeRecordPo);
        RechargeReCordVo rechargeReCordVo = new RechargeReCordVo();
        if (cardNoRechargeRecordList.getData() == null) {
            rechargeReCordVo.setBalance(Double.valueOf(0.0));
            rechargeReCordVo.setMbrRechargeRecordPos(null);
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)rechargeReCordVo);
            return responseData;
        }
        if (((List)cardNoRechargeRecordList.getData()).size() > 0) {
            Double balance = ((MbrRechargeRecordPo)((List)cardNoRechargeRecordList.getData()).get(0)).getBalance();
            List listData = (List)cardNoRechargeRecordList.getData();
            rechargeReCordVo.setBalance(balance);
            rechargeReCordVo.setMbrRechargeRecordPos(listData);
        } else {
            rechargeReCordVo.setBalance(Double.valueOf(0.0));
            rechargeReCordVo.setMbrRechargeRecordPos(null);
        }
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)rechargeReCordVo);
        return responseData;
    }

    @RequestMapping(value={"/getCardNoRechargeRecordListNew"}, method={RequestMethod.POST})
    public ResponseData getCardNoRechargeRecordListNew(MbrRechargeRecordBo mbrRechargeRecordBo, HttpServletRequest request) {
        logger.info("MemberRechargeController-getCardNoRechargeRecordListNew-info,mbrRechargeRecordBo:{}", (Object)JSON.toJSONString((Object)mbrRechargeRecordBo));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        ResponseData modelResponseData = mbrRechargeRecordBo.getMemberCode() != null && this.cSysBrandIdList.contains(mbrRechargeRecordBo.getSysBrandId()) ? this.memberCardProgramApiService.queryMemberCardInfo(mbrRechargeRecordBo.getMemberCode()) : this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        if (modelResponseData == null || modelResponseData.getCode() != SysResponseEnum.SUCCESS.getCode() || modelResponseData.getData() == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        MemberCardLevelModel data = (MemberCardLevelModel)modelResponseData.getData();
        String cardNo = data.getCardNo();
        MbrRechargeRecordPo mbrRechargeRecordPo = new MbrRechargeRecordPo();
        mbrRechargeRecordPo.setSysBrandId(data.getBrandId());
        mbrRechargeRecordPo.setCardNo(cardNo);
        mbrRechargeRecordPo.setMbrPetCardNo(mbrRechargeRecordBo.getPetCard());
        logger.info("\u6839\u636e\u4f1a\u5458\u5361\u53f7\u67e5\u8be2\u5145\u503c\u8bb0\u5f55\u5165\u53c2={}", (Object)JSON.toJSONString((Object)mbrRechargeRecordPo));
        ResponseData cardNoRechargeRecordVOList = this.mbrRechargeServiceRpc.getCardNoRechargeRecordVOList(mbrRechargeRecordPo);
        logger.info("getCardNoRechargeRecordListNew#cardNoRechargeRecordVOList:{}", (Object)JacksonUtil.bean2Json((Object)cardNoRechargeRecordVOList));
        RechargeReCordNewVo rechargeReCordNewVo = new RechargeReCordNewVo();
        if (cardNoRechargeRecordVOList.getData() == null) {
            rechargeReCordNewVo.setBalance(Double.valueOf(0.0));
            rechargeReCordNewVo.setMbrRechargeRecordPos(null);
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)rechargeReCordNewVo);
            return responseData;
        }
        if (((List)cardNoRechargeRecordVOList.getData()).size() > 0) {
            Double balance = ((AppletMbrRechargeResponseVO)((List)cardNoRechargeRecordVOList.getData()).get(0)).getBalance();
            List listData = (List)cardNoRechargeRecordVOList.getData();
            ArrayList<MbrRechargeRecordNewVO> voListData = new ArrayList<MbrRechargeRecordNewVO>();
            rechargeReCordNewVo.setBalance(balance);
            for (AppletMbrRechargeResponseVO rechargeRecordVO : listData) {
                MbrRechargeRecordNewVO recordNewVO = new MbrRechargeRecordNewVO();
                BeanUtils.copyProperties((Object)rechargeRecordVO, (Object)recordNewVO);
                if (0L == rechargeRecordVO.getState() && StringUtils.isNotBlank((CharSequence)rechargeRecordVO.getOutTradeNo())) {
                    ResponseData gameBOResponseData = this.activityServiceRpc.selectOldGivenGameActivity(mbrRechargeRecordBo.getSysBrandId(), memberCode, rechargeRecordVO.getOutTradeNo());
                    logger.info("selectOldGivenGameActivity responseData:{}", (Object)JSON.toJSONString((Object)gameBOResponseData));
                    if (null != gameBOResponseData && null != gameBOResponseData.getData()) {
                        recordNewVO.setActivityGameBO((ActivityGameBO)gameBOResponseData.getData());
                    }
                }
                voListData.add(recordNewVO);
            }
            rechargeReCordNewVo.setMbrRechargeRecordPos(voListData);
        } else {
            rechargeReCordNewVo.setBalance(Double.valueOf(0.0));
            rechargeReCordNewVo.setMbrRechargeRecordPos(null);
        }
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)rechargeReCordNewVo);
        return responseData;
    }

    @RequestMapping(value={"/getSmallAmountRechargeRecord"}, method={RequestMethod.POST})
    public ResponseData<HqtSpecialRechargeResponseVO> getSmallAmountRechargeRecord(HqtSmallAmountRechargeRequestVO requestVO, HttpServletRequest request) {
        logger.info("getSmallAmountRechargeRecord#requestVO:{}", (Object)JacksonUtil.bean2Json((Object)requestVO));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        MemberCardLevelModel data = (MemberCardLevelModel)modelResponseData.getData();
        String cardNo = data.getCardNo();
        SmallAmountRechargeRequestVO rechargeRequestVO = new SmallAmountRechargeRequestVO();
        rechargeRequestVO.setSysBrandId(requestVO.getSysBrandId());
        rechargeRequestVO.setCardNo(cardNo);
        rechargeRequestVO.setMbrRechargeExplainId(requestVO.getMbrRechargeExplainId());
        rechargeRequestVO.setStoreId(requestVO.getStoreId());
        rechargeRequestVO.setOrganizationCode(requestVO.getOrganizationCode());
        rechargeRequestVO.setMemberCode(memberCode);
        logger.info("\u6839\u636e\u4f1a\u5458\u5361\u53f7\u67e5\u8be2\u5bf9\u5e94\u89c4\u5219\u7684\u5145\u503c\u8bb0\u5f55rechargeRequestVO:{}", (Object)JSON.toJSONString((Object)rechargeRequestVO));
        ResponseData rechargeRecordResp = this.mbrRechargeServiceRpc.getSmallAmountRechargeRecord(rechargeRequestVO);
        logger.info("getSmallAmountRechargeRecord#rechargeRecordResp:{}", (Object)JacksonUtil.bean2Json((Object)rechargeRecordResp));
        HqtSpecialRechargeResponseVO hqtSpecialRechargeResponseVO = new HqtSpecialRechargeResponseVO();
        if (null != rechargeRecordResp && SysResponseEnum.SUCCESS.getCode() == rechargeRecordResp.getCode() && null != rechargeRecordResp.getData()) {
            SmallAmountRechargeResponseVO responseVO = (SmallAmountRechargeResponseVO)rechargeRecordResp.getData();
            hqtSpecialRechargeResponseVO.setAccumulateGetTimes(responseVO.getAccumulateGetTimes());
            hqtSpecialRechargeResponseVO.setTodayResidueTimes(responseVO.getTodayResidueTimes());
            if (CollectionUtils.isNotEmpty((Collection)responseVO.getRechargeRecordPoList())) {
                ArrayList<MbrRechargeRecordNewVO> rechargeRecordVOList = new ArrayList<MbrRechargeRecordNewVO>();
                for (MbrRechargeRecordPo recordPo : responseVO.getRechargeRecordPoList()) {
                    MbrRechargeRecordNewVO recordNewVO = new MbrRechargeRecordNewVO();
                    BeanUtils.copyProperties((Object)recordPo, (Object)recordNewVO);
                    if (0L == recordPo.getState()) {
                        ResponseData gameBOResponseData = this.activityServiceRpc.selectOldGivenGameActivity(recordPo.getSysBrandId(), memberCode, recordPo.getOutTradeNo());
                        logger.info("selectOldGivenGameActivity gameBOResponseData:{}", (Object)JSON.toJSONString((Object)gameBOResponseData));
                        if (null != gameBOResponseData && null != gameBOResponseData.getData()) {
                            recordNewVO.setActivityGameBO((ActivityGameBO)gameBOResponseData.getData());
                        }
                    }
                    rechargeRecordVOList.add(recordNewVO);
                }
                if (CollectionUtils.isNotEmpty(rechargeRecordVOList)) {
                    hqtSpecialRechargeResponseVO.setRechargeRecordVOList(rechargeRecordVOList);
                }
            }
        }
        responseData.setData((Object)hqtSpecialRechargeResponseVO);
        return responseData;
    }

    @RequestMapping(value={"/getRechargeStyle"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData getRechargeStyle(MbrRechargeRecordBo mbrRechargeRecordBo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        logger.info("\u4f1a\u5458\u5145\u503c\u5361\u6837\u5f0f\u5165\u53c2={}", (Object)JSON.toJSONString((Object)mbrRechargeRecordBo));
        return this.mbrRechargeServiceRpc.getRechargeStyle(mbrRechargeRecordBo.getSysBrandId());
    }

    @RequestMapping(value={"/selectActivityBrandList"}, method={RequestMethod.POST})
    public ResponseData selectActivityBrandList(MktActivityPayVo activityVO, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        MemberInfoModel member = (MemberInfoModel)singleMemberModel.getData();
        activityVO.setMemberCode(memberCode);
        activityVO.setMbrLevelCode(String.valueOf(member.getLevelId()));
        activityVO.setStoreLimitList(String.valueOf(member.getServiceStoreId()));
        logger.info("\u50a8\u503c\u793c\u5305\u5217\u8868\u5982\u5165\u53c2={}", (Object)JSON.toJSONString((Object)activityVO));
        return this.activityPayServiceRpc.selectActivityBrandList(activityVO);
    }

    @RequestMapping(value={"/getBalanceByMemberCode"}, method={RequestMethod.POST})
    public ResponseData getBalanceByMemberCode(Long brandId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        ResponseData result = this.memberInfoApiService.getBalanceByMemberCode(memberCode, brandId);
        BigDecimal balance = (BigDecimal)result.getData();
        balance = balance != null ? balance.setScale(2, 1) : new BigDecimal(0).setScale(0);
        responseData.setData((Object)balance);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    @RequestMapping(value={"/getBarcode"}, method={RequestMethod.POST})
    public ResponseData getBarcode(String code) {
        return this.utilsServiceFeign.getBarcode(code);
    }

    @Deprecated
    @RequestMapping(value={"/getBarcode2"}, method={RequestMethod.POST})
    public ResponseData getBarcode2(String code) {
        ResponseData result = new ResponseData();
        String s = null;
        try {
            s = QRCodeUtil.crateQRCode((String)code, (int)200, (int)200);
        }
        catch (IOException e) {
            e.printStackTrace();
            result.setCode(SysResponseEnum.FAILED.getCode());
            result.setMessage("\u4e8c\u7ef4\u7801\u751f\u6210\u5f02\u5e38");
            result.setData((Object)s);
        }
        result.setCode(SysResponseEnum.SUCCESS.getCode());
        result.setMessage(SysResponseEnum.SUCCESS.getMessage());
        result.setData((Object)s.replaceAll("\\n", ""));
        return result;
    }

    @RequestMapping(value={"/getMbrRechargeCardList"}, method={RequestMethod.GET})
    public ResponseData<List<MbrRechargeCardVo>> getMbrRechargeCardList(HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        MemberResoucreBO memberResourceBO = this.loginService.getMemberResourceBO();
        String memberCode = memberResourceBO.getMemberCode();
        Long sysCompanyId = memberResourceBO.getSysCompanyId();
        Long sysBrandId = memberResourceBO.getBrandId();
        ArrayList list = Lists.newArrayList();
        if (this.cSysBrandIdList.contains(sysBrandId)) {
            MemberInfoModel infoModel = new MemberInfoModel();
            infoModel.setSysCompanyId(sysCompanyId);
            infoModel.setMemberCode(memberCode);
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(infoModel);
            if (singleMemberModel == null || singleMemberModel.getCode() != SysResponseEnum.SUCCESS.getCode() || singleMemberModel.getData() == null) {
                responseData.setMessage("\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u4e3a\u7a7a");
                responseData.setCode(-100);
                return responseData;
            }
            String erpId = ((MemberInfoModel)singleMemberModel.getData()).getErpId();
            ResponseData modelListRes = this.memberInfoApiService.listMemberInfoByErpId(Collections.singletonList(erpId), sysCompanyId, this.cSysBrandIdList);
            if (modelListRes == null || modelListRes.getCode() != SysResponseEnum.SUCCESS.getCode() || CollectionUtils.isEmpty((Collection)((Collection)modelListRes.getData()))) {
                responseData.setMessage("\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u4e3a\u7a7a");
                responseData.setCode(-100);
                return responseData;
            }
            for (int i = 0; i < ((List)modelListRes.getData()).size(); ++i) {
                MemberInfoModel item = (MemberInfoModel)((List)modelListRes.getData()).get(i);
                logger.info("\u7ea2\u873b\u8713\u52a0\u76df\u548c\u76f4\u8425,MemberRechargeController-getMbrRechargeCardList-info,request:sysCompanyId,brandId:{},memberCode:{}", (Object)item.getBrandId(), (Object)item.getMemberCode());
                ResponseData listRes = this.mbrRechargeCardRpcService.queryMbrRechargeCardList(item.getSysCompanyId(), item.getBrandId(), item.getMemberCode(), null);
                if (listRes == null || listRes.getCode() != SysResponseEnum.SUCCESS.getCode() || !CollectionUtils.isNotEmpty((Collection)((Collection)listRes.getData()))) continue;
                list.addAll((Collection)listRes.getData());
            }
            long count = list.stream().map(MbrRechargeCardVo::getPetCardNo).distinct().count();
            if (count < (long)list.size()) {
                Map uniquePeople = list.stream().collect(Collectors.toMap(MbrRechargeCardVo::getPetCardNo, Function.identity(), (existing, replacement) -> {
                    if (Objects.equals(replacement.getSysBrandId(), sysBrandId)) {
                        return replacement;
                    }
                    return existing;
                }));
                list = new ArrayList(uniquePeople.values());
            }
            list = list.stream().sorted(Comparator.comparing(MbrRechargeCardVo::getCardSourceType)).collect(Collectors.toList());
        } else {
            logger.info("MemberRechargeController-getMbrRechargeCardList-info,request:{}", (Object)JacksonUtil.bean2Json((Object)memberResourceBO));
            ResponseData listRes = this.mbrRechargeCardRpcService.queryMbrRechargeCardList(memberResourceBO.getSysCompanyId(), memberResourceBO.getBrandId(), memberResourceBO.getMemberCode(), null);
            if (listRes != null && listRes.getCode() == SysResponseEnum.SUCCESS.getCode() && CollectionUtils.isNotEmpty((Collection)((Collection)listRes.getData()))) {
                list = (List)listRes.getData();
            }
        }
        logger.info("MemberRechargeController-getMbrRechargeCardList-info,result:{}", (Object)JacksonUtil.list2Json((List)list));
        responseData.setData((Object)list);
        return responseData;
    }

    @RequestMapping(value={"/getMbrCarBarCode1"}, method={RequestMethod.POST})
    public ResponseData<MbrCarBarCodeVO> getMbrCarBarCode1(Long sysCompanyId, Long sysBrandId, String code) {
        return new ResponseData((Object)this.membershipCardService.getMbrCarBarCode1VO(sysCompanyId, sysBrandId, code));
    }

    @RequestMapping(value={"/getMbrCarBarCode2"}, method={RequestMethod.POST})
    public ResponseData<MbrCarBarCodeVO> getMbrCarBarCode2(Long sysCompanyId, Long sysBrandId, String code) {
        return new ResponseData((Object)this.membershipCardService.getMbrCarBarCode2VO(sysCompanyId, sysBrandId, code));
    }
}

