/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.MemberPrizeService;
import com.bizvane.appletservice.models.vo.MemberOpenCardStoreVo;
import com.bizvane.mktcenterservice.models.vo.MemberTaskPrizeReqVO;
import com.bizvane.mktcenterservice.models.vo.MemberTaskPrizeResVO;
import com.bizvane.mktcenterservice.models.vo.TaskPrizeAddressReqVO;
import com.bizvane.mktcenterservice.models.vo.TaskPrizeExchangeDetailReqVO;
import com.bizvane.mktcenterservice.models.vo.TaskPrizeExchangeDetailResVO;
import com.bizvane.mktcenterservice.models.vo.TaskPrizeExchangeReqVO;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/memberPrize"})
public class MemberPrizeController {
    private static final Logger log = LoggerFactory.getLogger(MemberPrizeController.class);
    @Autowired
    private MemberPrizeService memberPrizeService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;

    @RequestMapping(value={"/taskPrizeRecord"}, method={RequestMethod.POST})
    public ResponseData<List<MemberTaskPrizeResVO>> prizeRecordPage(MemberTaskPrizeReqVO reqVO, HttpServletRequest request) {
        log.info("memberPrize prizeRecordPage :{}", (Object)JSON.toJSONString((Object)reqVO));
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            return new ResponseData("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId", null);
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            return new ResponseData(-100, "\u4f1a\u5458\u4e3a\u7a7a", null);
        }
        reqVO.setMemberCode(memberCode);
        return this.memberPrizeService.taskPrizeRecord(reqVO);
    }

    @RequestMapping(value={"/addPrizeAddressNew"}, method={RequestMethod.POST})
    public ResponseData addPrizeAddressNew(TaskPrizeAddressReqVO reqVO, HttpServletRequest request) {
        log.info("memberPrize addPrizeAddressNew :{}", (Object)JSON.toJSONString((Object)reqVO));
        ResponseData responseData = new ResponseData();
        if (request.getHeader("bizvaneSessionId") == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        return this.memberPrizeService.addPrizeAddressNew(reqVO);
    }

    @RequestMapping(value={"/getPrizeExchangeDetail"}, method={RequestMethod.POST})
    public ResponseData<TaskPrizeExchangeDetailResVO> getPrizeExchangeDetail(TaskPrizeExchangeDetailReqVO reqVO, HttpServletRequest request) {
        log.info("memberPrize getPrizeExchangeDetail :{}", (Object)JSON.toJSONString((Object)reqVO));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        reqVO.setMemberCode(memberCode);
        return this.memberPrizeService.getPrizeExchangeDetail(reqVO);
    }

    @RequestMapping(value={"/receivePrize"}, method={RequestMethod.POST})
    public ResponseData receivePrize(TaskPrizeExchangeReqVO reqVO, HttpServletRequest request) {
        log.info("memberPrize receivePrize :{}", (Object)JSON.toJSONString((Object)reqVO));
        return this.memberPrizeService.receivePrize(reqVO);
    }

    @RequestMapping(value={"/searchStoresByRecordId"}, method={RequestMethod.POST})
    public ResponseData searchStoresByRecordId(MemberOpenCardStoreVo memberOpenCardStoreVo, HttpServletRequest request) {
        log.info("memberPrize searchStoresByRecordId :{}", (Object)JSON.toJSONString((Object)memberOpenCardStoreVo));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        if (null == memberOpenCardStoreVo.getMktActivityPrizeRecordId()) {
            responseData.setMessage("\u6d3b\u52a8ID\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        memberOpenCardStoreVo.setMemberCode(memberCode);
        return this.memberPrizeService.searchStoresByRecordId(memberOpenCardStoreVo);
    }
}

