/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.bizvane.appletservice.interfaces.MemberInvitedService;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.mktcenterservice.models.bo.TaskWXDetailBO;
import com.bizvane.mktcenterservice.models.vo.ShareSuccessVO;
import com.bizvane.mktcenterservice.rpc.TaskServiceForWXRpc;
import com.bizvane.mktcenterservice.rpc.TaskShareServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/memberInvited"})
public class MemberInvitedController {
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private MemberInvitedService memberInvitedService;
    @Autowired
    private TaskShareServiceRpc taskShareServiceRpc;
    @Autowired
    private TaskServiceForWXRpc taskServiceForWXRpc;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/invitedOpenCard"}, method={RequestMethod.POST})
    public ResponseData invitedOpenCard(HttpServletRequest request, Integer taskType, Long taskId) {
        Long aLong;
        logger.info("taskType={},taskId={}", (Object)taskType, (Object)taskId);
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        String oderMemberCode = memberCode;
        String sysBrandId = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "sysBrandId"));
        Long brand = aLong = Long.valueOf(sysBrandId);
        return this.memberInvitedService.invitedOpenCard(taskType, taskId, oderMemberCode, brand, bizvaneSessionId);
    }

    @RequestMapping(value={"/invitedConfirm"}, method={RequestMethod.POST})
    public ResponseData invitedConfirm(HttpServletRequest request, Long mktTaskId) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        ShareSuccessVO shareSuccessVO = new ShareSuccessVO();
        shareSuccessVO.setMemberCode(memberCode);
        logger.info("memberCode={}", (Object)memberCode);
        shareSuccessVO.setShareDate(new Date());
        shareSuccessVO.setMktTaskId(mktTaskId);
        logger.info("mktTaskId={}", (Object)mktTaskId);
        this.taskShareServiceRpc.doAwardShare(shareSuccessVO);
        ResponseData wxDetail = this.taskServiceForWXRpc.getTaskWXDetail(mktTaskId);
        if (SysResponseEnum.SUCCESS.getCode() == wxDetail.getCode() && wxDetail.getData() != null) {
            TaskWXDetailBO taskDetail = (TaskWXDetailBO)wxDetail.getData();
            if (StringUtils.isNotBlank((CharSequence)taskDetail.getShareImg())) {
                String url = QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)taskDetail.getShareImg());
                taskDetail.setShareImg(url);
            }
            return wxDetail;
        }
        return responseData;
    }
}

