/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.bizvane.appletservice.interfaces.LoginService;
import com.bizvane.appletservice.interfaces.MemberCenterService;
import com.bizvane.appletservice.interfaces.MenuAuthService;
import com.bizvane.appletservice.interfaces.MktPopupService;
import com.bizvane.appletservice.models.bo.AppletBrandMenberBo;
import com.bizvane.appletservice.models.bo.AppletBtfBo;
import com.bizvane.appletservice.models.bo.MemberResoucreBO;
import com.bizvane.appletservice.models.po.AppletResourcesPO;
import com.bizvane.appletservice.models.vo.AppletBrandMicroFitmentVO;
import com.bizvane.appletservice.models.vo.AppletBrandPopupFitmentVO;
import com.bizvane.appletservice.models.vo.AppletFitmentVo;
import com.bizvane.appletservice.models.vo.AppletHomeFitmentVo;
import com.bizvane.appletservice.models.vo.AppletHomeMemberAssetsVO;
import com.bizvane.appletservice.models.vo.AppletHomeMemberVo;
import com.bizvane.appletservice.models.vo.AppletMemberCenterConfigVO;
import com.bizvane.appletservice.models.vo.MemberBaseInfoVo;
import com.bizvane.appletservice.models.vo.MktPopupAdvertisementInfoVO;
import com.bizvane.appletservice.models.vo.menu.MenuWhiteListResponseVo;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.CenterStageServiceRpc;
import com.bizvane.centerstageservice.rpc.SysVipConfigsApiService;
import com.bizvane.mktcenterservice.models.vo.MktPopupAdvertisementRequestVO;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/memberCenter"})
public class MemberCenterController {
    private static final Logger log = LoggerFactory.getLogger(MemberCenterController.class);
    @Autowired
    private MemberCenterService memberCardService;
    @Autowired
    private CenterStageServiceRpc centerStageServiceRpc;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private LoginService loginService;
    @Autowired
    private SysVipConfigsApiService sysVipConfigsApiService;
    @Autowired
    private MenuAuthService menuAuthService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private MktPopupService mktPopupService;

    @RequestMapping(value={"/getBtfRel"}, method={RequestMethod.POST})
    public ResponseData<AppletBtfBo> getBtfRel(AppletBrandMenberBo appletBrandMenberBo, HttpServletRequest request) {
        return this.memberCardService.getBtfRel(appletBrandMenberBo, request);
    }

    @RequestMapping(value={"/getHomePage"}, method={RequestMethod.POST})
    public ResponseData<AppletBtfBo> getHomePage(AppletBrandMenberBo appletBrandMenberBo, HttpServletRequest request, HttpServletResponse response) {
        return this.memberCardService.getHomePage(appletBrandMenberBo, request, response);
    }

    @RequestMapping(value={"/getSlideImg"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<List<AppletResourcesPO>> getSlideImg(Long sysBrandId, HttpServletRequest request, HttpServletResponse response) {
        return this.memberCardService.getSlideImg(sysBrandId, request, response);
    }

    @RequestMapping(value={"/getTemplateInfo"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<AppletBtfBo> getTemplateInfo(Long sysBrandId, HttpServletRequest request) {
        return this.memberCardService.getTemplateInfo(sysBrandId, request);
    }

    @PostMapping(value={"/getMemberInfo"})
    public ResponseData<MemberBaseInfoVo> getMemberInfo(MemberBaseInfoVo memberBaseInfoVo, HttpServletRequest httpServletRequest) {
        return this.memberCardService.getMemberInfo(memberBaseInfoVo, httpServletRequest);
    }

    @PostMapping(value={"/getVerificationCode"})
    public ResponseData<String> getVerificationCode(@RequestParam(value="petCard") String petCard) {
        return this.centerStageServiceRpc.getVerificationCode(petCard);
    }

    @PostMapping(value={"/processTraceForStore"})
    public ResponseData processTraceForStore(@RequestParam(value="traceId") String traceId, @RequestParam(value="memberCode") String memberCode, HttpServletRequest request) {
        return this.memberCardService.processTraceForStore(traceId, memberCode, request);
    }

    @GetMapping(value={"/getBannerConfig"})
    public ResponseData getBannerConfig() {
        MemberResoucreBO memberResoucreBO = this.loginService.getMemberResourceBO();
        return this.sysVipConfigsApiService.queryBannerConfig(memberResoucreBO.getSysCompanyId(), memberResoucreBO.getBrandId());
    }

    @GetMapping(value={"/getConsumptionInfo"})
    public ResponseData getConsumptionInfo() {
        MemberResoucreBO memberResoucreBO = this.loginService.getMemberResourceBO();
        return this.memberCardService.getConsumptionInfo(memberResoucreBO);
    }

    @RequestMapping(value={"/getHomeByBrandId"}, method={RequestMethod.GET})
    public ResponseData<AppletHomeFitmentVo> getHomeByBrandId(@RequestParam(value="brandId", required=true) Long brandId) {
        return this.memberCardService.getHomeByBrandId(brandId);
    }

    @RequestMapping(value={"/getNaviDetail"}, method={RequestMethod.GET})
    public ResponseData<List<AppletFitmentVo>> getNaviDetail(@RequestParam(value="brandId", required=true) Long brandId, @RequestParam(value="navigationType", required=true) Integer navigationType) {
        return this.memberCardService.getNaviDetail(brandId, navigationType);
    }

    @RequestMapping(value={"/getMbrHomeInfo"}, method={RequestMethod.GET})
    public ResponseData<AppletHomeMemberVo> getMbrHomeInfo(@RequestParam(required=false, name="roundingMode", defaultValue="0") Byte roundingMode, @RequestParam(required=false, name="appletVipPrivilegeVersion") Integer appletVipPrivilegeVersion, HttpServletRequest request) {
        MemberResoucreBO memberResoucreBO = this.loginService.getMemberResourceBO();
        return this.memberCardService.getMbrHomeInfo(roundingMode, memberResoucreBO, appletVipPrivilegeVersion);
    }

    @RequestMapping(value={"/getBrandBusinessConfiguration"}, method={RequestMethod.GET})
    public ResponseData<SysBrandPo> getBrandBusinessConfiguration(HttpServletRequest request) {
        String sysBrandId = request.getHeader("sysBrandId");
        if (StringUtils.isBlank((CharSequence)sysBrandId)) {
            return new ResponseData(-100, "\u6388\u6743\u4fe1\u606f\u4e3a\u7a7a");
        }
        return this.brandServiceRpc.getBrandByID(Long.valueOf(sysBrandId));
    }

    @RequestMapping(value={"/getAuthMenuInfo"}, method={RequestMethod.GET})
    public ResponseData<MenuWhiteListResponseVo> getAuthMenuInfo(HttpServletRequest request) {
        MenuWhiteListResponseVo authMenuInfo = this.menuAuthService.getAuthMenuInfo();
        return new ResponseData((Object)authMenuInfo);
    }

    @RequestMapping(value={"/getHomeMicroFitmentByBrandId"}, method={RequestMethod.GET})
    public ResponseData<AppletBrandMicroFitmentVO> getHomeMicroFitmentByBrandId(@RequestParam(value="brandId", required=true) Long brandId, @RequestParam(value="channelType", required=false) Integer channelType) {
        return this.memberCardService.getHomeMicroFitmentByBrandId(brandId, channelType);
    }

    @RequestMapping(value={"/getMbrCardBasicInfo"}, method={RequestMethod.GET})
    public ResponseData<AppletHomeMemberVo> getMbrCardBasicInfo(@RequestParam(required=false, name="roundingMode", defaultValue="0") Byte roundingMode, @RequestParam(required=false, name="appletVipPrivilegeVersion") Integer appletVipPrivilegeVersion) {
        MemberResoucreBO memberResoucreBO = this.loginService.getMemberResourceBO();
        return this.memberCardService.getMbrCardBasicInfo(memberResoucreBO, roundingMode, appletVipPrivilegeVersion);
    }

    @RequestMapping(value={"/getMbrAssetsInfo"}, method={RequestMethod.GET})
    public ResponseData<AppletHomeMemberAssetsVO> getMbrAssetsInfo(@RequestParam(required=false, name="roundingMode", defaultValue="0") Byte roundingMode, HttpServletRequest request) {
        MemberResoucreBO memberResoucreBO = this.loginService.getMemberResourceBO();
        return this.memberCardService.getMbrAssetsInfo(roundingMode, memberResoucreBO);
    }

    @RequestMapping(value={"/getBrandFitmentConfig"}, method={RequestMethod.GET})
    public ResponseData<AppletMemberCenterConfigVO> getBrandFitmentConfig(HttpServletRequest request, @RequestParam(value="channelType", required=false) Integer channelType) {
        String sysBrandId = request.getHeader("sysBrandId");
        if (StringUtils.isBlank((CharSequence)sysBrandId)) {
            return new ResponseData(-100, "\u6388\u6743\u4fe1\u606f\u4e3a\u7a7a");
        }
        return this.memberCardService.getBrandFitmentConfig(Long.valueOf(sysBrandId), channelType);
    }

    @RequestMapping(value={"/getMallMicroFitmentByBrandId"}, method={RequestMethod.GET})
    public ResponseData<AppletBrandMicroFitmentVO> getMallMicroFitmentByBrandId(@RequestParam(value="brandId", required=true) Long brandId, @RequestParam(value="channelType", required=false) Integer channelType) {
        return this.memberCardService.getMallMicroFitmentByBrandId(brandId, channelType);
    }

    @RequestMapping(value={"/getBrandPopupFitmentByBrandId"}, method={RequestMethod.GET})
    public ResponseData<AppletBrandPopupFitmentVO> getBrandPopupFitmentByBrandId(@RequestParam(value="brandId", required=true) Long brandId) {
        return this.memberCardService.getBrandPopupFitmentByBrandId(brandId);
    }

    @RequestMapping(value={"/getPopupAdvertisementList"}, method={RequestMethod.GET})
    public ResponseData<MktPopupAdvertisementInfoVO> getPopupAdvertisementList(@RequestParam(value="brandId", required=true) Long brandId, @RequestParam(value="channelType", required=false) Integer channelType, HttpServletRequest request) {
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (StringUtils.isBlank((CharSequence)bizvaneSessionId)) {
            log.info("\u672a\u83b7\u53d6bizvaneSessionId");
            return new ResponseData();
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            log.info("memberCode\u4e3a\u7a7a");
            return new ResponseData();
        }
        return this.mktPopupService.getPopupAdvertisementList(brandId, memberCode, channelType);
    }

    @RequestMapping(value={"/mktPopupScanDataCollect"}, method={RequestMethod.POST})
    public ResponseData<String> mktPopupScanDataCollect(@RequestBody MktPopupAdvertisementRequestVO mktPopupAdvertisementRequestVO, HttpServletRequest request) {
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)bizvaneSessionId)) {
            responseData.setMessage("bizvaneSessionId\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        Long sysCompanyId = null;
        Long sysBrandId = null;
        String appId = request.getHeader("appId");
        try {
            sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
            sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        }
        catch (Exception e) {
            log.info("\u8bf7\u6c42\u5934\u83b7\u53d6\u4f01\u4e1aID/\u54c1\u724cID\u5f02\u5e38");
            responseData.setMessage("\u4f01\u4e1aID\u6216\u54c1\u724cID\u683c\u5f0f\u4e0d\u6b63\u786e");
            responseData.setCode(-100);
            return responseData;
        }
        mktPopupAdvertisementRequestVO.setSysCompanyId(sysCompanyId);
        mktPopupAdvertisementRequestVO.setSysBrandId(sysBrandId);
        mktPopupAdvertisementRequestVO.setAppId(appId);
        mktPopupAdvertisementRequestVO.setMemberCode(memberCode);
        mktPopupAdvertisementRequestVO.setEventDateTime(new Date());
        return this.mktPopupService.mktPopupScanDataCollect(mktPopupAdvertisementRequestVO);
    }
}

