/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.models.bo.IntegralActivityGoodBO;
import com.bizvane.appletservice.models.vo.integralactivity.IntegralNSActivityFindCouponsRequestVO;
import com.bizvane.appletservice.models.vo.integralactivity.IntegralNSActivityFindGoodsRequestVO;
import com.bizvane.appletserviceimpl.impl.integeractivity.nsActivity.IntegrationShopNSActivityServiceImpl;
import com.bizvane.mktcenterservice.models.vo.CouponRecordVO;
import com.bizvane.mktcenterservice.rpc.TaskServiceForWXRpc;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/integrationShop/activity"})
public class IntegrationShopActivityController {
    private static final Logger log = LoggerFactory.getLogger(IntegrationShopActivityController.class);
    @Autowired
    private IntegrationShopNSActivityServiceImpl integrationShopNSActivityService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private TaskServiceForWXRpc taskServiceForWXRpc;

    @GetMapping(value={"getNSActivityDetail"})
    public ResponseData getNSActivityDetail(@RequestParam Long activityId, @RequestParam Long brandId) {
        log.info("IntegrationShopActivityController#getNSActivityDetail#id:{},brandId:{}", (Object)activityId, (Object)brandId);
        return this.integrationShopNSActivityService.getNSActivityDetail(activityId, brandId);
    }

    @GetMapping(value={"deleteNSActivityAll"})
    public ResponseData deleteNSActivityAll(@RequestParam Long activityId, @RequestParam Long brandId) {
        log.info("IntegrationShopActivityController#deleteNSActivityAll#id:{},brandId:{}", (Object)activityId, (Object)brandId);
        return this.integrationShopNSActivityService.deleteNSActivityAll(brandId, activityId);
    }

    @PostMapping(value={"getActivityGood"})
    public ResponseData getActivityGood(@RequestBody @Valid IntegralNSActivityFindGoodsRequestVO requestVO) {
        log.info("IntegrationShopActivityController#getActivityGood#requestVO:{}", (Object)JSON.toJSONString((Object)requestVO));
        return this.integrationShopNSActivityService.getNSActivityGoods(requestVO);
    }

    @PostMapping(value={"getActivityCoupon"})
    public ResponseData getExchangeCoupon(@RequestBody @Valid IntegralNSActivityFindCouponsRequestVO requestVO, HttpServletRequest request) {
        CouponRecordVO couponRecordVO = new CouponRecordVO();
        couponRecordVO.setPageNumber(requestVO.getPageIndex());
        couponRecordVO.setPageSize(requestVO.getPageSize());
        couponRecordVO.setBrandId(requestVO.getBrandId());
        couponRecordVO.setExchangePriceType(requestVO.getExchangePriceType());
        log.info("IntegrationShopActivityController#getActivityCoupon#couponRecordVO:{}", (Object)JSON.toJSONString((Object)couponRecordVO));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        log.info("integrationShopGetall memberCode:{}", (Object)memberCode);
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        if (couponRecordVO.getBrandId() == null) {
            responseData.setMessage("\u54c1\u724c\u4e3a null");
            responseData.setCode(100);
            return responseData;
        }
        couponRecordVO.setMemberCode(memberCode);
        return this.integrationShopNSActivityService.getNSActivityCoupons(couponRecordVO, requestVO.getActivityId());
    }

    @GetMapping(value={"getShelfIntegralCoupon"})
    public ResponseData<List<IntegralActivityGoodBO>> getShelfIntegralCoupon(@RequestParam Long brandId) {
        return this.taskServiceForWXRpc.getShelfIntegralCoupon(brandId);
    }
}

