/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.common.HttpUtil;
import com.bizvane.appletservice.interfaces.IntegrationShopService;
import com.bizvane.appletservice.models.po.IntegralConfigPO;
import com.bizvane.appletservice.models.po.IntegralConfigPOWithBLOBs;
import com.bizvane.appletservice.models.vo.IntegralOrderDetailResponseVo;
import com.bizvane.appletservice.models.vo.IntegralOrderRequestVo;
import com.bizvane.appletservice.models.vo.IntegralOrderResponseVo;
import com.bizvane.appletservice.models.vo.IntegralOrderSendMqRequestVo;
import com.bizvane.appletserviceimpl.impl.integeractivity.nsActivity.IntegrationShopNSActivityServiceImpl;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
@RequestMapping(value={"/integralShopServiceRpc"}, method={RequestMethod.POST})
public class IntegralShopControllerRpc {
    private static final Logger log = LoggerFactory.getLogger(IntegralShopControllerRpc.class);
    @Value(value="${wxStore.baseUrl}")
    private String DOMAINNAME = "https://www.uat.bizvane.cn/";
    @Autowired
    private IntegrationShopService integrationShopService;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private IntegrationShopNSActivityServiceImpl integrationShopNSActivityService;
    private static final String getMerchantConfigList = "api/apiIntegralConfig/getMerchantConfigList";
    private static final String getOrderDetailByOrderNo = "api/rpc/integral/getOrderDetailByOrderNo";
    private static final String orderPrefix = "JFSC";

    @PostMapping(value={"getMerchantConfigList"})
    public List<IntegralConfigPOWithBLOBs> getMerchantConfigList(@RequestBody IntegralConfigPO integralConfigPO) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Content-Type", "application/json");
            String result = HttpUtil.post((String)(this.DOMAINNAME + getMerchantConfigList), (String)JSON.toJSONString((Object)integralConfigPO), map);
            log.info("IntegralShopControllerRpc#getMerchantConfigList#result:{}", (Object)JSON.toJSONString((Object)result));
            List integralConfigPOWithBLOBs = JSONObject.parseArray((String)result, IntegralConfigPOWithBLOBs.class);
            log.info("IntegralShopControllerRpc#getMerchantConfigList#integralConfigPOWithBLOBs:{}", (Object)JSON.toJSONString((Object)integralConfigPOWithBLOBs));
            return integralConfigPOWithBLOBs;
        }
        catch (IOException e) {
            log.error("IntegralShopControllerRpc#getMerchantConfigList#:error:{}", (Object)e.getMessage());
            return null;
        }
    }

    @PostMapping(value={"getOrderDetail"})
    public ResponseData<IntegralOrderResponseVo> getOrderDetail(@RequestBody IntegralOrderRequestVo requestVo) {
        log.info("IntegralShopControllerRpc#getOrderDetail#requestVo:{}", (Object)JSON.toJSONString((Object)requestVo));
        ResponseData responseData = new ResponseData();
        IntegralOrderResponseVo integralOrderResponseVo = new IntegralOrderResponseVo();
        if (requestVo.getOrderNo().contains(orderPrefix)) {
            try {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("Content-Type", "application/json");
                String result = HttpUtil.post((String)(this.DOMAINNAME + getOrderDetailByOrderNo), (String)JSON.toJSONString((Object)requestVo), map);
                log.info("IntegralShopControllerRpc#getOrderDetail#result:{}", (Object)JSON.toJSONString((Object)result));
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                IntegralOrderDetailResponseVo integralOrderDetailResponseVo = (IntegralOrderDetailResponseVo)JSONObject.parseObject((String)jsonObject.getString("data"), IntegralOrderDetailResponseVo.class);
                log.info("IntegralShopControllerRpc#getOrderDetail#integralOrderDetailResponseVo:{}", (Object)JSON.toJSONString((Object)integralOrderDetailResponseVo));
                integralOrderResponseVo.setOrderNo(integralOrderDetailResponseVo.getIntegralOrdersPO().getOrderNo());
                if (StringUtils.isEmpty((Object)integralOrderDetailResponseVo.getIntegralOrdersPO().getOrderType())) {
                    integralOrderResponseVo.setShippingMode(Integer.valueOf(0));
                }
                integralOrderResponseVo.setShippingMode(Integer.valueOf(integralOrderDetailResponseVo.getIntegralOrdersPO().getOrderType()));
                integralOrderResponseVo.setOrderType(Integer.valueOf(1));
                integralOrderResponseVo.setCardNo(integralOrderDetailResponseVo.getIntegralOrdersPO().getMemberCardNo());
                integralOrderResponseVo.setPhone(integralOrderDetailResponseVo.getIntegralOrdersPO().getMemberPhone());
                integralOrderResponseVo.setOrderTime(integralOrderDetailResponseVo.getIntegralOrdersPO().getOrderTime());
                integralOrderResponseVo.setSelfPickStoreName(integralOrderDetailResponseVo.getIntegralOrdersPO().getStoreName());
                integralOrderResponseVo.setSelfPickStoreCode(integralOrderDetailResponseVo.getIntegralOrdersPO().getStoreCode());
                integralOrderResponseVo.setSaleQuantity(integralOrderDetailResponseVo.getIntegralOrdersDetailsPO().getSaleQuantity());
                integralOrderResponseVo.setPayedIntegral(integralOrderDetailResponseVo.getIntegralOrdersDetailsPO().getSaleIntegral());
                integralOrderResponseVo.setPayedCash(integralOrderDetailResponseVo.getIntegralOrdersDetailsPO().getSalePrice());
                integralOrderResponseVo.setGoodsNo(integralOrderDetailResponseVo.getGoodsPO().getGoodsNo());
                integralOrderResponseVo.setGoodsName(integralOrderDetailResponseVo.getGoodsPO().getGoodsName());
                integralOrderResponseVo.setGoodsCoverImg(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)integralOrderDetailResponseVo.getGoodsPO().getCoverImg()));
                if (integralOrderDetailResponseVo.getGoodsSkuPO() != null) {
                    integralOrderResponseVo.setSkuNo(integralOrderDetailResponseVo.getGoodsSkuPO().getSkuNo());
                    integralOrderResponseVo.setSpecNames(integralOrderDetailResponseVo.getGoodsSkuPO().getSpecNames());
                    integralOrderResponseVo.setSkuImg(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)integralOrderDetailResponseVo.getGoodsSkuPO().getSkuImg()));
                }
                responseData.setData((Object)integralOrderResponseVo);
                return responseData;
            }
            catch (IOException e) {
                log.error("IntegralShopControllerRpc#getOrderDetail#:error:{}", (Object)e.getMessage());
                responseData.setData((Object)integralOrderResponseVo);
                return responseData;
            }
        }
        return this.integrationShopService.getOrderDetail(requestVo);
    }

    @PostMapping(value={"sendPayedOrderMq"})
    public ResponseData<Integer> sendPayedOrderMq(@RequestBody @Valid IntegralOrderSendMqRequestVo requestVo) {
        this.integrationShopService.sendPayedOrderMq(requestVo);
        return new ResponseData();
    }

    @GetMapping(value={"getNSActivityCouponCodes"})
    public ResponseData<List<String>> getNSActivityCouponCodes(@RequestParam Long activityId, @RequestParam Long brandId) {
        log.info("IntegrationShopActivityController#getNSActivityCouponCodes#id:{},brandId:{}", (Object)activityId, (Object)brandId);
        return this.integrationShopNSActivityService.getNSActivityCouponCodes(activityId, brandId);
    }
}

