/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.fitmentservice.models.Rpc.AppletGraphicServiceRpc;
import com.bizvane.fitmentservice.models.po.AppletGraphicPO;
import com.bizvane.fitmentservice.models.po.AppletGraphicStatisticPO;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/graphic"})
public class GraphicController {
    private static final Logger log = LoggerFactory.getLogger(GraphicController.class);
    @Autowired
    private AppletGraphicServiceRpc appletGraphicServiceRpc;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;

    @RequestMapping(value={"/selectById"}, method={RequestMethod.GET})
    @ApiOperation(value="\u56fe\u6587\u67e5\u8be2")
    public ResponseData<AppletGraphicPO> selectById(@RequestParam Long graphicId) {
        log.info("\u8fdb\u5165GraphicController\u5c42selectById\u65b9\u6cd5 \u53c2\u6570\uff1agraphicId=" + graphicId);
        ResponseData responseData = this.appletGraphicServiceRpc.selectById(graphicId);
        if (responseData != null && responseData.getCode() == 200) {
            responseData.setCode(0);
        }
        return responseData;
    }

    @ApiOperation(value="\u6dfb\u52a0\u4f1a\u5458\u56fe\u6587\u67e5\u8be2\u8bb0\u5f55")
    @RequestMapping(value={"/record"}, method={RequestMethod.POST})
    public ResponseData record(HttpServletRequest request, @RequestParam Long graphicId) {
        ResponseData responseData = null;
        log.info("\u8fdb\u5165GraphicController\u5c42record\u65b9\u6cd5 \u53c2\u6570\uff1agraphicId=" + graphicId);
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData = new ResponseData(-100, "\u4f1a\u5458\u4e3a\u7a7a");
            return responseData;
        }
        Long sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        Long sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        AppletGraphicStatisticPO appletGraphicStatisticPO = new AppletGraphicStatisticPO();
        appletGraphicStatisticPO.setMemberCode(memberCode);
        appletGraphicStatisticPO.setGraphicId(graphicId);
        appletGraphicStatisticPO.setSysBrandId(sysBrandId);
        appletGraphicStatisticPO.setSysCompanyId(sysCompanyId);
        responseData = this.appletGraphicServiceRpc.record(appletGraphicStatisticPO);
        return responseData;
    }
}

