/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.interfaces.LoginService;
import com.bizvane.appletservice.models.bo.MemberResoucreBO;
import com.bizvane.appletservice.models.vo.CouponReceiveStatusVO;
import com.bizvane.appletservice.models.vo.ReceiveCouponAppletVO;
import com.bizvane.appletserviceimpl.utils.LogicException;
import com.bizvane.couponfacade.interfaces.CouponServiceFeign;
import com.bizvane.couponfacade.models.vo.CouponDetailResponseVO;
import com.bizvane.couponfacade.models.vo.CouponEntityAndDefinitionVO;
import com.bizvane.couponfacade.models.vo.CouponListByMemberCodeRequestVO;
import com.bizvane.couponfacade.models.vo.CouponQuotaSendDetailAppletVo;
import com.bizvane.couponfacade.models.vo.ReceiveCouponStatusVO;
import com.bizvane.couponfacade.models.vo.SendCouponQuotaBatchRequestVO;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateService;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/coupon"})
public class CouponController {
    private static final Logger log = LoggerFactory.getLogger(CouponController.class);
    @Autowired
    private RedisTemplateService<String, String> redisTemplateService;
    @Autowired
    private LoginService loginService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private CouponServiceFeign couponServiceFeign;

    @GetMapping(value={"/activityCoupon"})
    public ResponseData getActivityCoupon(@RequestParam(value="sysBrandId") Long sysBrandId, @RequestParam(value="page") Integer page, @RequestParam(value="pageSize") Integer pageSize) {
        log.info("\u8c03\u7528applet_activityCoupon");
        return this.couponServiceFeign.activityCoupon(sysBrandId, page, pageSize);
    }

    @PostMapping(value={"/getCouponReceiveStatus"})
    public ResponseData getCouponReceiveStatus(@RequestBody CouponReceiveStatusVO couponReceiveStatusVO) {
        log.info("coupon.api_CouponController_getCouponReceiveStatus{}", (Object)JSON.toJSONString((Object)couponReceiveStatusVO));
        ReceiveCouponStatusVO receiveCouponStatusVO = new ReceiveCouponStatusVO();
        BeanUtils.copyProperties((Object)couponReceiveStatusVO, (Object)receiveCouponStatusVO);
        log.info("coupon.api_CouponController_getCouponReceiveStatus\u8bf7\u6c42\u53c2\u6570{}", (Object)JSON.toJSONString((Object)receiveCouponStatusVO));
        return this.couponServiceFeign.getCouponReceiveStatus(receiveCouponStatusVO);
    }

    @PostMapping(value={"/getCouponDtlById"})
    public ResponseData<CouponDetailResponseVO> getCouponDtlById(HttpServletRequest request, @RequestParam Long couponDifindustrySendDetailId) {
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            ResponseData responseData = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
        ResponseData couponBySendIdRpc = this.couponServiceFeign.findCouponBySendIdRpc(couponDifindustrySendDetailId);
        ResponseData response = new ResponseData(SysResponseEnum.SUCCESS.getCode(), SysResponseEnum.SUCCESS.getMessage(), couponBySendIdRpc.getData());
        return response;
    }

    @PostMapping(value={"/getOtherBrandDifindustryCoupon"})
    public ResponseData<PageInfo<CouponEntityAndDefinitionVO>> getOtherBrandDifindustryCoupon(HttpServletRequest request, @RequestParam(required=false, defaultValue="0") Integer pageNum, @RequestParam(required=false, defaultValue="0") Integer pageSize) {
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        Long sysBrandId = null;
        Long sysCompanyId = null;
        if (StringUtils.isNotBlank((CharSequence)memberCode)) {
            sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
            sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        }
        CouponListByMemberCodeRequestVO vo = new CouponListByMemberCodeRequestVO();
        vo.setPageNumber(pageNum);
        vo.setPageSize(pageSize);
        vo.setMemberCode(memberCode);
        vo.setSysCompanyId(sysCompanyId);
        vo.setSysBrandId(sysBrandId);
        ResponseData responseData = this.couponServiceFeign.getOtherBrandDifindustryCoupon(vo);
        return responseData;
    }

    @GetMapping(value={"/getCouponQuotaSendDetailById"})
    public ResponseData<CouponQuotaSendDetailAppletVo> getCouponQuotaSendDetailById(HttpServletRequest request, @RequestParam(value="couponQuotaSendDetailId") Long couponQuotaSendDetailId) {
        String sysBrandId = request.getHeader("sysBrandId");
        log.info("getCouponQuotaSendDetailById method sysBrandId:{}, couponQuotaSendDetailId:{}", (Object)sysBrandId, (Object)couponQuotaSendDetailId);
        if (StringUtils.isBlank((CharSequence)sysBrandId)) {
            throw LogicException.error((Integer)-100, (String)"\u672a\u6388\u6743\uff0c\u8bf7\u91cd\u65b0\u767b\u9646");
        }
        ResponseData couponQuotaSendDetailAppletVoRes = this.couponServiceFeign.getCouponQuotaSendDetailAppletVoById(couponQuotaSendDetailId);
        if (couponQuotaSendDetailAppletVoRes == null || couponQuotaSendDetailAppletVoRes.getData() == null) {
            log.info("couponServiceFeign#getCouponQuotaSendDetailAppletVoById method couponQuotaSendDetailAppletVoRes:{}", (Object)JacksonUtil.bean2Json((Object)couponQuotaSendDetailAppletVoRes));
            return new ResponseData((Object)new CouponQuotaSendDetailAppletVo());
        }
        CouponQuotaSendDetailAppletVo couponQuotaSendDetailAppletVo = (CouponQuotaSendDetailAppletVo)couponQuotaSendDetailAppletVoRes.getData();
        if (!couponQuotaSendDetailAppletVo.getSysBrandId().toString().equals(sysBrandId)) {
            log.info("\u5c0f\u7a0b\u5e8f\u54c1\u724c\u548c\u5238\u53d1\u9001\u54c1\u724c\u4e0d\u4e00\u81f4,\u5c0f\u7a0b\u5e8f\u54c1\u724c:{},\u5238\u53d1\u9001\u54c1\u724c:{}", (Object)sysBrandId, (Object)couponQuotaSendDetailAppletVo.getSysBrandId());
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u62b1\u6b49,\u5c0f\u7a0b\u5e8f\u54c1\u724c\u548c\u5238\u53d1\u9001\u54c1\u724c\u4e0d\u4e00\u81f4!");
        }
        return new ResponseData((Object)couponQuotaSendDetailAppletVo);
    }

    @PostMapping(value={"/receiveCoupon"})
    public ResponseData<String> receiveCoupon(HttpServletRequest request, @RequestBody ReceiveCouponAppletVO receiveCouponAppletVO) {
        MemberResoucreBO memberResourceBO = this.loginService.getMemberResourceBO();
        log.info("receiveCoupon method memberResourceBO:{},receiveCouponAppletVO:{}", (Object)JacksonUtil.bean2Json((Object)memberResourceBO), (Object)JacksonUtil.bean2Json((Object)receiveCouponAppletVO));
        if (receiveCouponAppletVO == null) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u62b1\u6b49,\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a!");
        }
        if (receiveCouponAppletVO.getReceiveCouponType() == null) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u62b1\u6b49,\u8bf7\u6c42\u53c2\u6570receiveCouponType\u4e3a\u7a7a!");
        }
        if (Integer.valueOf(1).equals(receiveCouponAppletVO.getReceiveCouponType()) && receiveCouponAppletVO.getCouponQuotaSendDetailId() == null) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u62b1\u6b49,\u8bf7\u6c42\u53c2\u6570couponQuotaSendDetailId\u4e3a\u7a7a!");
        }
        if (Integer.valueOf(1).equals(receiveCouponAppletVO.getReceiveCouponType())) {
            return this.receiveCouponQuota(receiveCouponAppletVO, memberResourceBO);
        }
        return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u62b1\u6b49,\u8be5\u4f18\u60e0\u5238\u6682\u4e0d\u652f\u6301\u8be5\u9886\u53d6\u65b9\u5f0f!");
    }

    private ResponseData<String> receiveCouponQuota(@RequestBody ReceiveCouponAppletVO receiveCouponAppletVO, MemberResoucreBO memberResourceBO) {
        MemberInfoModel memberInfoModel;
        ResponseData couponQuotaSendDetailAppletVoRes = this.couponServiceFeign.getCouponQuotaSendDetailAppletVoById(receiveCouponAppletVO.getCouponQuotaSendDetailId());
        if (couponQuotaSendDetailAppletVoRes == null || couponQuotaSendDetailAppletVoRes.getData() == null) {
            log.info("\u9886\u5238\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a,couponQuotaSendDetailAppletVoRes:{}", (Object)JacksonUtil.bean2Json((Object)couponQuotaSendDetailAppletVoRes));
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u62b1\u6b49,\u8be5\u4f18\u60e0\u5238\u9886\u5238\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a!");
        }
        CouponQuotaSendDetailAppletVo couponQuotaSendDetailAppletVo = (CouponQuotaSendDetailAppletVo)couponQuotaSendDetailAppletVoRes.getData();
        if (Integer.valueOf(3).equals(couponQuotaSendDetailAppletVo.getSendStatus())) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u62b1\u6b49,\u8be5\u4f18\u60e0\u5238\u5df2\u7ecf\u9886\u53d6\u4e86!");
        }
        if (!Integer.valueOf(2).equals(couponQuotaSendDetailAppletVo.getSendStatus())) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u62b1\u6b49,\u8be5\u4f18\u60e0\u5238\u975e\u5f85\u9886\u53d6\u72b6\u6001!");
        }
        if (Boolean.FALSE.equals(couponQuotaSendDetailAppletVo.getValid())) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u62b1\u6b49,\u8be5\u4f18\u60e0\u5238\u5df2\u7ecf\u5931\u6548\u4e86!");
        }
        if (couponQuotaSendDetailAppletVo.getGetCouponEndTime() != null && couponQuotaSendDetailAppletVo.getGetCouponEndTime().before(new Date())) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u62b1\u6b49,\u8be5\u4f18\u60e0\u5238\u5df2\u7ecf\u5931\u6548\u4e86!");
        }
        if (StringUtils.isNotBlank((CharSequence)couponQuotaSendDetailAppletVo.getMemberCodeList()) && !couponQuotaSendDetailAppletVo.getMemberCodeList().equals(memberResourceBO.getMemberCode())) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u62b1\u6b49,\u8be5\u4f18\u60e0\u5238\u4e0d\u5c5e\u4e8e\u60a8!");
        }
        SendCouponQuotaBatchRequestVO sendCouponQuotaBatchRequestVO = new SendCouponQuotaBatchRequestVO();
        sendCouponQuotaBatchRequestVO.setCouponQuotaSendDetailId(couponQuotaSendDetailAppletVo.getCouponQuotaSendDetailId());
        sendCouponQuotaBatchRequestVO.setCouponQuotaId(couponQuotaSendDetailAppletVo.getCouponQuotaId());
        sendCouponQuotaBatchRequestVO.setCouponQuotaDetailId(couponQuotaSendDetailAppletVo.getCouponQuotaDetailId());
        sendCouponQuotaBatchRequestVO.setCouponDefinitionId(couponQuotaSendDetailAppletVo.getCouponDefinitionId());
        sendCouponQuotaBatchRequestVO.setSysCompanyId(couponQuotaSendDetailAppletVo.getSysCompanyId());
        sendCouponQuotaBatchRequestVO.setSysBrandId(couponQuotaSendDetailAppletVo.getSysBrandId());
        sendCouponQuotaBatchRequestVO.setStaffCode(couponQuotaSendDetailAppletVo.getStaffCode());
        sendCouponQuotaBatchRequestVO.setGetCouponSwitch(Boolean.TRUE);
        sendCouponQuotaBatchRequestVO.setIsDeductQuota(Boolean.valueOf(false));
        sendCouponQuotaBatchRequestVO.setMemberCode(memberResourceBO.getMemberCode());
        if (StringUtils.isBlank((CharSequence)couponQuotaSendDetailAppletVo.getMemberCodeList()) && (memberInfoModel = this.getMemberInfoByMemberCode(memberResourceBO.getBrandId(), memberResourceBO.getMemberCode())) != null) {
            sendCouponQuotaBatchRequestVO.setMemberName(memberInfoModel.getName());
        }
        ResponseData sendCouponRes = this.couponServiceFeign.sendCoupon(sendCouponQuotaBatchRequestVO);
        log.info("\u9886\u5238\u7ed3\u679c:{}", (Object)JacksonUtil.bean2Json((Object)sendCouponRes));
        return sendCouponRes;
    }

    private MemberInfoModel getMemberInfoByMemberCode(Long brandId, String memberCode) {
        MemberInfoModel memberInfoModelSearch = MemberInfoModel.builder().brandId(brandId).memberCode(memberCode).build();
        ResponseData singleMemberModelRes = this.memberInfoApiService.getSingleMemberModel(memberInfoModelSearch);
        if (singleMemberModelRes == null || singleMemberModelRes.getData() == null) {
            log.info("memberInfoApiService#getSingleMemberModel singleMemberModelRes:{}", (Object)JacksonUtil.bean2Json((Object)singleMemberModelRes));
            return null;
        }
        return (MemberInfoModel)singleMemberModelRes.getData();
    }

    @PostMapping(value={"/exchangePreCoupon"})
    public ResponseData<Boolean> exchangePreCoupon(HttpServletRequest request, @NotBlank @RequestParam(value="couponCode") String couponCode) {
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isEmpty((CharSequence)memberCode)) {
            throw new BizException(-1, "\u7528\u6237\u672a\u6388\u6743\u5c0f\u7a0b\u5e8f");
        }
        log.info("\u5151\u6362\u9884\u751f\u6210\u5238exchangePreCoupon:{},{}", (Object)couponCode, (Object)memberCode);
        return this.couponServiceFeign.exchangePreCoupon(couponCode, memberCode);
    }
}

