/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.vg;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.interfaces.MembershipCardService;
import com.bizvane.appletservice.models.bo.AppletCardLevelPrivLegeBo;
import com.bizvane.appletservice.models.po.AppletVipCartPO;
import com.bizvane.appletservice.models.po.AppletVipCartPOExample;
import com.bizvane.appletservice.models.vo.vg.VGClubMemberCardLevelResponseVO;
import com.bizvane.appletserviceimpl.mappers.AppletVipCartPOMapper;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberLevelApiService;
import com.bizvane.members.facade.service.api.vg.VGMemberInfoRpcService;
import com.bizvane.members.facade.vo.vg.AllOrderResquestVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VGMemberDetailPageServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(VGMemberDetailPageServiceImpl.class);
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private MemberLevelApiService memberLevelApiService;
    @Autowired
    private VGMemberInfoRpcService vgMemberInfoRpcService;
    @Autowired
    private MembershipCardService membershipCardService;
    @Resource
    private AppletVipCartPOMapper appletVipCartPoMapper;
    private static final String SPECIAL_TYPE = "2";

    public void getMemberClubCardUpAndDown(MemberInfoModel member, MbrLevelModel currentLevel, AppletCardLevelPrivLegeBo result) {
        List<VGClubMemberCardLevelResponseVO> needAddList = new ArrayList();
        String upGradeConditionStr = currentLevel.getUpGradeCondition();
        JSONObject upGradeConditionJson = JSON.parseObject((String)upGradeConditionStr);
        String singlemonetary = upGradeConditionJson.getString("singlemonetary");
        String currentTotalmonetaryStr = upGradeConditionJson.getString("totalmonetary");
        Long mbrLevelId = currentLevel.getMbrLevelId();
        log.info("VGMemberDetailPageServiceImpl#getMemberClubCardUpAndDown#currentSingleMonetary:{},currentTotalmonetaryStr:{}", (Object)singlemonetary, (Object)currentTotalmonetaryStr);
        if (StringUtils.isNotEmpty((CharSequence)currentLevel.getKeepLevelTime()) && member.getLevelUpTime() != null) {
            Integer timeMonthStamp = Integer.valueOf(currentLevel.getKeepLevelTime());
            Calendar rightNow = Calendar.getInstance();
            rightNow.setTime(member.getLevelUpTime());
            rightNow.add(2, timeMonthStamp);
            Date deadLine = rightNow.getTime();
            result.setKeepLevelTime(deadLine);
        }
        BigDecimal currentTotalmonetary = BigDecimal.ZERO;
        if (StringUtils.isNotEmpty((CharSequence)currentTotalmonetaryStr)) {
            currentTotalmonetary = new BigDecimal(currentTotalmonetaryStr);
        }
        result.setLevelUpRate(BigDecimal.ZERO);
        if (SPECIAL_TYPE.equals(currentLevel.getLevelType())) {
            log.info("\u8be5\u4f1a\u5458\u4e0d\u652f\u6301\u5347\u7ea7");
            result.setLevelUpJudge(Boolean.FALSE);
            needAddList = this.getCurrentLevelList(mbrLevelId, member.getBrandId());
            result.setRateList(needAddList);
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)singlemonetary)) {
            log.info("\u5355\u6b21\u6d88\u8d39\u4e0d\u8ba1\u7b97\u767e\u5206\u6bd4\uff0c\u4e0d\u663e\u793a\u8fdb\u5ea6\u6761");
            result.setLevelUpJudge(Boolean.FALSE);
            needAddList = this.getCurrentLevelList(mbrLevelId, member.getBrandId());
            result.setRateList(needAddList);
            return;
        }
        List allLevelModels = (List)this.memberLevelApiService.queryAllLevelList(member.getBrandId()).getData();
        log.info("VGmemberDetailPageServiceImpl#getMemberClubCardUpAndDown#allLevelModels:{}", (Object)JSON.toJSONString((Object)allLevelModels));
        AppletVipCartPOExample appletVipCartPoExample = new AppletVipCartPOExample();
        appletVipCartPoExample.createCriteria().andValidEqualTo(Boolean.TRUE).andSysBrandIdEqualTo(member.getBrandId());
        List appletVipCartPOS = this.appletVipCartPoMapper.selectByExample(appletVipCartPoExample);
        Iterator allLevelModelIterator = allLevelModels.iterator();
        String canUpLevelType = "1";
        while (allLevelModelIterator.hasNext()) {
            MbrLevelModel next = (MbrLevelModel)allLevelModelIterator.next();
            if (next.getLevelType().equals(canUpLevelType)) continue;
            allLevelModelIterator.remove();
        }
        CollectionUtil.sort((List)allLevelModels, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        log.info("VGmemberDetailPageServiceImpl#getMemberClubCardUpAndDown#allLevelModels#\u6392\u5e8f\u540e:{}", (Object)JSON.toJSONString((Object)allLevelModels));
        MbrLevelModel mbrLevelModelCurrentUp = null;
        boolean ifCurrentLevelJudge = Boolean.FALSE;
        for (MbrLevelModel forEachModel : allLevelModels) {
            if (ifCurrentLevelJudge) {
                mbrLevelModelCurrentUp = forEachModel;
            }
            ifCurrentLevelJudge = forEachModel.getMbrLevelId().equals(currentLevel.getMbrLevelId());
            for (AppletVipCartPO appletVipCartPO : appletVipCartPOS) {
                if (forEachModel.getMbrLevelId().compareTo(appletVipCartPO.getGradeId()) != 0 || !Byte.valueOf("1").equals(appletVipCartPO.getReveal())) continue;
                needAddList.add(this.translateMbrLevelModel2RateResponseVO(forEachModel, Boolean.valueOf(ifCurrentLevelJudge)));
            }
        }
        log.info("mbrLevelModelCurrentUp:{}", (Object)JSON.toJSONString(mbrLevelModelCurrentUp));
        if (mbrLevelModelCurrentUp != null) {
            String highUpGradeConditionStr = mbrLevelModelCurrentUp.getUpGradeCondition();
            JSONObject highUpGradeConditionJson = JSON.parseObject((String)highUpGradeConditionStr);
            String highSinglemonetary = highUpGradeConditionJson.getString("singlemonetary");
            String highTotalmonetaryStr = highUpGradeConditionJson.getString("totalmonetary");
            BigDecimal highTotalmonetary = new BigDecimal(highTotalmonetaryStr);
            log.info("VGMemberDetailPageServiceImpl#getMemberClubCardUpAndDown#highSinglemonetary:{}", (Object)highSinglemonetary);
            if (SPECIAL_TYPE.equals(mbrLevelModelCurrentUp.getLevelType())) {
                log.info("\u9ad8\u7b49\u7ea7\u4f1a\u5458\u4e0d\u652f\u6301\u5347\u7ea7");
                result.setLevelUpJudge(Boolean.FALSE);
                result.setRateList(needAddList);
                return;
            }
            if (StringUtils.isNotEmpty((CharSequence)highSinglemonetary)) {
                log.info("\u9ad8\u7b49\u7ea7\u5355\u6b21\u6d88\u8d39\u4e0d\u8ba1\u7b97\u767e\u5206\u6bd4\uff0c\u4e0d\u663e\u793a\u8fdb\u5ea6\u6761");
                result.setLevelUpJudge(Boolean.FALSE);
                result.setRateList(needAddList);
                return;
            }
            if (StringUtils.isEmpty((CharSequence)highTotalmonetaryStr)) {
                log.info("\u5347\u7ea7\u6761\u4ef6\u4e3a\u7a7a");
                result.setLevelUpJudge(Boolean.FALSE);
                result.setRateList(needAddList);
                return;
            }
            if (highTotalmonetary.compareTo(currentTotalmonetary) < 1) {
                log.info("\u9ad8\u7b49\u7ea7\u5347\u7ea7\u6761\u4ef6\u5c0f\u4e8e\u4f4e\u7b49\u7ea7");
                result.setLevelUpJudge(Boolean.FALSE);
                result.setRateList(needAddList);
                return;
            }
            BigDecimal difference = highTotalmonetary.subtract(currentTotalmonetary);
            log.info("\u5dee\u503c={}-{}={}", new Object[]{highTotalmonetary, currentTotalmonetary, difference});
            Date deadLine = null;
            if (member.getLevelUpTime() != null && mbrLevelModelCurrentUp.getUpMonthNum() != 0) {
                Calendar rightNow = Calendar.getInstance();
                rightNow.setTime(member.getLevelUpTime());
                rightNow.add(2, mbrLevelModelCurrentUp.getUpMonthNum());
                deadLine = rightNow.getTime();
            }
            AllOrderResquestVO getOrderRequestVO = AllOrderResquestVO.builder().startDate(member.getLevelUpTime()).endDate(deadLine).groupMemberCode(member.getMemberCode()).sysBrandId(member.getBrandId()).build();
            if (mbrLevelModelCurrentUp.getUpMonthNum() == 0) {
                log.info("\u8fdb\u5165\u7d2f\u8ba1\u903b\u8f91\uff0c\u4e0d\u8bbe\u65f6\u95f4\u9650\u5236");
                getOrderRequestVO.setEndDate(null);
                getOrderRequestVO.setStartDate(null);
            }
            log.info("\u67e5\u8ba2\u5355\u91d1\u989d\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)getOrderRequestVO));
            BigDecimal allOrderByBrandId = (BigDecimal)this.vgMemberInfoRpcService.getAllOrderByBrandId(getOrderRequestVO).getData();
            log.info("\u8ba2\u5355\u91d1\u989d:{}", (Object)allOrderByBrandId);
            if (allOrderByBrandId == null) {
                log.info("\u8ba2\u5355\u91d1\u989d\u7a7a");
                allOrderByBrandId = BigDecimal.ZERO;
            } else if (mbrLevelModelCurrentUp.getUpMonthNum() == 0) {
                log.info("\u8ba2\u5355\u91d1\u989d={}-{}", (Object)allOrderByBrandId, (Object)currentTotalmonetary);
                allOrderByBrandId = allOrderByBrandId.subtract(currentTotalmonetary);
                log.info("\u8ba2\u5355\u91d1\u989d11={}", (Object)allOrderByBrandId);
            }
            if (allOrderByBrandId.compareTo(BigDecimal.ZERO) < 0) {
                log.info("\u8ba2\u5355\u91d1\u989d<0,\u9ed8\u8ba40");
                allOrderByBrandId = BigDecimal.ZERO;
            }
            BigDecimal rate = allOrderByBrandId.divide(difference, 3, 4);
            log.info("VGMemberDetailPageServiceImpl#getMemberClubCardUpAndDown#allOrderByBrandId:{},difference:{},rate:{}", new Object[]{allOrderByBrandId.toString(), difference.toString(), rate.toString()});
            if (rate.compareTo(BigDecimal.ONE) > 0) {
                log.info("rate\u8fdb\u5165\u5904\u7406");
                rate = BigDecimal.ONE;
            }
            BigDecimal multiply = rate.multiply(new BigDecimal(100));
            log.info("setLevelUpRate:{}", (Object)multiply);
            result.setLevelUpRate(multiply);
        }
        result.setLevelUpJudge(Boolean.TRUE);
        result.setRateList(needAddList);
        log.info("VGMemberDetailPageServiceImpl#getMemberClubCardUpAndDown:{}", (Object)JSON.toJSONString((Object)result));
    }

    private List<VGClubMemberCardLevelResponseVO> getCurrentLevelList(Long currentLevelId, Long brandId) {
        ArrayList<VGClubMemberCardLevelResponseVO> needAddList = new ArrayList<VGClubMemberCardLevelResponseVO>();
        List allLevelModels = (List)this.memberLevelApiService.queryAllLevelList(brandId).getData();
        log.info("VGMemberDetailPageServiceImpl#getCurrentLevelList#allLevelModels:{}", (Object)JSON.toJSONString((Object)allLevelModels));
        AppletVipCartPOExample appletVipCartPoExample = new AppletVipCartPOExample();
        appletVipCartPoExample.createCriteria().andValidEqualTo(Boolean.TRUE).andSysBrandIdEqualTo(brandId);
        List appletVipCartPOS = this.appletVipCartPoMapper.selectByExample(appletVipCartPoExample);
        CollectionUtil.sort((List)allLevelModels, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        log.info("VGMemberDetailPageServiceImpl#getCurrentLevelList#allLevelModels:{}", (Object)JSON.toJSONString((Object)allLevelModels));
        for (MbrLevelModel forEachModel : allLevelModels) {
            boolean ifCurrentLevelJudge = forEachModel.getMbrLevelId().equals(currentLevelId);
            for (AppletVipCartPO appletVipCartPO : appletVipCartPOS) {
                if (forEachModel.getMbrLevelId().compareTo(appletVipCartPO.getGradeId()) != 0 || !Byte.valueOf("1").equals(appletVipCartPO.getReveal())) continue;
                needAddList.add(this.translateMbrLevelModel2RateResponseVO(forEachModel, Boolean.valueOf(ifCurrentLevelJudge)));
            }
        }
        return needAddList;
    }

    private VGClubMemberCardLevelResponseVO translateMbrLevelModel2RateResponseVO(MbrLevelModel levelModel, Boolean ifCurrentLevel) {
        String highUpGradeConditionStr = levelModel.getUpGradeCondition();
        JSONObject highUpGradeConditionJson = JSON.parseObject((String)highUpGradeConditionStr);
        String highTotalmonetaryStr = highUpGradeConditionJson.getString("totalmonetary");
        List appletVipCartPos = (List)this.membershipCardService.selectByPrimaryKey(levelModel.getMbrLevelId()).getData();
        VGClubMemberCardLevelResponseVO responseVO = VGClubMemberCardLevelResponseVO.builder().currentLevelJudge(ifCurrentLevel).levelName(levelModel.getLevelName()).mbrLevelId(levelModel.getMbrLevelId()).levelSort(levelModel.getLevelValue()).totalmonetary(highTotalmonetaryStr).build();
        if (CollectionUtils.isNotEmpty((Collection)appletVipCartPos)) {
            AppletVipCartPO appletVipCartPO = (AppletVipCartPO)appletVipCartPos.get(0);
            responseVO.setImg(appletVipCartPO.getIsImg());
            if (appletVipCartPO.getIsImg().booleanValue()) {
                responseVO.setCardStyle(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)appletVipCartPO.getCardStyle()));
            } else {
                responseVO.setCardStyle(appletVipCartPO.getCardStyle());
            }
        }
        log.info("VGMemberDetailPageServiceImpl#translateMbrLevelModel2RateResponseVO:{}", (Object)JSON.toJSONString((Object)responseVO));
        return responseVO;
    }
}

