/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.vg;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.interfaces.ActivityService;
import com.bizvane.appletservice.interfaces.vg.VGLoginService;
import com.bizvane.appletservice.models.bo.AppletBrandMenberBo;
import com.bizvane.appletservice.models.vo.vg.VGChildBrandRedisVo;
import com.bizvane.appletservice.models.vo.vg.VGMbrRegisterRequestVo;
import com.bizvane.appletservice.models.vo.vg.VGRequestHeaderVo;
import com.bizvane.appletserviceimpl.common.ChannelMemberCodeEnum;
import com.bizvane.appletserviceimpl.impl.vg.VGGetAllMemberInfoServiceImpl;
import com.bizvane.appletserviceimpl.impl.vg.VGInitServiceImpl;
import com.bizvane.appletserviceimpl.utils.MD5Util;
import com.bizvane.appletserviceimpl.utils.OptionUtils;
import com.bizvane.core.facade.interfaces.CoreTraceFeign;
import com.bizvane.core.facade.models.po.TracePO;
import com.bizvane.core.facade.models.po.TraceRecordPO;
import com.bizvane.core.facade.models.vo.TraceRecordVo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.vg.VGMemberInfoRpcService;
import com.bizvane.mktcenterservice.models.bo.MktActivityDetailAndPicture;
import com.bizvane.mktcenterservice.models.vg.VGContentVo;
import com.bizvane.mktcenterservice.models.vo.ProbabilityVO;
import com.bizvane.mktcenterservice.rpc.ActivityEGServiceRpc;
import com.bizvane.mktcenterservice.rpc.ContentServiceRpc;
import com.bizvane.unifiedreg.model.vo.UnifiedRegisterMemberVo;
import com.bizvane.unifiedreg.model.vo.UnifiedRegisterVo;
import com.bizvane.unifiedreg.rpc.MemberChannelRegistrationFeign;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateService;
import com.bizvane.utils.responseinfo.ResponseData;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class VGLoginServiceImpl
implements VGLoginService {
    private static final Logger log = LoggerFactory.getLogger(VGLoginServiceImpl.class);
    @Autowired
    private RedisTemplateService<String, String> redisTemplateService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private MemberChannelRegistrationFeign memberChannelRegistrationFeign;
    @Autowired
    private CoreTraceFeign coreTraceFeign;
    @Autowired
    private ActivityEGServiceRpc activityEGServiceRpc;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private VGInitServiceImpl vgInitService;
    @Autowired
    private OptionUtils optionUtils;
    @Autowired
    private VGGetAllMemberInfoServiceImpl vgGetAllMemberInfoService;
    @Autowired
    private VGMemberInfoRpcService vgMemberInfoRpcService;
    @Autowired
    private ContentServiceRpc contentServiceRpc;

    public ResponseData getMbrAndOpenCard(HttpServletRequest request, VGMbrRegisterRequestVo wxMbrRegisteRequestVo) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        this.redisTemplateService.deleteFromRedis((Object)(memberCode + "_allCardByGroupMemberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            responseData.setCode(-100);
            return responseData;
        }
        String clubBrandId = request.getHeader("clubBrandId");
        if (clubBrandId == null) {
            responseData.setMessage("clubBrandId\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        String phone = (String)this.redisTemplateService.stringGetStringByKey((Object)("Phone:" + memberCode));
        String childBizvaneSessionId = MD5Util.md5((String)(bizvaneSessionId + clubBrandId));
        String masterChildInfo = bizvaneSessionId + "masterCard";
        String vgChildBrandRedisVoJSON = (String)this.redisTemplateService.hashGet((Object)masterChildInfo, (Object)childBizvaneSessionId);
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        Long sysBrandId = Long.valueOf(clubBrandId);
        Long sysCompanyId = ((MemberInfoModel)singleMemberModel.getData()).getSysCompanyId();
        String wxUnionId = ((MemberInfoModel)singleMemberModel.getData()).getWxUnionId();
        String channelCode = null;
        String source = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "source"));
        AppletBrandMenberBo menberBoRes = new AppletBrandMenberBo();
        log.info("\u5f53\u524d\u54c1\u724c\u4ff1\u4e50\u90e8\u6e20\u9053\u4e3a\u5fae\u4fe1\u6e20\u9053");
        channelCode = ChannelMemberCodeEnum.WX_MINI_MEMBER.getCode();
        String redisChildMemberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(childBizvaneSessionId + "memberCode"));
        menberBoRes.setSysBrandId(Long.valueOf(sysBrandId));
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{redisChildMemberCode})) {
            menberBoRes.setMemberCode(redisChildMemberCode);
            return this.getMbrInfoByWx(childBizvaneSessionId, menberBoRes, redisChildMemberCode);
        }
        String mktTaskId = wxMbrRegisteRequestVo.getMktTaskId();
        UnifiedRegisterVo unifiedRegisterVo = new UnifiedRegisterVo();
        String uuid = request.getHeader("UUID");
        log.info("UUID\u5f00\u5361={}", (Object)uuid);
        String uuidJONString = null;
        if (StringUtils.isNotBlank((CharSequence)uuid)) {
            uuidJONString = (String)this.redisTemplateService.stringGetStringByKey((Object)uuid);
            log.info("uuidJONString={}", (Object)uuidJONString);
        }
        if (StringUtils.isNotBlank(uuidJONString)) {
            JSONObject JSONobjectUUID = JSONObject.parseObject(uuidJONString);
            String mktActivityId = JSONobjectUUID.getString("mktActivityId");
            ProbabilityVO vo = new ProbabilityVO();
            vo.setMktActivityId(Long.valueOf(mktActivityId));
            ResponseData mktActivityPOWithBLOBs = this.activityEGServiceRpc.getMktActivityPOWithBLOBs(vo);
            Integer activityType = ((MktActivityDetailAndPicture)mktActivityPOWithBLOBs.getData()).getActivityType();
            log.info("activityType={}, mktActivityId={}", (Object)activityType, (Object)mktActivityId);
            unifiedRegisterVo.setActivityId(Long.valueOf(mktActivityId));
            unifiedRegisterVo.setActivityType(activityType);
        }
        String channelUniqueMemberCode = MD5Util.md5((String)(memberCode + sysBrandId));
        String traceId = this.convertTraceId(wxMbrRegisteRequestVo, sysBrandId, sysCompanyId, wxUnionId);
        this.fillTraceInfo(wxMbrRegisteRequestVo, sysBrandId, unifiedRegisterVo, traceId, (MemberInfoModel)singleMemberModel.getData());
        unifiedRegisterVo.setPhone(phone);
        unifiedRegisterVo.setSysBrandId(sysBrandId);
        unifiedRegisterVo.setSysCompanyId(sysCompanyId);
        unifiedRegisterVo.setChannelUniqueMemberCode(channelUniqueMemberCode);
        unifiedRegisterVo.setChannelCode(channelCode);
        unifiedRegisterVo.setMasterMemberCode(memberCode);
        ResponseData unifiedRegisterMemberVoResponseData = null;
        try {
            unifiedRegisterMemberVoResponseData = this.memberChannelRegistrationFeign.unifiedRegister(unifiedRegisterVo);
        }
        catch (Exception e) {
            log.info("\u5f00\u5361\u63a5\u53e3\u8c03\u7528\u5f02\u5e38:{}", (Throwable)e);
            ResponseData responseDataError = (ResponseData)JSON.parseObject((String)e.getMessage().split("content:")[1], ResponseData.class);
            return new ResponseData(100, responseDataError.getMessage());
        }
        log.info("\u5f00\u5361\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)unifiedRegisterMemberVoResponseData));
        if (unifiedRegisterMemberVoResponseData == null || unifiedRegisterMemberVoResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            return new ResponseData(100, "\u5fae\u4fe1\u6388\u6743\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u518d\u8bd5");
        }
        UnifiedRegisterMemberVo unifiedRegisterMemberVoResponseDataData = (UnifiedRegisterMemberVo)unifiedRegisterMemberVoResponseData.getData();
        String childMemberCode = unifiedRegisterMemberVoResponseDataData.getMemberCode();
        menberBoRes.setMemberCode(childMemberCode);
        Integer operateType = null;
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(childBizvaneSessionId + "memberCode"), (Object)childMemberCode, 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(childMemberCode + "bizvaneSessionId"), (Object)childBizvaneSessionId, 7776000000L);
        VGChildBrandRedisVo vgChildBrandRedisVoAdd = VGChildBrandRedisVo.builder().sysBrandId(sysBrandId).sysCompanyId(sysCompanyId).memberCode(childMemberCode).build();
        this.redisTemplateService.hashPushHashMap((Object)masterChildInfo, (Object)childBizvaneSessionId, (Object)JSON.toJSONString((Object)vgChildBrandRedisVoAdd));
        this.activityService.executeActivity(Long.valueOf(sysBrandId), childMemberCode, operateType);
        if (StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getOderMemberCode())) {
            this.activityService.inviteOpenCoder(childMemberCode, wxMbrRegisteRequestVo.getOderMemberCode(), mktTaskId);
        }
        if (StringUtils.isNotBlank((CharSequence)mktTaskId) && !"null".equals(mktTaskId)) {
            this.activityService.executeTaskCallBack(request, sysCompanyId, sysBrandId, childMemberCode, Long.valueOf(mktTaskId));
        }
        this.insertTraceRecord(wxMbrRegisteRequestVo, menberBoRes);
        VGRequestHeaderVo requestHeader = this.optionUtils.getRequestHeader(memberCode);
        VGContentVo vgContentVo = new VGContentVo();
        vgContentVo.setMemberCode(((UnifiedRegisterMemberVo)unifiedRegisterMemberVoResponseData.getData()).getMemberCode());
        vgContentVo.setPage(requestHeader.getPage());
        vgContentVo.setSourceid(requestHeader.getSourceid());
        this.contentServiceRpc.joinClub(vgContentVo);
        return this.getMbrInfoByWx(bizvaneSessionId, menberBoRes, childMemberCode);
    }

    @Async
    public ResponseData autoJoinClub(VGRequestHeaderVo requestHeader, VGMbrRegisterRequestVo wxMbrRegisteRequestVo) {
        log.info("autoJoinClub#wxMbrRegisteRequestVo:{}", (Object)JSON.toJSONString((Object)wxMbrRegisteRequestVo));
        String autoJoinClubUUID = wxMbrRegisteRequestVo.getAutoJoinClubUUID();
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = wxMbrRegisteRequestVo.getBizvaneSessionId();
        log.info("header\u4e2d\u65e0\u6cd5\u83b7\u53d6bizvaneSessionId,\u4ecebody\u4e2d\u518d\u83b7\u53d6\u4e00\u6b21:{}", (Object)bizvaneSessionId);
        if (bizvaneSessionId == null) {
            log.info("bizvaneSessionId\u53c2\u6570\u4e0d\u5b58\u5728,\u7ed3\u675f\u81ea\u52a8\u5165\u4f1a,uuid:{}", (Object)autoJoinClubUUID);
            return responseData;
        }
        String traceId = wxMbrRegisteRequestVo.getTraceId();
        if (StringUtils.isEmpty((CharSequence)traceId)) {
            log.info("traceId\u53c2\u6570\u4e0d\u5b58\u5728,\u7ed3\u675f\u81ea\u52a8\u5165\u4f1a");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        this.redisTemplateService.deleteFromRedis((Object)(memberCode + "_allCardByGroupMemberCode"));
        if (memberCode == null) {
            log.info("\u96c6\u56e2\u4f1a\u5458\u4e0d\u5b58\u5728,\u7ed3\u675f\u81ea\u52a8\u5165\u4f1a,uuid:{}", (Object)autoJoinClubUUID);
            return responseData;
        }
        ResponseData tracePOResponseData = this.coreTraceFeign.selectByTraceId(Long.valueOf(traceId));
        log.info("selectByTraceId\u65b9\u6cd5\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)tracePOResponseData));
        TracePO tracePOResponseDataData = (TracePO)tracePOResponseData.getData();
        if (tracePOResponseDataData == null) {
            log.info("selectByTraceId\u67e5\u8be2\u4e0d\u5b58\u5728,\u7ed3\u675f\u81ea\u52a8\u5165\u4f1a,uuid:{}", (Object)autoJoinClubUUID);
            return responseData;
        }
        MemberInfoModel masterMemberInfoModelSearch = new MemberInfoModel();
        masterMemberInfoModelSearch.setMemberCode(memberCode);
        ResponseData masteSingleMemberModel = this.memberInfoApiService.getSingleMemberModel(masterMemberInfoModelSearch);
        MemberInfoModel masterMemberModelData = (MemberInfoModel)masteSingleMemberModel.getData();
        if (masterMemberModelData == null) {
            log.info("\u5c0f\u7a0b\u5e8fmemberCode:{}\u4f1a\u5458\u4e0d\u5b58\u5728!,\u7ed3\u675f\u81ea\u52a8\u5165\u4f1a,uuid:{}", (Object)memberCode, (Object)autoJoinClubUUID);
            return responseData;
        }
        Long clubSysCompanyId = tracePOResponseDataData.getSysCompanyId();
        if (masterMemberModelData.getSysCompanyId().compareTo(clubSysCompanyId) != 0) {
            log.info("\u5c0f\u7a0b\u5e8fmemberCode:{}\u4f1a\u5458\u548ctraceId:{}\u4f01\u4e1a\u4e0d\u4e00\u81f4!,\u7ed3\u675f\u81ea\u52a8\u5165\u4f1a,uuid:{}", new Object[]{memberCode, traceId, autoJoinClubUUID});
            return responseData;
        }
        Long clubBrandId = tracePOResponseDataData.getBrandId();
        if (masterMemberModelData.getBrandId().compareTo(clubBrandId) == 0) {
            log.info("\u5c0f\u7a0b\u5e8fmemberCode:{}\u4f1a\u5458\u548ctraceId:{}\u54c1\u724c\u4e00\u81f4!,\u7ed3\u675f\u81ea\u52a8\u5165\u4f1a,uuid:{}", new Object[]{memberCode, traceId, autoJoinClubUUID});
            return responseData;
        }
        if (StringUtils.isEmpty((CharSequence)masterMemberModelData.getGroupMemberCode())) {
            log.info("\u5c0f\u7a0b\u5e8fmemberCode:{}\u4f1a\u5458groupMemberCode\u4e3a\u7a7a!,\u7ed3\u675f\u81ea\u52a8\u5165\u4f1a,uuid:{}", new Object[]{memberCode, traceId, autoJoinClubUUID});
            return responseData;
        }
        MemberInfoModel clubMemberInfoModelSearch = new MemberInfoModel();
        clubMemberInfoModelSearch.setGroupMemberCode(masterMemberModelData.getGroupMemberCode());
        clubMemberInfoModelSearch.setBrandId(clubBrandId);
        ResponseData clubSingleMemberModel = this.memberInfoApiService.getSingleMemberModel(clubMemberInfoModelSearch);
        MemberInfoModel clubMemberModelData = (MemberInfoModel)clubSingleMemberModel.getData();
        if (clubMemberModelData == null) {
            log.info("\u4f1a\u5458\u672a\u5165\u4f1a,\u8fdb\u884c\u81ea\u52a8\u5165\u4f1a,uuid:{}", (Object)autoJoinClubUUID);
        }
        UnifiedRegisterVo unifiedRegisterVo = new UnifiedRegisterVo();
        String channelUniqueMemberCode = MD5Util.md5((String)(memberCode + clubBrandId));
        String channelCode = ChannelMemberCodeEnum.WX_MINI_MEMBER.getCode();
        this.fillTraceInfo(wxMbrRegisteRequestVo, clubBrandId, unifiedRegisterVo, traceId, masterMemberModelData);
        unifiedRegisterVo.setPhone(masterMemberModelData.getPhone());
        unifiedRegisterVo.setSysBrandId(clubBrandId);
        unifiedRegisterVo.setSysCompanyId(clubSysCompanyId);
        unifiedRegisterVo.setChannelUniqueMemberCode(channelUniqueMemberCode);
        unifiedRegisterVo.setChannelCode(channelCode);
        unifiedRegisterVo.setMasterMemberCode(memberCode);
        ResponseData unifiedRegisterMemberVoResponseData = null;
        try {
            unifiedRegisterMemberVoResponseData = this.memberChannelRegistrationFeign.unifiedRegister(unifiedRegisterVo);
        }
        catch (Exception e) {
            log.info("\u5f00\u5361\u63a5\u53e3\u8c03\u7528\u5f02\u5e38:{}", (Throwable)e);
            return responseData;
        }
        log.info("\u5f00\u5361\u63a5\u53e3\u8fd4\u56de\u7ed3\u679cautoJoinClub:{}", (Object)JSONObject.toJSONString((Object)unifiedRegisterMemberVoResponseData));
        if (unifiedRegisterMemberVoResponseData == null || unifiedRegisterMemberVoResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            log.info("\u5f00\u5361\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u7a7a,\u7ed3\u675f\u81ea\u52a8\u5165\u4f1a,uuid:{}", (Object)autoJoinClubUUID);
            return responseData;
        }
        VGContentVo vgContentVo = new VGContentVo();
        vgContentVo.setMemberCode(((UnifiedRegisterMemberVo)unifiedRegisterMemberVoResponseData.getData()).getMemberCode());
        vgContentVo.setPage(requestHeader.getPage());
        vgContentVo.setSourceid(requestHeader.getSourceid());
        log.info("VGLoginServiceImpl#autoJoinClub#vgContentVo:{}", (Object)JSON.toJSONString((Object)vgContentVo));
        this.contentServiceRpc.joinClub(vgContentVo);
        return responseData;
    }

    public MemberInfoModel simpleJoinClub(HttpServletRequest request, MemberInfoModel memberInfoModelMaster, Long clubBrandId) {
        String masterMemberCode = memberInfoModelMaster.getMemberCode();
        Long sysCompanyId = memberInfoModelMaster.getSysCompanyId();
        String phone = memberInfoModelMaster.getPhone();
        MemberInfoModel memberInfoModelSearchClub = new MemberInfoModel();
        memberInfoModelSearchClub.setGroupMemberCode(masterMemberCode);
        memberInfoModelSearchClub.setBrandId(clubBrandId);
        MemberInfoModel memberInfoModelClub = (MemberInfoModel)this.memberInfoApiService.getSingleMemberModel(memberInfoModelSearchClub).getData();
        if (memberInfoModelClub != null) {
            return memberInfoModelClub;
        }
        String traceId = this.convertTraceId(new VGMbrRegisterRequestVo(), clubBrandId, sysCompanyId, memberInfoModelMaster.getWxUnionId());
        log.info("\u5f53\u524d\u54c1\u724c\u4ff1\u4e50\u90e8\u6e20\u9053\u4e3a\u5fae\u4fe1\u6e20\u9053");
        String channelCode = ChannelMemberCodeEnum.WX_MINI_MEMBER.getCode();
        String channelUniqueMemberCode = MD5Util.md5((String)(masterMemberCode + clubBrandId));
        UnifiedRegisterVo unifiedRegisterVo = new UnifiedRegisterVo();
        this.fillTraceInfo(null, clubBrandId, unifiedRegisterVo, traceId, memberInfoModelMaster);
        unifiedRegisterVo.setPhone(phone);
        unifiedRegisterVo.setSysBrandId(clubBrandId);
        unifiedRegisterVo.setSysCompanyId(sysCompanyId);
        unifiedRegisterVo.setChannelUniqueMemberCode(channelUniqueMemberCode);
        unifiedRegisterVo.setChannelCode(channelCode);
        unifiedRegisterVo.setMasterMemberCode(masterMemberCode);
        ResponseData unifiedRegisterMemberVoResponseData = null;
        try {
            unifiedRegisterMemberVoResponseData = this.memberChannelRegistrationFeign.unifiedRegister(unifiedRegisterVo);
        }
        catch (Exception e) {
            log.info("\u5f00\u5361\u63a5\u53e3\u8c03\u7528\u5f02\u5e38:{}", (Throwable)e);
            return null;
        }
        UnifiedRegisterMemberVo unifiedRegisterMemberVo = (UnifiedRegisterMemberVo)unifiedRegisterMemberVoResponseData.getData();
        if (SysResponseEnum.SUCCESS.getCode() != unifiedRegisterMemberVoResponseData.getCode() || unifiedRegisterMemberVo == null) {
            return null;
        }
        String memberCode = unifiedRegisterMemberVo.getMemberCode();
        MemberInfoModel memberInfoModelSearch = new MemberInfoModel();
        memberInfoModelSearch.setMemberCode(memberCode);
        MemberInfoModel memberInfoModel = (MemberInfoModel)this.memberInfoApiService.getSingleMemberModel(memberInfoModelSearch).getData();
        VGRequestHeaderVo requestHeader = this.optionUtils.getRequestHeader(memberCode);
        VGContentVo vgContentVo = new VGContentVo();
        vgContentVo.setMemberCode(memberCode);
        vgContentVo.setPage(requestHeader.getPage());
        vgContentVo.setSourceid(requestHeader.getSourceid());
        this.contentServiceRpc.joinClub(vgContentVo);
        this.redisTemplateService.deleteFromRedis((Object)(masterMemberCode + "_allCardByGroupMemberCode"));
        return memberInfoModel;
    }

    private void fillTraceInfo(VGMbrRegisterRequestVo wxMbrRegisteRequestVo, Long sysBrandId, UnifiedRegisterVo unifiedRegisterVo, String traceId, MemberInfoModel masterMemberModelData) {
        block10: {
            if (StringUtils.isNotBlank((CharSequence)traceId)) {
                try {
                    ResponseData tracePOResponseData = this.coreTraceFeign.selectByTraceId(Long.valueOf(traceId));
                    int code = tracePOResponseData.getCode();
                    TracePO data = (TracePO)tracePOResponseData.getData();
                    if (SysResponseEnum.SUCCESS.getCode() != code || data == null) break block10;
                    try {
                        data = this.convertTracePo(data, sysBrandId, masterMemberModelData);
                    }
                    catch (Exception e) {
                        log.warn("\u901a\u8fc7tracePo\u83b7\u53d6\u65b0\u7684TracePo\u5931\u8d25:{}", (Throwable)e);
                    }
                    if (data.getBrandId().compareTo(sysBrandId) == 0) {
                        String traceValue = data.getTraceValue();
                        JSONObject obj = JSON.parseObject((String)traceValue);
                        String storeId = obj.getString("storeId");
                        String guideId = obj.getString("guideId");
                        String source_way = obj.getString("source_way");
                        if (StringUtils.isNotEmpty((CharSequence)storeId)) {
                            unifiedRegisterVo.setSysStoreId(Long.valueOf(storeId));
                        }
                        if (StringUtils.isNotEmpty((CharSequence)guideId)) {
                            unifiedRegisterVo.setSysGuideId(Long.valueOf(guideId));
                        }
                        if (StringUtils.isNotEmpty((CharSequence)source_way)) {
                            unifiedRegisterVo.setSourceWay(source_way);
                        }
                        unifiedRegisterVo.setTraceValue(traceValue);
                    } else {
                        log.warn("\u5f53\u524d\u4f20\u5165traceId\u5bf9\u5e94\u54c1\u724c\u548c\u4ff1\u4e50\u90e8\u4e0d\u4e00\u81f4");
                    }
                }
                catch (NumberFormatException e) {
                    log.error("\u5165\u4f1a\u65f6\u8f6c\u6362traceId\u5931\u8d25:{}", (Throwable)e);
                }
            }
        }
    }

    private String convertTraceId(VGMbrRegisterRequestVo wxMbrRegisteRequestVo, Long sysBrandId, Long sysCompanyId, String wxUnionId) {
        String traceId = null;
        if (StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getTraceId()) && !"null".equals(wxMbrRegisteRequestVo.getTraceId())) {
            traceId = wxMbrRegisteRequestVo.getTraceId();
        } else {
            TraceRecordVo traceRecordVo = new TraceRecordVo();
            traceRecordVo.setUnionId(wxUnionId);
            traceRecordVo.setSysCompanyId(sysCompanyId);
            traceRecordVo.setBrandId(sysBrandId);
            try {
                ResponseData traceRecordPOResponseData = this.coreTraceFeign.selectTraceRecord(traceRecordVo);
                log.info("selectTraceRecord\u65b9\u6cd5\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)traceRecordPOResponseData));
                if (traceRecordPOResponseData.getData() != null) {
                    traceId = ((TraceRecordPO)traceRecordPOResponseData.getData()).getTraceId().toString();
                }
            }
            catch (Exception e) {
                log.warn("coreTraceFeign.selectTraceRecord error:{}", (Throwable)e);
            }
        }
        return traceId;
    }

    private TracePO convertTracePo(TracePO data, Long sysBrandId, MemberInfoModel masterMemberModelData) {
        TraceRecordPO traceRecordPO = new TraceRecordPO();
        traceRecordPO.setBrandId(sysBrandId);
        traceRecordPO.setSysCompanyId(masterMemberModelData.getSysCompanyId());
        traceRecordPO.setUnionid(masterMemberModelData.getWxUnionId());
        traceRecordPO.setTraceId(data.getTraceId());
        traceRecordPO.setTraceValue(data.getTraceValue());
        TraceRecordPO traceIsOfficialAccountsDefault = this.vgMemberInfoRpcService.traceIsOfficialAccountsDefault(traceRecordPO);
        if (traceIsOfficialAccountsDefault == null) {
            log.info("traceIsOfficialAccountsDefault is null");
            return data;
        }
        Long traceIdNew = traceIsOfficialAccountsDefault.getTraceId();
        ResponseData tracePOResponseData = this.coreTraceFeign.selectByTraceId(traceIdNew);
        if (SysResponseEnum.SUCCESS.getCode() != tracePOResponseData.getCode() || tracePOResponseData.getData() == null) {
            log.info("traceIsOfficialAccountsDefault selectByTraceId is null");
            return data;
        }
        log.info("traceIsOfficialAccountsDefault data:{}", (Object)JSON.toJSONString((Object)tracePOResponseData.getData()));
        return (TracePO)tracePOResponseData.getData();
    }

    private ResponseData<AppletBrandMenberBo> getMbrInfoByWx(String childBizvaneSessionId, AppletBrandMenberBo menberBoRes, String clubMemberCode) {
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(clubMemberCode);
        ResponseData model = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        if (model.getData() != null) {
            String phone = ((MemberInfoModel)model.getData()).getPhone();
            this.redisTemplateService.stringSetValueAndExpireTime((Object)("Phone:" + clubMemberCode), (Object)phone, 7776000000L);
        }
        log.info("getUserInfo childMemberCode={}  childBizvaneSessionId={}", (Object)clubMemberCode, (Object)childBizvaneSessionId);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(childBizvaneSessionId + "MemberCode"), (Object)clubMemberCode, 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(clubMemberCode + "BizvaneSessionId"), (Object)childBizvaneSessionId, 7776000000L);
        log.info("memberCode\u6388\u6743\u5df2\u5f00\u5361={}", this.redisTemplateService.stringGetStringByKey((Object)(childBizvaneSessionId + "MemberCode")));
        menberBoRes.setMemberCode(clubMemberCode);
        menberBoRes.setOpenCard(true);
        menberBoRes.setBrandName(((MemberInfoModel)model.getData()).getOfflineBrandCode());
        log.info("openCard={}", (Object)JSON.toJSONString((Object)menberBoRes));
        return new ResponseData((Object)menberBoRes);
    }

    private void insertTraceRecord(VGMbrRegisterRequestVo wxMbrRegisteRequestVo, AppletBrandMenberBo menberBoRes) {
        TraceRecordVo traceRecordVo = new TraceRecordVo();
        traceRecordVo.setOpenId(menberBoRes.getOpenId());
        traceRecordVo.setSysCompanyId(menberBoRes.getSysCompanyId());
        traceRecordVo.setBrandId(menberBoRes.getSysBrandId());
        traceRecordVo.setUnionId(menberBoRes.getUnionId());
        if (StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getTraceId()) && !"null".equals(wxMbrRegisteRequestVo.getTraceId())) {
            traceRecordVo.setTraceId(Long.valueOf(wxMbrRegisteRequestVo.getTraceId()));
            this.coreTraceFeign.saveTraceRecord(traceRecordVo);
        }
        log.info("\u54c1\u724c\u4ff1\u4e50\u90e8\u4f1a\u5458\u5f00\u5361,traceRecord,\u5185\u5bb9:{},appid={}", (Object)JSONObject.toJSONString((Object)traceRecordVo), (Object)menberBoRes.getAppid());
    }
}

