/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.vg;

import com.alibaba.fastjson.JSON;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.FitmentService;
import com.bizvane.appletservice.models.bo.AppletBrandFunctionBo;
import com.bizvane.appletservice.models.po.MemberQuestionnaireTempPO;
import com.bizvane.appletservice.models.vo.AppletBrandIntroduceWrapperVO;
import com.bizvane.appletservice.models.vo.UrlParamVO;
import com.bizvane.appletserviceimpl.handler.AppletBizvaneException;
import com.bizvane.appletserviceimpl.impl.vg.VGGetAllMemberInfoServiceImpl;
import com.bizvane.appletserviceimpl.mappers.MemberQuestionnaireTempMapper;
import com.bizvane.customized.facade.utils.ResponseUtils;
import com.bizvane.members.facade.vo.vg.AllCardResponseVO;
import com.bizvane.mktcenterservice.models.requestvo.CheckMemberFinishedTaskResquestVO;
import com.bizvane.mktcenterservice.models.vo.TaskSearchVO;
import com.bizvane.mktcenterservice.rpc.TaskServiceRpc;
import com.bizvane.utils.commonutils.DateUtils;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class VGGroupHomePageServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(VGGroupHomePageServiceImpl.class);
    @Autowired
    private FitmentService fitmentService;
    @Autowired
    private TaskServiceRpc taskServiceRpc;
    @Autowired
    private VGGetAllMemberInfoServiceImpl vgGetAllMemberInfoService;
    @Autowired
    private MemberQuestionnaireTempMapper memberQuestionnaireTempMapper;
    @Value(value="${dcwj.temppopimg}")
    private String temppopimg;
    @Value(value="${dcwj.tempurl}")
    private String tempurl;
    @Value(value="${dcwj.beginTime}")
    private String beginTime;
    @Value(value="${dcwj.endTime}")
    private String endTime;

    public ResponseData getPopupForMemberCode(String memberCode) {
        List allCardByGroupMemberCode = this.vgGetAllMemberInfoService.getAllMemberCardByMemberCode(memberCode);
        Iterator iterator = allCardByGroupMemberCode.iterator();
        AllCardResponseVO groupCard = null;
        while (iterator.hasNext()) {
            AllCardResponseVO next = (AllCardResponseVO)iterator.next();
            if (!next.getMemberCode().equals(next.getGroupMemberCode())) continue;
            groupCard = next;
            iterator.remove();
            break;
        }
        if (groupCard == null) {
            throw new AppletBizvaneException("\u8be5\u4f1a\u5458\u5361\u6570\u636e\u5f02\u5e38,\u672a\u5f00\u96c6\u56e2\u5361");
        }
        if (StringUtils.isNotEmpty((CharSequence)memberCode) && this.inActivityTime().booleanValue()) {
            MemberQuestionnaireTempPO memberQuestionnaireTempPO = new MemberQuestionnaireTempPO();
            memberQuestionnaireTempPO.setCardNo(memberCode);
            List queryList = this.memberQuestionnaireTempMapper.selectTempData(memberQuestionnaireTempPO);
            if (CollectionUtils.isNotEmpty((Collection)queryList) && queryList.get(0) != null) {
                ResponseData responseData = new ResponseData();
                AppletBrandIntroduceWrapperVO appletBrandIntroduceWrapperVO = new AppletBrandIntroduceWrapperVO();
                appletBrandIntroduceWrapperVO.setImgUrl(this.temppopimg);
                appletBrandIntroduceWrapperVO.setBusinessUrl(this.tempurl);
                appletBrandIntroduceWrapperVO.setJumpType(Integer.valueOf(4));
                appletBrandIntroduceWrapperVO.setPageUrl(this.tempurl);
                appletBrandIntroduceWrapperVO.setAppClubImg(this.temppopimg);
                appletBrandIntroduceWrapperVO.setJoinClubPopupImg(this.temppopimg);
                appletBrandIntroduceWrapperVO.setPopupImgUrl(this.temppopimg);
                appletBrandIntroduceWrapperVO.setPopupJudge(Boolean.TRUE);
                ArrayList<UrlParamVO> urlParamVOS = new ArrayList<UrlParamVO>();
                UrlParamVO urlParamVO = new UrlParamVO();
                urlParamVO.setKey("q1");
                urlParamVO.setValue((Object)((MemberQuestionnaireTempPO)queryList.get(0)).getCardNo());
                urlParamVOS.add(urlParamVO);
                UrlParamVO urlParamVO2 = new UrlParamVO();
                urlParamVO2.setKey("q2");
                urlParamVO2.setValue((Object)((MemberQuestionnaireTempPO)queryList.get(0)).getType());
                urlParamVOS.add(urlParamVO2);
                appletBrandIntroduceWrapperVO.setUrlParamVOS(urlParamVOS);
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setData((Object)appletBrandIntroduceWrapperVO);
                return responseData;
            }
        }
        if (CollectionUtils.isEmpty((Collection)allCardByGroupMemberCode) || allCardByGroupMemberCode.size() > 1) {
            return this.fitmentService.selectBrandIntroduce(groupCard.getBrandId());
        }
        if (allCardByGroupMemberCode.size() == 1) {
            return this.fitmentService.selectBrandIntroduce(((AllCardResponseVO)allCardByGroupMemberCode.get(0)).getBrandId());
        }
        return ResponseUtils.getFailedData((String)"\u83b7\u53d6\u5f39\u7a97\u5931\u8d25");
    }

    private Boolean inActivityTime() {
        String now = DateUtils.getStringNoDate((Date)new Date());
        return StringUtils.isNotEmpty((CharSequence)this.beginTime) && StringUtils.isNotEmpty((CharSequence)this.endTime) && now.compareTo(this.beginTime) >= 0 && now.compareTo(this.endTime) <= 0;
    }

    public AppletBrandFunctionBo checkTaskFinished(AppletBrandFunctionBo appletBrandFunctionBo) {
        TaskSearchVO taskSearchVO = new TaskSearchVO();
        taskSearchVO.setBrandId(appletBrandFunctionBo.getBrandId());
        taskSearchVO.setTaskType(Integer.valueOf(1));
        taskSearchVO.setPageSize(Integer.valueOf(10));
        taskSearchVO.setPageNumber(Integer.valueOf(1));
        taskSearchVO.setCheckStatus(Integer.valueOf(3));
        taskSearchVO.setTaskStatus(Integer.valueOf(2));
        PageInfo data = (PageInfo)this.taskServiceRpc.getTaskByTaskType(taskSearchVO).getData();
        if (data == null) {
            appletBrandFunctionBo.setFloatingIconShownJudge(Boolean.FALSE);
            return appletBrandFunctionBo;
        }
        List list = data.getList();
        log.info("MemberCenterServiceImpl#getTemplateInfo#list:{}", (Object)JSON.toJSONString((Object)list));
        if (CollectionUtils.isEmpty((Collection)list)) {
            appletBrandFunctionBo.setFloatingIconShownJudge(Boolean.FALSE);
            return appletBrandFunctionBo;
        }
        ArrayList taskIds = new ArrayList();
        list.forEach(item -> taskIds.add(item.getMktTaskId()));
        CheckMemberFinishedTaskResquestVO checkMemberFinishedTaskResquestVO = new CheckMemberFinishedTaskResquestVO();
        checkMemberFinishedTaskResquestVO.setTaskIds(taskIds);
        checkMemberFinishedTaskResquestVO.setMemberCode(appletBrandFunctionBo.getOderMemberCode());
        Boolean judge = (Boolean)this.taskServiceRpc.checkMemberFinishedTasks(checkMemberFinishedTaskResquestVO).getData();
        appletBrandFunctionBo.setFloatingIconShownJudge(judge);
        return appletBrandFunctionBo;
    }
}

