/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.vg;

import com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.models.po.AppletVipCartPO;
import com.bizvane.appletservice.models.po.AppletVipCartPOExample;
import com.bizvane.appletservice.models.po.AppletVipPrivilegePO;
import com.bizvane.appletservice.models.po.AppletVipPrivilegePOExample;
import com.bizvane.appletservice.models.po.IntegralRechargeConfigPoExample;
import com.bizvane.appletservice.models.vo.vg.VGClubCardStatusRequestVO;
import com.bizvane.appletservice.models.vo.vg.VGClubCardStatusResponseVO;
import com.bizvane.appletservice.models.vo.vg.VGMemberClubAllPrivilegeByLevelResponseVO;
import com.bizvane.appletserviceimpl.handler.AppletBizvaneException;
import com.bizvane.appletserviceimpl.impl.vg.VGGetAllMemberInfoServiceImpl;
import com.bizvane.appletserviceimpl.impl.vg.VGInitServiceImpl;
import com.bizvane.appletserviceimpl.mappers.AppletVipCartPOMapper;
import com.bizvane.appletserviceimpl.mappers.AppletVipPrivilegePOMapper;
import com.bizvane.appletserviceimpl.mappers.IntegralRechargeConfigPoMapper;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.customized.facade.utils.ResponseUtils;
import com.bizvane.fitmentservice.models.Rpc.FitMentServiceRpc;
import com.bizvane.fitmentservice.models.po.AppletBrandIntroducePO;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MemberLevelApiService;
import com.bizvane.members.facade.vo.MemberInfoApiModel;
import com.bizvane.members.facade.vo.vg.AllCardResponseVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.wmeimob.fastboot.bizvane.entity.IntegralRechargeConfig;
import com.wmeimob.fastboot.bizvane.service.rpc.vg.IntegralRechargeRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VGClubPageServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(VGClubPageServiceImpl.class);
    @Autowired
    private VGGetAllMemberInfoServiceImpl vgGetAllMemberInfoService;
    @Resource
    private AppletVipCartPOMapper appletVipCartPOMapper;
    @Resource
    private AppletVipPrivilegePOMapper appletVipPrivilegePOMapper;
    @Autowired
    private FitMentServiceRpc fitMentServiceRpc;
    @Autowired
    private VGInitServiceImpl vgInitService;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private MemberLevelApiService memberLevelApiService;
    @Autowired
    private IntegralRechargeRpcService integralRechargeRpcService;
    @Resource
    private IntegralRechargeConfigPoMapper integralRechargeConfigPoMapper;
    private String TWBrandCode = "TW-CLUB";
    @Autowired
    private MemberInfoApiService memberInfoApiService;

    public ResponseData<List<VGClubCardStatusResponseVO>> getMemberClubCardStatus(VGClubCardStatusRequestVO vo) {
        ResponseData responseData = new ResponseData();
        List brandListByCompanyId = this.vgGetAllMemberInfoService.getBrandListByCompanyId(vo.getSysCompanyId());
        List allMemberCardByMemberCode = this.vgGetAllMemberInfoService.getAllMemberCardByMemberCode(vo.getMemberCode());
        ArrayList<VGClubCardStatusResponseVO> resultList = new ArrayList<VGClubCardStatusResponseVO>();
        Iterator brandListIterator = brandListByCompanyId.iterator();
        AllCardResponseVO mainGroup = null;
        AppletBrandIntroducePO brandIntroducePO = null;
        while (brandListIterator.hasNext()) {
            SysBrandPo brandPo = (SysBrandPo)brandListIterator.next();
            Iterator allCardResponseVOIterator = allMemberCardByMemberCode.iterator();
            Boolean finish = Boolean.FALSE;
            while (allCardResponseVOIterator.hasNext()) {
                AllCardResponseVO card = (AllCardResponseVO)allCardResponseVOIterator.next();
                if (card.getMemberCode().equals(card.getGroupMemberCode())) {
                    mainGroup = card;
                    allCardResponseVOIterator.remove();
                    continue;
                }
                if (!card.getBrandId().equals(brandPo.getSysBrandId())) continue;
                brandIntroducePO = (AppletBrandIntroducePO)this.fitMentServiceRpc.selectBrandIntroduce(brandPo.getSysBrandId()).getData();
                if (brandIntroducePO == null) {
                    brandIntroducePO = new AppletBrandIntroducePO();
                }
                VGClubCardStatusResponseVO successVo = VGClubCardStatusResponseVO.builder().clubName(brandPo.getBrandName() + "\u4ff1\u4e50\u90e8").childMemberCode(card.getMemberCode()).memberCode(card.getGroupMemberCode()).openCardJudge(Boolean.TRUE).sysBrandId(card.getBrandId()).sysCompanyId(card.getSysCompanyId()).appClubImg(brandIntroducePO.getAppClubImg()).joinClubPopUpImg(brandIntroducePO.getJoinClubPopupImg()).build();
                resultList.add(successVo);
                finish = Boolean.TRUE;
                allCardResponseVOIterator.remove();
                break;
            }
            if (mainGroup == null) {
                throw new AppletBizvaneException("\u96c6\u56e2\u5361\u4fe1\u606f\u672a\u627e\u5230");
            }
            if (brandPo.getSysBrandId().equals(mainGroup.getBrandId()) || finish.booleanValue()) continue;
            brandIntroducePO = (AppletBrandIntroducePO)this.fitMentServiceRpc.selectBrandIntroduce(brandPo.getSysBrandId()).getData();
            if (brandIntroducePO == null) {
                brandIntroducePO = new AppletBrandIntroducePO();
            }
            VGClubCardStatusResponseVO successVo = VGClubCardStatusResponseVO.builder().clubName(brandPo.getBrandName() + "\u4ff1\u4e50\u90e8").openCardJudge(Boolean.FALSE).sysBrandId(brandPo.getSysBrandId()).sysCompanyId(brandPo.getSysCompanyId()).appClubImg(brandIntroducePO.getAppClubImg()).joinClubPopUpImg(brandIntroducePO.getJoinClubPopupImg()).build();
            resultList.add(successVo);
        }
        if (CollectionUtils.isNotEmpty((Collection)brandListByCompanyId)) {
            this.vgInitService.initChildBrandBizvaneSessionId(mainGroup.getSysCompanyId(), mainGroup.getBrandId(), vo.getBizvaneSessionId());
        }
        log.info("VGClubPageServiceImpl#getMemberClubCardStatus#resultList :{}", (Object)JSON.toJSONString(resultList));
        responseData.setData(resultList);
        return responseData;
    }

    public ResponseData<List<AppletVipPrivilegePO>> getMemberClubVipPrivilege(Long sysBrandId, Long levelId, Integer num) {
        ResponseData responseData = new ResponseData();
        AppletVipCartPOExample appletVipCartPOExample = new AppletVipCartPOExample();
        AppletVipCartPOExample.Criteria appletVipCartPOCriteria = appletVipCartPOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andValidEqualTo(Boolean.valueOf(true));
        if (levelId != null) {
            appletVipCartPOCriteria.andGradeIdEqualTo(levelId);
        }
        List appletVipCartPOList = this.appletVipCartPOMapper.selectByExample(appletVipCartPOExample);
        ArrayList<AppletVipPrivilegePO> appletVipPrivilegePOList = new ArrayList<AppletVipPrivilegePO>();
        for (AppletVipCartPO cartPO : appletVipCartPOList) {
            AppletVipPrivilegePOExample example = new AppletVipPrivilegePOExample();
            example.setOrderByClause("sort asc");
            example.createCriteria().andAppletVipCardIdEqualTo(cartPO.getAppletVipCardId()).andValidEqualTo(Boolean.valueOf(true));
            List appletVipPrivilegePOS = this.appletVipPrivilegePOMapper.selectByExample(example);
            for (AppletVipPrivilegePO appletVipPrivilegePO : appletVipPrivilegePOS) {
                appletVipPrivilegePO.setPrivilegeLogo(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)appletVipPrivilegePO.getPrivilegeLogo()));
                appletVipPrivilegePOList.add(appletVipPrivilegePO);
                if (num == null || appletVipPrivilegePOList.size() != num.intValue()) continue;
                break;
            }
            if (num == null || appletVipPrivilegePOList.size() != num.intValue()) continue;
            break;
        }
        responseData.setData(appletVipPrivilegePOList);
        return responseData;
    }

    public ResponseData getMemberClubAllPrivilegeByLevel(Long sysBrandId, Long levelId) {
        ResponseData responseData = new ResponseData();
        List mbrLevelModels = this.memberLevelApiService.queryLevelList(sysBrandId);
        log.info("VGClubPageServiceImpl#getMemberClubAllPrivilegeByLevel#mbrLevelModels:{}", (Object)JSON.toJSONString((Object)mbrLevelModels));
        if (CollectionUtils.isEmpty((Collection)mbrLevelModels)) {
            throw new AppletBizvaneException("\u8be5\u4f01\u4e1a\u6ca1\u6709\u914d\u7f6e\u53ef\u5347\u7ea7\u4f1a\u5458\u7b49\u7ea7");
        }
        AtomicReference<MbrLevelModel> currentLevelModel = new AtomicReference<MbrLevelModel>(new MbrLevelModel());
        mbrLevelModels.forEach(item -> {
            if (item.getMbrLevelId().equals(levelId)) {
                currentLevelModel.set((MbrLevelModel)item);
            }
        });
        LinkedList<Long> downAndNowLevelList = new LinkedList<Long>();
        LinkedList<Long> upLevelList = new LinkedList<Long>();
        for (MbrLevelModel mbrLevelModel : mbrLevelModels) {
            if (mbrLevelModel.getLevelValue() >= currentLevelModel.get().getLevelValue()) {
                downAndNowLevelList.add(mbrLevelModel.getMbrLevelId());
                continue;
            }
            upLevelList.add(mbrLevelModel.getMbrLevelId());
        }
        if (CollectionUtils.isEmpty(downAndNowLevelList)) {
            throw new AppletBizvaneException("\u4f20\u5165\u7b49\u7ea7id\u4e0d\u5728\u8be5\u4f01\u4e1a\u4e2d");
        }
        List downAndNowLevelPrivileges = this.getMemberClubAllPrivilegeByLevels(downAndNowLevelList, null);
        LinkedList downAndNowLevelIds = new LinkedList();
        if (CollectionUtils.isNotEmpty((Collection)downAndNowLevelPrivileges)) {
            downAndNowLevelPrivileges.forEach(item -> downAndNowLevelIds.add(item.getAppletVipPrivilegeId()));
        }
        VGMemberClubAllPrivilegeByLevelResponseVO responseVO = new VGMemberClubAllPrivilegeByLevelResponseVO();
        responseVO.setDownAndNowLevelPrivileges(downAndNowLevelPrivileges);
        List upLevelPrivileges = new ArrayList();
        if (CollectionUtils.isNotEmpty(upLevelList)) {
            upLevelPrivileges = this.getMemberClubAllPrivilegeByLevels(upLevelList, downAndNowLevelIds);
        }
        responseVO.setUpLevelPrivileges(upLevelPrivileges);
        responseData.setData((Object)responseVO);
        return responseData;
    }

    private List<AppletVipPrivilegePO> getMemberClubAllPrivilegeByLevels(List<Long> levels, List<Long> privilegeIds) {
        log.info("VGClubPageServiceImpl#getMemberClubAllPrivilegeByLevels#levels:{}", (Object)JSON.toJSONString(levels));
        AppletVipCartPOExample appletVipCartPOExample = new AppletVipCartPOExample();
        appletVipCartPOExample.createCriteria().andGradeIdIn(levels).andValidEqualTo(Boolean.valueOf(true));
        List appletVipCartPOS = this.appletVipCartPOMapper.selectByExample(appletVipCartPOExample);
        log.info("VGClubPageServiceImpl#getMemberClubAllPrivilegeByLevels#appletVipCartPOS:{}", (Object)JSON.toJSONString((Object)appletVipCartPOS));
        LinkedList appletVipCartIds = new LinkedList();
        appletVipCartPOS.forEach(item -> appletVipCartIds.add(item.getAppletVipCardId()));
        log.info("VGClubPageServiceImpl#getMemberClubAllPrivilegeByLevels#appletVipCartIds:{}", (Object)JSON.toJSONString(appletVipCartIds));
        AppletVipPrivilegePOExample privilegePOExample = new AppletVipPrivilegePOExample();
        AppletVipPrivilegePOExample.Criteria criteria = privilegePOExample.createCriteria().andAppletVipCardIdIn(appletVipCartIds).andValidEqualTo(Boolean.valueOf(true));
        if (CollectionUtils.isNotEmpty(privilegeIds)) {
            criteria.andAppletVipPrivilegeIdNotIn(privilegeIds);
        }
        List appletVipPrivilegePOS = this.appletVipPrivilegePOMapper.selectByExample(privilegePOExample);
        appletVipPrivilegePOS.forEach(item -> item.setPrivilegeLogo(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)item.getPrivilegeLogo())));
        return appletVipPrivilegePOS;
    }

    public ResponseData getLevelRatio(Long sysBrandId, String memberCode) {
        IntegralRechargeConfigPoExample integralRechargeConfigPoExample = new IntegralRechargeConfigPoExample();
        integralRechargeConfigPoExample.createCriteria().andValidEqualTo(Boolean.TRUE).andSysBrandIdEqualTo(sysBrandId);
        IntegralRechargeConfig integralRechargeConfig = this.integralRechargeRpcService.getIntegralRechargeByBrandId(sysBrandId);
        if (null == integralRechargeConfig) {
            return ResponseUtils.getFailedData((String)"\u6b64\u54c1\u724c\u672a\u914d\u7f6e\u5145\u503c\u6bd4\u4f8b");
        }
        MemberInfoApiModel memberInfoApiModel = new MemberInfoApiModel();
        memberInfoApiModel.setBrandId(sysBrandId);
        memberInfoApiModel.setGroupMemberCode(memberCode);
        ResponseData memberInfoModelResponseData = this.memberInfoApiService.getMemberModel((MemberInfoModel)memberInfoApiModel);
        if (memberInfoModelResponseData.getCode() != 0 || memberInfoModelResponseData.getData() == null) {
            return ResponseUtils.getFailedData((String)"\u4ff1\u4e50\u90e8\u672a\u5165\u4f1a");
        }
        MemberInfoModel memberInfoModel = (MemberInfoModel)memberInfoModelResponseData.getData();
        Long levelId = memberInfoModel.getLevelId();
        ResponseData mbrLevelModelResponseData = this.memberLevelApiService.queryLevelModel(levelId);
        ((MbrLevelModel)mbrLevelModelResponseData.getData()).setRatioMoney(integralRechargeConfig.getRatioMoney());
        ((MbrLevelModel)mbrLevelModelResponseData.getData()).setRatioIntegral(integralRechargeConfig.getRatioIntegral());
        return mbrLevelModelResponseData;
    }
}

