/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.vg;

import com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.interfaces.MemberPrivilegeService;
import com.bizvane.appletservice.models.po.AppletVipCartPO;
import com.bizvane.appletservice.models.po.AppletVipCartPOExample;
import com.bizvane.appletservice.models.po.AppletVipPrivilegePO;
import com.bizvane.appletservice.rpc.vg.MemberShipCardServiceRpc;
import com.bizvane.appletserviceimpl.mappers.AppletVipCartPOMapper;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"memberShipCardServiceRpc"})
public class MemberShipCardServiceRpcImpl
implements MemberShipCardServiceRpc {
    private static final Logger log = LoggerFactory.getLogger(MemberShipCardServiceRpcImpl.class);
    @Resource
    private AppletVipCartPOMapper appletVipCartPoMapper;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private MemberPrivilegeService memberPrivilegeService;

    @PostMapping(value={"getMemberShipCardMapByLevelIdList"})
    public Map<Long, AppletVipCartPO> getMemberShipCardByLevelId(@RequestBody List<Long> levelIdList) {
        log.info("MemberShipCardServiceRpcImpl#getMemberShipCardByLevelId#levelIdList:{}", (Object)JSON.toJSONString(levelIdList));
        HashMap<Long, AppletVipCartPO> resultMap = new HashMap<Long, AppletVipCartPO>();
        if (CollectionUtils.isEmpty(levelIdList)) {
            return resultMap;
        }
        AppletVipCartPOExample appletVipCartPOExample = new AppletVipCartPOExample();
        appletVipCartPOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andGradeIdIn(levelIdList);
        List appletVipCartPO = this.appletVipCartPoMapper.selectByExample(appletVipCartPOExample);
        appletVipCartPO.forEach(item -> resultMap.put(item.getGradeId(), (AppletVipCartPO)item));
        return resultMap;
    }

    @PostMapping(value={"getVipPrivilegeListByCardIdList"})
    public Map<Long, List<AppletVipPrivilegePO>> getVipPrivilegeListByCardIdList(@RequestBody List<Long> cardIdList) {
        log.info("MemberShipCardServiceRpcImpl#getVipPrivilegeListByCardIdList#cardIdList:{}", (Object)JSON.toJSONString(cardIdList));
        HashMap<Long, List<AppletVipPrivilegePO>> resultMap = new HashMap<Long, List<AppletVipPrivilegePO>>();
        if (CollectionUtils.isEmpty(cardIdList)) {
            return resultMap;
        }
        Iterator<Long> iterator = cardIdList.iterator();
        while (iterator.hasNext()) {
            Long cardId = iterator.next();
            String vipPrivilegeListStr = (String)this.redisTemplateService.stringGetStringByKey((Object)("AppletMemberPrivilege_CardId_" + cardId));
            if (!StringUtils.isNotEmpty((CharSequence)vipPrivilegeListStr)) continue;
            List vipPrivilegeList = JSON.parseArray((String)vipPrivilegeListStr, AppletVipPrivilegePO.class);
            resultMap.put(cardId, vipPrivilegeList);
            iterator.remove();
        }
        log.info("MemberShipCardServiceRpcImpl#getVipPrivilegeListByCardIdList#cardIdListNew:{}", (Object)JSON.toJSONString(cardIdList));
        if (CollectionUtils.isEmpty(cardIdList)) {
            return resultMap;
        }
        ResponseData memberPrivilegeByGrderIdList = this.memberPrivilegeService.getMemberPrivilegeByGrderIdList(cardIdList);
        if (CollectionUtils.isEmpty((Collection)((Collection)memberPrivilegeByGrderIdList.getData()))) {
            return resultMap;
        }
        HashMap<Long, List> temporaryMap = new HashMap<Long, List>();
        List data = (List)memberPrivilegeByGrderIdList.getData();
        for (AppletVipPrivilegePO privilege : data) {
            if (temporaryMap.containsKey(privilege.getAppletVipCardId())) {
                List appletVipPrivilegePOS = (List)temporaryMap.get(privilege.getAppletVipCardId());
                appletVipPrivilegePOS.add(privilege);
                temporaryMap.replace(privilege.getAppletVipCardId(), appletVipPrivilegePOS);
                continue;
            }
            ArrayList<AppletVipPrivilegePO> list = new ArrayList<AppletVipPrivilegePO>();
            list.add(privilege);
            temporaryMap.put(privilege.getAppletVipCardId(), list);
        }
        for (Long cardId : temporaryMap.keySet()) {
            this.redisTemplateService.stringSetValueAndExpireTime((Object)("AppletMemberPrivilege_CardId_" + cardId), (Object)JSON.toJSONString(temporaryMap.get(cardId)), 7776000000L);
        }
        resultMap.putAll(temporaryMap);
        return resultMap;
    }

    @GetMapping(value={"clearVipPrivilegeListRedis"})
    public void clearVipPrivilegeListRedis(@RequestParam Long cardId) {
        this.redisTemplateService.deleteFromRedis((Object)("AppletMemberPrivilege_CardId_" + cardId));
    }
}

