/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.alipay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.alipayfacade.interfaces.AlipayChannelMembersFeign;
import com.bizvane.alipayfacade.interfaces.AlipayCoreTraceFeign;
import com.bizvane.alipayfacade.interfaces.AlipayPublicServiceFeign;
import com.bizvane.alipayfacade.interfaces.AlipayUserAuthorizationFeign;
import com.bizvane.alipayfacade.models.enums.AlipayPublicTypeEnum;
import com.bizvane.alipayfacade.models.vo.AlipayChannelInfoVo;
import com.bizvane.alipayfacade.models.vo.AlipayCodeResolveVo;
import com.bizvane.alipayfacade.models.vo.AlipayTraceRecordVo;
import com.bizvane.alipayfacade.models.vo.UserAuthorizationGetPhoneNumberRequestVO;
import com.bizvane.alipayfacade.models.vo.UserAuthorizationGetPhoneNumberResponseVO;
import com.bizvane.appletservice.interfaces.ActivityService;
import com.bizvane.appletservice.interfaces.alipay.AlipayLoginService;
import com.bizvane.appletservice.models.bo.AppletBrandMenberBo;
import com.bizvane.appletservice.models.bo.AppletByCodeBo;
import com.bizvane.appletservice.models.vo.AlipayMbrRegisterRequestVo;
import com.bizvane.appletserviceimpl.common.ChannelMemberCodeEnum;
import com.bizvane.appletserviceimpl.enums.OpenCardSourceEnum;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.vo.SysBrandVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MiniProgramOpenCardService;
import com.bizvane.members.facade.service.api.WxChannelInfoApiService;
import com.bizvane.mktcenterservice.models.bo.MktActivityDetailAndPicture;
import com.bizvane.mktcenterservice.models.vo.ProbabilityVO;
import com.bizvane.mktcenterservice.rpc.ActivityEGServiceRpc;
import com.bizvane.unifiedreg.model.vo.UnifiedRegisterMemberVo;
import com.bizvane.unifiedreg.model.vo.UnifiedRegisterVo;
import com.bizvane.unifiedreg.rpc.MemberChannelRegistrationFeign;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateService;
import com.bizvane.utils.responseinfo.ResponseData;
import feign.FeignException;
import io.jsonwebtoken.lang.Assert;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlipayLoginServiceImpl
implements AlipayLoginService {
    private static final Logger log = LoggerFactory.getLogger(AlipayLoginServiceImpl.class);
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private WxChannelInfoApiService wxChannelInfoApiService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private MiniProgramOpenCardService miniProgramOpenCardService;
    @Autowired
    private ActivityEGServiceRpc activityEGServiceRpc;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private RedisTemplateService<String, String> redisTemplateService;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private AlipayUserAuthorizationFeign alipayUserAuthorizationFeign;
    @Autowired
    private AlipayChannelMembersFeign alipayChannelMembersFeign;
    @Autowired
    private AlipayPublicServiceFeign alipayPublicServiceFeign;
    @Autowired
    private AlipayCoreTraceFeign coreTraceFeign;
    @Autowired
    private MemberChannelRegistrationFeign memberChannelRegistrationFeign;
    private static final String MEMEBER_ACTIVITY = "api/marketActivity/newMemberByActivity";

    public ResponseData<AppletBrandMenberBo> getUserInfobyCode(String code, String appid) {
        log.info("AlipayLoginServiceImpl#getUserInfobyCode\u63a5\u53e3\u5165\u53c2,code={} , appid={}", (Object)code, (Object)appid);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)code), (String)"code\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)appid), (String)"appid\u4e3a\u7a7a");
        AppletByCodeBo appletByCodeBo = new AppletByCodeBo();
        AlipayCodeResolveVo wxCodeResolveVo = this.getAlipayCodeResolveVo(code, appid);
        String bizvaneSessionId = wxCodeResolveVo.getBizvaneSessionId();
        log.info("AlipayLoginServiceImpl#getUserInfobyCode#bizvaneSessionId\u5b58\u50a8\u5230Redis,bizvaneSessionId={}", (Object)bizvaneSessionId);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)bizvaneSessionId, (Object)bizvaneSessionId, 7776000000L);
        appletByCodeBo.setBizvanekey(bizvaneSessionId);
        appletByCodeBo.setQiniuUrl(this.qiNiuConfig.getDomain());
        SysBrandPo sysBrandPo = this.getBrandInfo(wxCodeResolveVo.getSysBrandId());
        if (StringUtils.isNotBlank((CharSequence)sysBrandPo.getBrandLogo())) {
            appletByCodeBo.setBrandLogo(this.qiNiuConfig.getDomain() + sysBrandPo.getBrandLogo());
        }
        log.info("\u7f13\u5b58\u6240\u9700\u652f\u4ed8\u5b9d\u5173\u952e\u4fe1\u606f\u5230Redis,userId={},appid={},sysBrandId={}", new Object[]{wxCodeResolveVo.getUserId(), appid, sysBrandPo.getSysBrandId()});
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("getUserId" + bizvaneSessionId), (Object)wxCodeResolveVo.getUserId(), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("getAppId" + bizvaneSessionId), (Object)appid, 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("sysBrandId" + bizvaneSessionId), (Object)String.valueOf(sysBrandPo.getSysBrandId()), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(bizvaneSessionId + "sysBrandId"), (Object)String.valueOf(sysBrandPo.getSysBrandId()), 7776000000L);
        AppletBrandMenberBo appletBrandMenberBo = this.getMbrOpenCardFlag(wxCodeResolveVo, sysBrandPo.getSysBrandId(), appid);
        appletBrandMenberBo.setAppletByCodeBo(appletByCodeBo);
        appletBrandMenberBo.setSysCompanyId(sysBrandPo.getSysCompanyId());
        appletBrandMenberBo.setSysBrandId(sysBrandPo.getSysBrandId());
        appletBrandMenberBo.setUserId(wxCodeResolveVo.getUserId());
        log.info("AlipayLoginServiceImpl#getUserInfobyCode#appletBrandMenberBo:{}", (Object)JSONObject.toJSONString((Object)appletBrandMenberBo));
        return new ResponseData((Object)appletBrandMenberBo);
    }

    public ResponseData<AppletBrandMenberBo> getMbrAndOpenCard(HttpServletRequest request, AlipayMbrRegisterRequestVo wxMbrRegisteRequestVo) {
        log.info("AlipayLoginServiceImpl#getMbrAndOpenCard#wxMbrRegisteRequestVo:{}", (Object)JSONObject.toJSONString((Object)wxMbrRegisteRequestVo));
        this.checkMbrRegisterRequestVoParam(wxMbrRegisteRequestVo);
        AlipayCodeResolveVo alipayCodeResolveVo = this.getAlipayCodeResolveVo(wxMbrRegisteRequestVo.getCode(), wxMbrRegisteRequestVo.getAppid());
        log.info("AlipayLoginServiceImpl#getMbrAndOpenCard#alipayCodeResolveVo={}", (Object)JSON.toJSONString((Object)alipayCodeResolveVo));
        String bizvaneSessionId = alipayCodeResolveVo.getBizvaneSessionId();
        log.info("AlipayLoginServiceImpl#getMbrAndOpenCard#bizvaneSessionId\u5b58\u50a8\u5230Redis,bizvaneSessionId={}", (Object)bizvaneSessionId);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)bizvaneSessionId, (Object)bizvaneSessionId, 7776000000L);
        UserAuthorizationGetPhoneNumberRequestVO userAuthorizationGetPhoneNumberRequestVO = new UserAuthorizationGetPhoneNumberRequestVO();
        userAuthorizationGetPhoneNumberRequestVO.setAppid(wxMbrRegisteRequestVo.getAppid());
        userAuthorizationGetPhoneNumberRequestVO.setPhoneNumberData(wxMbrRegisteRequestVo.getPhone());
        userAuthorizationGetPhoneNumberRequestVO.setBizvaneSessionId(bizvaneSessionId);
        ResponseData phoneNumber = this.alipayUserAuthorizationFeign.getPhoneNumber(userAuthorizationGetPhoneNumberRequestVO);
        log.info("AlipayLoginServiceImpl#getMbrAndOpenCard#\u89e3\u6790\u624b\u673a\u53f7\u8fd4\u56de\u7684\u7ed3\u679c={}", (Object)JSON.toJSONString((Object)phoneNumber));
        if (phoneNumber.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            return new ResponseData(100, phoneNumber.getMessage());
        }
        this.cacheWxInfoToRedis(wxMbrRegisteRequestVo, bizvaneSessionId, alipayCodeResolveVo);
        AppletByCodeBo appletByCodeBo = new AppletByCodeBo();
        appletByCodeBo.setBizvanekey(bizvaneSessionId);
        appletByCodeBo.setQiniuUrl(this.qiNiuConfig.getDomain());
        SysBrandPo sysBrandPo = this.getBrandInfo(alipayCodeResolveVo.getSysBrandId());
        log.info("AlipayLoginServiceImpl#getMbrAndOpenCard#sysBrandPo:{}", (Object)JSON.toJSONString((Object)sysBrandPo));
        if (StringUtils.isNotBlank((CharSequence)sysBrandPo.getBrandLogo())) {
            appletByCodeBo.setBrandLogo(this.qiNiuConfig.getDomain() + sysBrandPo.getBrandLogo());
        }
        AppletBrandMenberBo menberBoRes = new AppletBrandMenberBo();
        menberBoRes.setAppletByCodeBo(appletByCodeBo);
        menberBoRes.setUserId(alipayCodeResolveVo.getUserId());
        menberBoRes.setSysBrandId(sysBrandPo.getSysBrandId());
        menberBoRes.setSysCompanyId(sysBrandPo.getSysCompanyId());
        menberBoRes.setPhone(((UserAuthorizationGetPhoneNumberResponseVO)phoneNumber.getData()).getPhoneNumber());
        menberBoRes.setAppid(wxMbrRegisteRequestVo.getAppid());
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(bizvaneSessionId + "alipayAppletBrandMenberBo"), (Object)JSON.toJSONString((Object)menberBoRes), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(bizvaneSessionId + "source"), (Object)OpenCardSourceEnum.ALIPAY.getCode(), 7776000000L);
        AppletBrandMenberBo appletBrandMenberBo = this.getMbrOpenCardFlag(alipayCodeResolveVo, sysBrandPo.getSysBrandId(), wxMbrRegisteRequestVo.getAppid());
        log.info("AlipayLoginServiceImpl#getMbrAndOpenCard#appletBrandMenberBo:{}", (Object)JSON.toJSONString((Object)appletBrandMenberBo));
        if (StringUtils.isNotBlank((CharSequence)appletBrandMenberBo.getMemberCode())) {
            return this.getMbrInfoByWx(bizvaneSessionId, menberBoRes, appletBrandMenberBo);
        }
        this.insertTraceRecord(wxMbrRegisteRequestVo, menberBoRes);
        return this.MbrOpenCardByWx(request, wxMbrRegisteRequestVo, bizvaneSessionId, menberBoRes);
    }

    private void cacheWxInfoToRedis(AlipayMbrRegisterRequestVo wxMbrRegisteRequestVo, String bizvaneSessionId, AlipayCodeResolveVo userInfoRes) {
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("getUserId" + bizvaneSessionId), (Object)userInfoRes.getUserId(), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("getAppId" + bizvaneSessionId), (Object)wxMbrRegisteRequestVo.getAppid(), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("sysBrandId" + bizvaneSessionId), (Object)String.valueOf(userInfoRes.getSysBrandId()), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(bizvaneSessionId + "sysBrandId"), (Object)String.valueOf(userInfoRes.getSysBrandId()), 7776000000L);
        log.info("UnionId={}", this.redisTemplateService.stringGetStringByKey((Object)("getUnionId" + bizvaneSessionId)));
    }

    private void checkMbrRegisterRequestVoParam(AlipayMbrRegisterRequestVo wxMbrRegisteRequestVo) {
        Assert.isTrue((wxMbrRegisteRequestVo != null ? 1 : 0) != 0, (String)"\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getAppid()), (String)"\u8bf7\u6c42\u53c2\u6570appid\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getCode()), (String)"\u8bf7\u6c42\u53c2\u6570code\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getPhone()), (String)"\u8bf7\u6c42\u53c2\u6570\u624b\u673a\u4fe1\u606f\u4f20\u5165\u4e3a\u7a7a");
    }

    private void insertTraceRecord(AlipayMbrRegisterRequestVo wxMbrRegisteRequestVo, AppletBrandMenberBo menberBoRes) {
        AlipayTraceRecordVo traceRecordVo = new AlipayTraceRecordVo();
        traceRecordVo.setUserId(menberBoRes.getUserId());
        traceRecordVo.setSysCompanyId(menberBoRes.getSysCompanyId());
        if (StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getTraceId()) && !"null".equals(wxMbrRegisteRequestVo.getTraceId())) {
            traceRecordVo.setTraceId(Long.valueOf(wxMbrRegisteRequestVo.getTraceId()));
            this.coreTraceFeign.saveTraceRecord(traceRecordVo);
        }
        log.info("\u4f1a\u5458\u5f00\u5361,traceRecord,\u5185\u5bb9:{},appid={}", (Object)JSONObject.toJSONString((Object)traceRecordVo), (Object)wxMbrRegisteRequestVo.getAppid());
    }

    private ResponseData<AppletBrandMenberBo> MbrOpenCardByWx(HttpServletRequest request, AlipayMbrRegisterRequestVo wxMbrRegisteRequestVo, String bizvaneSessionId, AppletBrandMenberBo menberBoRes) {
        String mktTaskId = wxMbrRegisteRequestVo.getMktTaskId();
        UnifiedRegisterVo unifiedRegisterVo = new UnifiedRegisterVo();
        unifiedRegisterVo.setSysCompanyId(menberBoRes.getSysCompanyId());
        unifiedRegisterVo.setSysBrandId(menberBoRes.getSysBrandId());
        unifiedRegisterVo.setPhone(menberBoRes.getPhone());
        unifiedRegisterVo.setChannelUniqueMemberCode(menberBoRes.getUserId());
        unifiedRegisterVo.setChannelCode(ChannelMemberCodeEnum.ALIPAY_MINI.getCode());
        String uuid = request.getHeader("UUID");
        log.info("UUID\u5f00\u5361={}", (Object)uuid);
        String uuidJONString = null;
        if (StringUtils.isNotBlank((CharSequence)uuid)) {
            uuidJONString = (String)this.redisTemplateService.stringGetStringByKey((Object)uuid);
            log.info("uuidJONString={}", (Object)uuidJONString);
        }
        if (StringUtils.isNotBlank(uuidJONString)) {
            JSONObject JSONobjectUUID = JSONObject.parseObject(uuidJONString);
            String mktActivityId = JSONobjectUUID.getString("mktActivityId");
            ProbabilityVO vo = new ProbabilityVO();
            vo.setMktActivityId(Long.valueOf(mktActivityId));
            ResponseData mktActivityPOWithBLOBs = this.activityEGServiceRpc.getMktActivityPOWithBLOBs(vo);
            Integer activityType = ((MktActivityDetailAndPicture)mktActivityPOWithBLOBs.getData()).getActivityType();
            log.info("activityType={}, mktActivityId={}", (Object)activityType, (Object)mktActivityId);
            unifiedRegisterVo.setActivityId(Long.valueOf(mktActivityId));
            unifiedRegisterVo.setActivityType(activityType);
        }
        ResponseData unifiedRegisterMemberVoResponseData = null;
        try {
            log.info("AlipayLoginServiceImpl#MbrOpenCardByWx#unifiedRegisterVo:{}", (Object)JSON.toJSONString((Object)unifiedRegisterVo));
            unifiedRegisterMemberVoResponseData = this.memberChannelRegistrationFeign.unifiedRegister(unifiedRegisterVo);
            log.info("AlipayLoginServiceImpl#MbrOpenCardByWx#unifiedRegisterMemberVoResponseData:{}", (Object)JSON.toJSONString((Object)unifiedRegisterMemberVoResponseData));
        }
        catch (FeignException e1) {
            log.info("openCardMenbr:{}", (Object)e1.getMessage());
            ResponseData responseData = new ResponseData();
            String errorMsg = e1.getMessage();
            int indexOf = errorMsg.indexOf("content:");
            if (indexOf >= 0) {
                String errorResponseData = errorMsg.substring(indexOf + 9);
                responseData = (ResponseData)JacksonUtil.json2Obj((String)errorResponseData, ResponseData.class);
            } else {
                responseData.setCode(-1);
                responseData.setMessage(errorMsg);
            }
            return responseData;
        }
        log.info("\u5f00\u5361\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)unifiedRegisterMemberVoResponseData));
        if (unifiedRegisterMemberVoResponseData == null || unifiedRegisterMemberVoResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            return new ResponseData(100, "\u5fae\u4fe1\u6388\u6743\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u518d\u8bd5");
        }
        UnifiedRegisterMemberVo responseOpenCardModel = (UnifiedRegisterMemberVo)unifiedRegisterMemberVoResponseData.getData();
        AlipayChannelInfoVo alipayChannelInfoVo = new AlipayChannelInfoVo();
        JSONObject jsonObject = JSON.parseObject((String)wxMbrRegisteRequestVo.getUserInfoData());
        if ("10000".equals(jsonObject.getString("code"))) {
            alipayChannelInfoVo.setAvatar(jsonObject.getString("avatar"));
            alipayChannelInfoVo.setNickname(jsonObject.getString("nickName"));
            alipayChannelInfoVo.setGender(jsonObject.getString("gender"));
            alipayChannelInfoVo.setProvince(jsonObject.getString("province"));
            alipayChannelInfoVo.setCity(jsonObject.getString("city"));
            alipayChannelInfoVo.setCountrycode(jsonObject.getString("countryCode"));
        }
        alipayChannelInfoVo.setMemberCode(responseOpenCardModel.getMemberCode());
        alipayChannelInfoVo.setSysCompanyId(unifiedRegisterVo.getSysCompanyId());
        alipayChannelInfoVo.setSysBrandId(unifiedRegisterVo.getSysBrandId());
        alipayChannelInfoVo.setAppid(wxMbrRegisteRequestVo.getAppid());
        alipayChannelInfoVo.setAlipayPublicType("2");
        alipayChannelInfoVo.setUserId(menberBoRes.getUserId());
        alipayChannelInfoVo.setPhone(menberBoRes.getPhone());
        log.info("AlipayLoginServiceImpl#MbrOpenCardByWx#alipayChannelInfoVo:{}", (Object)JSON.toJSONString((Object)alipayChannelInfoVo));
        this.alipayChannelMembersFeign.addAlipayChannelMemberInfo(alipayChannelInfoVo);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("Phone:" + responseOpenCardModel.getMemberCode()), (Object)menberBoRes.getPhone(), 7776000000L);
        Integer operateType = null;
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(bizvaneSessionId + "memberCode"), (Object)responseOpenCardModel.getMemberCode(), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(responseOpenCardModel.getMemberCode() + "bizvaneSessionId"), (Object)bizvaneSessionId, 7776000000L);
        Long sysBrandId = menberBoRes.getSysBrandId();
        Long sysCompanyId = menberBoRes.getSysCompanyId();
        this.activityService.executeActivity(sysBrandId, responseOpenCardModel.getMemberCode(), operateType);
        if (StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getOderMemberCode())) {
            this.activityService.inviteOpenCoder(responseOpenCardModel.getMemberCode(), wxMbrRegisteRequestVo.getOderMemberCode(), mktTaskId);
        }
        SysBrandVo sysBrandVo = new SysBrandVo();
        sysBrandVo.setSysBrandId(sysBrandId);
        ResponseData skipByBrandId = this.brandServiceRpc.getSkipByBrandId(sysBrandVo);
        String skipByBrandIdData = (String)skipByBrandId.getData();
        menberBoRes.setSkipByBrandId(skipByBrandIdData);
        menberBoRes.setPhone(menberBoRes.getPhone());
        log.info("operateType={} , mktTaskId={} , sysBrandId={} , \u4f1a\u5458\u4fe1\u606f\u5b58\u50a8={}", new Object[]{operateType, mktTaskId, sysBrandId, this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"))});
        menberBoRes.setMemberCode(responseOpenCardModel.getMemberCode());
        menberBoRes.setOpenCard(true);
        return new ResponseData((Object)menberBoRes);
    }

    private ResponseData<AppletBrandMenberBo> getMbrInfoByWx(String bizvaneSessionId, AppletBrandMenberBo menberBoRes, AppletBrandMenberBo userInfoRes) {
        String memberCode = userInfoRes.getMemberCode();
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData model = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        if (model.getData() != null) {
            String phone = ((MemberInfoModel)model.getData()).getPhone();
            this.redisTemplateService.stringSetValueAndExpireTime((Object)("Phone:" + memberCode), (Object)phone, 7776000000L);
        }
        log.info("getUserInfo memberCode={}  bizvaneSessionId={}", (Object)memberCode, (Object)bizvaneSessionId);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(bizvaneSessionId + "memberCode"), (Object)memberCode, 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(memberCode + "bizvaneSessionId"), (Object)bizvaneSessionId, 7776000000L);
        log.info("memberCode\u6388\u6743\u5df2\u5f00\u5361={}", this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode")));
        menberBoRes.setMemberCode(memberCode);
        menberBoRes.setOpenCard(true);
        log.info("openCard={}", (Object)JSON.toJSONString((Object)menberBoRes));
        return new ResponseData((Object)menberBoRes);
    }

    private AlipayCodeResolveVo getAlipayCodeResolveVo(String code, String appid) {
        ResponseData wxCodeResolveVoResponseData = this.alipayUserAuthorizationFeign.byCode(code, appid);
        if (wxCodeResolveVoResponseData == null || wxCodeResolveVoResponseData.getCode() != SysResponseEnum.SUCCESS.getCode() || wxCodeResolveVoResponseData.getData() == null || StringUtils.isBlank((CharSequence)((AlipayCodeResolveVo)wxCodeResolveVoResponseData.getData()).getBizvaneSessionId())) {
            log.info("alipayUserAuthorizationFeign#getWxCodeResolveVo,{}", (Object)JSONObject.toJSONString((Object)wxCodeResolveVoResponseData));
            throw new RuntimeException("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        return (AlipayCodeResolveVo)wxCodeResolveVoResponseData.getData();
    }

    private SysBrandPo getBrandInfo(Long sysBrandId) {
        log.info("\u5c0f\u7a0b\u5e8f\u8d26\u53f7\u4e3b\u4f53\u4fe1\u606f sysBrandId={}", (Object)sysBrandId);
        ResponseData sysBrandPoResponseData = this.brandServiceRpc.getBrandByID(sysBrandId);
        if (sysBrandPoResponseData.getCode() != SysResponseEnum.SUCCESS.getCode() || sysBrandPoResponseData.getData() == null) {
            log.info("brandServiceRpc#getBrandByID\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25,{}", (Object)JSONObject.toJSONString((Object)sysBrandPoResponseData));
            throw new RuntimeException("\u5c0f\u7a0b\u5e8f\u8d26\u53f7\u4e3b\u4f53\u54c1\u724c\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        }
        return (SysBrandPo)sysBrandPoResponseData.getData();
    }

    private AppletBrandMenberBo getMbrOpenCardFlag(AlipayCodeResolveVo wxCodeResolveVo, Long sysBrandId, String appid) {
        AlipayChannelInfoVo alipayChannelInfoVo = new AlipayChannelInfoVo();
        alipayChannelInfoVo.setAppid(appid);
        alipayChannelInfoVo.setSysBrandId(sysBrandId);
        alipayChannelInfoVo.setUserId(wxCodeResolveVo.getUserId());
        alipayChannelInfoVo.setAlipayPublicType(AlipayPublicTypeEnum.MINI.getCode());
        ResponseData alipayChannelInfoVoResponseData = this.alipayChannelMembersFeign.getAlipayChannelMemberInfo(alipayChannelInfoVo);
        log.info("AlipayLoginServiceImpl#getMbrOpenCardFlag#alipayChannelMemberInfo:{}", (Object)JSONObject.toJSONString((Object)alipayChannelInfoVoResponseData));
        AppletBrandMenberBo appletBrandMenberBo = new AppletBrandMenberBo();
        if (alipayChannelInfoVoResponseData == null || alipayChannelInfoVoResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            throw new RuntimeException("\u5fae\u4fe1\u6388\u6743\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u518d\u8bd5");
        }
        if (alipayChannelInfoVoResponseData.getData() == null || StringUtils.isBlank((CharSequence)((AlipayChannelInfoVo)alipayChannelInfoVoResponseData.getData()).getMemberCode())) {
            appletBrandMenberBo.setOpenCard(false);
            log.info("\u672a\u5f00\u5361,openid={}", (Object)wxCodeResolveVo.getUserId());
            return appletBrandMenberBo;
        }
        alipayChannelInfoVo = (AlipayChannelInfoVo)alipayChannelInfoVoResponseData.getData();
        appletBrandMenberBo.setOpenCard(true);
        appletBrandMenberBo.setMemberCode(alipayChannelInfoVo.getMemberCode());
        appletBrandMenberBo.setUserId(alipayChannelInfoVo.getUserId());
        log.info("AlipayLoginServiceImpl#getMbrOpenCardFlag#\u5b58\u50a8\u4f1a\u5458\u4fe1\u606f\u5230Redis memberCode={}  bizvaneSessionId={}   phone={}", new Object[]{alipayChannelInfoVo.getMemberCode(), wxCodeResolveVo.getBizvaneSessionId(), alipayChannelInfoVo.getPhone()});
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("getUserId" + wxCodeResolveVo.getBizvaneSessionId()), (Object)alipayChannelInfoVo.getUserId(), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("Phone:" + alipayChannelInfoVo.getMemberCode()), (Object)alipayChannelInfoVo.getPhone(), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(wxCodeResolveVo.getBizvaneSessionId() + "memberCode"), (Object)alipayChannelInfoVo.getMemberCode(), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(alipayChannelInfoVo.getMemberCode() + "bizvaneSessionId"), (Object)wxCodeResolveVo.getBizvaneSessionId(), 7776000000L);
        log.info("AlipayLoginServiceImpl#getMbrOpenCardFlag#userId={}", this.redisTemplateService.stringGetStringByKey((Object)("getUserId" + wxCodeResolveVo.getBizvaneSessionId())));
        return appletBrandMenberBo;
    }
}

