/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.activity;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.interfaces.BrandService;
import com.bizvane.appletservice.interfaces.IntegrationShopService;
import com.bizvane.appletservice.models.vo.ConfirmGoodsVo;
import com.bizvane.appletservice.models.vo.ShopStoreVo;
import com.bizvane.appletserviceimpl.enums.SysBusinessResponseEnum;
import com.bizvane.appletserviceimpl.impl.activity.ActivityCouponsReponseVO;
import com.bizvane.appletserviceimpl.impl.activity.ActivityCouponsRequestVO;
import com.bizvane.appletserviceimpl.impl.activity.ActivityGoodsRequestVO;
import com.bizvane.appletserviceimpl.impl.activity.ActivityGoodsResponseVO;
import com.bizvane.appletserviceimpl.impl.activity.ActivityRequestVO;
import com.bizvane.appletserviceimpl.impl.activity.IntegralActivityAppletCouponDTO;
import com.bizvane.appletserviceimpl.impl.seckill.SeckillActivityService;
import com.bizvane.appletserviceimpl.utils.CouponUtils;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.members.facade.models.MemberCardLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberCardProgramApiService;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.mktcenterservice.models.bo.CouponIntegralExchangeBO;
import com.bizvane.mktcenterservice.models.po.MktCouponIntegralExchangePO;
import com.bizvane.mktcenterservice.models.vo.CouponIntegralExchangeVO;
import com.bizvane.mktcenterservice.models.vo.CouponRecordVO;
import com.bizvane.mktcenterservice.models.vo.MktCouponIntegralExchangeVO;
import com.bizvane.mktcenterservice.models.vo.MktGiftBagVO;
import com.bizvane.mktcenterservice.rpc.TaskServiceForWXRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.enums.IntegralStore.activity.IntegralActivityGoodsTypeEnum;
import com.wmeimob.fastboot.bizvane.service.rpc.vg.IntegralActivityRpcService;
import com.wmeimob.fastboot.bizvane.utils.response.Result;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.activity.IntegralActivityAddResponseVO;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.activity.IntegralActivityCouponDTO;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.activity.IntegralActivityRequestVO;
import com.wmeimob.fastboot.bizvane.vo.rpc.ActivityRequestRpcVO;
import com.wmeimob.fastboot.bizvane.vo.rpc.ActivityResponseRpcVO;
import com.wmeimob.fastboot.bizvane.vo.rpc.ActivityRpcGoods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class IntegralActivityService {
    private static final Logger log = LoggerFactory.getLogger(IntegralActivityService.class);
    public static final Logger logger = LoggerFactory.getLogger(IntegralActivityService.class);
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private IntegralActivityRpcService integralActivityRpcService;
    @Autowired
    private SeckillActivityService seckillActivityService;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private TaskServiceForWXRpc taskServiceForWXRpc;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private MemberCardProgramApiService memberCardProgramApiService;
    @Autowired
    private IntegrationShopService integrationShopService;
    @Autowired
    private BrandService brandService;

    public Result<ActivityGoodsResponseVO> getActivityGoodsList(ActivityGoodsRequestVO requestVO) {
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(requestVO.getMemberCode());
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        log.info("IntegralActivityService|getActivityGoodsList|singleMemberModel:{}", JSON.toJSON((Object)singleMemberModel));
        MemberInfoModel memberModelData = (MemberInfoModel)singleMemberModel.getData();
        if (memberModelData == null) {
            return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)"\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        try {
            ActivityRequestRpcVO request = new ActivityRequestRpcVO();
            request.setActivityId(requestVO.getActivityId());
            request.setGoodsType(requestVO.getGoodsType());
            request.setPageNum(requestVO.getPageNum());
            request.setPageSize(requestVO.getPageSize());
            Result goodsList = this.integralActivityRpcService.getActivityGoodsRpcList(request);
            log.info("IntegralActivityService|goodsList={}", (Object)JSONObject.toJSONString((Object)goodsList));
            if (!goodsList.isSuccess()) {
                return Result.failure((Integer)goodsList.getCode(), (String)goodsList.getMessage());
            }
            if (goodsList.getData() == null) {
                return Result.success(null);
            }
            ActivityGoodsResponseVO response = new ActivityGoodsResponseVO();
            response.setActiveActivity(((ActivityResponseRpcVO)goodsList.getData()).getActiveActivity());
            PageInfo storeVoPageInfo = this.pageMergeShopStoreVo(((ActivityResponseRpcVO)goodsList.getData()).getActivityGoodsList());
            response.setStoreVos(storeVoPageInfo);
            return Result.success((Object)response, (Long)goodsList.getTotal());
        }
        catch (Exception e) {
            log.error("IntegralActivityService|getActivityGoodsList|msg:{},exception:{}", (Object)e.getMessage(), (Object)e);
            return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)"\u6d3b\u52a8\u5df2\u7ed3\u675f");
        }
    }

    public Result<ActivityGoodsResponseVO> getGoodsDetail(ActivityGoodsRequestVO requestVO) {
        try {
            ActivityRequestRpcVO request = new ActivityRequestRpcVO();
            request.setActivityId(requestVO.getActivityId());
            request.setGoodsId(Integer.valueOf(Integer.parseInt(requestVO.getGoodsId())));
            Result detail = this.integralActivityRpcService.getActivityGoodsRpcDetail(request);
            if (!detail.isSuccess()) {
                return Result.failure((Integer)detail.getCode(), (String)detail.getMessage());
            }
            if (detail.getData() == null) {
                return Result.success();
            }
            if (((ActivityResponseRpcVO)detail.getData()).getIntegralGoods() == null) {
                return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)"\u5546\u54c1\u5df2\u4e0b\u67b6\u6216\u4e0d\u5b58\u5728~");
            }
            log.info("IntegralActivityService|detail:{}", (Object)JSON.toJSONString((Object)detail.getData()));
            ShopStoreVo shopStoreVo = this.seckillActivityService.buildShopStoreVo(((ActivityResponseRpcVO)detail.getData()).getIntegralGoods());
            log.info("IntegralActivityService|shopStoreVo:{}", (Object)JSONObject.toJSONString((Object)shopStoreVo));
            this.redisTemplateService.stringSetValueAndExpireTime((Object)("integralActivity_integrationShopGoodId:" + requestVO.getGoodsId()), (Object)JSON.toJSONString((Object)shopStoreVo), 300000L);
            ActivityGoodsResponseVO response = new ActivityGoodsResponseVO();
            response.setShopStoreVo(shopStoreVo);
            response.setActiveActivity(((ActivityResponseRpcVO)detail.getData()).getActiveActivity());
            return Result.success((Object)response);
        }
        catch (Exception e) {
            log.error("IntegralActivityService|getGoodsDetail|msg:{},exception:{}", (Object)e.getMessage(), (Object)e);
            return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)SysResponseEnum.FAILED.getMessage());
        }
    }

    public Result<Boolean> checkActivityInfo(ActivityRequestVO requestVO) {
        try {
            if (IntegralActivityGoodsTypeEnum.GOODS.getCode().equals(requestVO.getGoodsType())) {
                if (requestVO.getActivityId() == null || requestVO.getGoodsId() == null || requestVO.getSaleQuantity() == null || requestVO.getPriceType() == null) {
                    return Result.failure((String)"\u6d3b\u52a8id\u3001\u5546\u54c1id\u3001\u5546\u54c1\u5151\u6362\u6570\u91cf\u3001\u5546\u54c1\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
                }
                String redisJsonString = (String)this.redisTemplateService.stringGetStringByKey((Object)("integralActivity_integrationShopGoodId:" + requestVO.getGoodsId()));
                log.info("IntegralActivityService|checkActivityInfo|redisJsonString:{}", (Object)redisJsonString);
                if (StringUtils.isEmpty((Object)redisJsonString)) {
                    return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)"\u7f51\u7edc\u5f02\u5e38,\u5237\u65b0\u5f53\u524d\u9875\u9762\u91cd\u8bd5");
                }
                if (!this.integrationShopService.checkMemberLabelMatchNew(this.buildConfirmGoodsVo(requestVO), requestVO.getMemberCode()).booleanValue()) {
                    return Result.failure((String)SysBusinessResponseEnum.BUSINESS_DEFINED_CODE_NOT_LABEl_ALLOWED.getMessage());
                }
                return this.integralActivityRpcService.checkActivityPurchase(this.buildActivityRequestRpcVO(requestVO));
            }
            if (!this.integrationShopService.checkMemberLabelMatchNew(this.buildConfirmGoodsVo(requestVO), requestVO.getMemberCode()).booleanValue()) {
                return Result.failure((String)SysBusinessResponseEnum.BUSINESS_DEFINED_CODE_NOT_LABEl_ALLOWED.getMessage());
            }
            if (requestVO.getActivityId() == null || requestVO.getExchangeId() == null || requestVO.getExchangeNum() == null) {
                return Result.failure((String)"\u6d3b\u52a8id\u3001\u5151\u6362\u5238id\u3001\u5151\u6362\u5238\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            CouponRecordVO recordVO = new CouponRecordVO();
            recordVO.setActivityId(requestVO.getActivityId());
            recordVO.setExchangeId(requestVO.getExchangeId());
            recordVO.setExchangeNum(requestVO.getExchangeNum());
            recordVO.setMemberCode(requestVO.getMemberCode());
            ResponseData responseData = this.taskServiceForWXRpc.checkActivityPurchase(recordVO);
            log.info("IntegralActivityService|responseData:{}", (Object)JSON.toJSONString((Object)responseData));
            if (responseData.getCode() == 100 || responseData.getData() == null || !((Boolean)responseData.getData()).booleanValue()) {
                return Result.failure((Integer)responseData.getCode(), (String)responseData.getMessage());
            }
            return Result.success((Object)Boolean.TRUE);
        }
        catch (Exception e) {
            log.error("IntegralActivityService|checkActivityInfo|msg:{},exception:{}", (Object)e.getMessage(), (Object)e);
            return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)SysResponseEnum.FAILED.getMessage());
        }
    }

    private ConfirmGoodsVo buildConfirmGoodsVo(ActivityRequestVO requestVO) {
        ConfirmGoodsVo confirmGoodsVo = new ConfirmGoodsVo();
        confirmGoodsVo.setActivityId(requestVO.getActivityId());
        confirmGoodsVo.setSysBrandId(String.valueOf(requestVO.getBrandId()));
        confirmGoodsVo.setSysCompanyId(requestVO.getCompanyId());
        return confirmGoodsVo;
    }

    private ActivityRequestRpcVO buildActivityRequestRpcVO(ActivityRequestVO requestVO) {
        ActivityRequestRpcVO rpcVO = new ActivityRequestRpcVO();
        rpcVO.setActivityId(requestVO.getActivityId());
        IntegralOrders orders = new IntegralOrders();
        orders.setGoodId(Integer.valueOf(Integer.parseInt(requestVO.getGoodsId())));
        orders.setSaleQuantity(Integer.valueOf(Integer.parseInt(requestVO.getSaleQuantity())));
        orders.setMemberCode(requestVO.getMemberCode());
        orders.setGmtCreate(new Date());
        orders.setGoodSkuNo(requestVO.getGoodSkuNo());
        rpcVO.setIntegralOrders(orders);
        rpcVO.setPriceType(requestVO.getPriceType());
        return rpcVO;
    }

    public PageInfo<ShopStoreVo> pageMergeShopStoreVo(List<ActivityRpcGoods> source) {
        ArrayList<ShopStoreVo> storeVos = new ArrayList<ShopStoreVo>();
        for (int i = 0; i < source.size(); ++i) {
            ActivityRpcGoods integralGoods = source.get(i);
            ShopStoreVo shopStoreVo = new ShopStoreVo();
            shopStoreVo.setShopId(String.valueOf(integralGoods.getActivityGoodsId()));
            shopStoreVo.setGoodsNo(integralGoods.getGoodsNo());
            shopStoreVo.setGoodsName(integralGoods.getGoodsName());
            shopStoreVo.setCoverImg(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)integralGoods.getCoverImg()));
            shopStoreVo.setPrice(String.valueOf(integralGoods.getActivityPrice()));
            shopStoreVo.setUpperShelfTime(String.valueOf(integralGoods.getUpperShelfTime()));
            shopStoreVo.setActualSales(String.valueOf(integralGoods.getOrderGoodsNum()));
            shopStoreVo.setTotalStock(integralGoods.getTotalStock());
            shopStoreVo.setCashPrice(String.valueOf(integralGoods.getActivityCashPrice()));
            shopStoreVo.setPriceType(integralGoods.getActivityPriceType());
            shopStoreVo.setExchangeClubId(integralGoods.getClubId());
            if (integralGoods.getMbrLevelStatus() != null) {
                shopStoreVo.setMbrLevelStatus(integralGoods.getMbrLevelStatus());
            } else {
                shopStoreVo.setMbrLevelStatus(Boolean.valueOf(false));
            }
            shopStoreVo.setSecondPrice(integralGoods.getActivitySecondPrice() == null ? "0" : String.valueOf(integralGoods.getActivitySecondPrice()));
            shopStoreVo.setSecondCashPrice(integralGoods.getActivitySecondCashPrice() == null ? "0.00" : String.valueOf(integralGoods.getActivitySecondCashPrice()));
            shopStoreVo.setGoodsType(integralGoods.getGoodsType());
            storeVos.add(shopStoreVo);
        }
        PageInfo storeVoPageInfo = new PageInfo();
        storeVoPageInfo.setList(storeVos);
        return storeVoPageInfo;
    }

    public Result<ActivityCouponsReponseVO> queryActivityCoupons(ActivityCouponsRequestVO requestVO, HttpServletRequest request) {
        ResponseData exchangeCoupon = this.getExchangeCoupon(requestVO.getBrandId(), requestVO.getCompanyId(), requestVO.getPageNumber(), requestVO.getPageSize(), Boolean.valueOf(false), Boolean.valueOf(false), null, null, request);
        logger.info("IntegralActivityService.queryActivityDetail exchangeCoupon:{}", (Object)JSON.toJSONString((Object)exchangeCoupon));
        List list = new ArrayList();
        if (exchangeCoupon.getCode() != 0) {
            return Result.failure((String)exchangeCoupon.getMessage());
        }
        CouponIntegralExchangeBO data = (CouponIntegralExchangeBO)exchangeCoupon.getData();
        PageInfo pageInfo = data.getPageInfo();
        list = pageInfo.getList();
        Map<Long, MktCouponIntegralExchangeVO> idMapExchange = list.stream().collect(Collectors.toMap(MktCouponIntegralExchangePO::getExchangeId, e -> e));
        IntegralActivityRequestVO integralActivityRequestVO = new IntegralActivityRequestVO();
        integralActivityRequestVO.setActivityId(requestVO.getActivityId());
        Result activity = this.integralActivityRpcService.queryActivities(integralActivityRequestVO);
        logger.info("IntegralActivityService.queryActivityDetail activity:{}", (Object)JSON.toJSONString((Object)activity));
        ActivityCouponsReponseVO vo = new ActivityCouponsReponseVO();
        if (activity.isSuccess()) {
            IntegralActivityAddResponseVO result = (IntegralActivityAddResponseVO)activity.getData();
            boolean status = result.getActivityStatus();
            if (!status) {
                return Result.failure((String)"\u5f88\u62b1\u6b49\uff0c\u6d3b\u52a8\u5df2\u7ecf\u7ed3\u675f\u4e86\u66f4\u591a\u7cbe\u5f69\u6d3b\u52a8\uff0c\u671f\u5f85\u60a8\u7684\u53c2\u4e0e\uff01");
            }
            boolean activityTimeBegin = result.getBeginTime().after(new Date());
            if (activityTimeBegin) {
                return Result.failure((String)"\u6d3b\u52a8\u672a\u5f00\u59cb\uff0c\u66f4\u591a\u7cbe\u5f69\u6d3b\u52a8\uff0c\u671f\u5f85\u60a8\u7684\u53c2\u4e0e\uff01");
            }
            boolean activityTimeEnd = result.getEndTime().before(new Date());
            if (activityTimeEnd) {
                return Result.failure((String)"\u5f88\u62b1\u6b49\uff0c\u6d3b\u52a8\u5df2\u7ecf\u7ed3\u675f\u4e86\u66f4\u591a\u7cbe\u5f69\u6d3b\u52a8\uff0c\u671f\u5f85\u60a8\u7684\u53c2\u4e0e\uff01");
            }
            BeanUtils.copyProperties((Object)result, (Object)vo);
            List coupons = result.getCoupons();
            List response = coupons.stream().filter(coupon -> {
                MktCouponIntegralExchangeVO exchangeVO = (MktCouponIntegralExchangeVO)idMapExchange.get(coupon.getExchangeId());
                return exchangeVO != null && exchangeVO.getSalesStatus() == 1;
            }).map(coupon -> {
                IntegralActivityAppletCouponDTO dto = new IntegralActivityAppletCouponDTO();
                dto.setExchangeId(coupon.getExchangeId());
                dto.setIntegralActivityCouponDTO(coupon);
                dto.setMktCouponIntegralExchangeVO((MktCouponIntegralExchangeVO)idMapExchange.get(coupon.getExchangeId()));
                return dto;
            }).collect(Collectors.toList());
            if (requestVO.getExchangeId() != null) {
                response = response.stream().filter(dto -> dto.getExchangeId().equals(requestVO.getExchangeId())).collect(Collectors.toList());
            }
            vo.setCouponDTOS(response);
            return Result.success((Object)vo);
        }
        return Result.failure((String)activity.getMessage());
    }

    public Result<ActivityCouponsReponseVO> queryActivityCouponsDetail(ActivityCouponsRequestVO requestVO, HttpServletRequest request) {
        IntegralActivityRequestVO integralActivityRequestVO = new IntegralActivityRequestVO();
        integralActivityRequestVO.setActivityId(requestVO.getActivityId());
        integralActivityRequestVO.setExchangeId(requestVO.getExchangeId());
        Result activity = this.integralActivityRpcService.queryActivities(integralActivityRequestVO);
        CouponRecordVO couponRecordVO = new CouponRecordVO();
        couponRecordVO.setExchangeId(requestVO.getExchangeId());
        couponRecordVO.setSysCompanyId(requestVO.getCompanyId());
        couponRecordVO.setBrandId(requestVO.getBrandId());
        ResponseData couponAndPrice = this.getCouponAndPrice(request, couponRecordVO);
        if (couponAndPrice.getCode() != 0) {
            return Result.failure((String)couponAndPrice.getMessage());
        }
        ActivityCouponsReponseVO vo = new ActivityCouponsReponseVO();
        if (activity.isSuccess()) {
            IntegralActivityAddResponseVO result = (IntegralActivityAddResponseVO)activity.getData();
            BeanUtils.copyProperties((Object)result, (Object)vo);
            vo.setPriceData((CouponIntegralExchangeVO)couponAndPrice.getData());
            if (!CollectionUtils.isEmpty((Collection)result.getCoupons())) {
                vo.setCouponDTO((IntegralActivityCouponDTO)result.getCoupons().get(0));
            }
            return Result.success((Object)vo);
        }
        return Result.failure((String)activity.getMessage());
    }

    public ResponseData<CouponIntegralExchangeBO> getExchangeCoupon(Long brandId, Long companyId, Integer pageNumber, Integer pageSize, Boolean canConvertCoupon, Boolean hotGoods, Integer getTarget, Integer exchangePriceType, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        try {
            Object data;
            CouponRecordVO couponRecordVO = new CouponRecordVO();
            couponRecordVO.setPageNumber(pageNumber);
            couponRecordVO.setPageSize(pageSize);
            couponRecordVO.setBrandId(brandId);
            couponRecordVO.setCanConvertCoupon(canConvertCoupon);
            couponRecordVO.setHotGoods(hotGoods);
            couponRecordVO.setExchangePriceType(exchangePriceType);
            couponRecordVO.setSysCompanyId(companyId);
            logger.info("IntegrationShopController#getExchangeCoupon#couponRecordVO:{}", (Object)JSON.toJSONString((Object)couponRecordVO));
            String bizvaneSessionId = request.getHeader("bizvaneSessionId");
            if (bizvaneSessionId == null) {
                responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
                return responseData;
            }
            String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
            logger.info("integrationShopGetall memberCode:{}", (Object)memberCode);
            if (memberCode == null) {
                responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                responseData.setCode(-100);
                return responseData;
            }
            if (couponRecordVO.getCanConvertCoupon() == null) {
                responseData.setMessage("\u67e5\u8be2\u52fe\u9009\u6846\u4e3anull");
                responseData.setCode(100);
                return responseData;
            }
            couponRecordVO.setMemberCode(memberCode);
            Long serviceStoreId = this.wxAppletApiService.getOpenCardStoreId(memberCode).getData() == null ? Long.valueOf(0L) : (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
            try {
                ResponseData config = this.integrationShopService.getConfig(Integer.valueOf(couponRecordVO.getBrandId().intValue()));
                data = config.getData();
                JSONObject json = (JSONObject)JSON.toJSON((Object)data);
                logger.info("IntegrationShopController#integrationShopGetall#169# configMap:{}", (Object)json);
                if (!couponRecordVO.getCanConvertCoupon().booleanValue()) {
                    logger.info("hiddenGoods:{}", (Object)json.getBoolean("hiddenGoods"));
                    couponRecordVO.setHiddenGoods(json.getBoolean("hiddenGoods"));
                }
            }
            catch (Exception e) {
                logger.info("IntegrationShopController#integrationShopGetall#157 Exception :{},:{}", (Object)e.getMessage(), (Object)e);
            }
            couponRecordVO.setOpenCardStoreId(serviceStoreId);
            ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
            data = (MemberCardLevelModel)modelResponseData.getData();
            Integer integral = data.getCountIntegral();
            logger.info("integrationShopGetall memberCode:{},memberResp:{}", (Object)memberCode, (Object)JSONObject.toJSONString((Object)modelResponseData));
            if (integral != null) {
                couponRecordVO.setCountIntegral(integral);
            }
            couponRecordVO.setMbrLevelId(data.getLevelId());
            logger.info("\u5165\u53c2222222222====" + JSON.toJSON((Object)couponRecordVO));
            ResponseData convernCouponLists = this.taskServiceForWXRpc.getConvernCouponListsForActivity(couponRecordVO);
            logger.info("integrationShopGetall convernCouponLists:{}", (Object)JSON.toJSONString((Object)convernCouponLists));
            try {
                CouponUtils.mergeCouponListsApplicableBrandCodes((ResponseData)convernCouponLists);
                log.info("\u683c\u5f0f\u5316\u540e\u6570\u636e:{}", (Object)JSON.toJSONString((Object)convernCouponLists));
            }
            catch (Exception e) {
                log.warn("IntegrationShopController#getExchangeCoupon\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            }
            return convernCouponLists;
        }
        catch (Exception e) {
            log.warn("IntegrationShopController#getExchangeCoupon\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            responseData.setMessage(e.getMessage());
            return responseData;
        }
    }

    public ResponseData getCouponAndPrice(HttpServletRequest request, CouponRecordVO couponRecordVO) {
        SysBrandPo sysBrandPo;
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        MemberCardLevelModel data = (MemberCardLevelModel)modelResponseData.getData();
        couponRecordVO.setMemberCode(memberCode);
        couponRecordVO.setMbrLevelId(data.getLevelId());
        couponRecordVO.setOpenId(openId);
        logger.info("\u5165\u53c2====" + JSON.toJSON((Object)couponRecordVO.toString()));
        ResponseData couponAndPrice = this.taskServiceForWXRpc.getCouponAndPriceForActivity(couponRecordVO);
        CouponIntegralExchangeVO priceData = (CouponIntegralExchangeVO)couponAndPrice.getData();
        if (StringUtils.isEmpty((Object)priceData)) {
            log.info("priceData=======null");
            return couponAndPrice;
        }
        Long twCLubBrandId = null;
        if (!StringUtils.isEmpty((Object)priceData.getExchangeClubId()) && (sysBrandPo = this.brandService.getBrandById(Long.valueOf(priceData.getExchangeClubId()))) != null) {
            twCLubBrandId = sysBrandPo.getParentId();
            priceData.setExchangeClubName(sysBrandPo.getBrandName());
        }
        if (twCLubBrandId != null) {
            SysBrandPo twSysBrandPo = this.brandService.getBrandById(twCLubBrandId);
            priceData.setExchangeClubId(twCLubBrandId.toString());
            priceData.setExchangeClubName(twSysBrandPo.getBrandName());
            List mbrLevelModelList = priceData.getMbrLevelModelList();
            if (!CollectionUtils.isEmpty((Collection)mbrLevelModelList)) {
                List transformTwLevel = this.integrationShopService.transformTwLevel(twCLubBrandId, mbrLevelModelList);
                priceData.setMbrLevelModelList(transformTwLevel);
            }
        }
        priceData.setMktCouponIntegralExchangePOWithBLOBs(null);
        MktGiftBagVO giftBagVO = priceData.getGiftBagVO();
        if (!StringUtils.isEmpty((Object)giftBagVO)) {
            log.info("\u52b5\u5305\u8f6c\u5316\u663e\u793a");
            List couponDefinitionPOList = giftBagVO.getCouponDefinitionPOList();
            CouponDefinitionPO couponDefinition2 = new CouponDefinitionPO();
            StringBuilder listCodeBuilder = new StringBuilder();
            if (!CollectionUtils.isEmpty((Collection)couponDefinitionPOList)) {
                for (CouponDefinitionPOWithBLOBs coupon : couponDefinitionPOList) {
                    CouponUtils.convertApplicableBrandCodes((CouponDefinitionPO)coupon, (int)2);
                    listCodeBuilder.append(coupon.getApplicableBrandCodes());
                    listCodeBuilder.append(",");
                }
                if (!StringUtils.isEmpty((Object)listCodeBuilder)) {
                    couponDefinition2.setApplicableBrandCodes(listCodeBuilder.toString());
                    CouponUtils.convertApplicableBrandCodes((CouponDefinitionPO)couponDefinition2, (int)2);
                    priceData.setCouponDefinitionPO(couponDefinition2);
                }
            }
        } else {
            log.info("\u52b5\u8f6c\u5316\u663e\u793a");
            CouponDefinitionPO couponDefinitionPo = priceData.getCouponDefinitionPO();
            if (!StringUtils.isEmpty((Object)couponDefinitionPo)) {
                CouponUtils.convertApplicableBrandCodes((CouponDefinitionPO)couponDefinitionPo, (int)2);
            }
        }
        return couponAndPrice;
    }
}

