/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.interfaces.ResourcesService;
import com.bizvane.appletservice.models.po.AppletBrandThemePO;
import com.bizvane.appletservice.models.po.AppletBrandThemePOExample;
import com.bizvane.appletservice.models.po.AppletResourcesPO;
import com.bizvane.appletservice.models.po.AppletResourcesPOExample;
import com.bizvane.appletserviceimpl.mappers.AppletBrandThemePOMapper;
import com.bizvane.appletserviceimpl.mappers.AppletResourcesPOMapper;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResourcesServiceImpl
implements ResourcesService {
    @Autowired
    private AppletResourcesPOMapper appletResourcesPOMapper;
    @Autowired
    private AppletBrandThemePOMapper appletBrandThemePOMapper;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    public ResponseData<List<AppletResourcesPO>> getResources(AppletResourcesPO po) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        if (po.getSysBrandId() == null) {
            responseData.setMessage("\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)po.getModularCode())) {
            responseData.setMessage("\u8d44\u6e90code\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        AppletResourcesPOExample example = new AppletResourcesPOExample();
        example.createCriteria().andSysBrandIdEqualTo(po.getSysBrandId()).andModularCodeEqualTo(po.getModularCode()).andValidEqualTo(Boolean.valueOf(true));
        List appletResourcesPOList = this.appletResourcesPOMapper.selectByExample(example);
        if (appletResourcesPOList.size() <= 0) {
            responseData.setMessage("\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u7684\u8d44\u6e90!");
            return responseData;
        }
        responseData.setData((Object)appletResourcesPOList);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData<List<AppletBrandThemePO>> themeResources(Long sysBrandId) {
        ResponseData responseData = new ResponseData();
        logger.info("\u4e3b\u9898={}", (Object)sysBrandId);
        AppletBrandThemePOExample appletBrandThemePOExample = new AppletBrandThemePOExample();
        appletBrandThemePOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andSysBrandIdEqualTo(sysBrandId);
        List brandThemePOS = this.appletBrandThemePOMapper.selectByExample(appletBrandThemePOExample);
        if (brandThemePOS != null) {
            logger.info("\u4e3b\u9898\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)brandThemePOS));
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)brandThemePOS);
            return responseData;
        }
        responseData.setMessage("\u672a\u83b7\u53d6\u5230\u4e3b\u9898");
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        return responseData;
    }
}

