/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.common.HttpUtil;
import com.bizvane.appletservice.interfaces.BrandService;
import com.bizvane.appletservice.interfaces.IntegrationShopService;
import com.bizvane.appletservice.interfaces.vg.VGLoginService;
import com.bizvane.appletservice.models.bo.MktConvertCouponRecordBo;
import com.bizvane.appletservice.models.vo.ActivityImgQueryResponseVO;
import com.bizvane.appletservice.models.vo.AllMerchandiseVo;
import com.bizvane.appletservice.models.vo.ChildsVo;
import com.bizvane.appletservice.models.vo.ConfirmGoodsVo;
import com.bizvane.appletservice.models.vo.GoodSkuSpecDetailsVo;
import com.bizvane.appletservice.models.vo.GoodsInfoDetailVO;
import com.bizvane.appletservice.models.vo.GoodsInfoVO;
import com.bizvane.appletservice.models.vo.IntegralOrderFeightVO;
import com.bizvane.appletservice.models.vo.IntegralQRCodeRequestVO;
import com.bizvane.appletservice.models.vo.IntegralShopGetHomePageHotCommodityRequestVO;
import com.bizvane.appletservice.models.vo.MainSpecVo;
import com.bizvane.appletservice.models.vo.OrderVo;
import com.bizvane.appletservice.models.vo.RefundLogisticsVo;
import com.bizvane.appletservice.models.vo.ReturnGoodsVo;
import com.bizvane.appletservice.models.vo.RotationChartVo;
import com.bizvane.appletservice.models.vo.ShopClassifyMapVo;
import com.bizvane.appletservice.models.vo.ShopHomePageVo;
import com.bizvane.appletservice.models.vo.ShopStoreSkuVo;
import com.bizvane.appletservice.models.vo.ShopStoreVo;
import com.bizvane.appletservice.models.vo.ShopVo;
import com.bizvane.appletservice.models.vo.UserAddressPutVo;
import com.bizvane.appletservice.models.vo.classifiedGoodsVo;
import com.bizvane.appletservice.models.vo.refundOrderVo;
import com.bizvane.appletserviceimpl.enums.MktCouponIntegralExchangeTypeEnum;
import com.bizvane.appletserviceimpl.enums.SysBusinessResponseEnum;
import com.bizvane.appletserviceimpl.handler.AppletBizvaneException;
import com.bizvane.appletserviceimpl.impl.seckill.SeckillActivityService;
import com.bizvane.appletserviceimpl.mappers.LocalHandwrittenMapper;
import com.bizvane.appletserviceimpl.utils.LogicException;
import com.bizvane.appletserviceimpl.utils.PageUtils;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.appletserviceimpl.utils.UUIDUtils;
import com.bizvane.appletserviceimpl.vo.ActivitySubjectResVO;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.WxPayConfigPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.couponfacade.interfaces.CouponDefinitionServiceFeign;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.customized.facade.utils.ResponseUtils;
import com.bizvane.members.facade.es.vo.MembersInfoSearchVo;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.WxChannelInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MemberLevelApiService;
import com.bizvane.members.facade.service.api.MembersAdvancedSearchApiService;
import com.bizvane.members.facade.service.api.WxChannelInfoApiService;
import com.bizvane.members.facade.vo.WxChannelRelationVo;
import com.bizvane.mktcenterservice.models.po.MktConvertCouponRecordPO;
import com.bizvane.mktcenterservice.models.vo.CouponRecordVO;
import com.bizvane.mktcenterservice.models.vo.MktGiftBagVO;
import com.bizvane.mktcenterservice.rpc.TaskServiceForWXRpc;
import com.bizvane.utils.commonutils.CustomException;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatenterprise.service.entity.vo.StoreOrderInformVO;
import com.bizvane.wechatfacade.interfaces.QRCodeServiceFeign;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import com.bizvane.wechatfacade.models.vo.UrlMinaQRCodeCreateRequestVO;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoods;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.enums.IntegralStore.activity.IntegralActivityGoodsTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.skyworth.IntegralGoodsPriceTypeEnum;
import com.wmeimob.fastboot.bizvane.po.IntegralActivityPO;
import com.wmeimob.fastboot.bizvane.po.IntegralActivityPOWithBLOBs;
import com.wmeimob.fastboot.bizvane.service.rpc.vg.IntegralActivityRpcService;
import com.wmeimob.fastboot.bizvane.service.rpc.vg.IntegralGoodsRpcService;
import com.wmeimob.fastboot.bizvane.utils.response.Result;
import com.wmeimob.fastboot.bizvane.vo.rpc.ActivityRequestRpcVO;
import com.wmeimob.fastboot.bizvane.vo.rpc.ActivityResponseRpcVO;
import com.wmeimob.fastboot.bizvane.vo.rpc.ActivitySubjectRequestVO;
import com.wmeimob.fastboot.bizvane.vo.rpc.ActivitySubjectResponseVO;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@RefreshScope
public class IntegrationShopServiceImpl
implements IntegrationShopService {
    private static final Logger log = LoggerFactory.getLogger(IntegrationShopServiceImpl.class);
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private WxChannelInfoApiService wxChannelInfoApiService;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private TaskServiceForWXRpc taskServiceForWXRpc;
    @Autowired
    private CouponDefinitionServiceFeign couponDefinitionServiceFeign;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private QRCodeServiceFeign qrCodeServiceFeign;
    @Autowired
    private MemberLevelApiService memberLevelApiService;
    @Autowired
    private IntegrationShopService integrationShopService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private VGLoginService vgLoginService;
    @Autowired
    private IntegralActivityRpcService integralActivityRpcService;
    @Autowired
    private SeckillActivityService seckillActivityService;
    private final DecimalFormat df = new DecimalFormat("###,###.00");
    @Value(value="${wxStore.baseUrl}")
    private String DOMAINNAME;
    private static final String ROTATIONCHART = "api/wx/homePage/getHomePage/";
    private static final String CLASSIFICATION = "api/wx/classify/getClassifyMap/";
    private static final String HOTCOMMODITY = "api/wx/goods/getHotGoods/";
    private static final String HOTCOMMODITYNEW = "api/wx/goods/getHotGoodsNew/";
    private static final String ALLMERCHANDISE = "api/wx/goods/getAllGoods?";
    private static final String COMMODITYDETAILS = "api/wx/goods/getGoodsDetail/";
    private static final String TAILCLASSIFIEDGOODS = "api/wx/goods/getGoodsByClassifyId?";
    private static final String INVENTORYSTATUS = "api/wx/goods/getSkuStock?skuId=";
    private static final String ORDERDETAILS = "api/wx/orders/getOrderById/";
    private static final String LOGISTICLIST = "api/logistics/companyList";
    private static final String DISPLAYLOGISTICS = "api/logistics/queryLogisticInfo?companyCode=";
    private static final String USERADDRESS = "api/integral/userAddress?userId=";
    private static final String ORDERLIST = "api/wx/orders/getOrderListByStatus/";
    private static final String INSTRUCTIONNS = "api/wx/refundOrder/getRejectedExplain?merchantId=";
    private static final String APPLICATIONSUBMISSION = "api/wx/refundOrder/submitReturnGoods";
    private static final String APPLICATIONSUBMISSIONWULIU = "api/wx/refundOrder/submitRefundLogistics";
    private static final String GENERATEORDEER = "api/wx/orders/confirmGoods";
    private static final String CHECK_CAN_MANUAL_SIGN = "api/wx/orders/checkCanManualSign";
    private static final String MANUAL_SIGN = "api/wx/orders/manualSign";
    private static final String ADDUSERADDRESS = "api/integral/userAddress";
    private static final String PUTUSERADDRESS = "api/integral/userAddress";
    private static final String DELETESERADDRESS = "api/integral/userAddress";
    private static final String ALL_ORDERS_PAGE = "api/wx/orders/integralOrdersByPage";
    private static final String INTEGRALACQUISITIOON = "api/integral/gain/";
    private static final String GET_CONFIG = "api/integral/config/getConfig";
    private static final String GET_SECKILL_ACTIVITY_LIST = "api/seckill/activity/getSecKillActivityHomeList";
    private static final String GET_PAY_CONFIG = "api/integral/config/getPayConfig";
    private static final String PAYMENT = "api/wx/orders/payment";
    private static final String PAYMENTWITHCOUPON = "api/wx/orders/paymentWithCoupon";
    private static final String INTEGRALORDERFEIGHT = "api/wx/orders/getFeight";
    private static final String QRCORDURL = "api/integral/classify/getCompany?merchantId=";
    private static final String INTEGRAL_INFO = "api/wx/goods/getGoodsDetailInfo/";
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String IS_SORT = "10";
    @Autowired
    private MembersAdvancedSearchApiService membersAdvancedSearchApiService;
    @Autowired
    private BrandService brandService;
    @Autowired
    private IntegralGoodsRpcService integralGoodsRpcService;
    @Resource
    private LocalHandwrittenMapper localHandwrittenMapper;

    public ResponseData manualSign(String orderNo) {
        String result = null;
        try {
            result = HttpUtil.get((String)(this.DOMAINNAME + MANUAL_SIGN + "?orderNo=" + orderNo));
        }
        catch (IOException e) {
            log.error("IntegrationShopServiceImpl.manualSign,orderNo:{}", (Object)orderNo, (Object)e);
            throw new AppletBizvaneException("\u7cfb\u7edf\u5f02\u5e38\uff01");
        }
        if (result == null) {
            log.error("IntegrationShopServiceImpl.manualSign,result is null orderNo:{}", (Object)orderNo);
            throw new AppletBizvaneException("\u624b\u52a8\u7b7e\u6536\u5931\u8d25");
        }
        return (ResponseData)JSON.parseObject((String)result, ResponseData.class);
    }

    public ResponseData checkCanManualSign(String orderNo) {
        String result = null;
        try {
            result = HttpUtil.get((String)(this.DOMAINNAME + CHECK_CAN_MANUAL_SIGN + "?orderNo=" + orderNo));
        }
        catch (IOException e) {
            log.error("IntegrationShopServiceImpl.checkCanManualSign,orderNo:{}", (Object)orderNo, (Object)e);
            throw new AppletBizvaneException("\u7cfb\u7edf\u5f02\u5e38\uff01");
        }
        if (result == null) {
            log.error("IntegrationShopServiceImpl.checkCanManualSign,result is null orderNo:{}", (Object)orderNo);
            throw new AppletBizvaneException("\u624b\u52a8\u7b7e\u6536\u5931\u8d25");
        }
        return (ResponseData)JSON.parseObject((String)result, ResponseData.class);
    }

    public ResponseData shopHomePage(String sysBrandId, String memberCode) {
        ResponseData responseData = new ResponseData();
        try {
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setMemberCode(memberCode);
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            if (singleMemberModel.getData() == null) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
                return responseData;
            }
            MemberInfoModel memberModelData = (MemberInfoModel)singleMemberModel.getData();
            log.info("memberModelData\u4f1a\u5458\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)memberModelData));
            String name = memberModelData.getName();
            Long sysCompanyId = memberModelData.getSysCompanyId();
            Integer countIntegral = memberModelData.getCountIntegral();
            Long levelId = ((MemberInfoModel)singleMemberModel.getData()).getLevelId();
            String levelName = "";
            if (levelId != null) {
                ResponseData mbrLevelModelResponseData = this.memberLevelApiService.queryLevelModel(levelId);
                levelName = ((MbrLevelModel)mbrLevelModelResponseData.getData()).getLevelName();
            }
            String rotationChart = null;
            try {
                rotationChart = HttpUtil.get((String)(this.DOMAINNAME + ROTATIONCHART + sysBrandId));
                log.info("rotationChart={}", (Object)JSON.toJSONString((Object)rotationChart));
            }
            catch (IOException e) {
                log.warn("IntegrationShopServiceImpl#shopHomePage\u5f02\u5e38001:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
                throw new CustomException("\u8f6e\u64ad\u56fe\uff08\u9996\u9875\uff09\u3001\u5e7f\u544a\u4f4d\u5f02\u5e38\uff01");
            }
            String classification = null;
            try {
                classification = HttpUtil.get((String)(this.DOMAINNAME + CLASSIFICATION + sysCompanyId));
                log.info("classification={}", (Object)JSON.toJSONString((Object)classification));
            }
            catch (IOException e) {
                log.warn("IntegrationShopServiceImpl#shopHomePage\u5f02\u5e38002:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
                throw new CustomException("\u83b7\u53d6\u6240\u6709\u5206\u7c7b\u548c\u52b5\u56fe\u5f02\u5e38\uff01");
            }
            String url = this.DOMAINNAME + HOTCOMMODITY + sysBrandId + "?levelName=" + URLEncoder.encode(levelName, "UTF-8") + "&storeId=" + ((MemberInfoModel)singleMemberModel.getData()).getOpenCardStoreId() + "&sysCompanyId=" + sysCompanyId;
            log.info("\u70ed\u95e8\u5546\u54c1url:{}", (Object)url);
            String hotCommodity = null;
            try {
                hotCommodity = HttpUtil.get((String)url);
                log.info("hotCommodity={}", (Object)JSON.toJSONString((Object)hotCommodity));
            }
            catch (IOException e) {
                log.warn("IntegrationShopServiceImpl#shopHomePage\u5f02\u5e38003:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
                throw new CustomException("\u70ed\u95e8\u5546\u54c1\u5f02\u5e38\uff01");
            }
            ShopHomePageVo shopHomePageVo = new ShopHomePageVo();
            HashMap<String, String> stringMap = new HashMap<String, String>();
            HashMap<String, String> attrMap = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)classification)) {
                JSONObject jsonClassification = JSON.parseObject((String)classification);
                JSONArray classifyList = jsonClassification.getJSONArray("ClassifyList");
                ArrayList<ShopClassifyMapVo> classify = new ArrayList<ShopClassifyMapVo>();
                for (int i = 0; i < classifyList.size(); ++i) {
                    ShopClassifyMapVo shopClassifyMapVo = new ShopClassifyMapVo();
                    JSONObject jsonObject = classifyList.getJSONObject(i);
                    String classifyHome = jsonObject.getString("classifyHome");
                    String classifyImg = jsonObject.getString("classifyImg");
                    String classifyIcon = jsonObject.getString("classifyIcon");
                    String className = jsonObject.getString("name");
                    String sort = jsonObject.getString("sort");
                    String classifyNo = jsonObject.getString("classifyNo");
                    String classifyListID = jsonObject.getString("id");
                    String classifyAttribute = jsonObject.getString("classifyAttribute");
                    stringMap.put(classifyListID, classifyImg);
                    shopClassifyMapVo.setClassID(classifyListID);
                    shopClassifyMapVo.setClassifyNo(classifyNo);
                    shopClassifyMapVo.setClassifyIcon(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)classifyIcon));
                    shopClassifyMapVo.setClassifyImg(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)classifyImg));
                    shopClassifyMapVo.setClassifyHome(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)classifyHome));
                    shopClassifyMapVo.setClassifyName(className);
                    shopClassifyMapVo.setSort(sort);
                    shopClassifyMapVo.setClassifyAttribute(classifyAttribute);
                    classify.add(shopClassifyMapVo);
                    attrMap.put(classifyListID, classifyAttribute);
                }
                shopHomePageVo.setClassification(classify);
            } else {
                shopHomePageVo.setClassification(null);
            }
            if (StringUtils.isNotBlank((CharSequence)rotationChart)) {
                JSONObject jsonRotationChart = JSON.parseObject((String)rotationChart);
                String chartString = jsonRotationChart.getString("imgInfo");
                if (StringUtils.isBlank((CharSequence)chartString)) {
                    shopHomePageVo.setRotationChart(null);
                } else {
                    JSONArray imgInfo = jsonRotationChart.getJSONArray("imgInfo");
                    String imgInterval = jsonRotationChart.getString("imgInterval");
                    shopHomePageVo.setImgInterval(imgInterval);
                    ArrayList<RotationChartVo> rotationChartVos = new ArrayList<RotationChartVo>();
                    for (int i = 0; i < imgInfo.size(); ++i) {
                        RotationChartVo rotationChartVo = new RotationChartVo();
                        JSONObject jsonObject = imgInfo.getJSONObject(i);
                        String imgUrl = jsonObject.getString("imgUrl");
                        String classifyId = jsonObject.getString("classifyId");
                        String goodsNo = jsonObject.getString("goodsNo");
                        Integer goodsId = jsonObject.getInteger("goodsId");
                        Integer shelf = jsonObject.getInteger("shelf");
                        Integer type = jsonObject.getInteger("type");
                        String classifyImg = (String)stringMap.get(classifyId);
                        rotationChartVo.setClassifyAttribute((String)attrMap.get(classifyId));
                        rotationChartVo.setClassifyImg(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)classifyImg));
                        rotationChartVo.setClassifyId(classifyId);
                        rotationChartVo.setImgUrl(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)imgUrl));
                        rotationChartVo.setGoodsNo(goodsNo);
                        rotationChartVo.setGoodsId(goodsId);
                        rotationChartVo.setShelf(shelf);
                        rotationChartVo.setType(type);
                        rotationChartVos.add(rotationChartVo);
                        log.info("i={},imgUrl={}", (Object)i, (Object)JSON.toJSONString((Object)hotCommodity));
                    }
                    shopHomePageVo.setRotationChart(rotationChartVos);
                }
            } else {
                shopHomePageVo.setRotationChart(null);
            }
            ArrayList<ShopStoreVo> shopStoreVos = new ArrayList<ShopStoreVo>();
            if (StringUtils.isNotBlank((CharSequence)hotCommodity)) {
                JSONArray jsonHotCommodity = JSON.parseArray((String)hotCommodity);
                for (int i = 0; i < jsonHotCommodity.size(); ++i) {
                    ShopStoreVo shopStoreVo = new ShopStoreVo();
                    JSONObject jsonObject = jsonHotCommodity.getJSONObject(i);
                    String id = jsonObject.getString("id");
                    String goodsNo = jsonObject.getString("goodsNo");
                    String goodsName = jsonObject.getString("goodsName");
                    String coverImg = jsonObject.getString("coverImg");
                    String price = jsonObject.getString("price");
                    Integer totalStock = jsonObject.getInteger("totalStock");
                    String priceType = jsonObject.getString("priceType");
                    String cashPrice = jsonObject.getString("cashPrice");
                    String mbrLevelStatus = jsonObject.getString("mbrLevelStatus");
                    String clubId = jsonObject.getString("clubId");
                    shopStoreVo.setShopId(id);
                    shopStoreVo.setGoodsNo(goodsNo);
                    shopStoreVo.setGoodsName(goodsName);
                    shopStoreVo.setCoverImg(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)coverImg));
                    shopStoreVo.setPrice(price);
                    shopStoreVo.setTotalStock(totalStock);
                    shopStoreVo.setCashPrice(cashPrice);
                    shopStoreVo.setPriceType(priceType);
                    shopStoreVos.add(shopStoreVo);
                    shopStoreVo.setExchangeClubId(clubId);
                    if (StringUtils.isNotBlank((CharSequence)mbrLevelStatus) && Boolean.valueOf(mbrLevelStatus).booleanValue()) {
                        shopStoreVo.setMbrLevelStatus(Boolean.valueOf(mbrLevelStatus));
                        continue;
                    }
                    shopStoreVo.setMbrLevelStatus(Boolean.valueOf(false));
                }
                shopHomePageVo.setPopular(shopStoreVos);
            } else {
                shopHomePageVo.setPopular(null);
            }
            log.info("current memberInfo={}", (Object)JSONObject.toJSONString((Object)memberModelData));
            WxChannelRelationVo wxChannelRelationVo = new WxChannelRelationVo();
            wxChannelRelationVo.setBrandId(Long.valueOf(sysBrandId));
            wxChannelRelationVo.setMemberCode(memberCode);
            ResponseData wxChannelInfoRelation = this.wxChannelInfoApiService.getWxChannelInfoRelation(wxChannelRelationVo);
            log.info("wxChannelInfoRelation:{}", (Object)JSON.toJSONString((Object)wxChannelInfoRelation));
            shopHomePageVo.setMemberCode(memberCode);
            shopHomePageVo.setMemberName(name);
            shopHomePageVo.setInterGerge(String.valueOf(countIntegral));
            if (wxChannelInfoRelation.getData() != null) {
                String wxNick = ((WxChannelInfoModel)wxChannelInfoRelation.getData()).getWxNick();
                String headPortraits = ((WxChannelInfoModel)wxChannelInfoRelation.getData()).getHeadPortraits();
                shopHomePageVo.setWxNick(wxNick);
                shopHomePageVo.setWeChatHead(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)headPortraits));
            }
            responseData.setData((Object)shopHomePageVo);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        catch (Exception e) {
            log.info("\u8fd9\u91cc\u5f02\u5e38\u4e86Exception={},{}", (Object)e.getMessage(), (Object)e);
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public ResponseData<ShopHomePageVo> getHomePageRotationChart(String sysBrandId, Long sysCompanyId, String memberCode) {
        String getHomePageRotationChartRedisKey = "getHomePageRotationChart:" + memberCode;
        String getHomePageRotationChartRedisValue = (String)this.redisTemplateService.stringGetStringByKey((Object)getHomePageRotationChartRedisKey);
        if (StringUtils.isNotBlank((CharSequence)getHomePageRotationChartRedisValue)) {
            log.info("getHomePageRotationChart redis :{}", (Object)getHomePageRotationChartRedisValue);
            ShopHomePageVo shopHomePageVo = (ShopHomePageVo)JSON.parseObject((String)getHomePageRotationChartRedisValue, ShopHomePageVo.class);
            return new ResponseData((Object)shopHomePageVo);
        }
        try {
            ResponseData responseData = new ResponseData();
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setMemberCode(memberCode);
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            if (singleMemberModel.getData() == null) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
                return responseData;
            }
            MemberInfoModel memberModelData = (MemberInfoModel)singleMemberModel.getData();
            log.info("memberModelData\u4f1a\u5458\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)memberModelData));
            String rotationChart = HttpUtil.get((String)(this.DOMAINNAME + ROTATIONCHART + sysBrandId));
            log.info("rotationChart={}", (Object)JSON.toJSONString((Object)rotationChart));
            String classification = HttpUtil.get((String)(this.DOMAINNAME + CLASSIFICATION + sysCompanyId));
            log.info("classification={}", (Object)JSON.toJSONString((Object)classification));
            ShopHomePageVo shopHomePageVo = new ShopHomePageVo();
            HashMap<String, String> stringMap = new HashMap<String, String>();
            HashMap<String, String> attrMap = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)classification)) {
                JSONObject jsonClassification = JSON.parseObject((String)classification);
                JSONArray classifyList = jsonClassification.getJSONArray("ClassifyList");
                ArrayList<ShopClassifyMapVo> classify = new ArrayList<ShopClassifyMapVo>();
                for (int i = 0; i < classifyList.size(); ++i) {
                    ShopClassifyMapVo shopClassifyMapVo = new ShopClassifyMapVo();
                    JSONObject jsonObject = classifyList.getJSONObject(i);
                    String classifyHome = jsonObject.getString("classifyHome");
                    String classifyImg = jsonObject.getString("classifyImg");
                    String classifyIcon = jsonObject.getString("classifyIcon");
                    String className = jsonObject.getString("name");
                    String sort = jsonObject.getString("sort");
                    String classifyNo = jsonObject.getString("classifyNo");
                    String classifyListID = jsonObject.getString("id");
                    String classifyAttribute = jsonObject.getString("classifyAttribute");
                    stringMap.put(classifyListID, classifyImg);
                    shopClassifyMapVo.setClassID(classifyListID);
                    shopClassifyMapVo.setClassifyNo(classifyNo);
                    shopClassifyMapVo.setClassifyIcon(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)classifyIcon));
                    shopClassifyMapVo.setClassifyImg(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)classifyImg));
                    shopClassifyMapVo.setClassifyHome(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)classifyHome));
                    shopClassifyMapVo.setClassifyName(className);
                    shopClassifyMapVo.setSort(sort);
                    shopClassifyMapVo.setClassifyAttribute(classifyAttribute);
                    classify.add(shopClassifyMapVo);
                    attrMap.put(classifyListID, classifyAttribute);
                }
                shopHomePageVo.setClassification(classify);
            } else {
                shopHomePageVo.setClassification(null);
            }
            if (StringUtils.isNotBlank((CharSequence)rotationChart)) {
                JSONObject jsonRotationChart = JSON.parseObject((String)rotationChart);
                String chartString = jsonRotationChart.getString("imgInfo");
                if (StringUtils.isBlank((CharSequence)chartString)) {
                    shopHomePageVo.setRotationChart(null);
                } else {
                    JSONArray imgInfo = jsonRotationChart.getJSONArray("imgInfo");
                    String imgInterval = jsonRotationChart.getString("imgInterval");
                    shopHomePageVo.setImgInterval(imgInterval);
                    ArrayList<RotationChartVo> rotationChartVos = new ArrayList<RotationChartVo>();
                    for (int i = 0; i < imgInfo.size(); ++i) {
                        RotationChartVo rotationChartVo = new RotationChartVo();
                        JSONObject jsonObject = imgInfo.getJSONObject(i);
                        String imgUrl = jsonObject.getString("imgUrl");
                        String classifyId = jsonObject.getString("classifyId");
                        String goodsNo = jsonObject.getString("goodsNo");
                        Integer goodsId = jsonObject.getInteger("goodsId");
                        Integer shelf = jsonObject.getInteger("shelf");
                        Integer type = jsonObject.getInteger("type");
                        Integer imgType = jsonObject.getInteger("imgType");
                        String ztPath = jsonObject.getString("ztPath");
                        String appId = jsonObject.getString("appId");
                        String link = jsonObject.getString("link");
                        String classifyImg = (String)stringMap.get(classifyId);
                        rotationChartVo.setClassifyAttribute((String)attrMap.get(classifyId));
                        rotationChartVo.setClassifyImg(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)classifyImg));
                        rotationChartVo.setClassifyId(classifyId);
                        rotationChartVo.setImgUrl(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)imgUrl));
                        rotationChartVo.setGoodsNo(goodsNo);
                        rotationChartVo.setGoodsId(goodsId);
                        rotationChartVo.setShelf(shelf);
                        rotationChartVo.setType(type);
                        rotationChartVo.setImgType(imgType);
                        rotationChartVo.setZtPath(ztPath);
                        rotationChartVo.setAppId(appId);
                        rotationChartVo.setLink(link);
                        rotationChartVos.add(rotationChartVo);
                    }
                    shopHomePageVo.setRotationChart(rotationChartVos);
                }
            } else {
                shopHomePageVo.setRotationChart(null);
            }
            this.redisTemplateService.stringSetValueAndExpireTime((Object)getHomePageRotationChartRedisKey, (Object)JSON.toJSONString((Object)shopHomePageVo), 30000L);
            log.info("getHomePageRotationChart db :{}", (Object)JSON.toJSONString((Object)shopHomePageVo));
            return new ResponseData((Object)shopHomePageVo);
        }
        catch (Exception e) {
            log.info("IntegrationShopServiceImpl#getHomePageRotationChart#getHomePageRotationChartException", (Throwable)e);
            throw new AppletBizvaneException("\u9996\u9875\u8f6e\u64ad\u56fe\u5206\u7c7b\u83b7\u53d6\u5931\u8d25");
        }
    }

    public ResponseData<JSONObject> getHomePageHotCommodity(IntegralShopGetHomePageHotCommodityRequestVO requestVO) {
        ResponseData responseData = new ResponseData();
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(requestVO.getMemberCode());
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        log.info("IntegrationShopServiceImpl#getHomePageHotCommodity#singleMemberModel:{}", JSON.toJSON((Object)singleMemberModel));
        MemberInfoModel memberModelData = (MemberInfoModel)singleMemberModel.getData();
        String name = memberModelData.getName();
        Long sysCompanyId = memberModelData.getSysCompanyId();
        Integer countIntegral = memberModelData.getCountIntegral();
        Long levelId = ((MemberInfoModel)singleMemberModel.getData()).getLevelId();
        String levelName = "";
        if (levelId != null) {
            ResponseData mbrLevelModelResponseData = this.memberLevelApiService.queryLevelModel(levelId);
            levelName = ((MbrLevelModel)mbrLevelModelResponseData.getData()).getLevelName();
        }
        log.info("IntegrationShopServiceImpl#getHomePageHotCommodity#levelName\uff1a{}", (Object)levelName);
        if (singleMemberModel.getData() == null) {
            return ResponseUtils.getFailedData((String)"\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        try {
            String url = this.DOMAINNAME + HOTCOMMODITYNEW + requestVO.getSysBrandId() + "?levelName=" + URLEncoder.encode(levelName, "UTF-8") + "&storeId=" + ((MemberInfoModel)singleMemberModel.getData()).getOpenCardStoreId() + "&pageSize=" + requestVO.getPageSize() + "&pageIndex=" + requestVO.getPageIndex() + "&sysCompanyId=" + sysCompanyId;
            log.info("url:{}", (Object)url);
            String hotCommodity = HttpUtil.get((String)url);
            log.info("hotCommodity={}", (Object)JSON.toJSONString((Object)hotCommodity));
            JSONObject result = JSON.parseObject((String)hotCommodity);
            responseData.setData((Object)result);
            return responseData;
        }
        catch (Exception e) {
            log.info("IntegrationShopServiceImpl#getHomePageHotCommodity#Exception", (Throwable)e);
            throw new AppletBizvaneException("\u9996\u9875\u70ed\u95e8\u5546\u54c1\u83b7\u53d6\u5931\u8d25");
        }
    }

    public WxPayConfigPo getPayConfig(Integer merchantId) {
        log.info("IntegrationShopServiceImpl#getPayConfig#merchantId:{}", (Object)merchantId);
        try {
            String merchantConfigString = (String)this.redisTemplateService.stringGetStringByKey((Object)("integrationShopGetPayConfig" + merchantId));
            log.info("IntegrationShopServiceImpl#getConfig#merchantConfigString:{}", (Object)merchantConfigString);
            if (!StringUtils.isBlank((CharSequence)merchantConfigString)) {
                WxPayConfigPo configPo = (WxPayConfigPo)JSON.parseObject((String)merchantConfigString, WxPayConfigPo.class);
                return configPo;
            }
            log.info("\u5f00\u59cb\u52a0\u8f7d\u79ef\u5206\u5546\u57ce\u652f\u4ed8\u914d\u7f6e");
            String result = HttpUtil.get((String)(this.DOMAINNAME + GET_PAY_CONFIG + "?merchantId=" + merchantId));
            log.info("\u79ef\u5206\u5546\u57ce\u8fd4\u56de\u652f\u4ed8\u914d\u7f6e:{}", (Object)result);
            if (StringUtils.isEmpty((CharSequence)result)) {
                throw LogicException.error((Integer)-1, (String)"\u79ef\u5206\u5546\u57ce\u672a\u8bbe\u7f6e\u652f\u4ed8\u914d\u7f6e");
            }
            JSONObject json = JSONObject.parseObject((String)result);
            log.info("IntegrationShopServiceImpl#getPayConfig#2009#json :{}", (Object)json);
            WxPayConfigPo configPo = new WxPayConfigPo();
            configPo.setMerchantNumber(json.getString("mchNo"));
            configPo.setSecretKey(json.getString("mchKey"));
            configPo.setSysBrandId(json.getLong("merchantId"));
            try {
                this.redisTemplateService.stringSetValueAndExpireTime((Object)("integrationShopGetPayConfig" + merchantId), (Object)JSON.toJSONString((Object)configPo), 300000L);
            }
            catch (Exception e) {
                log.error("\u914d\u7f6e\u88c5\u8f7dredis\u5f02\u5e38:{}========={}", (Object)e.getMessage(), (Object)e);
            }
            log.info("IntegrationShopServiceImpl#getConfig#2027#data:{}", (Object)JSON.toJSONString((Object)configPo));
            return configPo;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u914d\u7f6e\u5f02\u5e38:{}========={}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public ResponseData querySecKillActivityConfigList() {
        log.info("querySecKillActivityConfigList service begin");
        ResponseData responseData = new ResponseData();
        try {
            log.info("\u5730\u5740\u5730\u5740---  {} ", (Object)(this.DOMAINNAME + GET_SECKILL_ACTIVITY_LIST));
            String activityStr = HttpUtil.get((String)(this.DOMAINNAME + GET_SECKILL_ACTIVITY_LIST));
            if (StringUtils.isEmpty((CharSequence)activityStr)) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(SysResponseEnum.FAILED.getMessage());
                return responseData;
            }
            log.info("activityStr -- {} ", (Object)activityStr);
            JSONObject json = JSON.parseObject((String)activityStr);
            responseData.setData((Object)json.getJSONArray("data"));
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        catch (Exception e) {
            log.info("\u8fd9\u91cc\u5f02\u5e38\u4e86Exception={},{}", (Object)e.getMessage(), (Object)e);
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public ResponseData<ShopHomePageVo> getHomePageMemberInfo(String memberCode, Long sysBrandId) {
        ResponseData sysBrandPoResponseData = this.brandServiceRpc.getBrandByID(sysBrandId);
        ShopHomePageVo shopHomePageVo = new ShopHomePageVo();
        ResponseData result = new ResponseData();
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        log.info("IntegrationShopServiceImpl#getHomePageMemberInfo#singleMemberModel:{}", JSON.toJSON((Object)singleMemberModel));
        if (singleMemberModel.getData() == null) {
            return ResponseUtils.getFailedData((String)"\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        MemberInfoModel memberModelData = (MemberInfoModel)singleMemberModel.getData();
        String name = memberModelData.getName();
        Integer countIntegral = memberModelData.getCountIntegral();
        WxChannelRelationVo wxChannelRelationVo = new WxChannelRelationVo();
        wxChannelRelationVo.setBrandId(sysBrandId);
        wxChannelRelationVo.setMemberCode(memberCode);
        ResponseData wxChannelInfoRelation = this.wxChannelInfoApiService.getWxChannelInfoRelation(wxChannelRelationVo);
        log.info("wxChannelInfoRelation:{}", (Object)JSON.toJSONString((Object)wxChannelInfoRelation.getData()));
        shopHomePageVo.setMemberCode(memberCode);
        shopHomePageVo.setMemberName(name);
        shopHomePageVo.setInterGerge(String.valueOf(countIntegral));
        shopHomePageVo.setBrandLogo(((SysBrandPo)sysBrandPoResponseData.getData()).getBrandLogo());
        if (wxChannelInfoRelation.getData() != null) {
            String wxNick = ((WxChannelInfoModel)wxChannelInfoRelation.getData()).getWxNick();
            String headPortraits = ((WxChannelInfoModel)wxChannelInfoRelation.getData()).getHeadPortraits();
            shopHomePageVo.setWxNick(wxNick);
            shopHomePageVo.setWeChatHead(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)headPortraits));
        }
        result.setData((Object)shopHomePageVo);
        return result;
    }

    private void judgeIntegralActivityAppend(Long sysBrandId, ShopHomePageVo shopHomePageVo, MemberInfoModel memberModelData) {
        try {
            com.wmeimob.fastboot.bizvane.utils.response.ResponseData activeActivityOne = this.integralActivityRpcService.getActiveActivityOne(sysBrandId);
            IntegralActivityPOWithBLOBs integralActivityPO = (IntegralActivityPOWithBLOBs)activeActivityOne.getData();
            if (activeActivityOne.getCode() != SysResponseEnum.SUCCESS.getCode()) {
                log.info("judgeIntegralActivityAppend getActiveActivityOne is failed");
                return;
            }
            if (integralActivityPO == null) {
                log.info("judgeIntegralActivityAppend getActiveActivityOne is null");
                return;
            }
            Date date = new Date();
            if (integralActivityPO.getBeginTime().compareTo(date) > 0) {
                log.info("judgeIntegralActivityAppend getActiveActivityOne time is less than beginTime");
                return;
            }
            if (integralActivityPO.getEndTime().compareTo(date) < 0) {
                log.info("judgeIntegralActivityAppend getActiveActivityOne time is greater than beginTime");
                return;
            }
            Byte activityRange = integralActivityPO.getActivityRange();
            if (activityRange == null) {
                log.info("judgeIntegralActivityAppend getActiveActivityOne activityRange is null");
                return;
            }
            if (activityRange == 1) {
                log.info("judgeIntegralActivityAppend getActiveActivityOne activityRange != 0");
                MembersInfoSearchVo membersInfoSearchVo = new MembersInfoSearchVo();
                membersInfoSearchVo.setMemberCode(memberModelData.getMemberCode());
                membersInfoSearchVo.setAutoLabel(Boolean.TRUE);
                membersInfoSearchVo.setAutoLabelIdList(Arrays.asList(integralActivityPO.getAutoLabelId()));
                membersInfoSearchVo.setPageNumber(Integer.valueOf(1));
                membersInfoSearchVo.setPageSize(Integer.valueOf(1));
                membersInfoSearchVo.setBrandId(memberModelData.getBrandId());
                membersInfoSearchVo.setSysCompanyId(memberModelData.getSysCompanyId());
                ResponseData pageInfoResponseData = this.memberInfoApiService.vgSearch(membersInfoSearchVo);
                log.info("judgeIntegralActivityAppend vgSearch:{}", (Object)JSON.toJSONString((Object)pageInfoResponseData));
                if (pageInfoResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
                    log.info("judgeIntegralActivityAppend pageInfoResponseData is failed");
                    return;
                }
                com.bizvane.utils.responseinfo.PageInfo memberInfoVoPageInfo = (com.bizvane.utils.responseinfo.PageInfo)pageInfoResponseData.getData();
                if (memberInfoVoPageInfo == null) {
                    log.info("judgeIntegralActivityAppend memberInfoVoPageInfo is null");
                    return;
                }
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)memberInfoVoPageInfo.getList())) {
                    log.info("judgeIntegralActivityAppend memberInfoVoPageInfo.getList is empty");
                    return;
                }
            }
            shopHomePageVo.setJudgeIntegralActivity(Boolean.TRUE);
            shopHomePageVo.setAlertStatus(integralActivityPO.getAlertStatus());
            shopHomePageVo.setAlertType(integralActivityPO.getAlertType());
            shopHomePageVo.setAlertImg(integralActivityPO.getAlertImg());
            shopHomePageVo.setIntegralActivityId(Integer.valueOf(integralActivityPO.getIntegralActivityId().intValue()));
        }
        catch (Exception e) {
            log.info("judgeIntegralActivityAppend_error:{}", (Throwable)e);
        }
    }

    public ResponseData fullMerchandiseDisplay(AllMerchandiseVo allMerchandiseVo) {
        ResponseData responseData = new ResponseData();
        try {
            ArrayList<ShopStoreVo> storeVos = new ArrayList<ShopStoreVo>();
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setMemberCode(allMerchandiseVo.getMemberCode());
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            if (singleMemberModel.getData() == null) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
                return responseData;
            }
            Long levelId = ((MemberInfoModel)singleMemberModel.getData()).getLevelId();
            Long sysCompanyId = ((MemberInfoModel)singleMemberModel.getData()).getSysCompanyId();
            String levelName = "";
            if (levelId != null) {
                ResponseData mbrLevelModelResponseData = this.memberLevelApiService.queryLevelModel(levelId);
                levelName = ((MbrLevelModel)mbrLevelModelResponseData.getData()).getLevelName();
            }
            String allMerchandise = HttpUtil.get((String)(this.DOMAINNAME + ALLMERCHANDISE + "merchantId=" + allMerchandiseVo.getSysBrandId() + "&sortType=" + allMerchandiseVo.getSortType() + "&orderBy=" + allMerchandiseVo.getOrderByAsc() + "&levelName=" + URLEncoder.encode(levelName, "UTF-8") + "&storeId=" + ((MemberInfoModel)singleMemberModel.getData()).getOpenCardStoreId() + "&sysCompanyId=" + ((MemberInfoModel)singleMemberModel.getData()).getSysCompanyId()));
            log.info("allMerchandise={}", (Object)JSON.toJSONString((Object)allMerchandise));
            if (StringUtils.isNotBlank((CharSequence)allMerchandise)) {
                JSONArray merchandise = JSON.parseArray((String)allMerchandise);
                for (int i = 0; i < merchandise.size(); ++i) {
                    JSONObject jsonObject = merchandise.getJSONObject(i);
                    String goodsNo = jsonObject.getString("goodsNo");
                    String goodsName = jsonObject.getString("goodsName");
                    String coverImg = jsonObject.getString("coverImg");
                    String price = jsonObject.getString("price");
                    String upperShelfTime = jsonObject.getString("upperShelfTime");
                    String id = jsonObject.getString("id");
                    String actualSales = jsonObject.getString("actualSales");
                    Integer totalStock = jsonObject.getInteger("totalStock");
                    String priceType = jsonObject.getString("priceType");
                    String cashPrice = jsonObject.getString("cashPrice");
                    String mbrLevelStatus = jsonObject.getString("mbrLevelStatus");
                    String clubId = jsonObject.getString("clubId");
                    ShopStoreVo shopStoreVo = new ShopStoreVo();
                    shopStoreVo.setShopId(id);
                    shopStoreVo.setGoodsNo(goodsNo);
                    shopStoreVo.setGoodsName(goodsName);
                    shopStoreVo.setCoverImg(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)coverImg));
                    shopStoreVo.setPrice(price);
                    shopStoreVo.setUpperShelfTime(upperShelfTime);
                    shopStoreVo.setActualSales(actualSales);
                    shopStoreVo.setCashPrice(cashPrice);
                    shopStoreVo.setPriceType(priceType);
                    shopStoreVo.setTotalStock(totalStock);
                    shopStoreVo.setExchangeClubId(clubId);
                    if (StringUtils.isNotBlank((CharSequence)mbrLevelStatus) && Boolean.valueOf(mbrLevelStatus).booleanValue()) {
                        shopStoreVo.setMbrLevelStatus(Boolean.valueOf(mbrLevelStatus));
                    } else {
                        shopStoreVo.setMbrLevelStatus(Boolean.valueOf(false));
                    }
                    storeVos.add(shopStoreVo);
                }
            } else {
                storeVos.add(null);
            }
            responseData.setData(storeVos);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        catch (Exception e) {
            log.info("fullMerchandiseDisplay={}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public ResponseData commodityDetails(String hostID) {
        ResponseData responseData = new ResponseData();
        try {
            ShopStoreVo shopStoreVo = new ShopStoreVo();
            ShopVo shopVo = new ShopVo();
            String commodityDetails = HttpUtil.get((String)(this.DOMAINNAME + COMMODITYDETAILS + hostID));
            log.info("commodityDetails1={}", (Object)JSON.toJSONString((Object)commodityDetails));
            if (StringUtils.isNotBlank((CharSequence)commodityDetails)) {
                SysBrandPo sysBrandPo;
                JSONObject commodityDetailsJson = JSON.parseObject((String)commodityDetails);
                log.info("commodityDetailsJson:{}", (Object)JSONObject.toJSONString((Object)commodityDetails));
                log.info("commodityDetailsJsonStatus:{}", (Object)commodityDetailsJson.getString("exchangeStatus"));
                log.info("commodityDetailsJsonCount:{}", (Object)commodityDetailsJson.getString("exchangeCount"));
                String id = commodityDetailsJson.getString("id");
                String goodsNo = commodityDetailsJson.getString("goodsNo");
                String goodsName = commodityDetailsJson.getString("goodsName");
                String shelf = commodityDetailsJson.getString("shelf");
                String classifyId = commodityDetailsJson.getString("classifyId");
                String coverImg = commodityDetailsJson.getString("coverImg");
                String bannerImgPaths = commodityDetailsJson.getString("bannerImgPaths");
                String hot = commodityDetailsJson.getString("hot");
                String price = commodityDetailsJson.getString("price");
                String upperShelfTime = commodityDetailsJson.getString("upperShelfTime");
                String restrictedNum = commodityDetailsJson.getString("restrictedNum");
                String actualSales = commodityDetailsJson.getString("actualSales");
                String distributionMode = commodityDetailsJson.getString("distributionMode");
                String exchangeInstructions = commodityDetailsJson.getString("exchangeInstructions");
                String goodsDetails = commodityDetailsJson.getString("goodsDetails");
                String exchangeStatus = commodityDetailsJson.getString("exchangeStatus");
                String exchangeCount = commodityDetailsJson.getString("exchangeCount");
                String isWholeStore = commodityDetailsJson.getString("isWholeStore");
                Integer goodsType = commodityDetailsJson.getInteger("goodsType");
                Integer totalStock = commodityDetailsJson.getInteger("totalStock");
                String priceType = commodityDetailsJson.getString("priceType");
                String cashPrice = commodityDetailsJson.getString("cashPrice");
                Integer templateId = commodityDetailsJson.getInteger("integralExpressTemplateId");
                Integer feightType = commodityDetailsJson.getInteger("freightType");
                BigDecimal defaultFreight = commodityDetailsJson.getBigDecimal("defaultFreight");
                String clubId = commodityDetailsJson.getString("clubId");
                String mbrLevelStatus = commodityDetailsJson.getString("mbrLevelStatus");
                String secondPrice = commodityDetailsJson.getString("secondPrice");
                String secondCashPrice = commodityDetailsJson.getString("secondCashPrice");
                String videoUrl = commodityDetailsJson.getString("videoUrl");
                String videoPictureUrl = commodityDetailsJson.getString("videoPictureUrl");
                String isSaleFlag = commodityDetailsJson.getString("isSaleFlag");
                String dayEndTime = commodityDetailsJson.getString("dayEndTime");
                String dayStartTime = commodityDetailsJson.getString("dayStartTime");
                String saleTimeCycle = commodityDetailsJson.getString("saleTimeCycle");
                String saleScheduled = commodityDetailsJson.getString("saleScheduled");
                String storeType = commodityDetailsJson.getString("storeType");
                String storeLimitList = commodityDetailsJson.getString("storeLimitList");
                ArrayList storeList = new ArrayList();
                log.info("\u8f6c\u5316\u540e\u7684\u95e8\u5e97\u5217\u8868\u4e3a:{}", JSONObject.toJSON(storeList));
                shopStoreVo.setStoreInfoList(storeList);
                Long twCLubBrandId = null;
                shopStoreVo.setExchangeClubId(clubId);
                if (StringUtils.isNotBlank((CharSequence)clubId) && (sysBrandPo = this.brandService.getBrandById(Long.valueOf(clubId))) != null) {
                    twCLubBrandId = sysBrandPo.getParentId();
                    shopStoreVo.setExchangeClubName(sysBrandPo.getBrandName());
                }
                if (StringUtils.isNotBlank((CharSequence)clubId) && StringUtils.isNotBlank((CharSequence)mbrLevelStatus) && Boolean.valueOf(mbrLevelStatus).booleanValue()) {
                    ResponseData levelListResponseData = this.memberLevelApiService.queryAllLevelList(Long.valueOf(clubId));
                    List levelList = (List)levelListResponseData.getData();
                    if (SysResponseEnum.SUCCESS.getCode() != levelListResponseData.getCode() || CollectionUtils.isEmpty((Collection)levelList)) {
                        responseData.setCode(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode());
                        responseData.setMessage("\u7b49\u7ea7\u5217\u8868\u67e5\u8be2\u5931\u8d25\uff01");
                        return responseData;
                    }
                    List<String> mbrLevelIdList = Arrays.asList(commodityDetailsJson.getString("mbrLevelIds").split(","));
                    List mbrLevelModelList = levelList.stream().filter(mbrLevelModel -> mbrLevelIdList.contains(mbrLevelModel.getMbrLevelId().toString())).collect(Collectors.toList());
                    shopStoreVo.setMbrLevelModelList(mbrLevelModelList);
                    shopStoreVo.setMbrLevelStatus(Boolean.valueOf(mbrLevelStatus));
                } else {
                    shopStoreVo.setMbrLevelStatus(Boolean.valueOf(false));
                }
                if (twCLubBrandId != null) {
                    SysBrandPo twSysBrandPo = this.brandService.getBrandById(twCLubBrandId);
                    shopStoreVo.setExchangeClubId(twCLubBrandId.toString());
                    shopStoreVo.setExchangeClubName(twSysBrandPo.getBrandName());
                    List mbrLevelModelList = shopStoreVo.getMbrLevelModelList();
                    if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)mbrLevelModelList)) {
                        String[] transformTwLevel = this.transformTwLevel(twCLubBrandId, mbrLevelModelList);
                        shopStoreVo.setMbrLevelModelList((List)transformTwLevel);
                    }
                }
                shopStoreVo.setGoodsType(goodsType);
                shopStoreVo.setShopId(id);
                shopStoreVo.setGoodsNo(goodsNo);
                shopStoreVo.setGoodsName(goodsName);
                shopStoreVo.setShelf(shelf);
                shopStoreVo.setClassifyId(classifyId);
                shopStoreVo.setCoverImg(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)coverImg));
                shopStoreVo.setTotalStock(totalStock);
                shopStoreVo.setSecondCashPrice(secondCashPrice);
                shopStoreVo.setSecondPrice(secondPrice);
                shopStoreVo.setVideoUrl(videoUrl);
                shopStoreVo.setVideoPictureUrl(videoPictureUrl);
                shopStoreVo.setIsSaleFlag(Integer.valueOf(isSaleFlag));
                shopStoreVo.setDayEndTime(Objects.isNull(dayEndTime) ? null : Long.valueOf(dayEndTime));
                shopStoreVo.setDayStartTime(Objects.isNull(dayStartTime) ? null : Long.valueOf(dayStartTime));
                shopStoreVo.setSaleScheduled(Objects.isNull(saleScheduled) ? null : Integer.valueOf(saleScheduled));
                shopStoreVo.setSaleTimeCycle(saleTimeCycle);
                shopStoreVo.setStoreType(Objects.isNull(storeType) ? null : Integer.valueOf(storeType));
                shopStoreVo.setStoreLimitList(storeLimitList);
                String[] split = bannerImgPaths.split(",");
                ArrayList<String> stringList = new ArrayList<String>();
                for (String splits : split) {
                    String splitsDome = QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)splits);
                    stringList.add(splitsDome);
                }
                shopStoreVo.setBannerImgPaths(stringList);
                shopStoreVo.setHot(hot);
                shopStoreVo.setPrice(price);
                shopStoreVo.setUpperShelfTime(upperShelfTime);
                shopStoreVo.setRestrictedNum(restrictedNum);
                shopStoreVo.setExchangeStatus(Integer.valueOf(Integer.parseInt(exchangeStatus)));
                shopStoreVo.setExchangeCount(Integer.valueOf(Integer.parseInt(exchangeCount)));
                shopStoreVo.setActualSales(actualSales);
                shopStoreVo.setDistributionMode(distributionMode);
                shopStoreVo.setExchangeInstructions(exchangeInstructions);
                shopStoreVo.setGoodsDetails(goodsDetails);
                shopStoreVo.setCashPrice(cashPrice);
                shopStoreVo.setPriceType(priceType);
                shopStoreVo.setTemplateId(templateId);
                shopStoreVo.setFreightType(feightType);
                shopStoreVo.setDefaultFreight(defaultFreight);
                String jsonString = commodityDetailsJson.getString("skus");
                if (StringUtils.isNotBlank((CharSequence)jsonString)) {
                    JSONArray skus = commodityDetailsJson.getJSONArray("skus");
                    ArrayList<ShopStoreSkuVo> shopStoreSkuVos = new ArrayList<ShopStoreSkuVo>();
                    ArrayList<ShopStoreSkuVo> shopSkuVo = new ArrayList<ShopStoreSkuVo>();
                    ArrayList<MainSpecVo> shopMainSpecVo = new ArrayList<MainSpecVo>();
                    ArrayList<ChildsVo> shopChildsVoList = new ArrayList<ChildsVo>();
                    for (int i = 0; i < skus.size(); ++i) {
                        ShopStoreSkuVo shopStoreSkuVo = new ShopStoreSkuVo();
                        ShopStoreSkuVo storeSkuVo = new ShopStoreSkuVo();
                        JSONObject skusJSONObject = skus.getJSONObject(i);
                        String skuId = skusJSONObject.getString("id");
                        String goodsId = skusJSONObject.getString("goodsId");
                        String specNames = skusJSONObject.getString("specNames");
                        String specIds = skusJSONObject.getString("specIds");
                        String skuNo = skusJSONObject.getString("skuNo");
                        String skuImg = skusJSONObject.getString("skuImg");
                        String price1 = skusJSONObject.getString("price");
                        String stock = skusJSONObject.getString("stock");
                        String enabled = skusJSONObject.getString("enabled");
                        String cashPriceSku = skusJSONObject.getString("cashPrice");
                        String secondSkuPrice = skusJSONObject.getString("secondPrice");
                        String secondCashSkuPrice = skusJSONObject.getString("secondCashPrice");
                        String cashPriceStock = skusJSONObject.getString("cashPriceStock");
                        String cashBonusStock = skusJSONObject.getString("cashBonusStock");
                        String priceStock = skusJSONObject.getString("priceStock");
                        shopStoreSkuVo.setSecondPrice(secondSkuPrice);
                        shopStoreSkuVo.setSecondCashPrice(secondCashSkuPrice);
                        shopStoreSkuVo.setCashBonusStock(cashBonusStock);
                        shopStoreSkuVo.setPriceStock(priceStock);
                        shopStoreSkuVo.setCashPriceStock(cashPriceStock);
                        shopStoreSkuVo.setSkuId(skuId);
                        shopStoreSkuVo.setGoodsId(goodsId);
                        shopStoreSkuVo.setGoodsId(goodsId);
                        shopStoreSkuVo.setSpecNames(specNames);
                        shopStoreSkuVo.setSpecIds(specIds);
                        shopStoreSkuVo.setSkuNo(skuNo);
                        shopStoreSkuVo.setSkuImg(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)skuImg));
                        shopStoreSkuVo.setSkuPrice(price1);
                        shopStoreSkuVo.setStock(stock);
                        shopStoreSkuVo.setEnabled(enabled);
                        shopStoreSkuVo.setCashPrice(cashPriceSku);
                        storeSkuVo.setSkuId(skuId);
                        storeSkuVo.setSpecNames(specNames);
                        storeSkuVo.setSkuImg(skuImg);
                        shopSkuVo.add(storeSkuVo);
                        JSONArray goodSkuSpecDetails = skusJSONObject.getJSONArray("goodSkuSpecDetails");
                        ArrayList<GoodSkuSpecDetailsVo> detailsVoList = new ArrayList<GoodSkuSpecDetailsVo>();
                        for (int k = 0; k < goodSkuSpecDetails.size(); ++k) {
                            String uuid = UUIDUtils.getUUID();
                            GoodSkuSpecDetailsVo goodSkuSpecDetailsVo = new GoodSkuSpecDetailsVo();
                            MainSpecVo mainSpecVo = new MainSpecVo();
                            JSONObject detailsJSONObject = goodSkuSpecDetails.getJSONObject(k);
                            JSONObject mainSpec = detailsJSONObject.getJSONObject("mainSpec");
                            String id2 = mainSpec.getString("id");
                            String pid = mainSpec.getString("pid");
                            String specName = mainSpec.getString("specName");
                            mainSpecVo.setMainSpecName(specName);
                            mainSpecVo.setMainSpecPid(pid);
                            mainSpecVo.setMainSpecId(id2);
                            shopMainSpecVo.add(mainSpecVo);
                            mainSpecVo.setGoodSkuSpecDetailsID(uuid);
                            mainSpecVo.setSkuId(skuId);
                            goodSkuSpecDetailsVo.setSkuId(skuId);
                            goodSkuSpecDetailsVo.setMainSpecVo(mainSpecVo);
                            goodSkuSpecDetailsVo.setGoodSkuSpecDetailsID(uuid);
                            JSONArray childs = detailsJSONObject.getJSONArray("childs");
                            ArrayList<ChildsVo> childsVoList = new ArrayList<ChildsVo>();
                            for (int o = 0; o < childs.size(); ++o) {
                                ChildsVo childsVo = new ChildsVo();
                                JSONObject jsonObject = childs.getJSONObject(o);
                                childsVo.setChildsId(jsonObject.getString("id"));
                                childsVo.setChildsSpecPid(jsonObject.getString("pid"));
                                childsVo.setChildsSpecName(jsonObject.getString("specName"));
                                shopChildsVoList.add(childsVo);
                                childsVo.setGoodSkuSpecDetailsID(uuid);
                                childsVo.setSkuId(skuId);
                                childsVoList.add(childsVo);
                            }
                            goodSkuSpecDetailsVo.setChildsVoList(childsVoList);
                            detailsVoList.add(goodSkuSpecDetailsVo);
                        }
                        shopStoreSkuVo.setGoodSkuSpecDetails(detailsVoList);
                        shopStoreSkuVos.add(shopStoreSkuVo);
                    }
                    shopStoreVo.setShopStoreSkuVos(shopStoreSkuVos);
                    shopVo.setShopSkuVo(shopSkuVo);
                    shopVo.setShopMainSpecVo(shopMainSpecVo);
                    shopVo.setShopChildsVoList(shopChildsVoList);
                    shopStoreVo.setShopVo(shopVo);
                } else {
                    shopStoreVo.setShopStoreSkuVos(null);
                }
                String classify = commodityDetailsJson.getString("classifyList");
                if (StringUtils.isNotBlank((CharSequence)classify)) {
                    JSONArray classifyList = commodityDetailsJson.getJSONArray("classifyList");
                    ArrayList<ShopClassifyMapVo> shopClassifyMapVos = new ArrayList<ShopClassifyMapVo>();
                    for (int i = 0; i < classifyList.size(); ++i) {
                        JSONObject classifyListJSONObject = classifyList.getJSONObject(i);
                        ShopClassifyMapVo shopClassifyMapVo = new ShopClassifyMapVo();
                        String id1 = classifyListJSONObject.getString("id");
                        String merchantId = classifyListJSONObject.getString("merchantId");
                        String name = classifyListJSONObject.getString("name");
                        String classifyNo = classifyListJSONObject.getString("classifyNo");
                        String sort = classifyListJSONObject.getString("sort");
                        String classifyDescribe = classifyListJSONObject.getString("classifyDescribe");
                        String classifyImg = classifyListJSONObject.getString("classifyImg");
                        String classifyHome = classifyListJSONObject.getString("classifyHome");
                        String classifyIcon = classifyListJSONObject.getString("classifyIcon");
                        shopClassifyMapVo.setClassID(id1);
                        shopClassifyMapVo.setClassID(merchantId);
                        shopClassifyMapVo.setClassID(name);
                        shopClassifyMapVo.setClassID(classifyNo);
                        shopClassifyMapVo.setClassID(classifyDescribe);
                        shopClassifyMapVo.setClassID(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)classifyImg));
                        shopClassifyMapVo.setClassID(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)classifyHome));
                        shopClassifyMapVo.setClassID(sort);
                        shopClassifyMapVo.setClassID(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)classifyIcon));
                        shopClassifyMapVos.add(shopClassifyMapVo);
                    }
                    shopStoreVo.setClassifyMapVos(shopClassifyMapVos);
                } else {
                    shopStoreVo.setClassifyMapVos(null);
                }
                log.info("commodityDetails2={}", (Object)JSON.toJSONString((Object)shopStoreVo));
                responseData.setData((Object)shopStoreVo);
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                this.redisTemplateService.stringSetValueAndExpireTime((Object)("integrationShopGoodId:" + hostID), (Object)JSON.toJSONString((Object)shopStoreVo), 300000L);
                return responseData;
            }
            responseData.setData((Object)commodityDetails);
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u5546\u54c1\u5df2\u4e0b\u67b6\u6216\u4e0d\u5b58\u5728~");
            return responseData;
        }
        catch (Exception e) {
            log.info("commodityDetails={},{}", (Object)e.getMessage(), (Object)e);
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public List<MbrLevelModel> transformTwLevel(Long twCLubBrandId, List<MbrLevelModel> mbrLevelModelList) {
        ArrayList<MbrLevelModel> twMbrLevelModels = new ArrayList<MbrLevelModel>();
        ResponseData twLevelListResponseData = this.memberLevelApiService.queryAllLevelList(Long.valueOf(twCLubBrandId));
        List twLevelList = (List)twLevelListResponseData.getData();
        for (int i = 0; i < mbrLevelModelList.size(); ++i) {
            MbrLevelModel mbrLevelModelClub = mbrLevelModelList.get(i);
            MbrLevelModel mbrLevelModelTw = twLevelList.stream().filter(mbrLevelModel -> mbrLevelModel.getOfflineLevelCode().equals(mbrLevelModelClub.getOfflineLevelCode())).findFirst().orElse(null);
            if (mbrLevelModelTw == null) continue;
            twMbrLevelModels.add(mbrLevelModelTw);
        }
        log.info("transformTwLevel:{}", (Object)JSON.toJSONString(twMbrLevelModels));
        return twMbrLevelModels;
    }

    public ResponseData classifiedGoods(classifiedGoodsVo classifiedGoodsVo2) {
        log.info("IntegrationShopServiceImpl#classifiedGoods:{}", (Object)JSON.toJSONString((Object)classifiedGoodsVo2));
        ResponseData responseData = new ResponseData();
        try {
            String classification = HttpUtil.get((String)(this.DOMAINNAME + CLASSIFICATION + classifiedGoodsVo2.getSysCompanyId()));
            log.info("classification={}", (Object)JSON.toJSONString((Object)classification));
            if (StringUtils.isNotBlank((CharSequence)classification)) {
                JSONObject classificationJson = JSON.parseObject((String)classification);
                ArrayList<ShopClassifyMapVo> list = new ArrayList<ShopClassifyMapVo>();
                JSONArray classifyList = classificationJson.getJSONArray("ClassifyList");
                for (int i = 0; i < classifyList.size(); ++i) {
                    ShopClassifyMapVo shopClassifyMapVo = new ShopClassifyMapVo();
                    JSONObject jsonObject = classifyList.getJSONObject(i);
                    String id = jsonObject.getString("id");
                    String name = jsonObject.getString("name");
                    String classifyNo = jsonObject.getString("classifyNo");
                    String sort = jsonObject.getString("sort");
                    String classifyDescribe = jsonObject.getString("classifyDescribe");
                    String classifyHome = jsonObject.getString("classifyHome");
                    String classifyImg = jsonObject.getString("classifyImg");
                    String classifyIcon = jsonObject.getString("classifyIcon");
                    String classifyAttribute = jsonObject.getString("classifyAttribute");
                    shopClassifyMapVo.setClassID(id);
                    shopClassifyMapVo.setClassifyName(name);
                    shopClassifyMapVo.setClassifyNo(classifyNo);
                    shopClassifyMapVo.setSort(sort);
                    shopClassifyMapVo.setClassifyDescribe(classifyDescribe);
                    shopClassifyMapVo.setClassifyHome(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)classifyHome));
                    shopClassifyMapVo.setClassifyImg(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)classifyImg));
                    shopClassifyMapVo.setClassifyIcon(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)classifyIcon));
                    shopClassifyMapVo.setClassifyAttribute(classifyAttribute);
                    list.add(shopClassifyMapVo);
                }
                classifiedGoodsVo2.setClassifyList(list);
                responseData.setData((Object)classifiedGoodsVo2);
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                return responseData;
            }
            responseData.setData((Object)classification);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        catch (Exception e) {
            log.info("classifiedGoods={}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public ResponseData tailForClassifiedGoods(AllMerchandiseVo allMerchandiseVo) {
        ResponseData responseData = new ResponseData();
        try {
            List<Object> storeVos;
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setMemberCode(allMerchandiseVo.getMemberCode());
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            if (singleMemberModel.getData() == null) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
                return responseData;
            }
            Long levelId = ((MemberInfoModel)singleMemberModel.getData()).getLevelId();
            Long sysCompanyId = ((MemberInfoModel)singleMemberModel.getData()).getSysCompanyId();
            String levelName = "";
            if (levelId != null) {
                ResponseData mbrLevelModelResponseData = this.memberLevelApiService.queryLevelModel(levelId);
                levelName = ((MbrLevelModel)mbrLevelModelResponseData.getData()).getLevelName();
            }
            String tailForClassifiedGoods = HttpUtil.get((String)(this.DOMAINNAME + TAILCLASSIFIEDGOODS + "classifyId=" + allMerchandiseVo.getClassifyId() + "&merchantId=" + allMerchandiseVo.getSysBrandId() + "&sortType=" + allMerchandiseVo.getSortType() + "&orderBy=" + allMerchandiseVo.getOrderByAsc() + "&levelName=" + URLEncoder.encode(levelName, "utf-8") + "&storeId=" + ((MemberInfoModel)singleMemberModel.getData()).getOpenCardStoreId() + "&sysCompanyId=" + ((MemberInfoModel)singleMemberModel.getData()).getSysCompanyId()));
            log.info("tailForClassifiedGoods={}", (Object)JSON.toJSONString((Object)tailForClassifiedGoods));
            if (StringUtils.isNotBlank((CharSequence)tailForClassifiedGoods)) {
                JSONArray objects = JSON.parseArray((String)tailForClassifiedGoods);
                storeVos = new ArrayList();
                for (int i = 0; i < objects.size(); ++i) {
                    JSONObject jsonObject = objects.getJSONObject(i);
                    String goodsNo = jsonObject.getString("goodsNo");
                    String goodsName = jsonObject.getString("goodsName");
                    String coverImg = jsonObject.getString("coverImg");
                    String price = jsonObject.getString("price");
                    String upperShelfTime = jsonObject.getString("upperShelfTime");
                    String id = jsonObject.getString("id");
                    Integer totalStock = jsonObject.getInteger("totalStock");
                    String actualSales = jsonObject.getString("actualSales");
                    String priceType = jsonObject.getString("priceType");
                    String cashPrice = jsonObject.getString("cashPrice");
                    String mbrLevelStatus = jsonObject.getString("mbrLevelStatus");
                    String clubId = jsonObject.getString("clubId");
                    String secondPrice = jsonObject.getString("secondPrice");
                    String secondCashPrice = jsonObject.getString("secondCashPrice");
                    String videoUrl = jsonObject.getString("videoUrl");
                    String videoPictureUrl = jsonObject.getString("videoPictureUrl");
                    String isSaleFlag = jsonObject.getString("isSaleFlag");
                    String dayEndTime = jsonObject.getString("dayEndTime");
                    String dayStartTime = jsonObject.getString("dayStartTime");
                    String saleTimeCycle = jsonObject.getString("saleTimeCycle");
                    String saleScheduled = jsonObject.getString("saleScheduled");
                    String storeType = jsonObject.getString("storeType");
                    String storeLimitList = jsonObject.getString("storeLimitList");
                    String allIntegralNumber = jsonObject.getString("allIntegralNumber");
                    String totalExchangeNumber = jsonObject.getString("totalExchangeNumber");
                    String totalSaleQuantity = jsonObject.getString("totalSaleQuantity");
                    ShopStoreVo shopStoreVo = new ShopStoreVo();
                    shopStoreVo.setShopId(id);
                    shopStoreVo.setGoodsNo(goodsNo);
                    shopStoreVo.setGoodsName(goodsName);
                    shopStoreVo.setCoverImg(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)coverImg));
                    shopStoreVo.setPrice(price);
                    shopStoreVo.setUpperShelfTime(upperShelfTime);
                    shopStoreVo.setActualSales(actualSales);
                    shopStoreVo.setTotalStock(totalStock);
                    shopStoreVo.setCashPrice(cashPrice);
                    shopStoreVo.setPriceType(priceType);
                    shopStoreVo.setExchangeClubId(clubId);
                    shopStoreVo.setSecondCashPrice(secondCashPrice);
                    shopStoreVo.setSecondPrice(secondPrice);
                    shopStoreVo.setVideoUrl(videoUrl);
                    shopStoreVo.setVideoPictureUrl(videoPictureUrl);
                    shopStoreVo.setIsSaleFlag(Integer.valueOf(Objects.isNull(isSaleFlag) ? 1 : Integer.parseInt(isSaleFlag)));
                    shopStoreVo.setDayEndTime(Objects.isNull(dayEndTime) ? null : Long.valueOf(dayEndTime));
                    shopStoreVo.setDayStartTime(Objects.isNull(dayStartTime) ? null : Long.valueOf(dayStartTime));
                    shopStoreVo.setSaleScheduled(Objects.isNull(saleScheduled) ? null : Integer.valueOf(saleScheduled));
                    shopStoreVo.setSaleTimeCycle(saleTimeCycle);
                    shopStoreVo.setStoreType(Objects.isNull(storeType) ? null : Integer.valueOf(storeType));
                    shopStoreVo.setStoreLimitList(storeLimitList);
                    shopStoreVo.setTotalExchangeNumber(totalExchangeNumber);
                    shopStoreVo.setTotalSaleQuantity(totalSaleQuantity);
                    shopStoreVo.setAllIntegralNumber(allIntegralNumber);
                    if (StringUtils.isNotBlank((CharSequence)mbrLevelStatus) && Boolean.valueOf(mbrLevelStatus).booleanValue()) {
                        shopStoreVo.setMbrLevelStatus(Boolean.valueOf(mbrLevelStatus));
                    } else {
                        shopStoreVo.setMbrLevelStatus(Boolean.valueOf(false));
                    }
                    storeVos.add(shopStoreVo);
                }
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                Result notDisplayGoods = this.integralActivityRpcService.queryNotDisplayGoods(IntegralActivityGoodsTypeEnum.GOODS);
                if (notDisplayGoods.isSuccess() && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)((Collection)notDisplayGoods.getData()))) {
                    log.info("IntegrationShopServiceImpl.tailForClassifiedGoods-if notDisplayGoods:{}", notDisplayGoods.getData());
                    List data = (List)notDisplayGoods.getData();
                    storeVos = storeVos.stream().filter(storeVo -> !data.contains(Long.valueOf(storeVo.getShopId()))).collect(Collectors.toList());
                }
            } else {
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                responseData.setData((Object)tailForClassifiedGoods);
                return responseData;
            }
            responseData.setData(storeVos);
            return responseData;
        }
        catch (Exception e) {
            log.info("tailForClassifiedGoods={}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public ResponseData<ActivitySubjectResVO> activitySubjectGoods(AllMerchandiseVo allMerchandiseVo) {
        ResponseData responseData = new ResponseData();
        try {
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setMemberCode(allMerchandiseVo.getMemberCode());
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            if (singleMemberModel.getData() == null) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
                return responseData;
            }
            ActivitySubjectRequestVO activitySubjectRequestVO = new ActivitySubjectRequestVO();
            activitySubjectRequestVO.setPageNum(allMerchandiseVo.getPageNum());
            activitySubjectRequestVO.setPageSize(allMerchandiseVo.getPageSize());
            activitySubjectRequestVO.setIntegralActivityId(allMerchandiseVo.getIntegralActivityId());
            com.wmeimob.fastboot.bizvane.utils.response.ResponseData activitySubjectResponseVOResponseData = this.integralActivityRpcService.activitySubjectGoods(activitySubjectRequestVO);
            ActivitySubjectResponseVO activitySubjectResponseVO = (ActivitySubjectResponseVO)activitySubjectResponseVOResponseData.getData();
            if (activitySubjectResponseVOResponseData.getCode() != SysResponseEnum.SUCCESS.getCode() || activitySubjectResponseVO == null) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(SysResponseEnum.FAILED.getMessage());
                return responseData;
            }
            IntegralActivityPOWithBLOBs activeActivity = activitySubjectResponseVO.getActiveActivity();
            if (activeActivity == null || activeActivity.getValid() == null || !activeActivity.getValid().booleanValue()) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u6d3b\u52a8\u5df2\u7ed3\u675f");
                return responseData;
            }
            Date date = new Date();
            if (activeActivity.getBeginTime().compareTo(date) > 0) {
                log.info("activitySubjectGoods activeActivity time is less than beginTime");
                responseData.setCode(SysBusinessResponseEnum.CUSTOM_RESPONSE.getCode());
                responseData.setMessage("\u5f88\u62b1\u6b49\uff0c\u6d3b\u52a8\u8fd8\u6ca1\u5f00\u59cb \u8bf7\u8010\u5fc3\u7b49\u5f85\u54e6\uff5e");
                return responseData;
            }
            if (activeActivity.getEndTime().compareTo(date) < 0) {
                log.info("activitySubjectGoods activeActivity time is greater than endTime");
                responseData.setCode(SysBusinessResponseEnum.CUSTOM_RESPONSE.getCode());
                responseData.setMessage("\u5f88\u62b1\u6b49\uff0c\u6d3b\u52a8\u5df2\u7ecf\u7ed3\u675f\u4e86 \u66f4\u591a\u7cbe\u5f69\u6d3b\u52a8\uff0c\u671f\u5f85\u60a8\u7684\u53c2\u4e0e");
                return responseData;
            }
            ActivitySubjectResVO activitySubjectResVO = new ActivitySubjectResVO();
            activitySubjectResVO.setActiveActivity(activeActivity);
            PageInfo storeVoPageInfo = this.pageMergeShopStoreVo(activitySubjectResponseVO.getPageInfo());
            activitySubjectResVO.setStoreVos(storeVoPageInfo);
            responseData.setData((Object)activitySubjectResVO);
            return responseData;
        }
        catch (Exception e) {
            log.info("tailForClassifiedGoods={}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public PageInfo<ShopStoreVo> pageMergeShopStoreVo(PageInfo<IntegralGoods> source) {
        List list = source.getList();
        ArrayList<ShopStoreVo> storeVos = new ArrayList<ShopStoreVo>();
        for (int i = 0; i < list.size(); ++i) {
            IntegralGoods integralGoods = (IntegralGoods)list.get(i);
            ShopStoreVo shopStoreVo = new ShopStoreVo();
            shopStoreVo.setShopId(integralGoods.getId().toString());
            shopStoreVo.setGoodsNo(integralGoods.getGoodsNo());
            shopStoreVo.setGoodsName(integralGoods.getGoodsName());
            shopStoreVo.setCoverImg(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)integralGoods.getCoverImg()));
            shopStoreVo.setPrice(integralGoods.getPrice().toString());
            shopStoreVo.setUpperShelfTime(integralGoods.getUpperShelfTime().toString());
            shopStoreVo.setActualSales(integralGoods.getActualSales().toString());
            shopStoreVo.setTotalStock(integralGoods.getTotalStock());
            shopStoreVo.setCashPrice(integralGoods.getCashPrice().toString());
            shopStoreVo.setPriceType(integralGoods.getPriceType());
            shopStoreVo.setExchangeClubId(integralGoods.getClubId());
            if (integralGoods.getMbrLevelStatus() != null) {
                shopStoreVo.setMbrLevelStatus(integralGoods.getMbrLevelStatus());
            } else {
                shopStoreVo.setMbrLevelStatus(Boolean.valueOf(false));
            }
            storeVos.add(shopStoreVo);
        }
        PageInfo storeVoPageInfo = new PageInfo();
        storeVoPageInfo.setPageNum(source.getPageNum());
        storeVoPageInfo.setPageSize(source.getPageSize());
        storeVoPageInfo.setSize(source.getSize());
        storeVoPageInfo.setStartRow(source.getStartRow());
        storeVoPageInfo.setEndRow(source.getEndRow());
        storeVoPageInfo.setPages(source.getPages());
        storeVoPageInfo.setPrePage(source.getPrePage());
        storeVoPageInfo.setNextPage(source.getNextPage());
        storeVoPageInfo.setIsFirstPage(source.isIsFirstPage());
        storeVoPageInfo.setIsLastPage(source.isIsLastPage());
        storeVoPageInfo.setHasPreviousPage(source.isHasPreviousPage());
        storeVoPageInfo.setHasNextPage(source.isHasNextPage());
        storeVoPageInfo.setNavigatePages(source.getNavigatePages());
        storeVoPageInfo.setNavigatepageNums(source.getNavigatepageNums());
        storeVoPageInfo.setNavigateFirstPage(source.getNavigateFirstPage());
        storeVoPageInfo.setNavigateLastPage(source.getNavigateLastPage());
        storeVoPageInfo.setTotal(source.getTotal());
        storeVoPageInfo.setList(storeVos);
        return storeVoPageInfo;
    }

    public ResponseData generateOrder(HttpServletRequest request, ConfirmGoodsVo confirmGoodsVo) {
        return this.generateOrderWithLable(request, confirmGoodsVo, Boolean.TRUE);
    }

    private ResponseData generateOrderWithLable(HttpServletRequest request, ConfirmGoodsVo confirmGoodsVo, Boolean checkLable) {
        ResponseData responseData = new ResponseData();
        String memberCode = confirmGoodsVo.getMemberCode();
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        log.info("\u79ef\u5206\u751f\u6210\u8ba2\u5355generateOrder\u7684memberCode:{},\u83b7\u53d6crm\u7528\u6237\u4fe1\u606f\u4e3a:{}", (Object)memberCode, JSON.toJSON((Object)singleMemberModel));
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        log.info("\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2SingleMemberModel\u8fd4\u56de:[{}]", JSON.toJSON((Object)singleMemberModel));
        String phone = ((MemberInfoModel)singleMemberModel.getData()).getPhone();
        String name = ((MemberInfoModel)singleMemberModel.getData()).getName();
        String cardNo = ((MemberInfoModel)singleMemberModel.getData()).getCardNo();
        Long brandId = ((MemberInfoModel)singleMemberModel.getData()).getBrandId();
        Long sysCompanyId = ((MemberInfoModel)singleMemberModel.getData()).getSysCompanyId();
        Long openCardStoreId = ((MemberInfoModel)singleMemberModel.getData()).getOpenCardStoreId();
        Long levelId = ((MemberInfoModel)singleMemberModel.getData()).getLevelId();
        String gender = ((MemberInfoModel)singleMemberModel.getData()).getGender();
        confirmGoodsVo.setMemberCode(memberCode);
        confirmGoodsVo.setMemberPhone(phone);
        confirmGoodsVo.setMemberName(name);
        confirmGoodsVo.setMemberCardNo(cardNo);
        confirmGoodsVo.setSysBrandId(String.valueOf(brandId));
        confirmGoodsVo.setSysCompanyId(sysCompanyId);
        MemberInfoModel memberInfoModelSearch = new MemberInfoModel();
        memberInfoModelSearch.setMemberCode(memberCode);
        ResponseData modelResponseData = this.memberInfoApiService.getSingleMemberModel(memberInfoModelSearch);
        log.info("\u79ef\u5206\u5151\u6362\u5238\u83b7\u53d6crm\u7684memberCode:{},\u7528\u6237\u4fe1\u606f:{}", (Object)memberCode, JSON.toJSON((Object)modelResponseData));
        MemberInfoModel masterMemberInfo = (MemberInfoModel)modelResponseData.getData();
        String redisJsonString = "";
        if (confirmGoodsVo.getActivityId() == null) {
            redisJsonString = (String)this.redisTemplateService.stringGetStringByKey((Object)("integrationShopGoodId:" + confirmGoodsVo.getGoodId()));
        } else {
            log.info("IntegrationShopServiceImpl|generateOrder|activityCreateOrder|confirmGoodsVo:{}", (Object)JSONObject.toJSONString((Object)confirmGoodsVo));
            redisJsonString = (String)this.redisTemplateService.stringGetStringByKey((Object)("integralActivity_integrationShopGoodId:" + confirmGoodsVo.getGoodId()));
            log.info("IntegrationShopServiceImpl|generateOrder|activityCreateOrder|redisJsonString:{}", (Object)redisJsonString);
        }
        if (StringUtils.isEmpty((CharSequence)redisJsonString)) {
            responseData.setMessage("\u7f51\u7edc\u5f02\u5e38,\u5237\u65b0\u5f53\u524d\u9875\u9762\u91cd\u8bd5");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        ShopStoreVo shopStoreVo = (ShopStoreVo)JSON.parseObject((String)redisJsonString, ShopStoreVo.class);
        String clubId = shopStoreVo.getExchangeClubId();
        List mbrLevelModelList = shopStoreVo.getMbrLevelModelList();
        if (!StringUtils.isEmpty((CharSequence)clubId)) {
            List mbrLevelIds;
            boolean notEmptyList = !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)mbrLevelModelList);
            MemberInfoModel memberInfoModelClub = this.vgLoginService.simpleJoinClub(request, masterMemberInfo, Long.valueOf(clubId));
            if (memberInfoModelClub == null) {
                responseData.setMessage(SysResponseEnum.FAILED.getMessage());
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                return responseData;
            }
            if (notEmptyList && !(mbrLevelIds = mbrLevelModelList.stream().map(MbrLevelModel::getMbrLevelId).collect(Collectors.toList())).contains(memberInfoModelClub.getLevelId())) {
                responseData.setMessage(SysBusinessResponseEnum.BUSINESS_DEFINED_CODE_NOT_EXCHANGE_ALLOWED.getMessage());
                responseData.setCode(SysBusinessResponseEnum.BUSINESS_DEFINED_CODE_NOT_EXCHANGE_ALLOWED.getCode());
                return responseData;
            }
        }
        confirmGoodsVo.setSysBrandId(masterMemberInfo.getBrandId().toString());
        confirmGoodsVo.setSysCompanyId(masterMemberInfo.getSysCompanyId());
        if (confirmGoodsVo.getActivityId() != null && checkLable.booleanValue() && !this.checkMemberLabelMatchNew(confirmGoodsVo, memberCode).booleanValue()) {
            responseData.setMessage(SysBusinessResponseEnum.BUSINESS_DEFINED_CODE_NOT_LABEl_ALLOWED.getMessage());
            responseData.setCode(SysBusinessResponseEnum.BUSINESS_DEFINED_CODE_NOT_LABEl_ALLOWED.getCode());
            return responseData;
        }
        Integer countIntegral = ((MemberInfoModel)singleMemberModel.getData()).getCountIntegral();
        if (StringUtils.isBlank((CharSequence)confirmGoodsVo.getPriceType())) {
            responseData.setMessage("\u652f\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            responseData.setCode(100);
            return responseData;
        }
        if (!IntegralGoodsPriceTypeEnum.CASH.getType().equals(confirmGoodsVo.getPriceType())) {
            if (IntegralGoodsPriceTypeEnum.INTEGRAL_AND_CASH.getType().equals(confirmGoodsVo.getPriceType()) && StringUtils.isNotEmpty((CharSequence)confirmGoodsVo.getSecondPrice()) && Integer.valueOf(confirmGoodsVo.getSecondPrice()) > countIntegral) {
                responseData.setMessage("\u60a8\u7684\u79ef\u5206\u597d\u50cf\u4e0d\u591f\u4e86\u54e6");
                responseData.setCode(100);
                return responseData;
            }
            if (IntegralGoodsPriceTypeEnum.INTEGRAL.getType().equals(confirmGoodsVo.getPriceType()) && Integer.valueOf(confirmGoodsVo.getSaleIntegral()) > countIntegral) {
                responseData.setMessage("\u60a8\u7684\u79ef\u5206\u597d\u50cf\u4e0d\u591f\u4e86\u54e6");
                responseData.setCode(100);
                return responseData;
            }
        }
        if (confirmGoodsVo.getActivityId() != null) {
            return this.createOrder(confirmGoodsVo, masterMemberInfo);
        }
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Content-Type", "application/json");
            HashMap<String, String> stringMap = new HashMap<String, String>();
            stringMap.put("merchantId", confirmGoodsVo.getSysBrandId());
            stringMap.put("sysCompanyId", confirmGoodsVo.getSysCompanyId() + "");
            stringMap.put("memberCode", confirmGoodsVo.getMemberCode());
            stringMap.put("memberCardNo", confirmGoodsVo.getMemberCardNo());
            stringMap.put("memberGender", gender);
            stringMap.put("memberName", confirmGoodsVo.getMemberName());
            stringMap.put("memberPhone", confirmGoodsVo.getMemberPhone());
            stringMap.put("goodId", confirmGoodsVo.getGoodId());
            stringMap.put("goodNo", confirmGoodsVo.getGoodNo());
            stringMap.put("shippingName", confirmGoodsVo.getShippingName());
            stringMap.put("shippingMobile", confirmGoodsVo.getShippingMobile());
            stringMap.put("shippingProvince", confirmGoodsVo.getShippingProvince());
            stringMap.put("shippingCity", confirmGoodsVo.getShippingCity());
            stringMap.put("shippingDistrict", confirmGoodsVo.getShippingDistrict());
            stringMap.put("shippingAddress", confirmGoodsVo.getShippingAddress());
            stringMap.put("userComments", confirmGoodsVo.getUserComments());
            stringMap.put("goodSkuNo", confirmGoodsVo.getGoodSkuNo());
            stringMap.put("goodSkuSpecNames", confirmGoodsVo.getGoodSkuSpecNames());
            stringMap.put("saleQuantity", confirmGoodsVo.getSaleQuantity());
            stringMap.put("orderType", confirmGoodsVo.getOrderType());
            stringMap.put("openId", confirmGoodsVo.getOpenId());
            stringMap.put("templateId", confirmGoodsVo.getTemplateId());
            stringMap.put("priceType", confirmGoodsVo.getPriceType());
            stringMap.put("orderRemark", confirmGoodsVo.getOrderRemark());
            stringMap.put("exchangeStatus", StringUtils.isEmpty((CharSequence)confirmGoodsVo.getExchangeStatus()) ? "0" : confirmGoodsVo.getExchangeStatus());
            stringMap.put("exchangeCount", StringUtils.isEmpty((CharSequence)confirmGoodsVo.getExchangeCount()) ? "0" : confirmGoodsVo.getExchangeCount());
            if (!org.springframework.util.StringUtils.isEmpty((Object)confirmGoodsVo.getSelfPickTime())) {
                stringMap.put("selfPickTimeStr", confirmGoodsVo.getSelfPickTime());
            }
            ResponseData configData = this.integrationShopService.getConfig(Integer.valueOf(Integer.parseInt(confirmGoodsVo.getSysBrandId())));
            log.info("\u6240\u83b7\u53d6\u7684\u914d\u7f6e:{}", (Object)JSONObject.toJSONString((Object)configData));
            Object data = configData.getData();
            JSONObject json = (JSONObject)JSON.toJSON((Object)data);
            String isDeliverCheck = json.getString("isDeliverCheck");
            String deliverAuditorMark = json.getString("deliverAuditorMark");
            if (!StringUtils.isEmpty((CharSequence)isDeliverCheck) && 1 == Integer.parseInt(isDeliverCheck)) {
                log.info("\u6267\u884c\u4e86\u9700\u8981\u53d1\u8d27\u903b\u8f91=======:{}", (Object)JSONObject.toJSONString((Object)isDeliverCheck));
                stringMap.put("isDeliverCheck", "1");
                stringMap.put("deliverAuditorMark", deliverAuditorMark);
            } else {
                log.info("\u6267\u884c\u4e86\u4e0d\u9700\u8981\u53d1\u8d27\u903b\u8f91====:{}", (Object)JSONObject.toJSONString((Object)isDeliverCheck));
                stringMap.put("isDeliverCheck", "0");
            }
            if (levelId != null) {
                ResponseData mbrLevelModelResponseData = this.memberLevelApiService.queryLevelModel(levelId);
                String levelName = ((MbrLevelModel)mbrLevelModelResponseData.getData()).getLevelName();
                stringMap.put("levelName", levelName);
            }
            String storeCode = "";
            if (StringUtils.isNotEmpty((CharSequence)confirmGoodsVo.getStoreId())) {
                ResponseData codeById = this.storeServiceRpc.getStoreCodeById(Long.valueOf(confirmGoodsVo.getStoreId()));
                storeCode = (String)codeById.getData();
                ResponseData distributorNameResponseData = this.storeServiceRpc.getDistributorName(Long.valueOf(confirmGoodsVo.getStoreId()));
                log.info("generateOrder#distributorNameResponseData#814:{}", (Object)JSON.toJSONString((Object)distributorNameResponseData));
                if (distributorNameResponseData.getData() != null) {
                    String distributorName = distributorNameResponseData.getData().toString();
                    stringMap.put("distributorName", distributorName);
                }
            }
            stringMap.put("storeCode", storeCode);
            stringMap.put("storeName", confirmGoodsVo.getStoreName());
            stringMap.put("storeId", confirmGoodsVo.getStoreId());
            log.info("generateOrder={}", (Object)JSON.toJSONString(stringMap));
            String generateOrder = HttpUtil.post((String)(this.DOMAINNAME + GENERATEORDEER), (String)JSON.toJSONString(stringMap), map);
            JSONObject jsonObject = JSON.parseObject((String)generateOrder);
            String code = jsonObject.getString("code");
            String msg = jsonObject.getString("msg");
            String orderNo = jsonObject.getString("data");
            log.info("generateOrderResult={}", (Object)generateOrder);
            if ("0".equals(code)) {
                if (StringUtils.isNotEmpty((CharSequence)confirmGoodsVo.getStoreId())) {
                    StoreOrderInformVO soiVO = new StoreOrderInformVO();
                    soiVO.setMemberName(confirmGoodsVo.getMemberName());
                    soiVO.setMemberPhone(confirmGoodsVo.getMemberPhone());
                    soiVO.setOrderDate(this.sdf.format(new Date()));
                    soiVO.setOrderNo(orderNo);
                    soiVO.setStoreName(confirmGoodsVo.getStoreName());
                    soiVO.setSysBrandId(((MemberInfoModel)singleMemberModel.getData()).getBrandId());
                    soiVO.setSysCompanyId(((MemberInfoModel)singleMemberModel.getData()).getSysCompanyId());
                    soiVO.setSysStoreId(Long.valueOf(confirmGoodsVo.getStoreId()));
                    soiVO.setSysStoreOfflineCode(storeCode);
                    log.info("memberInfoModel={}", (Object)((MemberInfoModel)singleMemberModel.getData()).getSysCompanyId());
                    log.info("\u901a\u77e5\u4f01\u5fae\u63a5\u53e3\u5165\u53c2{}", (Object)JSON.toJSONString((Object)soiVO));
                }
                JSONObject dataJson = jsonObject.getJSONObject("data");
                responseData.setData((Object)dataJson);
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                return responseData;
            }
            responseData.setMessage(msg);
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        catch (Exception e) {
            log.info("\u8fdb\u5165Exception20191230");
            log.error(e.getMessage(), (Throwable)e);
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
    }

    private Boolean checkMemberLabelMatch(ConfirmGoodsVo confirmGoodsVo, String memberCode) {
        try {
            com.wmeimob.fastboot.bizvane.utils.response.ResponseData goodsInfo = this.integralGoodsRpcService.getGoodsInfo(Integer.valueOf(confirmGoodsVo.getGoodId()));
            IntegralGoods integralGoods = (IntegralGoods)goodsInfo.getData();
            if (goodsInfo.getCode() != SysResponseEnum.SUCCESS.getCode() || integralGoods == null) {
                log.info("checkMemberLabelMatch integralGoods is null");
                return Boolean.FALSE;
            }
            Boolean activityJudge = integralGoods.getActivityJudge();
            if (!activityJudge.booleanValue()) {
                log.info("checkMemberLabelMatch activityJudge is false,return");
                return Boolean.TRUE;
            }
            com.wmeimob.fastboot.bizvane.utils.response.ResponseData activeActivityMatchResponse = this.integralActivityRpcService.checkActiveActivityMatchAnyGoodsId(Long.valueOf(confirmGoodsVo.getGoodId()));
            Boolean matchActivity = (Boolean)activeActivityMatchResponse.getData();
            if (activeActivityMatchResponse.getCode() != SysResponseEnum.SUCCESS.getCode() || matchActivity == null) {
                log.info("checkMemberLabelMatch checkActiveActivityMatchAnyGoodsId is null");
                return Boolean.FALSE;
            }
            log.info("checkMemberLabelMatch matchActivity is :{}", (Object)matchActivity);
            if (!matchActivity.booleanValue()) {
                log.info("checkMemberLabelMatch matchActivity is not match");
                return Boolean.FALSE;
            }
            Long sysBrandId = Long.valueOf(confirmGoodsVo.getSysBrandId());
            com.wmeimob.fastboot.bizvane.utils.response.ResponseData activeActivityOne = this.integralActivityRpcService.getActiveActivityOne(sysBrandId);
            IntegralActivityPOWithBLOBs enableIntegralActivity = (IntegralActivityPOWithBLOBs)activeActivityOne.getData();
            if (activeActivityOne.getCode() != SysResponseEnum.SUCCESS.getCode() || enableIntegralActivity == null) {
                log.info("checkMemberLabelMatch enableIntegralActivity is null");
                return Boolean.FALSE;
            }
            com.wmeimob.fastboot.bizvane.utils.response.ResponseData enableActivityMatchResponse = this.integralActivityRpcService.checkActiveActivityMatchGoodsId(enableIntegralActivity.getIntegralActivityId(), Long.valueOf(confirmGoodsVo.getGoodId()));
            Boolean enableMatchActivity = (Boolean)enableActivityMatchResponse.getData();
            if (enableActivityMatchResponse.getCode() != SysResponseEnum.SUCCESS.getCode() || enableMatchActivity == null) {
                log.info("checkMemberLabelMatch checkActiveActivityMatchGoodsId is null");
                return Boolean.FALSE;
            }
            if (!enableMatchActivity.booleanValue()) {
                log.info("checkMemberLabelMatch enableMatchActivity is false");
                return Boolean.FALSE;
            }
            if (enableIntegralActivity.getBeginTime() == null || enableIntegralActivity.getEndTime() == null) {
                log.info("checkMemberLabelMatch activity beginTime and endTime is any null");
                return Boolean.FALSE;
            }
            int matchDate = this.localHandwrittenMapper.queryBetweenTwoDate(enableIntegralActivity.getBeginTime(), enableIntegralActivity.getEndTime());
            if (matchDate == 0) {
                log.info("checkMemberLabelMatch matchDate is 0 , not need check autolabel");
                return Boolean.FALSE;
            }
            MembersInfoSearchVo membersInfoSearchVo = new MembersInfoSearchVo();
            membersInfoSearchVo.setMemberCode(memberCode);
            Byte activityRange = enableIntegralActivity.getActivityRange();
            if (activityRange == null) {
                log.info("checkMemberLabelMatch activityRange is null");
                return Boolean.FALSE;
            }
            if (activityRange == 0) {
                log.info("checkMemberLabelMatch activityRange is 0");
                return Boolean.TRUE;
            }
            membersInfoSearchVo.setAutoLabel(Boolean.TRUE);
            membersInfoSearchVo.setAutoLabelIdList(Arrays.asList(enableIntegralActivity.getAutoLabelId()));
            membersInfoSearchVo.setPageNumber(Integer.valueOf(1));
            membersInfoSearchVo.setPageSize(Integer.valueOf(1));
            membersInfoSearchVo.setBrandId(Long.valueOf(confirmGoodsVo.getSysBrandId()));
            membersInfoSearchVo.setSysCompanyId(confirmGoodsVo.getSysCompanyId());
            ResponseData pageInfoResponseData = this.memberInfoApiService.vgSearch(membersInfoSearchVo);
            log.info("checkMemberLabelMatch vgSearch:{}", (Object)JSON.toJSONString((Object)pageInfoResponseData));
            com.bizvane.utils.responseinfo.PageInfo memberInfoVoPageInfo = (com.bizvane.utils.responseinfo.PageInfo)pageInfoResponseData.getData();
            if (activeActivityOne.getCode() != SysResponseEnum.SUCCESS.getCode() || memberInfoVoPageInfo == null) {
                log.info("checkMemberLabelMatch pageInfoResponseData is null");
                return Boolean.FALSE;
            }
            List memberInfoVoList = memberInfoVoPageInfo.getList();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)memberInfoVoList)) {
                log.info("checkMemberLabelMatch memberInfoVoList is null");
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            log.info("checkMemberLabelMatch_error:{}", (Throwable)e);
            return Boolean.FALSE;
        }
    }

    public Boolean checkMemberLabelMatchNew(ConfirmGoodsVo confirmGoodsVo, String memberCode) {
        try {
            ActivityRequestRpcVO rpcVO = new ActivityRequestRpcVO();
            rpcVO.setActivityId(confirmGoodsVo.getActivityId());
            Result activityRpc = this.integralActivityRpcService.getActivityByActivityId(rpcVO);
            if (activityRpc == null || !activityRpc.isSuccess() || activityRpc.getData() == null) {
                log.error("checkMemberLabelMatch integralGoods is null");
                return Boolean.FALSE;
            }
            IntegralActivityPOWithBLOBs enableIntegralActivity = ((ActivityResponseRpcVO)activityRpc.getData()).getActiveActivity();
            if (!this.checkActivity(enableIntegralActivity).booleanValue()) {
                log.info("checkMemberLabelMatch checkActivity is not started");
                return Boolean.FALSE;
            }
            Byte activityRange = enableIntegralActivity.getActivityRange();
            if (activityRange == null) {
                log.info("checkMemberLabelMatch activityRange is null");
                return Boolean.FALSE;
            }
            if (activityRange == 0) {
                log.info("checkMemberLabelMatch activityRange is 0");
                return Boolean.TRUE;
            }
            MembersInfoSearchVo membersInfoSearchVo = new MembersInfoSearchVo();
            membersInfoSearchVo.setMemberCode(memberCode);
            membersInfoSearchVo.setAutoLabel(Boolean.TRUE);
            membersInfoSearchVo.setAutoLabelIdList((List)Lists.newArrayList((Object[])new Long[]{enableIntegralActivity.getAutoLabelId()}));
            membersInfoSearchVo.setPageNumber(Integer.valueOf(1));
            membersInfoSearchVo.setPageSize(Integer.valueOf(1));
            membersInfoSearchVo.setBrandId(Long.valueOf(confirmGoodsVo.getSysBrandId()));
            membersInfoSearchVo.setSysCompanyId(confirmGoodsVo.getSysCompanyId());
            ResponseData pageInfoResponseData = this.memberInfoApiService.vgSearch(membersInfoSearchVo);
            log.info("checkMemberLabelMatch vgSearch:{}", (Object)JSON.toJSONString((Object)pageInfoResponseData));
            com.bizvane.utils.responseinfo.PageInfo memberInfoVoPageInfo = (com.bizvane.utils.responseinfo.PageInfo)pageInfoResponseData.getData();
            if (SysResponseEnum.SUCCESS.getCode() != pageInfoResponseData.getCode() || memberInfoVoPageInfo == null || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)memberInfoVoPageInfo.getList())) {
                log.info("checkMemberLabelMatch memberInfoVo is null");
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            log.error("checkMemberLabelMatch_error:{},{}", (Object)e.getMessage(), (Object)e);
            return Boolean.FALSE;
        }
    }

    private Boolean checkActivity(IntegralActivityPOWithBLOBs integralActivity) {
        Date date;
        if (integralActivity.getActivityStatus().booleanValue() && (date = LocalDateTime.now().toDate()).compareTo(integralActivity.getBeginTime()) >= 0 && date.compareTo(integralActivity.getEndTime()) <= 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private ResponseData createOrder(ConfirmGoodsVo confirmGoodsVo, MemberInfoModel masterMemberInfo) {
        ResponseData responseData = new ResponseData();
        try {
            log.info("createOrder confirmGoodsVo:{}, masterMemberInfo:{}", (Object)JSONObject.toJSONString((Object)confirmGoodsVo), (Object)JSONObject.toJSONString((Object)masterMemberInfo));
            ActivityRequestRpcVO searchVO = new ActivityRequestRpcVO();
            searchVO.setActivityId(confirmGoodsVo.getActivityId());
            IntegralOrders orders = this.seckillActivityService.buildIntegralOrder(confirmGoodsVo, masterMemberInfo);
            searchVO.setIntegralOrders(orders);
            log.info("IntegrationShopServiceImpl|createOrder:{}", (Object)JSONObject.toJSONString((Object)searchVO));
            Result result = this.integralActivityRpcService.createOrder(searchVO);
            if (result.isSuccess()) {
                responseData.setData(result.getData());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            } else {
                responseData.setCode(result.getCode());
                responseData.setMessage(result.getMessage());
            }
            return responseData;
        }
        catch (Exception e) {
            log.error("IntegrationShopServiceImpl.createOrder.error:{},{}", (Object)e.getMessage(), (Object)e);
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public ResponseData generateOrderCheckLable(HttpServletRequest request, ConfirmGoodsVo confirmGoodsVo) {
        return this.generateOrderWithLable(request, confirmGoodsVo, Boolean.TRUE);
    }

    public ResponseData inventoryStatus(ConfirmGoodsVo confirmGoodsVo) {
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)confirmGoodsVo.getGoodNo())) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u8bf7\u8f93\u5165\u5546\u54c1\u7f16\u53f7");
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)confirmGoodsVo.getGoodSkuNo())) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u8bf7\u9009\u62e9\u89c4\u683c");
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)confirmGoodsVo.getSaleQuantity())) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u8bf7\u8f93\u5165\u5151\u6362\u6570\u91cf");
            return responseData;
        }
        try {
            ShopStoreVo shopStoreVo = new ShopStoreVo();
            String commodityDetails = HttpUtil.get((String)(this.DOMAINNAME + COMMODITYDETAILS + confirmGoodsVo.getGoodId()));
            log.info("commodityDetails={}", (Object)JSON.toJSONString((Object)commodityDetails));
            JSONObject commodityDetailsJson = JSON.parseObject((String)commodityDetails);
            String id = commodityDetailsJson.getString("id");
            String goodsNo = commodityDetailsJson.getString("goodsNo");
            String goodsName = commodityDetailsJson.getString("goodsName");
            String shelf = commodityDetailsJson.getString("shelf");
            String classifyId = commodityDetailsJson.getString("classifyId");
            String coverImg = commodityDetailsJson.getString("coverImg");
            String bannerImgPaths = commodityDetailsJson.getString("bannerImgPaths");
            String hot = commodityDetailsJson.getString("hot");
            String price = commodityDetailsJson.getString("price");
            String upperShelfTime = commodityDetailsJson.getString("upperShelfTime");
            String restrictedNum = commodityDetailsJson.getString("restrictedNum");
            String actualSales = commodityDetailsJson.getString("actualSales");
            String distributionMode = commodityDetailsJson.getString("distributionMode");
            String saleQuantity = confirmGoodsVo.getSaleQuantity();
            log.info("saleQuantity={}", (Object)saleQuantity);
            log.info("restrictedNum={}", (Object)restrictedNum);
            if (Integer.valueOf(saleQuantity) > Integer.valueOf(restrictedNum)) {
                responseData.setMessage("\u6bcf\u5355\u9650\u5151" + restrictedNum + "\u4ef6");
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                return responseData;
            }
            shopStoreVo.setShopId(id);
            shopStoreVo.setGoodsNo(goodsNo);
            shopStoreVo.setGoodsName(goodsName);
            shopStoreVo.setShelf(shelf);
            shopStoreVo.setClassifyId(classifyId);
            shopStoreVo.setCoverImg(coverImg);
            String[] split = bannerImgPaths.split(",");
            ArrayList<String> stringList = new ArrayList<String>();
            for (String splits : split) {
                String splitsDome = QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)splits);
                stringList.add(splitsDome);
            }
            shopStoreVo.setBannerImgPaths(stringList);
            shopStoreVo.setHot(hot);
            shopStoreVo.setPrice(price);
            shopStoreVo.setUpperShelfTime(upperShelfTime);
            shopStoreVo.setRestrictedNum(restrictedNum);
            shopStoreVo.setActualSales(actualSales);
            shopStoreVo.setDistributionMode(distributionMode);
            String jsonString = commodityDetailsJson.getString("skus");
            if (StringUtils.isNotBlank((CharSequence)jsonString)) {
                JSONArray skus = commodityDetailsJson.getJSONArray("skus");
                ArrayList<ShopStoreSkuVo> shopStoreSkuVos = new ArrayList<ShopStoreSkuVo>();
                for (int i = 0; i < skus.size(); ++i) {
                    ShopStoreSkuVo shopStoreSkuVo = new ShopStoreSkuVo();
                    JSONObject skusJSONObject = skus.getJSONObject(i);
                    String skuId = skusJSONObject.getString("id");
                    String goodsId = skusJSONObject.getString("goodsId");
                    String specNames = skusJSONObject.getString("specNames");
                    String specIds = skusJSONObject.getString("specIds");
                    String skuNo = skusJSONObject.getString("skuNo");
                    String skuImg = skusJSONObject.getString("skuImg");
                    String price1 = skusJSONObject.getString("price");
                    String stock = skusJSONObject.getString("stock");
                    String enabled = skusJSONObject.getString("enabled");
                    String quantity = confirmGoodsVo.getSaleQuantity();
                    if (confirmGoodsVo.getGoodSkuId().equals(skuId)) {
                        if (IntegralGoodsPriceTypeEnum.INTEGRAL.getType().equals(confirmGoodsVo.getPriceType())) {
                            ResponseData priceStock = this.checkInventoryStock(skusJSONObject.getString("priceStock"), quantity);
                            if (SysResponseEnum.FAILED.getCode() == priceStock.getCode()) {
                                return priceStock;
                            }
                        } else if (IntegralGoodsPriceTypeEnum.CASH.getType().equals(confirmGoodsVo.getPriceType())) {
                            ResponseData cashPriceStock = this.checkInventoryStock(skusJSONObject.getString("cashPriceStock"), quantity);
                            if (SysResponseEnum.FAILED.getCode() == cashPriceStock.getCode()) {
                                return cashPriceStock;
                            }
                        } else {
                            ResponseData cashBonusStock = this.checkInventoryStock(skusJSONObject.getString("cashBonusStock"), quantity);
                            if (SysResponseEnum.FAILED.getCode() == cashBonusStock.getCode()) {
                                return cashBonusStock;
                            }
                        }
                    }
                    shopStoreSkuVo.setSkuId(skuId);
                    shopStoreSkuVo.setGoodsId(goodsId);
                    shopStoreSkuVo.setSpecNames(specNames);
                    shopStoreSkuVo.setSpecIds(specIds);
                    shopStoreSkuVo.setSkuNo(skuNo);
                    shopStoreSkuVo.setSkuImg(skuImg);
                    shopStoreSkuVo.setSkuPrice(price1);
                    shopStoreSkuVo.setStock(stock);
                    shopStoreSkuVo.setEnabled(enabled);
                    JSONArray goodSkuSpecDetails = skusJSONObject.getJSONArray("goodSkuSpecDetails");
                    ArrayList<GoodSkuSpecDetailsVo> detailsVoList = new ArrayList<GoodSkuSpecDetailsVo>();
                    for (int k = 0; k < goodSkuSpecDetails.size(); ++k) {
                        String uuid = UUIDUtils.getUUID();
                        GoodSkuSpecDetailsVo goodSkuSpecDetailsVo = new GoodSkuSpecDetailsVo();
                        MainSpecVo mainSpecVo = new MainSpecVo();
                        JSONObject detailsJSONObject = goodSkuSpecDetails.getJSONObject(k);
                        JSONObject mainSpec = detailsJSONObject.getJSONObject("mainSpec");
                        String id2 = mainSpec.getString("id");
                        String pid = mainSpec.getString("pid");
                        String specName = mainSpec.getString("specName");
                        mainSpecVo.setMainSpecName(specName);
                        mainSpecVo.setMainSpecPid(pid);
                        mainSpecVo.setMainSpecId(id2);
                        mainSpecVo.setGoodSkuSpecDetailsID(uuid);
                        mainSpecVo.setSkuId(skuId);
                        goodSkuSpecDetailsVo.setSkuId(skuId);
                        goodSkuSpecDetailsVo.setMainSpecVo(mainSpecVo);
                        goodSkuSpecDetailsVo.setGoodSkuSpecDetailsID(uuid);
                        JSONArray childs = detailsJSONObject.getJSONArray("childs");
                        ArrayList<ChildsVo> childsVoList = new ArrayList<ChildsVo>();
                        for (int o = 0; o < childs.size(); ++o) {
                            ChildsVo childsVo = new ChildsVo();
                            JSONObject jsonObject = childs.getJSONObject(o);
                            childsVo.setChildsId(jsonObject.getString("id"));
                            childsVo.setChildsSpecPid(jsonObject.getString("pid"));
                            childsVo.setChildsSpecName(jsonObject.getString("specName"));
                            childsVo.setGoodSkuSpecDetailsID(uuid);
                            childsVo.setSkuId(skuId);
                            childsVoList.add(childsVo);
                        }
                        goodSkuSpecDetailsVo.setChildsVoList(childsVoList);
                        detailsVoList.add(goodSkuSpecDetailsVo);
                    }
                    shopStoreSkuVo.setGoodSkuSpecDetails(detailsVoList);
                    shopStoreSkuVos.add(shopStoreSkuVo);
                    shopStoreVo.setShopStoreSkuVos(shopStoreSkuVos);
                }
            } else {
                shopStoreVo.setShopStoreSkuVos(null);
            }
            String classify = commodityDetailsJson.getString("classifyList");
            if (StringUtils.isNotBlank((CharSequence)classify)) {
                JSONArray classifyList = commodityDetailsJson.getJSONArray("classifyList");
                ArrayList<ShopClassifyMapVo> shopClassifyMapVos = new ArrayList<ShopClassifyMapVo>();
                for (int i = 0; i < classifyList.size(); ++i) {
                    JSONObject classifyListJSONObject = classifyList.getJSONObject(i);
                    ShopClassifyMapVo shopClassifyMapVo = new ShopClassifyMapVo();
                    String id1 = classifyListJSONObject.getString("id");
                    String merchantId = classifyListJSONObject.getString("merchantId");
                    String name = classifyListJSONObject.getString("name");
                    String classifyNo = classifyListJSONObject.getString("classifyNo");
                    String sort = classifyListJSONObject.getString("sort");
                    String classifyDescribe = classifyListJSONObject.getString("classifyDescribe");
                    String classifyImg = classifyListJSONObject.getString("classifyImg");
                    String classifyHome = classifyListJSONObject.getString("classifyHome");
                    String classifyIcon = classifyListJSONObject.getString("classifyIcon");
                    shopClassifyMapVo.setClassID(id1);
                    shopClassifyMapVo.setClassID(merchantId);
                    shopClassifyMapVo.setClassID(name);
                    shopClassifyMapVo.setClassID(classifyNo);
                    shopClassifyMapVo.setClassID(classifyDescribe);
                    shopClassifyMapVo.setClassID(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)classifyImg));
                    shopClassifyMapVo.setClassID(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)classifyHome));
                    shopClassifyMapVo.setClassID(sort);
                    shopClassifyMapVo.setClassID(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)classifyIcon));
                    shopClassifyMapVos.add(shopClassifyMapVo);
                }
                shopStoreVo.setClassifyMapVos(shopClassifyMapVos);
            } else {
                shopStoreVo.setClassifyMapVos(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    private ResponseData checkInventoryStock(String skuStock, String saleQuantity) {
        ResponseData responseData = new ResponseData();
        Integer stock = skuStock == null ? 0 : Integer.parseInt(skuStock);
        Integer quantity = saleQuantity == null ? 0 : Integer.parseInt(saleQuantity);
        if (stock < quantity) {
            log.info("stock={}", (Object)stock);
            log.info("quantity={}", (Object)quantity);
            responseData.setMessage("\u5546\u54c1\u4ec5\u5269" + stock + "\u4ef6");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData increaseReceivingAddress(UserAddressPutVo userAddressPutVo) {
        ResponseData responseData = new ResponseData();
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(userAddressPutVo.getMemberCode());
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        Long mbrMemberId = ((MemberInfoModel)singleMemberModel.getData()).getMbrMemberId();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Content-Type", "application/json");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("address", (Object)userAddressPutVo.getAddress());
        jsonObject.put("city", (Object)userAddressPutVo.getCity());
        jsonObject.put("district", (Object)userAddressPutVo.getDistrict());
        jsonObject.put("isDefault", (Object)userAddressPutVo.getIsDefault());
        jsonObject.put("mobile", (Object)userAddressPutVo.getMobile());
        jsonObject.put("name", (Object)userAddressPutVo.getName());
        jsonObject.put("province", (Object)userAddressPutVo.getProvince());
        jsonObject.put("userId", (Object)mbrMemberId);
        log.info("increaseReceivingAddress+userId={}", (Object)mbrMemberId);
        try {
            log.info("increaseReceivingAddress={}", (Object)JSON.toJSONString((Object)jsonObject));
            String addUserAddress = HttpUtil.post((String)(this.DOMAINNAME + "api/integral/userAddress"), (String)jsonObject.toJSONString(), map);
            JSONObject jsonObject1 = JSON.parseObject((String)addUserAddress);
            String code = jsonObject1.getString("code");
            String msg = jsonObject1.getString("msg");
            if ("0".equals(code)) {
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                return responseData;
            }
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(msg);
            return responseData;
        }
        catch (Exception e) {
            log.info("increaseReceivingAddress={}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public ResponseData editReceivingAddress(UserAddressPutVo userAddressPutVo) {
        ResponseData responseData = new ResponseData();
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(userAddressPutVo.getMemberCode());
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        Long mbrMemberId = ((MemberInfoModel)singleMemberModel.getData()).getMbrMemberId();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Content-Type", "application/json");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("address", (Object)userAddressPutVo.getAddress());
        jsonObject.put("city", (Object)userAddressPutVo.getCity());
        jsonObject.put("district", (Object)userAddressPutVo.getDistrict());
        jsonObject.put("isDefault", (Object)userAddressPutVo.getIsDefault());
        jsonObject.put("mobile", (Object)userAddressPutVo.getMobile());
        jsonObject.put("name", (Object)userAddressPutVo.getName());
        jsonObject.put("province", (Object)userAddressPutVo.getProvince());
        jsonObject.put("userId", (Object)mbrMemberId);
        jsonObject.put("id", (Object)userAddressPutVo.getId());
        try {
            log.info("editReceivingAddress={}", (Object)JSON.toJSONString((Object)jsonObject));
            String addUserAddress = HttpUtil.put((String)(this.DOMAINNAME + "api/integral/userAddress"), (String)jsonObject.toJSONString(), map);
            JSONObject jsonObject1 = JSON.parseObject((String)addUserAddress);
            String code = jsonObject1.getString("code");
            String msg = jsonObject1.getString("msg");
            if ("0".equals(code)) {
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                return responseData;
            }
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(msg);
            return responseData;
        }
        catch (Exception e) {
            log.info("editReceivingAddress={}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public ResponseData eliminateReceivingAddress(UserAddressPutVo userAddressPutVo) {
        ResponseData responseData = new ResponseData();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Content-Type", "application/json");
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(userAddressPutVo.getMemberCode());
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        Long mbrMemberId = ((MemberInfoModel)singleMemberModel.getData()).getMbrMemberId();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)userAddressPutVo.getId());
        jsonObject.put("userId", (Object)mbrMemberId);
        try {
            log.info("eliminateReceivingAddress={}", (Object)JSON.toJSONString(map));
            String addUserAddress = HttpUtil.delete((String)(this.DOMAINNAME + "api/integral/userAddress"), (String)jsonObject.toJSONString(), map);
            JSONObject jsonObject1 = JSON.parseObject((String)addUserAddress);
            String code = jsonObject1.getString("code");
            String msg = jsonObject1.getString("msg");
            if ("0".equals(code)) {
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                return responseData;
            }
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(msg);
            return responseData;
        }
        catch (Exception e) {
            log.info("eliminateReceivingAddress={}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public ResponseData addressuery(String memberCode) {
        ResponseData responseData = new ResponseData();
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        Long mbrMemberId = ((MemberInfoModel)singleMemberModel.getData()).getMbrMemberId();
        log.info("\u5730\u5740\u67e5\u8be2+mbrMemberId={}", (Object)mbrMemberId);
        try {
            String hotCommodity = HttpUtil.get((String)(this.DOMAINNAME + USERADDRESS + mbrMemberId));
            JSONArray commodityArray = JSON.parseArray((String)hotCommodity);
            JSONArray jsonArray = new JSONArray();
            for (int n = 0; n < commodityArray.size(); ++n) {
                JSONObject arrayJSONObject = commodityArray.getJSONObject(n);
                String aDefault = arrayJSONObject.getString("isDefault");
                if (!"true".equals(aDefault)) continue;
                jsonArray.add(0, (Object)arrayJSONObject);
            }
            for (int i = 0; i < commodityArray.size(); ++i) {
                JSONObject jsonObject = commodityArray.getJSONObject(i);
                String isDefault = jsonObject.getString("isDefault");
                if ("true".equals(isDefault)) continue;
                jsonArray.add((Object)jsonObject);
            }
            log.info("hotCommodity={}", (Object)JSON.toJSONString((Object)hotCommodity));
            responseData.setData((Object)jsonArray);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        catch (Exception e) {
            log.info("addressuery={}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public ResponseData fullOrderDisplay(Long sysCompanyId, String sysBrandId, String orderStatus, String memberCode, Integer pageNum, Integer pageSize) {
        log.info("========orderStatus=========" + orderStatus);
        if (pageNum == null) {
            pageNum = 0;
        }
        if (pageSize == null) {
            pageSize = 20;
        }
        ResponseData responseData = new ResponseData();
        try {
            ArrayList<OrderVo> orderVoList = new ArrayList<OrderVo>();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Content-Type", "application/x-www-form-urlencoded");
            String orderList = null;
            try {
                orderList = HttpUtil.get((String)(this.DOMAINNAME + ORDERLIST + sysCompanyId + "/" + sysBrandId + "/" + orderStatus + "/" + memberCode + "/" + pageNum + "/" + pageSize));
            }
            catch (IOException e) {
                log.warn("IntegrationShopServiceImpl#fullOrderDisplay\u83b7\u53d6\u79ef\u5206\u5546\u57ce\u8ba2\u5355\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            }
            log.info("orderList={}", (Object)JSON.toJSONString(orderList));
            if (StringUtils.isNotBlank(orderList)) {
                JSONObject jsonObject = JSON.parseObject(orderList);
                JSONObject data = jsonObject.getJSONObject("data");
                JSONArray parseArray = data.getJSONArray("list");
                Integer pages = data.getInteger("pages");
                Integer total = data.getInteger("total");
                for (int i = 0; i < parseArray.size(); ++i) {
                    OrderVo orderVo = new OrderVo();
                    JSONObject orderDetailsJson = parseArray.getJSONObject(i);
                    String id = orderDetailsJson.getString("id");
                    String orderNo = orderDetailsJson.getString("orderNo");
                    String orderIndex = orderDetailsJson.getString("orderStatus");
                    String orderTime = orderDetailsJson.getString("orderTime");
                    String goodId = orderDetailsJson.getString("goodId");
                    String goodsName = orderDetailsJson.getString("goodsName");
                    String goodSkuNo = orderDetailsJson.getString("goodSkuNo");
                    String goodsSkuSpecNames = orderDetailsJson.getString("goodsSkuSpecNames");
                    String saleQuantity = orderDetailsJson.getString("saleQuantity");
                    String saleIntegral = orderDetailsJson.getString("saleIntegral");
                    String salePrice = orderDetailsJson.getString("salePrice");
                    String coverImg = orderDetailsJson.getString("coverImg");
                    String detailsId = orderDetailsJson.getString("detailsId");
                    String courierCompanyCode = orderDetailsJson.getString("courierCompanyCode");
                    String courierNo = orderDetailsJson.getString("courierNo");
                    String cancelTime = orderDetailsJson.getString("cancelTime");
                    String shippingMobile = orderDetailsJson.getString("shippingMobile");
                    Integer goodsType = orderDetailsJson.getInteger("goodsType");
                    orderVo.setGoodsType(goodsType);
                    orderVo.setId(id);
                    orderVo.setOrderNo(orderNo);
                    orderVo.setGoodId(goodId);
                    orderVo.setOrderTime(orderTime);
                    orderVo.setOrderStatus(orderIndex);
                    orderVo.setSaleQuantity(saleQuantity);
                    orderVo.setSaleIntegral(saleIntegral);
                    orderVo.setSalePrice(salePrice);
                    orderVo.setGoodSkuNo(goodSkuNo);
                    orderVo.setGoodsName(goodsName);
                    orderVo.setCoverImg(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)coverImg));
                    orderVo.setGoodsSkuSpecNames(goodsSkuSpecNames);
                    orderVo.setDetailsId(detailsId);
                    orderVo.setCourierCompanyCode(courierCompanyCode);
                    orderVo.setCourierNo(courierNo);
                    orderVo.setCancelTime(cancelTime);
                    orderVo.setShippingMobile(shippingMobile);
                    orderVo.setMerchantId(orderDetailsJson.getString("merchantId"));
                    refundOrderVo refundOrderVo2 = new refundOrderVo();
                    String refundOrderString = orderDetailsJson.getString("refundOrder");
                    JSONObject refundOrder = orderDetailsJson.getJSONObject("refundOrder");
                    if (StringUtils.isNotBlank((CharSequence)refundOrderString)) {
                        String refundOrderId = refundOrder.getString("id");
                        String merchantId1 = refundOrder.getString("merchantId");
                        String orderNo1 = refundOrder.getString("orderNo");
                        String refundNo = refundOrder.getString("refundNo");
                        String orderDetailId = refundOrder.getString("orderDetailId");
                        String refundIntegral = refundOrder.getString("refundIntegral");
                        String refundQuantity = refundOrder.getString("refundQuantity");
                        String refundStatus = refundOrder.getString("refundStatus");
                        String refundType = refundOrder.getString("refundType");
                        String refundTime = refundOrder.getString("refundTime");
                        String refundReason = refundOrder.getString("refundReason");
                        String auditStatus = refundOrder.getString("auditStatus");
                        String auditReback = refundOrder.getString("auditReback");
                        refundOrderVo2.setId(refundOrderId);
                        refundOrderVo2.setMerchantId(merchantId1);
                        refundOrderVo2.setOrderNo(orderNo1);
                        refundOrderVo2.setRefundNo(refundNo);
                        refundOrderVo2.setOrderDetailId(orderDetailId);
                        refundOrderVo2.setRefundIntegral(refundIntegral);
                        refundOrderVo2.setRefundQuantity(refundQuantity);
                        refundOrderVo2.setRefundStatus(refundStatus);
                        refundOrderVo2.setRefundType(refundType);
                        refundOrderVo2.setRefundTime(refundTime);
                        refundOrderVo2.setRefundReason(refundReason);
                        refundOrderVo2.setAuditStatus(auditStatus);
                        refundOrderVo2.setAuditReback(auditReback);
                        orderVo.setRefundOrderVo(refundOrderVo2);
                    } else {
                        orderVo.setRefundOrderVo(null);
                    }
                    orderVoList.add(orderVo);
                }
                PageInfo orderVoPageInfo = null;
                if (IS_SORT.equals(orderStatus)) {
                    orderVoPageInfo = this.sortOrdersMethod(pageNum, pageSize, orderVoList, sysCompanyId, memberCode);
                    log.info("orderVoPageInfo========:{}", (Object)JSON.toJSONString((Object)orderVoPageInfo));
                }
                if (orderVoPageInfo == null) {
                    PageInfo pageInfo = new PageInfo(orderVoList);
                    pageInfo.setPages(pages.intValue());
                    pageInfo.setTotal((long)total.intValue());
                    responseData.setData((Object)pageInfo);
                    responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                    responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                    return responseData;
                }
                responseData.setData(orderVoPageInfo);
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                return responseData;
            }
            if (IS_SORT.equals(orderStatus)) {
                log.info("\u79ef\u5206\u8ba2\u5355\u7a7a\u7684\u903b\u8f91");
                PageInfo orderVoPageInfo = this.sortOrdersMethod(pageNum, pageSize, orderVoList, sysCompanyId, memberCode);
                responseData.setData((Object)orderVoPageInfo);
            } else {
                responseData.setData(orderVoList);
            }
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        catch (Exception e) {
            log.info("fullOrderDisplay={}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(e.getMessage());
            return responseData;
        }
    }

    private PageInfo<OrderVo> sortOrdersMethod(Integer pageNum, Integer pageSize, List<OrderVo> orderVoList, Long sysCompanyId, String memberCode) {
        try {
            CouponRecordVO vo = new CouponRecordVO();
            vo.setMemberCode(memberCode);
            ResponseData couponRecordResponseData = this.fullCouponDisplay(vo);
            if (org.springframework.util.StringUtils.isEmpty((Object)couponRecordResponseData)) {
                log.info("couponRecordResponseData#sortOrdersMethod\u7a7a\u4e86");
                return null;
            }
            PageInfo data = (PageInfo)couponRecordResponseData.getData();
            if (org.springframework.util.StringUtils.isEmpty((Object)couponRecordResponseData)) {
                log.info("data\u7a7a\u4e86==============sortOrdersMethod");
                return null;
            }
            List list = data.getList();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
                log.info("list\u7a7a\u4e86==============sortOrdersMethod");
                return null;
            }
            ArrayList<OrderVo> orderVoArrayList = new ArrayList<OrderVo>(orderVoList);
            list.forEach(e -> {
                OrderVo orderVo = new OrderVo();
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String dateString = formatter.format(e.getConvertTime());
                orderVo.setOrderTime(dateString);
                orderVo.setMktConvertCouponRecordBo(e);
                orderVoArrayList.add(orderVo);
            });
            List sort = CollectionUtil.sort(orderVoArrayList, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
            return PageUtils.getPageInfo((int)pageNum, (int)pageSize, (List)sort);
        }
        catch (Exception e2) {
            log.warn("IntegrationShopServiceImpl#sortOrdersMethod\u5f02\u5e38:[{}]_[{}]", (Object)e2.getMessage(), (Object)e2);
            return null;
        }
    }

    public ResponseData fullOrderDisplay(Long sysCompanyId, String sysBrandId, String orderStatus, String memberCode) {
        ResponseData responseData = new ResponseData();
        try {
            ArrayList<OrderVo> orderVoList = new ArrayList<OrderVo>();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Content-Type", "application/x-www-form-urlencoded");
            String orderList = HttpUtil.get((String)(this.DOMAINNAME + ORDERLIST + sysCompanyId + "/" + sysBrandId + "/" + orderStatus + "/" + memberCode));
            log.info("orderList={}", (Object)JSON.toJSONString((Object)orderList));
            if (StringUtils.isNotBlank((CharSequence)orderList)) {
                JSONArray parseArray = JSON.parseArray((String)orderList);
                for (int i = 0; i < parseArray.size(); ++i) {
                    OrderVo orderVo = new OrderVo();
                    JSONObject orderDetailsJson = parseArray.getJSONObject(i);
                    String id = orderDetailsJson.getString("id");
                    String orderNo = orderDetailsJson.getString("orderNo");
                    String orderIndex = orderDetailsJson.getString("orderStatus");
                    String orderTime = orderDetailsJson.getString("orderTime");
                    String goodId = orderDetailsJson.getString("goodId");
                    String goodsName = orderDetailsJson.getString("goodsName");
                    String goodSkuNo = orderDetailsJson.getString("goodSkuNo");
                    String goodsSkuSpecNames = orderDetailsJson.getString("goodsSkuSpecNames");
                    String saleQuantity = orderDetailsJson.getString("saleQuantity");
                    String saleIntegral = orderDetailsJson.getString("saleIntegral");
                    String coverImg = orderDetailsJson.getString("coverImg");
                    String detailsId = orderDetailsJson.getString("detailsId");
                    String courierCompanyCode = orderDetailsJson.getString("courierCompanyCode");
                    String courierNo = orderDetailsJson.getString("courierNo");
                    String shippingMobile = orderDetailsJson.getString("shippingMobile");
                    Date date = new Date(Long.valueOf(orderTime));
                    SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String format = sd.format(date);
                    orderVo.setId(id);
                    orderVo.setOrderNo(orderNo);
                    orderVo.setGoodId(goodId);
                    orderVo.setOrderTime(format);
                    orderVo.setOrderStatus(orderIndex);
                    orderVo.setSaleQuantity(saleQuantity);
                    orderVo.setSaleIntegral(saleIntegral);
                    orderVo.setGoodSkuNo(goodSkuNo);
                    orderVo.setGoodsName(goodsName);
                    orderVo.setCoverImg(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)coverImg));
                    orderVo.setGoodsSkuSpecNames(goodsSkuSpecNames);
                    orderVo.setDetailsId(detailsId);
                    orderVo.setCourierCompanyCode(courierCompanyCode);
                    orderVo.setCourierNo(courierNo);
                    orderVo.setShippingMobile(shippingMobile);
                    orderVo.setMerchantId(orderDetailsJson.getString("merchantId"));
                    refundOrderVo refundOrderVo2 = new refundOrderVo();
                    String refundOrderString = orderDetailsJson.getString("refundOrder");
                    JSONObject refundOrder = orderDetailsJson.getJSONObject("refundOrder");
                    if (StringUtils.isNotBlank((CharSequence)refundOrderString)) {
                        String refundOrderId = refundOrder.getString("id");
                        String merchantId1 = refundOrder.getString("merchantId");
                        String orderNo1 = refundOrder.getString("orderNo");
                        String refundNo = refundOrder.getString("refundNo");
                        String orderDetailId = refundOrder.getString("orderDetailId");
                        String refundIntegral = refundOrder.getString("refundIntegral");
                        String refundQuantity = refundOrder.getString("refundQuantity");
                        String refundStatus = refundOrder.getString("refundStatus");
                        String refundType = refundOrder.getString("refundType");
                        String refundTime = refundOrder.getString("refundTime");
                        String refundReason = refundOrder.getString("refundReason");
                        String auditStatus = refundOrder.getString("auditStatus");
                        String auditReback = refundOrder.getString("auditReback");
                        refundOrderVo2.setId(refundOrderId);
                        refundOrderVo2.setMerchantId(merchantId1);
                        refundOrderVo2.setOrderNo(orderNo1);
                        refundOrderVo2.setRefundNo(refundNo);
                        refundOrderVo2.setOrderDetailId(orderDetailId);
                        refundOrderVo2.setRefundIntegral(refundIntegral);
                        refundOrderVo2.setRefundQuantity(refundQuantity);
                        refundOrderVo2.setRefundStatus(refundStatus);
                        refundOrderVo2.setRefundType(refundType);
                        refundOrderVo2.setRefundTime(refundTime);
                        refundOrderVo2.setRefundReason(refundReason);
                        refundOrderVo2.setAuditStatus(auditStatus);
                        refundOrderVo2.setAuditReback(auditReback);
                        orderVo.setRefundOrderVo(refundOrderVo2);
                    } else {
                        orderVo.setRefundOrderVo(null);
                    }
                    orderVoList.add(orderVo);
                }
                responseData.setData(orderVoList);
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                return responseData;
            }
            responseData.setData((Object)orderList);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        catch (Exception e) {
            log.info("fullOrderDisplay={}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(e.getMessage());
            return responseData;
        }
    }

    public ResponseData<PageInfo<MktConvertCouponRecordBo>> fullCouponDisplay(CouponRecordVO couponRecordVO) {
        ResponseData responseData = new ResponseData();
        ResponseData convernConpouByMember = this.taskServiceForWXRpc.getConvernConpouByMember(couponRecordVO);
        PageInfo pageInfo = new PageInfo();
        ArrayList<MktConvertCouponRecordBo> couponRecordBos = new ArrayList<MktConvertCouponRecordBo>();
        log.info("convernConpouByMember={}", (Object)JSON.toJSONString((Object)convernConpouByMember.getData()));
        for (MktConvertCouponRecordPO recordBo : ((PageInfo)convernConpouByMember.getData()).getList()) {
            Integer integralExchangeType = recordBo.getIntegralExchangeType();
            MktConvertCouponRecordBo mktConvertCouponRecordBo = new MktConvertCouponRecordBo();
            Long couponEntityId = recordBo.getCouponEntityId();
            if (MktCouponIntegralExchangeTypeEnum.COUPON.getCode().equals(integralExchangeType)) {
                ResponseData byIdRpc = this.couponDefinitionServiceFeign.findByIdRpc(couponEntityId);
                log.info("fullCouponDisplay#byIdRpc===>:{}", (Object)JSON.toJSONString((Object)byIdRpc));
                BeanUtils.copyProperties((Object)recordBo, (Object)mktConvertCouponRecordBo);
                CouponDefinitionPO data = (CouponDefinitionPO)byIdRpc.getData();
                if (org.springframework.util.StringUtils.isEmpty((Object)data)) {
                    log.info("couponEntityId" + couponEntityId + "\u6ca1\u6709\u83b7\u53d6\u5230\u52b5\u5b9a\u4e49");
                    continue;
                }
                Byte preferentialType = data.getPreferentialType();
                BigDecimal money = ((CouponDefinitionPO)byIdRpc.getData()).getMoney();
                BigDecimal discount = ((CouponDefinitionPO)byIdRpc.getData()).getDiscount();
                mktConvertCouponRecordBo.setPreferentialType(String.valueOf(preferentialType));
                mktConvertCouponRecordBo.setMoney(String.valueOf(money));
                mktConvertCouponRecordBo.setDiscount(String.valueOf(discount));
                couponRecordBos.add(mktConvertCouponRecordBo);
            }
            if (!MktCouponIntegralExchangeTypeEnum.COUPON_BAG.getCode().equals(integralExchangeType)) continue;
            BeanUtils.copyProperties((Object)recordBo, (Object)mktConvertCouponRecordBo);
            ResponseData giftBag = this.taskServiceForWXRpc.getGiftBag(couponEntityId);
            log.info("fullCouponDisplay#byIdRpc#COUPON_BAG#===>:{}", (Object)JSON.toJSONString((Object)giftBag));
            mktConvertCouponRecordBo.setMktGiftBagVO((MktGiftBagVO)giftBag.getData());
            couponRecordBos.add(mktConvertCouponRecordBo);
        }
        pageInfo.setList(couponRecordBos);
        pageInfo.setSize(((PageInfo)convernConpouByMember.getData()).getSize());
        pageInfo.setPageSize(((PageInfo)convernConpouByMember.getData()).getPageSize());
        pageInfo.setPageNum(((PageInfo)convernConpouByMember.getData()).getPageNum());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public ResponseData tailForFullCouponDisplay(Long convertCouponRecordId, String memberCode) {
        ResponseData responseData = new ResponseData();
        ResponseData convernConpouDetail = this.taskServiceForWXRpc.getConvernConpouDetail(convertCouponRecordId);
        MktConvertCouponRecordPO detailData = (MktConvertCouponRecordPO)convernConpouDetail.getData();
        MktConvertCouponRecordBo mktConvertCouponRecordBo = new MktConvertCouponRecordBo();
        BeanUtils.copyProperties((Object)detailData, (Object)mktConvertCouponRecordBo);
        Long couponEntityId = detailData.getCouponEntityId();
        log.info("tailForFullCouponDisplay@couponEntityId={}", (Object)couponEntityId);
        if (MktCouponIntegralExchangeTypeEnum.COUPON.getCode().equals(detailData.getIntegralExchangeType())) {
            ResponseData byIdRpc = this.couponDefinitionServiceFeign.findByIdRpc(couponEntityId);
            Byte preferentialType = ((CouponDefinitionPO)byIdRpc.getData()).getPreferentialType();
            BigDecimal money = ((CouponDefinitionPO)byIdRpc.getData()).getMoney();
            BigDecimal discount = ((CouponDefinitionPO)byIdRpc.getData()).getDiscount();
            mktConvertCouponRecordBo.setPreferentialType(String.valueOf(preferentialType));
            mktConvertCouponRecordBo.setMoney(String.valueOf(money));
            mktConvertCouponRecordBo.setDiscount(String.valueOf(discount));
            mktConvertCouponRecordBo.setCouponDefinitionPo((CouponDefinitionPO)byIdRpc.getData());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)mktConvertCouponRecordBo);
            return responseData;
        }
        if (MktCouponIntegralExchangeTypeEnum.COUPON_BAG.getCode().equals(detailData.getIntegralExchangeType())) {
            ResponseData giftBag = this.taskServiceForWXRpc.getGiftBag(couponEntityId);
            log.info("IntegrationShopServiceImpl#tailForFullCouponDisplay#giftBag:{}", (Object)JSON.toJSONString((Object)giftBag));
            StringBuilder couponDefinitionCodeBuilder = new StringBuilder();
            String couponDefinitionCode = "";
            if (giftBag.getData() != null) {
                MktGiftBagVO data = (MktGiftBagVO)giftBag.getData();
                List couponDefinitionPOList = data.getCouponDefinitionPOList();
                for (CouponDefinitionPOWithBLOBs couponDefinitionPOWithBLOBs : couponDefinitionPOList) {
                    couponDefinitionCodeBuilder.append(couponDefinitionPOWithBLOBs.getCouponDefinitionCode()).append(",");
                }
                couponDefinitionCode = couponDefinitionCodeBuilder.substring(0, couponDefinitionCodeBuilder.length() - 1);
            }
            CouponDefinitionPO couponDefinitionPO = new CouponDefinitionPO();
            couponDefinitionPO.setCouponDefinitionCode(couponDefinitionCode);
            mktConvertCouponRecordBo.setCouponDefinitionPo(couponDefinitionPO);
            mktConvertCouponRecordBo.setMktGiftBagVO((MktGiftBagVO)giftBag.getData());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)mktConvertCouponRecordBo);
            return responseData;
        }
        return responseData;
    }

    public ResponseData viewOrder(String orderId) {
        log.info("IntegrationShopServiceImpl#viewOrder#orderId:{}", (Object)orderId);
        ResponseData responseData = new ResponseData();
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Content-Type", "application/x-www-form-urlencoded");
            OrderVo orderVo = new OrderVo();
            String orderDetails = HttpUtil.get((String)(this.DOMAINNAME + ORDERDETAILS + orderId));
            log.info("IntegrationShopServiceImpl#viewOrder#orderDetails={}", (Object)JSON.toJSONString((Object)orderDetails));
            if (StringUtils.isNotBlank((CharSequence)orderDetails)) {
                JSONObject orderDetailsJson = JSON.parseObject((String)orderDetails);
                String id = orderDetailsJson.getString("id");
                String orderNo = orderDetailsJson.getString("orderNo");
                String orderIndex = orderDetailsJson.getString("orderStatus");
                String orderTime = orderDetailsJson.getString("orderTime");
                String goodId = orderDetailsJson.getString("goodId");
                String goodNo = orderDetailsJson.getString("goodNo");
                String goodsName = orderDetailsJson.getString("goodsName");
                String goodSkuNo = orderDetailsJson.getString("goodSkuNo");
                String goodsSkuSpecNames = orderDetailsJson.getString("goodsSkuSpecNames");
                String detailsId = orderDetailsJson.getString("detailsId");
                String shippingName = orderDetailsJson.getString("shippingName");
                String shippingMobile = orderDetailsJson.getString("shippingMobile");
                String shippingProvince = orderDetailsJson.getString("shippingProvince");
                String shippingCity = orderDetailsJson.getString("shippingCity");
                String shippingDistrict = orderDetailsJson.getString("shippingDistrict");
                String shippingAddress = orderDetailsJson.getString("shippingAddress");
                String saleQuantity = orderDetailsJson.getString("saleQuantity");
                String saleIntegral = orderDetailsJson.getString("saleIntegral");
                String salePrice = orderDetailsJson.getString("salePrice");
                String coverImg = orderDetailsJson.getString("coverImg");
                String distributionMode = orderDetailsJson.getString("distributionMode");
                String sendGoodTime = orderDetailsJson.getString("sendGoodTime");
                String courierCompanyName = orderDetailsJson.getString("courierCompanyName");
                String courierCompanyCode = orderDetailsJson.getString("courierCompanyCode");
                String courierNo = orderDetailsJson.getString("courierNo");
                String orderType = orderDetailsJson.getString("orderType");
                String signTime = orderDetailsJson.getString("gmtModified");
                String staffName = orderDetailsJson.getString("staffName");
                String storeName = orderDetailsJson.getString("storeName");
                String orderStoreName = orderDetailsJson.getString("orderStoreName");
                Date selfPickTime = orderDetailsJson.getDate("selfPickTime");
                Integer goodsType = orderDetailsJson.getInteger("goodsType");
                List goodsCouponBos = (List)orderDetailsJson.getObject("couponCodes", List.class);
                orderVo.setId(id);
                orderVo.setOrderNo(orderNo);
                orderVo.setOrderTime(orderTime);
                orderVo.setShippingName(shippingName);
                orderVo.setShippingMobile(shippingMobile);
                orderVo.setShippingProvince(shippingProvince);
                orderVo.setShippingCity(shippingCity);
                orderVo.setShippingDistrict(shippingDistrict);
                orderVo.setShippingAddress(shippingAddress);
                orderVo.setOrderStatus(orderIndex);
                orderVo.setGoodId(goodId);
                orderVo.setGoodNo(goodNo);
                orderVo.setGoodsName(goodsName);
                orderVo.setGoodSkuNo(goodSkuNo);
                orderVo.setGoodsSkuSpecNames(goodsSkuSpecNames);
                orderVo.setCoverImg(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)coverImg));
                orderVo.setDetailsId(detailsId);
                orderVo.setSaleQuantity(saleQuantity);
                orderVo.setSaleIntegral(saleIntegral);
                orderVo.setSalePrice(salePrice);
                orderVo.setDistributionMode(orderType);
                orderVo.setSendGoodTime(sendGoodTime);
                orderVo.setCourierCompanyName(courierCompanyName);
                orderVo.setCourierCompanyCode(courierCompanyCode);
                orderVo.setCourierNo(courierNo);
                orderVo.setOrderType(orderType);
                orderVo.setSignTime(signTime);
                orderVo.setStoreName(storeName);
                orderVo.setStaffName(staffName);
                orderVo.setMerchantId(orderDetailsJson.getString("merchantId"));
                orderVo.setOrderStoreName(orderStoreName);
                orderVo.setGoodsType(goodsType);
                orderVo.setCouponCodes(goodsCouponBos);
                if (selfPickTime != null) {
                    orderVo.setSelfPickTime(selfPickTime);
                }
                refundOrderVo refundOrderVo2 = new refundOrderVo();
                String detailsJsonString = orderDetailsJson.getString("refundOrder");
                if (StringUtils.isNotBlank((CharSequence)detailsJsonString)) {
                    JSONObject refundOrder = orderDetailsJson.getJSONObject("refundOrder");
                    String refundOrderId = refundOrder.getString("id");
                    String merchantId1 = refundOrder.getString("merchantId");
                    String orderNo1 = refundOrder.getString("orderNo");
                    String refundNo = refundOrder.getString("refundNo");
                    String orderDetailId = refundOrder.getString("orderDetailId");
                    String refundIntegral = refundOrder.getString("refundIntegral");
                    String refundQuantity = refundOrder.getString("refundQuantity");
                    String refundStatus = refundOrder.getString("refundStatus");
                    String refundType = refundOrder.getString("refundType");
                    String refundTime = refundOrder.getString("refundTime");
                    String refundReason = refundOrder.getString("refundReason");
                    String auditStatus = refundOrder.getString("auditStatus");
                    String auditReback = refundOrder.getString("auditReback");
                    String gmtCreate = refundOrder.getString("gmtCreate");
                    refundOrderVo2.setId(refundOrderId);
                    refundOrderVo2.setMerchantId(merchantId1);
                    refundOrderVo2.setOrderNo(orderNo1);
                    refundOrderVo2.setRefundNo(refundNo);
                    refundOrderVo2.setOrderDetailId(orderDetailId);
                    refundOrderVo2.setRefundIntegral(refundIntegral);
                    refundOrderVo2.setRefundQuantity(refundQuantity);
                    refundOrderVo2.setRefundStatus(refundStatus);
                    refundOrderVo2.setRefundType(refundType);
                    refundOrderVo2.setRefundTime(refundTime);
                    refundOrderVo2.setRefundReason(refundReason);
                    refundOrderVo2.setAuditStatus(auditStatus);
                    refundOrderVo2.setAuditReback(auditReback);
                    refundOrderVo2.setGmtCreate(gmtCreate);
                    orderVo.setRefundOrderVo(refundOrderVo2);
                } else {
                    orderVo.setRefundOrderVo(null);
                }
                responseData.setData((Object)orderVo);
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                return responseData;
            }
            responseData.setData((Object)orderDetails);
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            return responseData;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("IntegrationShopServiceImpl#viewOrder#error:{}", (Object)e.getMessage());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
    }

    public ResponseData integralAcquisition(String sysBrandId) {
        ResponseData responseData = new ResponseData();
        try {
            String integralAcquisition = HttpUtil.get((String)(this.DOMAINNAME + INTEGRALACQUISITIOON + sysBrandId));
            responseData.setData((Object)integralAcquisition);
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            return responseData;
        }
        catch (Exception e) {
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData(null);
            return responseData;
        }
    }

    public ResponseData storeSelfMention() {
        return null;
    }

    public ResponseData logisticsCompanyGroup() {
        ResponseData responseData = new ResponseData();
        try {
            String companyList = HttpUtil.get((String)(this.DOMAINNAME + LOGISTICLIST));
            JSONObject parseObject = JSON.parseObject((String)companyList);
            JSONArray jsonArray = parseObject.getJSONArray("companyList");
            log.info("companyList={}", (Object)jsonArray);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setData((Object)jsonArray);
            return responseData;
        }
        catch (Exception e) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(e.getMessage());
            return responseData;
        }
    }

    public ResponseData displayLogistics(String companyCode, String num, String phone) {
        ResponseData responseData = new ResponseData();
        try {
            String rotationChart = HttpUtil.get((String)(this.DOMAINNAME + DISPLAYLOGISTICS + companyCode + "&num=" + num + "&phone=" + phone));
            JSONArray parseArray = JSON.parseArray((String)rotationChart);
            responseData.setData((Object)parseArray);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        catch (Exception e) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u67e5\u8be2\u65e0\u7ed3\u679c\uff0c\u8bf7\u9694\u6bb5\u65f6\u95f4\u518d\u67e5");
            return responseData;
        }
    }

    public ResponseData applyeturnSubmission(ReturnGoodsVo returnGoodsVo) {
        ResponseData responseData = new ResponseData();
        try {
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setMemberCode(returnGoodsVo.getMemberCode());
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            Long brandId = ((MemberInfoModel)singleMemberModel.getData()).getBrandId();
            String name = ((MemberInfoModel)singleMemberModel.getData()).getName();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Content-Type", "application/json");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("merchantId", (Object)brandId);
            jsonObject.put("orderNo", (Object)returnGoodsVo.getOrderNo());
            jsonObject.put("orderDetailId", (Object)returnGoodsVo.getOrderDetailId());
            jsonObject.put("refundType", (Object)returnGoodsVo.getRefundType());
            jsonObject.put("refundReason", (Object)returnGoodsVo.getRefundReason());
            jsonObject.put("auditor", (Object)name);
            log.info("applyeturnSubmission={}", (Object)JSON.toJSONString((Object)jsonObject));
            String applyeturnSubmission = HttpUtil.post((String)(this.DOMAINNAME + APPLICATIONSUBMISSION), (String)jsonObject.toJSONString(), map);
            JSONObject jsonObject1 = JSON.parseObject((String)applyeturnSubmission);
            String code = jsonObject1.getString("code");
            String msg = jsonObject1.getString("msg");
            if ("0".equals(code)) {
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                return responseData;
            }
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(msg);
            return responseData;
        }
        catch (Exception e) {
            log.info("applyeturnSubmission={}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public ResponseData applyeturnNotSubmitted(RefundLogisticsVo refundLogisticsVo) {
        ResponseData responseData = new ResponseData();
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Content-Type", "application/json");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("refundNo", (Object)refundLogisticsVo.getRefundNo());
            jsonObject.put("refundShippingCompany", (Object)refundLogisticsVo.getRefundShippingCompany());
            jsonObject.put("refundCompanyCode", (Object)refundLogisticsVo.getRefundCompanyCode());
            jsonObject.put("refundShippingNo", (Object)refundLogisticsVo.getRefundShippingNo());
            log.info("applyeturnNotSubmitted={}", (Object)JSON.toJSONString((Object)jsonObject));
            String applyeturnSubmission = HttpUtil.post((String)(this.DOMAINNAME + APPLICATIONSUBMISSIONWULIU), (String)jsonObject.toJSONString(), map);
            JSONObject jsonObject1 = JSON.parseObject((String)applyeturnSubmission);
            String code = jsonObject1.getString("code");
            String msg = jsonObject1.getString("msg");
            if ("0".equals(code)) {
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                return responseData;
            }
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(msg);
            return responseData;
        }
        catch (Exception e) {
            log.info("applyeturnSubmission={}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public ResponseData instructions(String sysBrandId) {
        ResponseData responseData = new ResponseData();
        try {
            String instructions = HttpUtil.get((String)(this.DOMAINNAME + INSTRUCTIONNS + sysBrandId));
            responseData.setData((Object)instructions);
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            return responseData;
        }
        catch (Exception e) {
            log.info("instructions={}", (Object)e.getMessage());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
    }

    public ResponseData getConfig(Integer merchantId) throws IOException {
        log.info("IntegrationShopServiceImpl#getConfig#merchantId:{}", (Object)merchantId);
        ResponseData data = new ResponseData();
        try {
            String merchantConfigString = (String)this.redisTemplateService.stringGetStringByKey((Object)("integrationShopGetConfig" + merchantId));
            log.info("IntegrationShopServiceImpl#getConfig#merchantConfigString:{}", (Object)merchantConfigString);
            if (!StringUtils.isBlank((CharSequence)merchantConfigString)) {
                HashMap configMap = (HashMap)JSON.parseObject((String)merchantConfigString, HashMap.class);
                data.setData((Object)configMap);
                return data;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            log.info("\u5f00\u59cb\u52a0\u8f7d\u5fae\u5546\u57ce\u914d\u7f6e");
            String result = HttpUtil.get((String)(this.DOMAINNAME + GET_CONFIG + "?merchantId=" + merchantId));
            log.info("\u5fae\u5546\u57ce\u8fd4\u56de\u914d\u7f6e:{}", (Object)result);
            if (StringUtils.isEmpty((CharSequence)result)) {
                throw LogicException.error((Integer)-1, (String)"\u5546\u5bb6\u672a\u4fdd\u5b58\u57fa\u7840\u914d\u7f6e");
            }
            JSONObject json = JSONObject.parseObject((String)result);
            log.info("IntegrationShopServiceImpl#getConfig#2009#json :{}", (Object)json);
            Boolean customerService = (Boolean)json.get((Object)"customerService");
            Boolean refundSingle = (Boolean)json.get((Object)"refundSingle");
            if (refundSingle.booleanValue()) {
                map.put("refundSingleConditionList", json.get((Object)"refundSingleConditionList"));
            }
            map.put("awaitOrderCancel", json.get((Object)"awaitOrderCancel"));
            map.put("customerService", customerService);
            map.put("refundSingle", refundSingle);
            map.put("integralRule", json.getString("integralRule"));
            map.put("isDeliverCheck", json.getString("isDeliverCheck"));
            map.put("deliverAuditorMark", json.getString("deliverAuditorMark"));
            map.put("isWholeStore", json.getString("isWholeStore"));
            map.put("hiddenGoods", json.getBooleanValue("hiddenGoods"));
            map.put("showCoupon", json.getBooleanValue("showCoupon"));
            map.put("showCouponInGoods", json.getBooleanValue("showCouponInGoods"));
            map.put("isTimedCancelOrder", json.getIntValue("isTimedCancelOrder"));
            map.put("selfPickTimeJudge", json.getBooleanValue("selfPickTimeJudge"));
            map.put("goodsPriceDesc", json.getString("goodsPriceDesc"));
            map.put("refundExplain", json.getString("refundExplain"));
            map.put("rejectedExplain", json.getString("rejectedExplain"));
            try {
                this.setIntegralConfig2Redis(map, merchantId);
            }
            catch (Exception e) {
                log.error("\u914d\u7f6e\u88c5\u8f7dredis\u5f02\u5e38:{}========={}", (Object)e.getMessage(), (Object)e);
            }
            data.setData(map);
            log.info("IntegrationShopServiceImpl#getConfig#2027#data:{}", data.getData());
            return data;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u914d\u7f6e\u5f02\u5e38:{}========={}", (Object)e.getMessage(), (Object)e);
            data.setMessage("\u83b7\u53d6\u914d\u7f6e\u5931\u8d25");
            data.setCode(-1);
            return data;
        }
    }

    public void setIntegralConfig2Redis(Map<String, Object> map, Integer merchantId) {
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("integrationShopGetConfig" + merchantId), (Object)JSON.toJSONString(map), 300000L);
    }

    public ResponseData getAllOrdersPages(int pageNum, int pageSize, Integer sysBrandId, String memberCode) {
        ResponseData result = new ResponseData();
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("pageNum", pageNum + "");
            param.put("pageSize", pageSize + "");
            param.put("merchantId", sysBrandId + "");
            param.put("memberCode", memberCode);
            String tempResult = HttpUtil.postForm((String)(this.DOMAINNAME + ALL_ORDERS_PAGE), param);
            if (StringUtils.isEmpty((CharSequence)tempResult)) {
                throw LogicException.error((Integer)-1, (String)"\u672a\u627e\u5230\u6570\u636e");
            }
            JSONObject json = JSONObject.parseObject((String)tempResult);
            Integer code = json.getInteger("code");
            JSONObject data = json.getJSONObject("data");
            result.setData((Object)data);
            result.setCode(code.intValue());
            return result;
        }
        catch (IOException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public ResponseData payment(Integer ordersId) {
        ResponseData result = new ResponseData();
        try {
            String tempResult = HttpUtil.get((String)(this.DOMAINNAME + PAYMENT + "?ordersId=" + ordersId));
            if (StringUtils.isEmpty((CharSequence)tempResult)) {
                throw LogicException.error((Integer)-1, (String)"\u672a\u627e\u5230\u6570\u636e");
            }
            JSONObject json = JSONObject.parseObject((String)tempResult);
            Integer code = json.getInteger("code");
            String message = json.getString("message");
            JSONObject data = json.getJSONObject("data");
            result.setData((Object)data);
            result.setMessage(message);
            result.setCode(code.intValue());
            return result;
        }
        catch (IOException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public ResponseData paymentWithCoupon(Integer convertCouponRecordId, String bizvaneSessionId) {
        ResponseData convernConpouDetail = this.taskServiceForWXRpc.getConvernConpouDetail(Long.valueOf(convertCouponRecordId.longValue()));
        log.info("paymentWithCoupon_convernConpouDetail:{}", (Object)JSON.toJSONString((Object)convernConpouDetail));
        MktConvertCouponRecordPO convernConpouDetailData = (MktConvertCouponRecordPO)convernConpouDetail.getData();
        MemberInfoModel infoModel = new MemberInfoModel();
        infoModel.setMemberCode(convernConpouDetailData.getMemberCode());
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(infoModel);
        log.info("paymentWithCoupon_singleMemberModel:{}", (Object)JSON.toJSONString((Object)singleMemberModel));
        MemberInfoModel memberModelData = (MemberInfoModel)singleMemberModel.getData();
        String phone = memberModelData.getPhone();
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        log.info("memberOpenId:{},redisOpenId:{}", (Object)memberModelData.getWxOpenId(), (Object)openId);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("convertCouponRecordId", convertCouponRecordId + "");
        param.put("openId", openId);
        param.put("merchantId", convernConpouDetailData.getSysBrandId() + "");
        param.put("price", convernConpouDetailData.getConvertTatalCash().toString());
        param.put("convertCouponRecordCode", convernConpouDetailData.getConvertCouponRecordCode());
        param.put("memberCode", convernConpouDetailData.getMemberCode());
        param.put("memberName", convernConpouDetailData.getMemberName());
        param.put("memberPhone", phone);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Content-Type", "application/json");
        ResponseData result = new ResponseData();
        try {
            String tempResult = HttpUtil.post((String)(this.DOMAINNAME + PAYMENTWITHCOUPON), (String)JSON.toJSONString(param), map);
            if (StringUtils.isEmpty((CharSequence)tempResult)) {
                throw LogicException.error((Integer)-1, (String)"\u672a\u627e\u5230\u6570\u636e");
            }
            log.info("paymentWithCoupon_tempResult:{}", (Object)JSON.toJSONString((Object)tempResult));
            JSONObject json = JSONObject.parseObject((String)tempResult);
            Integer code = json.getInteger("code");
            String message = json.getString("message");
            JSONObject data = json.getJSONObject("data");
            result.setData((Object)data);
            result.setMessage(message);
            result.setCode(code.intValue());
            return result;
        }
        catch (IOException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            result.setMessage(SysResponseEnum.FAILED.getMessage());
            result.setCode(SysResponseEnum.FAILED.getCode());
            return result;
        }
    }

    public ResponseData payCouponSuccess(Integer convertCouponRecordId) {
        ResponseData convernConpouDetail = this.taskServiceForWXRpc.paySuccess(Long.valueOf(convertCouponRecordId.longValue()));
        return convernConpouDetail;
    }

    public ResponseData getFeight(IntegralOrderFeightVO integralOrderFeightVO) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("goodsId", integralOrderFeightVO.getGoodsId());
        param.put("orderType", integralOrderFeightVO.getOrderType());
        param.put("shippingProvince", integralOrderFeightVO.getShippingProvince());
        param.put("shippingCity", integralOrderFeightVO.getShippingCity());
        param.put("shippingDistrict", integralOrderFeightVO.getShippingDistrict());
        param.put("saleQuantity", integralOrderFeightVO.getSaleQuantity());
        param.put("templateId", integralOrderFeightVO.getTemplateId());
        param.put("merchantId", integralOrderFeightVO.getMerchantId());
        param.put("skuNo", integralOrderFeightVO.getSkuNo());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Content-Type", "application/json");
        ResponseData result = new ResponseData();
        try {
            String tempResult = HttpUtil.post((String)(this.DOMAINNAME + INTEGRALORDERFEIGHT), (String)JSON.toJSONString(param), map);
            if (StringUtils.isEmpty((CharSequence)tempResult)) {
                throw LogicException.error((Integer)-1, (String)"\u672a\u627e\u5230\u6570\u636e");
            }
            log.info("paymentWithCoupon_tempResult:{}", (Object)JSON.toJSONString((Object)tempResult));
            JSONObject json = JSONObject.parseObject((String)tempResult);
            Integer code = json.getInteger("code");
            String message = json.getString("message");
            String data = json.getString("data");
            result.setData((Object)data);
            result.setMessage(message);
            result.setCode(code.intValue());
            return result;
        }
        catch (IOException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            result.setMessage(SysResponseEnum.FAILED.getMessage());
            result.setCode(SysResponseEnum.FAILED.getCode());
            return result;
        }
    }

    public ResponseData getIntegralClassifyQRCord(IntegralQRCodeRequestVO integralQRCodeRequestVO) {
        UrlMinaQRCodeCreateRequestVO urlMinaQRCodeCreateRequestVO = new UrlMinaQRCodeCreateRequestVO();
        urlMinaQRCodeCreateRequestVO.setPath(integralQRCodeRequestVO.getPath());
        urlMinaQRCodeCreateRequestVO.setScene(integralQRCodeRequestVO.getScene());
        Long sysBrandId = integralQRCodeRequestVO.getSysBrandId();
        ResponseData data = this.wxPublicServiceFeign.getWxPublicListBySysBrandId(sysBrandId);
        List wxPublicPOList = (List)data.getData();
        log.info("getIntegralClassifyQRCord_wxPublicPOList:{}", (Object)JSON.toJSONString((Object)wxPublicPOList));
        WxPublicPO wxPublicPO = wxPublicPOList.stream().filter(e -> "2".equals(e.getWxPublicType())).findFirst().orElse(null);
        if (Objects.isNull(wxPublicPO)) {
            return ResponseUtils.getFailedData((String)"\u672a\u627e\u5230\u8be5\u5c0f\u7a0b\u5e8f");
        }
        String appid = wxPublicPO.getAppid();
        urlMinaQRCodeCreateRequestVO.setAppid(appid);
        ResponseData code = this.qrCodeServiceFeign.createUrlMinaQRCode(urlMinaQRCodeCreateRequestVO);
        log.info("\u751f\u6210\u4e8c\u7ef4\u7801\u8fd4\u56de\u4fe1\u606f" + JSONArray.toJSONString((Object)code));
        Assert.isTrue((SysResponseEnum.SUCCESS.getCode() == code.getCode() ? 1 : 0) != 0, (String)("\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25\uff0c" + code.getMessage()));
        return new ResponseData((Object)code);
    }

    public List<ActivityImgQueryResponseVO> queryActivityAlertImages(String sysBrandId, String memberCode) {
        try {
            Result result = this.integralActivityRpcService.getActiveActivity(Long.valueOf(sysBrandId), memberCode);
            if (!result.isSuccess()) {
                throw new AppletBizvaneException(result.getMessage());
            }
            List pos = (List)result.getData();
            ArrayList<ActivityImgQueryResponseVO> response = new ArrayList<ActivityImgQueryResponseVO>();
            for (IntegralActivityPOWithBLOBs po : pos) {
                if (!this.checkMemberInRange((IntegralActivityPO)po, memberCode).booleanValue() || !StringUtils.isNotBlank((CharSequence)po.getAlertImg())) continue;
                ActivityImgQueryResponseVO vo = new ActivityImgQueryResponseVO();
                vo.setAlertType(po.getAlertType());
                vo.setActivityId(po.getIntegralActivityId());
                vo.setImg(po.getAlertImg());
                response.add(vo);
            }
            return response;
        }
        catch (Exception e) {
            log.error("IntegrationShopServiceImpl.queryActivityAlertImages:{},{}", (Object)e.getMessage(), (Object)e);
            return new ArrayList<ActivityImgQueryResponseVO>();
        }
    }

    private Boolean checkMemberInRange(IntegralActivityPO po, String memberCode) {
        Byte activityRange = po.getActivityRange();
        if (activityRange == null) {
            log.info("checkMemberLabelMatch activityRange is null");
            return Boolean.FALSE;
        }
        if (activityRange == 0) {
            log.info("checkMemberLabelMatch activityRange is 0");
            return Boolean.TRUE;
        }
        MembersInfoSearchVo membersInfoSearchVo = new MembersInfoSearchVo();
        membersInfoSearchVo.setMemberCode(memberCode);
        membersInfoSearchVo.setAutoLabel(Boolean.TRUE);
        membersInfoSearchVo.setAutoLabelIdList((List)Lists.newArrayList((Object[])new Long[]{po.getAutoLabelId()}));
        membersInfoSearchVo.setPageNumber(Integer.valueOf(1));
        membersInfoSearchVo.setPageSize(Integer.valueOf(1));
        membersInfoSearchVo.setBrandId(Long.valueOf(po.getSysBrandId()));
        membersInfoSearchVo.setSysCompanyId(po.getSysCompanyId());
        ResponseData pageInfoResponseData = this.memberInfoApiService.vgSearch(membersInfoSearchVo);
        log.info("checkMemberLabelMatch vgSearch:{}", (Object)JSON.toJSONString((Object)pageInfoResponseData));
        com.bizvane.utils.responseinfo.PageInfo memberInfoVoPageInfo = (com.bizvane.utils.responseinfo.PageInfo)pageInfoResponseData.getData();
        if (SysResponseEnum.SUCCESS.getCode() != pageInfoResponseData.getCode() || memberInfoVoPageInfo == null || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)memberInfoVoPageInfo.getList())) {
            log.info("checkMemberLabelMatch memberInfoVo is null");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public ResponseData getGoodsClubInfo(String goodsId) {
        log.info("getGoodsClubInfo#param:{}", (Object)goodsId);
        ResponseData responseData = new ResponseData();
        GoodsInfoVO goodsInfoVO = new GoodsInfoVO();
        String goodsClubInfo = "";
        try {
            goodsClubInfo = HttpUtil.get((String)(this.DOMAINNAME + INTEGRAL_INFO + goodsId));
            log.info("\u67e5\u8be2\u51fa\u6765\u7684\u5546\u54c1\u54c1\u724c\u4fe1\u606f:{}", JSONObject.toJSON((Object)goodsClubInfo));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (StringUtils.isBlank((CharSequence)goodsClubInfo)) {
            log.info("\u8bf7\u6c42\u5546\u57ce\u63a5\u53e3\u5f02\u5e38");
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
        }
        JSONObject commodityDetailsJson = JSON.parseObject((String)goodsClubInfo);
        String integralGoodsId = commodityDetailsJson.getString("goodsId");
        goodsInfoVO.setGoodsId(integralGoodsId);
        String jsonString = commodityDetailsJson.getString("goodsInfoDetailDTOList");
        log.info("\u5546\u54c1\u4ff1\u4e50\u90e8\u4fe1\u606f\u8be6\u60c5:{}", (Object)JSON.toJSONString((Object)jsonString));
        if (StringUtils.isNotBlank((CharSequence)jsonString)) {
            ArrayList<GoodsInfoDetailVO> goodsInfoDetailVOS = new ArrayList<GoodsInfoDetailVO>();
            JSONArray goodsInfoDetailDTOList1 = commodityDetailsJson.getJSONArray("goodsInfoDetailDTOList");
            for (int i = 0; i < goodsInfoDetailDTOList1.size(); ++i) {
                GoodsInfoDetailVO goodsInfoDetailVO1 = new GoodsInfoDetailVO();
                JSONObject skusJSONObject = goodsInfoDetailDTOList1.getJSONObject(i);
                String clubId = skusJSONObject.getString("clubId");
                String clubImg = skusJSONObject.getString("clubImg");
                goodsInfoDetailVO1.setClubId(clubId);
                goodsInfoDetailVO1.setClubImg(clubImg);
                goodsInfoDetailVOS.add(goodsInfoDetailVO1);
            }
            goodsInfoVO.setGoodsInfoDetailDTOList(goodsInfoDetailVOS);
            log.info("goodsInfoVO={}", (Object)JSON.toJSONString((Object)goodsInfoVO));
            responseData.setData((Object)goodsInfoVO);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        }
        return responseData;
    }
}

