/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers.vg;

import com.bizvane.appletservice.interfaces.vg.VGInitService;
import com.bizvane.appletservice.interfaces.vg.VGLoginService;
import com.bizvane.appletservice.models.bo.AppletBrandMenberBo;
import com.bizvane.appletservice.models.vo.vg.VGMbrRegisterRequestVo;
import com.bizvane.appletservice.models.vo.vg.VGRequestHeaderVo;
import com.bizvane.appletserviceimpl.utils.OptionUtils;
import com.bizvane.appletserviceimpl.utils.UUIDUtils;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateService;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u767b\u5f55\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/vgUser"})
public class VGLoginController {
    private static final Logger log = LoggerFactory.getLogger(VGLoginController.class);
    @Autowired
    private VGLoginService vgLoginService;
    @Autowired
    private VGInitService vgInitService;
    @Autowired
    private OptionUtils optionUtils;
    @Autowired
    private RedisTemplateService<String, String> redisTemplateService;

    @ApiOperation(value="byCodeNew\u65b0\u63a5\u53e3", notes="byCodeNew\u65b0\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="appid", value="appid", required=true), @ApiImplicitParam(name="code", value="code", required=true), @ApiImplicitParam(name="phone", value="phone", required=true), @ApiImplicitParam(name="avatar", value="userInfoData", required=true), @ApiImplicitParam(name="gender", value="userInfoData", required=true), @ApiImplicitParam(name="nickName", value="userInfoData", required=true), @ApiImplicitParam(name="oderMemberCode", value="oderMemberCode", example="\u6ce8\u518c\u65f6\u6709\u63a8\u8350\u4eba\u65f6\u4f20\u5165"), @ApiImplicitParam(name="activityNo", value="activityNo", example="\u6d3b\u52a8\u5f00\u5361\u65f6\u4f20\u5165"), @ApiImplicitParam(name="mktTaskId", value="mktTaskId", example="\u9080\u8bf7\u5f00\u5361\u65f6\u4f20\u5165")})
    @PostMapping(value={"/getMbrAndOpenCard"})
    public ResponseData<AppletBrandMenberBo> getMbrAndOpenCard(HttpServletRequest request, VGMbrRegisterRequestVo wxMbrRegisteRequestVo) {
        try {
            return this.vgLoginService.getMbrAndOpenCard(request, wxMbrRegisteRequestVo);
        }
        catch (Exception exception) {
            return new ResponseData(100, exception.getMessage());
        }
    }

    @PostMapping(value={"/autoJoinClub"})
    public ResponseData<AppletBrandMenberBo> autoJoinClub(HttpServletRequest request, VGMbrRegisterRequestVo wxMbrRegisteRequestVo) {
        String uuid = UUIDUtils.getUUID();
        log.info("autoJoinClub#uid:{}", (Object)uuid);
        try {
            wxMbrRegisteRequestVo.setAutoJoinClubUUID(uuid);
            String bizvaneSessionId = wxMbrRegisteRequestVo.getBizvaneSessionId();
            String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
            VGRequestHeaderVo requestHeader = this.optionUtils.getRequestHeader(memberCode);
            this.vgLoginService.autoJoinClub(requestHeader, wxMbrRegisteRequestVo);
        }
        catch (Exception exception) {
            return new ResponseData(100, exception.getMessage());
        }
        return new ResponseData();
    }

    @PostMapping(value={"/initChild"})
    public ResponseData initChild(HttpServletRequest request) {
        ResponseData objectResponseData = new ResponseData();
        Long sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        Long sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        this.vgInitService.initChildBrandBizvaneSessionId(sysCompanyId, sysBrandId, bizvaneSessionId);
        objectResponseData.setCode(SysResponseEnum.SUCCESS.getCode());
        objectResponseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return objectResponseData;
    }
}

