/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers.seckill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.models.vo.ConfirmGoodsVo;
import com.bizvane.appletservice.models.vo.seckill.SeckillActivityBaseRequestVO;
import com.bizvane.appletservice.models.vo.seckill.SeckillActivityCreateOrderRequestVO;
import com.bizvane.appletserviceimpl.common.BaseConstant;
import com.bizvane.appletserviceimpl.impl.seckill.SeckillActivityResponseVO;
import com.bizvane.appletserviceimpl.impl.seckill.SeckillActivityService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.tokens.TokenUtils;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.utils.response.Result;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"seckill"})
public class SeckillActivityController {
    private static final Logger log = LoggerFactory.getLogger(SeckillActivityController.class);
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private SeckillActivityService seckillActivityService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @PostMapping(value={"/activity/goodsList"})
    public Result<SeckillActivityResponseVO> getActivityGoodsList(@RequestBody @Valid SeckillActivityBaseRequestVO requestVO, HttpServletRequest request) {
        logger.info("SeckillActivityController|getActivityGoodsList|requestVO:{}", JSON.toJSON((Object)requestVO));
        Result result = this.getMemberCode(request);
        if (result.isSuccess()) {
            requestVO.setMemberCode((String)result.getData());
            return this.seckillActivityService.getActivityGoodsList(requestVO);
        }
        return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)"\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
    }

    @PostMapping(value={"/activity/goodsDetail"})
    public Result<SeckillActivityResponseVO> goodsDetail(@RequestBody @Valid SeckillActivityBaseRequestVO requestVO, HttpServletRequest request) {
        logger.info("SeckillActivityController|goodsDetail|requestVO:{}", JSON.toJSON((Object)requestVO));
        Result result = this.getMemberCode(request);
        if (result.isSuccess()) {
            requestVO.setMemberCode((String)result.getData());
            return this.seckillActivityService.getGoodsDetail(requestVO);
        }
        return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)"\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
    }

    @PostMapping(value={"/activity/createOrder"})
    public Result<IntegralOrders> createOrder(@RequestBody @Valid SeckillActivityCreateOrderRequestVO requestVO, HttpServletRequest request) {
        logger.info("SeckillActivityController|createOrder|requestVO:{}", JSONObject.toJSON((Object)requestVO));
        Result checkRequest = this.checkRequest(requestVO);
        if (!checkRequest.isSuccess()) {
            return Result.failure((String)checkRequest.getMessage());
        }
        SeckillActivityBaseRequestVO baseRequest = this.buildBaseRequestVO(requestVO);
        Result result = this.getMemberCode(request);
        if (result.isSuccess()) {
            baseRequest.getConfirmGoodsVo().setMemberCode((String)result.getData());
            return this.seckillActivityService.createOrder(baseRequest, request);
        }
        return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)"\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
    }

    @PostMapping(value={"/activity/checkOrder"})
    public Result<SeckillActivityResponseVO> checkOrder(@RequestBody @Valid SeckillActivityCreateOrderRequestVO requestVO, HttpServletRequest request) {
        logger.info("SeckillActivityController|checkOrder|requestVO:{}", JSONObject.toJSON((Object)requestVO));
        Result checkRequest = this.checkRequest(requestVO);
        if (!checkRequest.isSuccess()) {
            return Result.failure((String)checkRequest.getMessage());
        }
        SeckillActivityBaseRequestVO baseRequest = this.buildBaseRequestVO(requestVO);
        Result result = this.getMemberCode(request);
        if (result.isSuccess()) {
            baseRequest.getConfirmGoodsVo().setMemberCode((String)result.getData());
            return this.seckillActivityService.checkOrder(baseRequest);
        }
        return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)"\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
    }

    private Result<String> getMemberCode(HttpServletRequest request) {
        String bizvaneSessionId = request.getHeader(BaseConstant.SESSION_ID);
        if (bizvaneSessionId == null) {
            return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)"\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + BaseConstant.MEMBER_CODE));
        if (memberCode == null) {
            return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)"\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return Result.success((Object)memberCode);
    }

    private Result<String> checkRequest(SeckillActivityCreateOrderRequestVO request) {
        try {
            this.checkEmpty((Object)request.getActivityCode(), "\u6d3b\u52a8\u7f16\u7801");
            this.checkEmpty((Object)request.getGoodId(), "\u5546\u54c1id");
            this.checkEmpty((Object)request.getGoodSkuNo(), "\u5546\u54c1sku");
            this.checkEmpty((Object)request.getSaleQuantity(), "\u8d2d\u4e70\u6570\u91cf");
            return Result.success();
        }
        catch (Exception e) {
            return Result.failure((String)e.getMessage());
        }
    }

    private void checkEmpty(Object object, String tipName) {
        if (Objects.isNull(object)) {
            throw new IllegalArgumentException(tipName + "\u4e0d\u53ef\u4e3a\u7a7a");
        }
    }

    private SeckillActivityBaseRequestVO buildBaseRequestVO(SeckillActivityCreateOrderRequestVO request) {
        SeckillActivityBaseRequestVO requestVO = new SeckillActivityBaseRequestVO();
        requestVO.setActivityCode(request.getActivityCode());
        requestVO.setPriceType(request.getPriceType());
        requestVO.setOrderRemark(request.getOrderRemark());
        requestVO.setConfirmGoodsVo(this.buildConfirmGoodsVO(request));
        return requestVO;
    }

    private ConfirmGoodsVo buildConfirmGoodsVO(SeckillActivityCreateOrderRequestVO request) {
        ConfirmGoodsVo confirmGoodsVo = new ConfirmGoodsVo();
        confirmGoodsVo.setGoodId(request.getGoodId());
        confirmGoodsVo.setSaleIntegral(request.getSaleIntegral());
        confirmGoodsVo.setGoodNo(request.getGoodNo());
        confirmGoodsVo.setShippingName(request.getShippingName());
        confirmGoodsVo.setShippingMobile(request.getShippingMobile());
        confirmGoodsVo.setShippingProvince(request.getShippingProvince());
        confirmGoodsVo.setShippingCity(request.getShippingCity());
        confirmGoodsVo.setShippingDistrict(request.getShippingDistrict());
        confirmGoodsVo.setShippingAddress(request.getShippingAddress());
        confirmGoodsVo.setUserComments(request.getUserComments());
        confirmGoodsVo.setGoodSkuNo(request.getGoodSkuNo());
        confirmGoodsVo.setGoodSkuSpecNames(request.getGoodSkuSpecNames());
        confirmGoodsVo.setSaleQuantity(request.getSaleQuantity());
        confirmGoodsVo.setOrderType(request.getOrderType());
        confirmGoodsVo.setOpenId(request.getOpenId());
        confirmGoodsVo.setTemplateId(request.getTemplateId());
        confirmGoodsVo.setExchangeCount(request.getExchangeCount());
        confirmGoodsVo.setExchangeStatus(request.getExchangeStatus());
        confirmGoodsVo.setSelfPickTime(request.getSelfPickTime());
        confirmGoodsVo.setStoreName(request.getStoreName());
        confirmGoodsVo.setSysBrandId(request.getSysBrandId());
        confirmGoodsVo.setStoreId(request.getStoreId());
        confirmGoodsVo.setMemberName(request.getMemberName());
        confirmGoodsVo.setMemberPhone(request.getMemberPhone());
        confirmGoodsVo.setSysCompanyId(request.getSysCompanyId());
        confirmGoodsVo.setPriceType(request.getPriceType());
        confirmGoodsVo.setOrderRemark(request.getOrderRemark());
        return confirmGoodsVo;
    }
}

