/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.models.bo.ActivityAppletBO;
import com.bizvane.appletservice.models.bo.AppletActivtyBo;
import com.bizvane.appletserviceimpl.impl.DataQueryService;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.appletserviceimpl.utils.RefreshScopeListConfig;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.couponfacade.models.vo.CouponDetailResponseVO;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.mktcenterservice.models.bo.ActivityBO;
import com.bizvane.mktcenterservice.models.bo.ActivityOrderBO;
import com.bizvane.mktcenterservice.models.vo.ActivityVO;
import com.bizvane.mktcenterservice.models.vo.CheckActivityVo;
import com.bizvane.mktcenterservice.models.vo.MktRedPortRecordVO;
import com.bizvane.mktcenterservice.rpc.ActivityRedPortServiceRpc;
import com.bizvane.mktcenterservice.rpc.ActivityServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mktcenter"})
public class MenberCenterMktcenterController {
    @Autowired
    private ActivityServiceRpc activityServiceRpc;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private RefreshScopeListConfig refreshScopeListConfig;
    @Autowired
    private ActivityRedPortServiceRpc activityRedPortServiceRpc;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    @Autowired
    private DataQueryService dataQueryService;
    @Value(value="${qiniu.domain}")
    private String DOMAINNAME;

    @RequestMapping(value={"/getActivityList"}, method={RequestMethod.POST})
    public ResponseData getActivityList(ActivityVO vo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        if (vo.getSysCompanyId() == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return responseData;
        }
        if (vo.getSysBrandId() == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        String appId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        logger.info("redisTemplateServiceAppId={}", (Object)appId);
        logger.info("\u4f1a\u5458\u6d3b\u52a8\u5165\u53c2={}", (Object)JSON.toJSONString((Object)vo));
        ResponseData listResponseData = this.activityServiceRpc.getActivityListVg(vo);
        logger.info("\u4f1a\u5458\u6d3b\u52a8={}", (Object)JSON.toJSONString((Object)listResponseData.getData()));
        ArrayList<AppletActivtyBo> list = new ArrayList<AppletActivtyBo>();
        if (listResponseData.getData() != null) {
            for (ActivityVO activityVO : (List)listResponseData.getData()) {
                AppletActivtyBo appletActivtyBo = new AppletActivtyBo();
                if (activityVO.getActivityType() != null) {
                    if (activityVO.getActivityType() == 2) {
                        appletActivtyBo.setMktActivityId(activityVO.getMktActivityId());
                        appletActivtyBo.setActivityCode(activityVO.getActivityCode());
                        appletActivtyBo.setActivityInfo(activityVO.getActivityInfo());
                        appletActivtyBo.setOpenPhtoUrl(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)activityVO.getActivityDetailImg()));
                        appletActivtyBo.setActivityType(activityVO.getActivityType());
                        list.add(appletActivtyBo);
                    }
                    if (activityVO.getActivityType() == 18) {
                        appletActivtyBo.setMktActivityId(activityVO.getMktActivityId());
                        appletActivtyBo.setActivityCode(activityVO.getActivityCode());
                        appletActivtyBo.setActivityInfo(activityVO.getActivityInfo());
                        appletActivtyBo.setOpenPhtoUrl(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)activityVO.getActivityDetailImg()));
                        appletActivtyBo.setActivityType(activityVO.getActivityType());
                        list.add(appletActivtyBo);
                    }
                    if (activityVO.getActivityType() == 5) {
                        appletActivtyBo.setMktActivityId(activityVO.getMktActivityId());
                        appletActivtyBo.setActivityCode(activityVO.getActivityCode());
                        appletActivtyBo.setActivityInfo(activityVO.getActivityInfo());
                        appletActivtyBo.setOpenPhtoUrl(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)activityVO.getActivityDetailImg()));
                        appletActivtyBo.setActivityType(activityVO.getActivityType());
                        list.add(appletActivtyBo);
                    }
                    if (activityVO.getActivityType() == 11) {
                        appletActivtyBo.setMktActivityId(activityVO.getMktActivityId());
                        appletActivtyBo.setActivityCode(activityVO.getActivityCode());
                        appletActivtyBo.setActivityInfo(activityVO.getActivityInfo());
                        appletActivtyBo.setOpenPhtoUrl(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)activityVO.getActivityDetailImg()));
                        appletActivtyBo.setActivityType(activityVO.getActivityType());
                        list.add(appletActivtyBo);
                    }
                    if (activityVO.getActivityType() == 12) {
                        appletActivtyBo.setMktActivityId(activityVO.getMktActivityId());
                        appletActivtyBo.setActivityCode(activityVO.getActivityCode());
                        appletActivtyBo.setActivityInfo(activityVO.getActivityInfo());
                        appletActivtyBo.setOpenPhtoUrl(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)activityVO.getActivityDetailImg()));
                        appletActivtyBo.setActivityType(activityVO.getActivityType());
                        list.add(appletActivtyBo);
                    }
                    if (activityVO.getActivityType() == 13) {
                        appletActivtyBo.setMktActivityId(activityVO.getMktActivityId());
                        appletActivtyBo.setActivityCode(activityVO.getActivityCode());
                        appletActivtyBo.setActivityInfo(activityVO.getActivityInfo());
                        appletActivtyBo.setOpenPhtoUrl(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)activityVO.getActivityDetailImg()));
                        appletActivtyBo.setActivityType(activityVO.getActivityType());
                        list.add(appletActivtyBo);
                    }
                    List configAppid = this.refreshScopeListConfig.getCONFIG_APPID();
                    logger.info("configAppid={}", (Object)JSON.toJSONString((Object)configAppid));
                    if (configAppid != null) {
                        for (String configAppids : configAppid) {
                            if (!appId.equals(configAppids) || activityVO.getActivityType() != 14) continue;
                            appletActivtyBo.setMktActivityId(activityVO.getMktActivityId());
                            appletActivtyBo.setActivityCode(activityVO.getActivityCode());
                            appletActivtyBo.setActivityInfo(activityVO.getActivityInfo());
                            appletActivtyBo.setOpenPhtoUrl(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)activityVO.getActivityDetailImg()));
                            appletActivtyBo.setActivityType(activityVO.getActivityType());
                            list.add(appletActivtyBo);
                        }
                    }
                    if (activityVO.getActivityType() == 15) {
                        appletActivtyBo.setMktActivityId(activityVO.getMktActivityId());
                        appletActivtyBo.setActivityCode(activityVO.getActivityCode());
                        appletActivtyBo.setActivityInfo(activityVO.getActivityInfo());
                        appletActivtyBo.setOpenPhtoUrl(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)activityVO.getActivityDetailImg()));
                        appletActivtyBo.setActivityType(activityVO.getActivityType());
                        list.add(appletActivtyBo);
                    }
                    if (activityVO.getActivityType() == 16) {
                        appletActivtyBo.setMktActivityId(activityVO.getMktActivityId());
                        appletActivtyBo.setActivityCode(activityVO.getActivityCode());
                        appletActivtyBo.setActivityInfo(activityVO.getActivityInfo());
                        appletActivtyBo.setOpenPhtoUrl(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)activityVO.getActivityDetailImg()));
                        appletActivtyBo.setActivityType(activityVO.getActivityType());
                        list.add(appletActivtyBo);
                    }
                    if (activityVO.getActivityType() != 23) continue;
                    appletActivtyBo.setMktActivityId(activityVO.getMktActivityId());
                    appletActivtyBo.setActivityCode(activityVO.getActivityCode());
                    appletActivtyBo.setActivityInfo(activityVO.getActivityInfo());
                    appletActivtyBo.setOpenPhtoUrl(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)activityVO.getActivityDetailImg()));
                    appletActivtyBo.setActivityType(activityVO.getActivityType());
                    list.add(appletActivtyBo);
                    continue;
                }
                responseData.setMessage("\u5f88\u62b1\u6b49\uff0c\u6d3b\u52a8\u5df2\u7ecf\u7ed3\u675f\u4e86");
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                return responseData;
            }
        } else {
            responseData.setMessage("\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        ResponseData brandByID = this.brandServiceRpc.getBrandByID(vo.getSysBrandId());
        Long sysCompanyId = ((SysBrandPo)brandByID.getData()).getSysCompanyId();
        Long serviceStoreId = (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
        String mktActivityId = (String)this.redisTemplateService.stringGetStringByKey((Object)(memberCode + vo.getSysBrandId() + 1));
        MktRedPortRecordVO mktRedPortRecordVO = new MktRedPortRecordVO();
        mktRedPortRecordVO.setType(Integer.valueOf(1));
        mktRedPortRecordVO.setMemberCode(memberCode);
        mktRedPortRecordVO.setSysCompanyId(sysCompanyId);
        mktRedPortRecordVO.setSysBrandId(vo.getSysBrandId());
        if (StringUtils.isNotBlank((CharSequence)mktActivityId)) {
            mktRedPortRecordVO.setMktActivityId(Long.valueOf(mktActivityId));
        }
        mktRedPortRecordVO.setServiceStoreId(serviceStoreId);
        logger.info("updateRedPort={}", (Object)JSON.toJSONString((Object)mktRedPortRecordVO));
        this.activityRedPortServiceRpc.updateRedPort(mktRedPortRecordVO);
        responseData.setData(list);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    @RequestMapping(value={"/selectActivityUpgradesById"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<ActivityBO> selectActivityUpgradesById(String activityCode) {
        ResponseData responseData = new ResponseData();
        if (activityCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return responseData;
        }
        ActivityAppletBO activityAppletBO = new ActivityAppletBO();
        ResponseData boResponseData = this.activityServiceRpc.selectActivityUpgradesById(activityCode);
        ActivityBO data = (ActivityBO)boResponseData.getData();
        if (data.getActivityVO().getActivityInfo() != null) {
            String actInfo = data.getActivityVO().getActivityInfo();
            if (actInfo.indexOf("http") == -1 && data.getActivityVO().getActivityInfoType() == 1) {
                activityAppletBO.setActivityInfo(this.DOMAINNAME + actInfo);
            } else {
                activityAppletBO.setActivityInfo(actInfo);
            }
        }
        activityAppletBO.setStartTime(data.getActivityVO().getStartTime());
        activityAppletBO.setEndTime(data.getActivityVO().getEndTime());
        activityAppletBO.setPoints((Integer)ObjectUtils.defaultIfNull((Object)data.getActivityVO().getPoints(), null));
        activityAppletBO.setActivityName((String)ObjectUtils.defaultIfNull((Object)data.getActivityVO().getActivityName(), null));
        activityAppletBO.setLongTerm((Integer)ObjectUtils.defaultIfNull((Object)data.getActivityVO().getLongTerm(), null));
        activityAppletBO.setActivityInfoType((Integer)ObjectUtils.defaultIfNull((Object)data.getActivityVO().getActivityInfoType(), null));
        ArrayList<String> getCouponName = new ArrayList<String>();
        if (data.getCouponEntityAndDefinitionVOList() == null) {
            activityAppletBO.setCouponName(null);
        } else {
            for (CouponDetailResponseVO couponDetailResponseVO : data.getCouponEntityAndDefinitionVOList()) {
                getCouponName.add(couponDetailResponseVO.getCouponDefinitionPO().getCouponName());
            }
            activityAppletBO.setCouponName(getCouponName);
        }
        responseData.setData((Object)activityAppletBO);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    @RequestMapping(value={"/selectActivityOrderById"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<ActivityBO> selectActivityOrderById(String activityCode) {
        ResponseData responseData = new ResponseData();
        if (activityCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return responseData;
        }
        ActivityAppletBO activityAppletBO = new ActivityAppletBO();
        ActivityOrderBO data = this.dataQueryService.selectActivityOrderById2C(activityCode);
        logger.info("data={}", (Object)JSON.toJSONString((Object)data));
        if (data.getActivityVO().getActivityInfo() != null) {
            String actInfo = data.getActivityVO().getActivityInfo();
            if (actInfo.indexOf("http") == -1 && data.getActivityVO().getActivityInfoType() != null && data.getActivityVO().getActivityInfoType() == 1) {
                activityAppletBO.setActivityInfo(this.DOMAINNAME + actInfo);
            } else {
                activityAppletBO.setActivityInfo(actInfo);
            }
        }
        activityAppletBO.setStartTime(data.getActivityVO().getStartTime());
        activityAppletBO.setEndTime(data.getActivityVO().getEndTime());
        activityAppletBO.setPoints((Integer)ObjectUtils.defaultIfNull((Object)data.getActivityVO().getPoints(), null));
        activityAppletBO.setActivityName((String)ObjectUtils.defaultIfNull((Object)data.getActivityVO().getActivityName(), null));
        activityAppletBO.setLongTerm((Integer)ObjectUtils.defaultIfNull((Object)data.getActivityVO().getLongTerm(), null));
        activityAppletBO.setActivityInfoType((Integer)ObjectUtils.defaultIfNull((Object)data.getActivityVO().getActivityInfoType(), null));
        activityAppletBO.setMktIntegralType(data.getActivityVO().getMktIntegralType());
        activityAppletBO.setMultiple(data.getActivityVO().getMultiple());
        ArrayList<String> getCouponName = new ArrayList<String>();
        if (data.getCouponEntityAndDefinitionVOList() == null) {
            activityAppletBO.setCouponName(null);
        } else {
            for (CouponDetailResponseVO couponDetailResponseVO : data.getCouponEntityAndDefinitionVOList()) {
                getCouponName.add(couponDetailResponseVO.getCouponDefinitionPO().getCouponName());
            }
            activityAppletBO.setCouponName(getCouponName);
        }
        responseData.setData((Object)activityAppletBO);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    @RequestMapping(value={"/selectActivityBabyBirthdayById"}, method={RequestMethod.POST})
    public ResponseData<ActivityBO> selectActivityBabyBirthdayById(String activityCode) {
        ResponseData responseData = new ResponseData();
        if (activityCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return responseData;
        }
        ActivityAppletBO activityAppletBO = new ActivityAppletBO();
        ResponseData boResponseData = this.activityServiceRpc.selectActivityBabyBirthdayById(activityCode);
        ActivityBO data = (ActivityBO)boResponseData.getData();
        if (data != null) {
            if (data.getActivityVO().getActivityInfo() != null) {
                String actInfo = data.getActivityVO().getActivityInfo();
                if (actInfo.indexOf("http") == -1 && data.getActivityVO().getActivityInfoType() == 1) {
                    activityAppletBO.setActivityInfo(this.DOMAINNAME + actInfo);
                } else {
                    activityAppletBO.setActivityInfo(actInfo);
                }
            }
            activityAppletBO.setStartTime(data.getActivityVO().getStartTime());
            activityAppletBO.setEndTime(data.getActivityVO().getEndTime());
            activityAppletBO.setPoints((Integer)ObjectUtils.defaultIfNull((Object)data.getActivityVO().getPoints(), null));
            activityAppletBO.setActivityName((String)ObjectUtils.defaultIfNull((Object)data.getActivityVO().getActivityName(), null));
            activityAppletBO.setLongTerm((Integer)ObjectUtils.defaultIfNull((Object)data.getActivityVO().getLongTerm(), null));
            activityAppletBO.setActivityInfoType((Integer)ObjectUtils.defaultIfNull((Object)data.getActivityVO().getActivityInfoType(), null));
            ArrayList<String> getCouponName = new ArrayList<String>();
            if (data.getCouponEntityAndDefinitionVOList() == null) {
                activityAppletBO.setCouponName(null);
            } else {
                for (CouponDetailResponseVO couponDetailResponseVO : data.getCouponEntityAndDefinitionVOList()) {
                    getCouponName.add(couponDetailResponseVO.getCouponDefinitionPO().getCouponName());
                }
                activityAppletBO.setCouponName(getCouponName);
            }
            responseData.setData((Object)activityAppletBO);
        } else {
            responseData.setData(null);
        }
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    @RequestMapping(value={"/selectActivityFirstOrderById"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<ActivityBO> selectActivityFirstOrderById(String activityCode) {
        ResponseData responseData = new ResponseData();
        if (activityCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return responseData;
        }
        ActivityAppletBO activityAppletBO = new ActivityAppletBO();
        ResponseData boResponseData = this.activityServiceRpc.selectActivityFirstOrderById(activityCode);
        ActivityBO data = (ActivityBO)boResponseData.getData();
        logger.info("data={}", (Object)JSON.toJSONString((Object)data));
        if (data != null) {
            if (data.getActivityVO().getActivityInfo() != null) {
                String actInfo = data.getActivityVO().getActivityInfo();
                if (actInfo.indexOf("http") == -1 && data.getActivityVO().getActivityInfoType() == 1 && data.getActivityVO().getActivityInfoType() == 1) {
                    activityAppletBO.setActivityInfo(this.DOMAINNAME + actInfo);
                } else {
                    activityAppletBO.setActivityInfo(actInfo);
                }
            }
            activityAppletBO.setStartTime(data.getActivityVO().getStartTime());
            activityAppletBO.setEndTime(data.getActivityVO().getEndTime());
            activityAppletBO.setPoints((Integer)ObjectUtils.defaultIfNull((Object)data.getActivityVO().getPoints(), null));
            activityAppletBO.setActivityName((String)ObjectUtils.defaultIfNull((Object)data.getActivityVO().getActivityName(), null));
            activityAppletBO.setLongTerm((Integer)ObjectUtils.defaultIfNull((Object)data.getActivityVO().getLongTerm(), null));
            activityAppletBO.setActivityInfoType((Integer)ObjectUtils.defaultIfNull((Object)data.getActivityVO().getActivityInfoType(), null));
            ArrayList<String> getCouponName = new ArrayList<String>();
            if (data.getCouponEntityAndDefinitionVOList() == null) {
                activityAppletBO.setCouponName(null);
            } else {
                for (CouponDetailResponseVO couponDetailResponseVO : data.getCouponEntityAndDefinitionVOList()) {
                    getCouponName.add(couponDetailResponseVO.getCouponDefinitionPO().getCouponName());
                }
                activityAppletBO.setCouponName(getCouponName);
            }
            responseData.setData((Object)activityAppletBO);
        } else {
            responseData.setData(null);
        }
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    @RequestMapping(value={"/selectActivityRegisterById"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<ActivityBO> selectActivityRegisterById(String activityCode) {
        ResponseData responseData = new ResponseData();
        if (activityCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return responseData;
        }
        return this.activityServiceRpc.selectActivityRegisterById(activityCode);
    }

    @RequestMapping(value={"/checkNowActivityIsHaveMember"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<CheckActivityVo> checkNowActivityIsHaveMember(HttpServletRequest request, String mktActivityId) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        if ("undefined".equals(mktActivityId)) {
            CheckActivityVo checkActivityVo = new CheckActivityVo();
            checkActivityVo.setIsHaveMember(Boolean.FALSE);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)checkActivityVo);
            return responseData;
        }
        return this.activityServiceRpc.checkNowActivityIsHaveMember(Long.valueOf(mktActivityId), memberCode);
    }

    @RequestMapping(value={"/checkNowBrandIsHaveMember"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<CheckActivityVo> checkNowBrandIsHaveMember(HttpServletRequest request, Long sysBrandId) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.activityServiceRpc.checkNowBrandIsHaveMember(sysBrandId, memberCode);
    }
}

