/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.interfaces.BrandService;
import com.bizvane.appletservice.interfaces.IntegrationShopService;
import com.bizvane.appletservice.interfaces.vg.VGLoginService;
import com.bizvane.appletservice.models.bo.MktConvertCouponRecordBo;
import com.bizvane.appletservice.models.po.AppletResourcesPO;
import com.bizvane.appletservice.models.po.AppletResourcesPOExample;
import com.bizvane.appletservice.models.vo.ActivityImgQueryResponseVO;
import com.bizvane.appletservice.models.vo.AllMerchandiseVo;
import com.bizvane.appletservice.models.vo.ConfirmGoodsVo;
import com.bizvane.appletservice.models.vo.IntegralOrderFeightVO;
import com.bizvane.appletservice.models.vo.IntegralQRCodeRequestVO;
import com.bizvane.appletservice.models.vo.IntegralShopGetHomePageHotCommodityRequestVO;
import com.bizvane.appletservice.models.vo.RefundLogisticsVo;
import com.bizvane.appletservice.models.vo.ReturnGoodsVo;
import com.bizvane.appletservice.models.vo.ShopHomePageVo;
import com.bizvane.appletservice.models.vo.UserAddressPutVo;
import com.bizvane.appletservice.models.vo.classifiedGoodsVo;
import com.bizvane.appletserviceimpl.enums.SysBusinessResponseEnum;
import com.bizvane.appletserviceimpl.mappers.AppletResourcesPOMapper;
import com.bizvane.appletserviceimpl.utils.CouponUtils;
import com.bizvane.appletserviceimpl.utils.PageUtils;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.vo.SysStoreVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.StaffServiceRpc;
import com.bizvane.couponfacade.interfaces.CouponAuthTmallServiceFeign;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.customized.facade.utils.ResponseUtils;
import com.bizvane.members.facade.models.MemberCardLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberCardProgramApiService;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MemberLevelApiService;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.mktcenterservice.models.bo.CouponIntegralExchangeBO;
import com.bizvane.mktcenterservice.models.po.MktCouponIntegralExchangePOWithBLOBs;
import com.bizvane.mktcenterservice.models.vo.CouponIntegralExchangeVO;
import com.bizvane.mktcenterservice.models.vo.CouponRecordVO;
import com.bizvane.mktcenterservice.models.vo.MktGiftBagVO;
import com.bizvane.mktcenterservice.rpc.TaskServiceForWXRpc;
import com.bizvane.utils.commonutils.CustomException;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.bizvane.wechatfacade.interfaces.QRCodeServiceFeign;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.enums.IntegralStore.activity.IntegralActivityGoodsTypeEnum;
import com.wmeimob.fastboot.bizvane.service.rpc.vg.IntegralActivityRpcService;
import com.wmeimob.fastboot.bizvane.utils.response.Result;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/integrationShop"}, method={RequestMethod.POST})
public class IntegrationShopController {
    private static final Logger log = LoggerFactory.getLogger(IntegrationShopController.class);
    @Autowired
    private TaskServiceForWXRpc taskServiceForWXRpc;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private MemberCardProgramApiService memberCardProgramApiService;
    @Autowired
    private AppletResourcesPOMapper appletResourcesPOMapper;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private IntegrationShopService integrationShopService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private CouponAuthTmallServiceFeign couponAuthTmallServiceFeign;
    @Autowired
    private MemberLevelApiService memberLevelApiService;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private QRCodeServiceFeign qrCodeServiceFeign;
    @Autowired
    private VGLoginService vgLoginService;
    @Autowired
    private IntegralActivityRpcService integralActivityRpcService;
    @Autowired
    private StaffServiceRpc staffServiceRpc;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    @Autowired
    private BrandService brandService;

    @RequestMapping(value={"/integrationShopResources"}, method={RequestMethod.POST})
    public ResponseData integrationShopResources(HttpServletRequest request, CouponRecordVO couponRecordVO) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        AppletResourcesPOExample appletResourcesPOExample = new AppletResourcesPOExample();
        appletResourcesPOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andModularCodeEqualTo("M006").andSysBrandIdEqualTo(couponRecordVO.getBrandId()).andModularTypeEqualTo("2");
        List resourcesPOS = this.appletResourcesPOMapper.selectByExample(appletResourcesPOExample);
        for (AppletResourcesPO appletResourcesPO : resourcesPOS) {
            appletResourcesPO.setModularContent(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)appletResourcesPO.getModularContent()));
        }
        responseData.setCode(0);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)resourcesPOS);
        return responseData;
    }

    @RequestMapping(value={"/integrationShopGetall"})
    public ResponseData integrationShopGetall(CouponRecordVO couponRecordVO, HttpServletRequest request) {
        Object data;
        logger.info("IntegrationShopController#integrationShopGetall#134# couponRecordVO:{}", (Object)JSON.toJSONString((Object)couponRecordVO));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        logger.info("integrationShopGetall memberCode:{}", (Object)memberCode);
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        if (couponRecordVO.getBrandId() == null) {
            responseData.setMessage("\u54c1\u724c\u4e3a null");
            responseData.setCode(100);
            return responseData;
        }
        if (couponRecordVO.getCanConvertCoupon() == null) {
            responseData.setMessage("\u67e5\u8be2\u52fe\u9009\u6846\u4e3anull");
            responseData.setCode(100);
            return responseData;
        }
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        couponRecordVO.setMemberCode(memberCode);
        Long serviceStoreId = this.wxAppletApiService.getOpenCardStoreId(memberCode).getData() == null ? Long.valueOf(0L) : (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
        try {
            ResponseData config = this.integrationShopService.getConfig(Integer.valueOf(couponRecordVO.getBrandId().intValue()));
            data = config.getData();
            JSONObject json = (JSONObject)JSON.toJSON((Object)data);
            logger.info("IntegrationShopController#integrationShopGetall#169# configMap:{}", (Object)json);
            if (!couponRecordVO.getCanConvertCoupon().booleanValue()) {
                logger.info("hiddenGoods:{}", (Object)json.getBoolean("hiddenGoods"));
                couponRecordVO.setHiddenGoods(json.getBoolean("hiddenGoods"));
            }
        }
        catch (Exception e) {
            logger.info("IntegrationShopController#integrationShopGetall#157 Exception :{},:{}", (Object)e.getMessage(), (Object)e);
        }
        couponRecordVO.setOpenCardStoreId(serviceStoreId);
        ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        data = (MemberCardLevelModel)modelResponseData.getData();
        Integer integral = data.getCountIntegral();
        logger.info("integrationShopGetall memberCode:{},memberResp:{}", (Object)memberCode, (Object)JSONObject.toJSONString((Object)modelResponseData));
        if (integral != null) {
            couponRecordVO.setCountIntegral(integral);
        }
        couponRecordVO.setMbrLevelId(data.getLevelId());
        couponRecordVO.setOpenId(openId);
        logger.info("\u5165\u53c2====" + JSON.toJSON((Object)couponRecordVO));
        ResponseData convernCouponLists = this.taskServiceForWXRpc.getConvernCouponLists(couponRecordVO);
        logger.info("integrationShopGetall convernCouponLists:{}", (Object)JSON.toJSONString((Object)convernCouponLists));
        return convernCouponLists;
    }

    @GetMapping(value={"/getExchangeCoupon"})
    public ResponseData getExchangeCoupon(@RequestHeader(value="sysBrandId") Long brandId, @RequestHeader(value="sysCompanyId") Long companyId, @RequestParam(value="pageNumber", required=false) Integer pageNumber, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="canConvertCoupon", required=false) Boolean canConvertCoupon, @RequestParam(value="hotGoods", required=false) Boolean hotGoods, @RequestParam(value="getTarget", required=false) Integer getTarget, @RequestParam(value="exchangePriceType", required=false) Integer exchangePriceType, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        try {
            Object data;
            CouponRecordVO couponRecordVO = new CouponRecordVO();
            couponRecordVO.setPageNumber(pageNumber);
            couponRecordVO.setPageSize(pageSize);
            couponRecordVO.setBrandId(brandId);
            couponRecordVO.setCanConvertCoupon(canConvertCoupon);
            couponRecordVO.setHotGoods(hotGoods);
            couponRecordVO.setExchangePriceType(exchangePriceType);
            couponRecordVO.setSysCompanyId(companyId);
            logger.info("IntegrationShopController#getExchangeCoupon#couponRecordVO:{}", (Object)JSON.toJSONString((Object)couponRecordVO));
            String bizvaneSessionId = request.getHeader("bizvaneSessionId");
            if (bizvaneSessionId == null) {
                responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
                return responseData;
            }
            String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
            String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
            logger.info("integrationShopGetall memberCode:{}", (Object)memberCode);
            if (memberCode == null) {
                responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                responseData.setCode(-100);
                return responseData;
            }
            if (couponRecordVO.getCanConvertCoupon() == null) {
                responseData.setMessage("\u67e5\u8be2\u52fe\u9009\u6846\u4e3anull");
                responseData.setCode(100);
                return responseData;
            }
            couponRecordVO.setMemberCode(memberCode);
            Long serviceStoreId = this.wxAppletApiService.getOpenCardStoreId(memberCode).getData() == null ? Long.valueOf(0L) : (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
            try {
                ResponseData config = this.integrationShopService.getConfig(Integer.valueOf(couponRecordVO.getBrandId().intValue()));
                data = config.getData();
                JSONObject json = (JSONObject)JSON.toJSON((Object)data);
                logger.info("IntegrationShopController#integrationShopGetall#169# configMap:{}", (Object)json);
                if (!couponRecordVO.getCanConvertCoupon().booleanValue()) {
                    logger.info("hiddenGoods:{}", (Object)json.getBoolean("hiddenGoods"));
                    couponRecordVO.setHiddenGoods(json.getBoolean("hiddenGoods"));
                }
            }
            catch (Exception e) {
                logger.info("IntegrationShopController#integrationShopGetall#157 Exception :{},:{}", (Object)e.getMessage(), (Object)e);
            }
            couponRecordVO.setOpenCardStoreId(serviceStoreId);
            ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
            data = (MemberCardLevelModel)modelResponseData.getData();
            Integer integral = data.getCountIntegral();
            logger.info("integrationShopGetall memberCode:{},memberResp:{}", (Object)memberCode, (Object)JSONObject.toJSONString((Object)modelResponseData));
            if (integral != null) {
                couponRecordVO.setCountIntegral(integral);
            }
            couponRecordVO.setMbrLevelId(data.getLevelId());
            couponRecordVO.setOpenId(openId);
            logger.info("\u5165\u53c2222222222====" + JSON.toJSON((Object)couponRecordVO));
            ResponseData convernCouponLists = this.taskServiceForWXRpc.getConvernCouponLists(couponRecordVO);
            logger.info("integrationShopGetall convernCouponLists:{}", (Object)JSON.toJSONString((Object)convernCouponLists));
            try {
                CouponUtils.mergeCouponListsApplicableBrandCodes((ResponseData)convernCouponLists);
                log.info("\u683c\u5f0f\u5316\u540e\u6570\u636e:{}", (Object)JSON.toJSONString((Object)convernCouponLists));
            }
            catch (Exception e) {
                log.warn("IntegrationShopController#getExchangeCoupon\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            }
            if (convernCouponLists.getCode() == 0) {
                CouponIntegralExchangeBO exchangeBO = (CouponIntegralExchangeBO)convernCouponLists.getData();
                PageInfo pageInfo = exchangeBO.getPageInfo();
                if (pageInfo == null || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
                    return convernCouponLists;
                }
                Result notDisplayGoodsResult = this.integralActivityRpcService.queryNotDisplayGoods(IntegralActivityGoodsTypeEnum.CONPON);
                log.info("IntegrationShopController.getExchangeCoupon notDisplayGoodsResult:{}", (Object)notDisplayGoodsResult);
                if (!notDisplayGoodsResult.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)notDisplayGoodsResult.getData()))) {
                    return convernCouponLists;
                }
                List notDisplayGoods = (List)notDisplayGoodsResult.getData();
                List list = pageInfo.getList();
                list = list.stream().filter(exchange -> !notDisplayGoods.contains(exchange.getExchangeId())).collect(Collectors.toList());
                pageInfo.setList(list);
                pageInfo.setTotal((long)list.size());
            }
            return convernCouponLists;
        }
        catch (Exception e) {
            log.warn("IntegrationShopController#getExchangeCoupon\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            responseData.setMessage(e.getMessage());
            return responseData;
        }
    }

    private ResponseData<CouponIntegralExchangeBO> filterMasterCouponList(Long companyId, ResponseData<CouponIntegralExchangeBO> convernCouponLists, Integer pageNumber, Integer pageSize) {
        ResponseData brandPoResponseData = this.brandServiceRpc.getMastCardBrandByCompanyId(companyId);
        SysBrandPo brandPo = (SysBrandPo)brandPoResponseData.getData();
        if (StringUtils.isEmpty((Object)brandPo)) {
            throw new CustomException("\u6682\u65e0\u6570\u636e004\uff01");
        }
        Long sysBrandIdMaster = brandPo.getSysBrandId();
        CouponIntegralExchangeBO data = (CouponIntegralExchangeBO)convernCouponLists.getData();
        if (StringUtils.isEmpty((Object)data)) {
            throw new CustomException("\u6682\u65e0\u6570\u636e001\uff01");
        }
        PageInfo pageInfo = data.getPageInfo();
        if (StringUtils.isEmpty((Object)pageInfo)) {
            throw new CustomException("\u6682\u65e0\u6570\u636e002\uff01");
        }
        List list = pageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new CustomException("\u6682\u65e0\u6570\u636e003\uff01");
        }
        ArrayList integralExchangeArrayList = new ArrayList();
        list.forEach(vo -> {
            Long sysBrandId = vo.getSysBrandId();
            if (!sysBrandIdMaster.equals(sysBrandId)) {
                integralExchangeArrayList.add(vo);
            }
        });
        log.info("\u8fc7\u6ee4\u540e\u52b5\uff1a{}", (Object)JSON.toJSONString(integralExchangeArrayList));
        PageInfo info = PageUtils.getPageInfo((int)pageNumber, (int)pageSize, integralExchangeArrayList);
        data.setPageInfo(info);
        convernCouponLists.setData((Object)data);
        return convernCouponLists;
    }

    @PostMapping(value={"/updateIntegralConfig"})
    public void updateIntegralConfig(@RequestBody JSONObject json) {
        logger.info("IntegrationShopController#getExchangeCoupon#updateVO:{}", (Object)JSON.toJSONString((Object)json));
        HashMap<String, Object> map = new HashMap<String, Object>();
        Boolean customerService = (Boolean)json.get((Object)"customerService");
        Boolean refundSingle = (Boolean)json.get((Object)"refundSingle");
        if (refundSingle.booleanValue()) {
            map.put("refundSingleConditionList", json.get((Object)"refundSingleConditionList"));
        }
        map.put("awaitOrderCancel", json.get((Object)"awaitOrderCancel"));
        map.put("customerService", customerService);
        map.put("refundSingle", refundSingle);
        map.put("integralRule", json.getString("integralRule"));
        map.put("isDeliverCheck", json.getString("isDeliverCheck"));
        map.put("deliverAuditorMark", json.getString("deliverAuditorMark"));
        map.put("isWholeStore", json.getString("isWholeStore"));
        map.put("hiddenGoods", json.getBooleanValue("hiddenGoods"));
        map.put("showCoupon", json.getBooleanValue("showCoupon"));
        map.put("showCouponInGoods", json.getBooleanValue("showCouponInGoods"));
        map.put("isTimedCancelOrder", json.getIntValue("isTimedCancelOrder"));
        map.put("selfPickTimeJudge", json.getBooleanValue("selfPickTimeJudge"));
        this.integrationShopService.setIntegralConfig2Redis(map, json.getInteger("merchantId"));
    }

    @RequestMapping(value={"/integrationShopStallInfo"}, method={RequestMethod.POST})
    public ResponseData integrationShopStallInfo(HttpServletRequest request, CouponRecordVO couponRecordVO) {
        logger.info("integrationShopStallInfo#couponRecordVO:{}", (Object)JSON.toJSONString((Object)couponRecordVO));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        try {
            if (StringUtils.isEmpty((Object)memberCode)) {
                responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                responseData.setCode(-100);
                return responseData;
            }
            logger.info("\u79ef\u5206\u5151\u6362\u5238\u7684redis\u83b7\u53d6memberCode:{}", (Object)memberCode);
            Long serviceStoreId = this.wxAppletApiService.getServiceStoreId(memberCode).getData() == null ? Long.valueOf(0L) : (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
            MemberInfoModel memberInfoModelSearch = new MemberInfoModel();
            memberInfoModelSearch.setMemberCode(memberCode);
            ResponseData modelResponseData = this.memberInfoApiService.getSingleMemberModel(memberInfoModelSearch);
            logger.info("\u79ef\u5206\u5151\u6362\u5238\u83b7\u53d6crm\u7684memberCode:{},\u7528\u6237\u4fe1\u606f:{}", (Object)memberCode, JSON.toJSON((Object)modelResponseData));
            MemberInfoModel masterMemberInfo = (MemberInfoModel)modelResponseData.getData();
            Integer integral = masterMemberInfo.getCountIntegral();
            if (integral != null) {
                couponRecordVO.setCountIntegral(integral);
            }
            couponRecordVO.setMbrLevelId(masterMemberInfo.getLevelId());
            couponRecordVO.setOpenCardStoreId(serviceStoreId);
            couponRecordVO.setMemberCode(memberCode);
            couponRecordVO.setOpenId(openId);
            CouponIntegralExchangeVO couponIntegralExchangeVO = (CouponIntegralExchangeVO)this.taskServiceForWXRpc.getCouponAndPrice(couponRecordVO).getData();
            MktCouponIntegralExchangePOWithBLOBs mktCouponIntegralExchangePOWithBLOBs = couponIntegralExchangeVO.getMktCouponIntegralExchangePOWithBLOBs();
            String clubId = mktCouponIntegralExchangePOWithBLOBs.getClubId();
            if (!StringUtils.isEmpty((Object)clubId)) {
                List<String> mbrLevelIds;
                Boolean mbrLevelStatus = mktCouponIntegralExchangePOWithBLOBs.getMbrLevelStatus();
                MemberInfoModel memberInfoModelClub = this.vgLoginService.simpleJoinClub(request, masterMemberInfo, Long.valueOf(clubId));
                if (memberInfoModelClub == null) {
                    responseData.setMessage(SysResponseEnum.FAILED.getMessage());
                    responseData.setCode(SysResponseEnum.FAILED.getCode());
                    return responseData;
                }
                if (mbrLevelStatus.booleanValue() && !(mbrLevelIds = Arrays.asList(mktCouponIntegralExchangePOWithBLOBs.getMbrLevelIds().split(","))).contains(memberInfoModelClub.getLevelId().toString())) {
                    responseData.setMessage(SysBusinessResponseEnum.BUSINESS_DEFINED_CODE_NOT_EXCHANGE_ALLOWED.getMessage());
                    responseData.setCode(SysBusinessResponseEnum.BUSINESS_DEFINED_CODE_NOT_EXCHANGE_ALLOWED.getCode());
                    return responseData;
                }
            }
            if (couponRecordVO.getBrandId() == null) {
                responseData.setMessage("\u54c1\u724c\u4e3a null");
                responseData.setCode(100);
                return responseData;
            }
            if (couponRecordVO.getExchangeId() == null) {
                responseData.setMessage("\u89c4\u5219 id \u4e3a\u7a7a");
                responseData.setCode(100);
                return responseData;
            }
            if (couponRecordVO.getExchangeNum() == null) {
                responseData.setMessage("\u5151\u6362\u6570 \u4e3a\u7a7a");
                responseData.setCode(100);
                return responseData;
            }
            logger.info("\u79ef\u5206\u5151\u6362\u5238\u5165\u53c2====" + JSON.toJSON((Object)couponRecordVO.toString()));
            return this.taskServiceForWXRpc.doConvernCoupon(couponRecordVO);
        }
        catch (Exception e) {
            logger.error(memberCode + ":" + e.getMessage(), (Throwable)e);
            responseData.setMessage("\u64cd\u4f5c\u5f02\u5e38");
            responseData.setCode(1);
            return responseData;
        }
    }

    @RequestMapping(value={"/getTmallNick"}, method={RequestMethod.POST})
    ResponseData<String> getTmallNick(CouponRecordVO couponRecordVO, HttpServletRequest request) {
        logger.info("enter IntegrationShopController getTmallNick method! ");
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        if (couponRecordVO.getBrandId() == null) {
            responseData.setMessage("\u54c1\u724c\u4e3a null");
            responseData.setCode(100);
            return responseData;
        }
        if (couponRecordVO.getExchangeId() == null) {
            responseData.setMessage("\u89c4\u5219 id \u4e3a\u7a7a");
            responseData.setCode(100);
            return responseData;
        }
        if (couponRecordVO.getExchangeNum() == null) {
            responseData.setMessage("\u5151\u6362\u6570 \u4e3a\u7a7a");
            responseData.setCode(100);
            return responseData;
        }
        Long openCardStoreId = this.wxAppletApiService.getOpenCardStoreId(memberCode).getData() == null ? Long.valueOf(0L) : (Long)this.wxAppletApiService.getOpenCardStoreId(memberCode).getData();
        ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        MemberCardLevelModel data = (MemberCardLevelModel)modelResponseData.getData();
        Integer integral = data.getCountIntegral();
        if (integral != null) {
            couponRecordVO.setCountIntegral(integral);
        }
        couponRecordVO.setMbrLevelId(data.getLevelId());
        couponRecordVO.setOpenCardStoreId(openCardStoreId);
        couponRecordVO.setMemberCode(memberCode);
        logger.info("\u6821\u9a8c\u5165\u53c2====" + JSON.toJSON((Object)couponRecordVO.toString()));
        return this.couponAuthTmallServiceFeign.getTmallNick(couponRecordVO);
    }

    @RequestMapping(value={"/integrationShopGetOld"}, method={RequestMethod.POST})
    public ResponseData integrationShopGetOld(HttpServletRequest request, CouponRecordVO couponRecordVO) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        if (couponRecordVO.getBrandId() == null) {
            responseData.setMessage("\u54c1\u724c\u4e3a null");
            responseData.setCode(100);
            return responseData;
        }
        ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        MemberCardLevelModel data = (MemberCardLevelModel)modelResponseData.getData();
        couponRecordVO.setMbrLevelId(data.getLevelId());
        couponRecordVO.setMemberCode(memberCode);
        logger.info("\u5165\u53c2====" + JSON.toJSON((Object)couponRecordVO.toString()));
        return this.taskServiceForWXRpc.getConvernConpouByMember(couponRecordVO);
    }

    @RequestMapping(value={"/getCouponAndPrice"}, method={RequestMethod.POST})
    public ResponseData getCouponAndPrice(HttpServletRequest request, CouponRecordVO couponRecordVO) {
        SysBrandPo sysBrandPo;
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        MemberCardLevelModel data = (MemberCardLevelModel)modelResponseData.getData();
        couponRecordVO.setMemberCode(memberCode);
        couponRecordVO.setMbrLevelId(data.getLevelId());
        couponRecordVO.setOpenId(openId);
        logger.info("\u5165\u53c2====" + JSON.toJSON((Object)couponRecordVO.toString()));
        ResponseData couponAndPrice = this.taskServiceForWXRpc.getCouponAndPrice(couponRecordVO);
        CouponIntegralExchangeVO priceData = (CouponIntegralExchangeVO)couponAndPrice.getData();
        if (StringUtils.isEmpty((Object)priceData)) {
            log.info("priceData=======null");
            return couponAndPrice;
        }
        Long twCLubBrandId = null;
        if (!StringUtils.isEmpty((Object)priceData.getExchangeClubId()) && (sysBrandPo = this.brandService.getBrandById(Long.valueOf(priceData.getExchangeClubId()))) != null) {
            twCLubBrandId = sysBrandPo.getParentId();
            priceData.setExchangeClubName(sysBrandPo.getBrandName());
        }
        if (twCLubBrandId != null) {
            SysBrandPo twSysBrandPo = this.brandService.getBrandById(twCLubBrandId);
            priceData.setExchangeClubId(twCLubBrandId.toString());
            priceData.setExchangeClubName(twSysBrandPo.getBrandName());
            List mbrLevelModelList = priceData.getMbrLevelModelList();
            if (!CollectionUtils.isEmpty((Collection)mbrLevelModelList)) {
                List transformTwLevel = this.integrationShopService.transformTwLevel(twCLubBrandId, mbrLevelModelList);
                priceData.setMbrLevelModelList(transformTwLevel);
            }
        }
        priceData.setMktCouponIntegralExchangePOWithBLOBs(null);
        MktGiftBagVO giftBagVO = priceData.getGiftBagVO();
        if (!StringUtils.isEmpty((Object)giftBagVO)) {
            log.info("\u52b5\u5305\u8f6c\u5316\u663e\u793a");
            List couponDefinitionPOList = giftBagVO.getCouponDefinitionPOList();
            CouponDefinitionPO couponDefinition2 = new CouponDefinitionPO();
            StringBuilder listCodeBuilder = new StringBuilder();
            if (!CollectionUtils.isEmpty((Collection)couponDefinitionPOList)) {
                for (CouponDefinitionPOWithBLOBs coupon : couponDefinitionPOList) {
                    CouponUtils.convertApplicableBrandCodes((CouponDefinitionPO)coupon, (int)2);
                    listCodeBuilder.append(coupon.getApplicableBrandCodes());
                    listCodeBuilder.append(",");
                }
                if (!StringUtils.isEmpty((Object)listCodeBuilder)) {
                    couponDefinition2.setApplicableBrandCodes(listCodeBuilder.toString());
                    CouponUtils.convertApplicableBrandCodes((CouponDefinitionPO)couponDefinition2, (int)2);
                    priceData.setCouponDefinitionPO(couponDefinition2);
                }
            }
        } else {
            log.info("\u52b5\u8f6c\u5316\u663e\u793a");
            CouponDefinitionPO couponDefinitionPo = priceData.getCouponDefinitionPO();
            if (!StringUtils.isEmpty((Object)couponDefinitionPo)) {
                CouponUtils.convertApplicableBrandCodes((CouponDefinitionPO)couponDefinitionPo, (int)2);
            }
        }
        return couponAndPrice;
    }

    @Deprecated
    @RequestMapping(value={"/shopHomePage"}, method={RequestMethod.POST})
    public ResponseData shopHomePage(String sysBrandId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.shopHomePage(sysBrandId, memberCode);
    }

    @Deprecated
    @RequestMapping(value={"/querySecKillActivityConfigList"}, method={RequestMethod.POST})
    public ResponseData querySecKillActivityConfigList(HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            return ResponseUtils.getFailedData((String)"\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        log.info("querySecKillActivityConfigList begin");
        return this.integrationShopService.querySecKillActivityConfigList();
    }

    @RequestMapping(value={"/shopHomePage/rotationChartAndClass"}, method={RequestMethod.GET})
    public ResponseData<ShopHomePageVo> getHomePageRotationChart(@RequestHeader(value="sysCompanyId") Long sysCompanyId, @RequestParam String sysBrandId, HttpServletRequest request) {
        logger.info("IntegrationShopController#getHomePageRotationChart#sysBrandId:{}==========:sysCompanyId{}", (Object)sysBrandId, (Object)sysCompanyId);
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            return ResponseUtils.getFailedData((String)"\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            return ResponseUtils.getFailedData((String)"\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return this.integrationShopService.getHomePageRotationChart(sysBrandId, sysCompanyId, memberCode);
    }

    @RequestMapping(value={"/shopHomePage/alertImages"}, method={RequestMethod.GET})
    public Result<List<ActivityImgQueryResponseVO>> getHomePagealertImages(@RequestHeader(value="sysCompanyId") Long sysCompanyId, @RequestParam String sysBrandId, HttpServletRequest request) {
        logger.info("IntegrationShopController#getHomePagealertImages#sysBrandId:{}==========:sysCompanyId{}", (Object)sysBrandId, (Object)sysCompanyId);
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            return Result.failure((String)"\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            return Result.failure((String)"\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return Result.success((Object)this.integrationShopService.queryActivityAlertImages(sysBrandId, memberCode));
    }

    @RequestMapping(value={"/shopHomePage/getHomePageHotCommodity"}, method={RequestMethod.GET})
    public ResponseData<JSONObject> getHomePageHotCommodity(@RequestParam(value="sysBrandId") Long sysBrandId, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="pageIndex") Integer pageIndex, HttpServletRequest request) {
        IntegralShopGetHomePageHotCommodityRequestVO requestVO = IntegralShopGetHomePageHotCommodityRequestVO.builder().sysBrandId(sysBrandId).pageIndex(pageIndex).pageSize(pageSize).build();
        logger.info("IntegrationShopController#getHomePageRotationChart#requestVO:{}", JSON.toJSON((Object)requestVO));
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            return ResponseUtils.getFailedData((String)"\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            return ResponseUtils.getFailedData((String)"\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        requestVO.setMemberCode(memberCode);
        return this.integrationShopService.getHomePageHotCommodity(requestVO);
    }

    @RequestMapping(value={"/shopHomePage/getHomePageMemberInfo"}, method={RequestMethod.GET})
    public ResponseData<ShopHomePageVo> getHomePageMemberInfo(HttpServletRequest request, @RequestParam Long sysBrandId) {
        logger.info("IntegrationShopController#getHomePageMemberInfo#sysBrandId:{} ", (Object)sysBrandId);
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            return ResponseUtils.getFailedData((String)"\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            return ResponseUtils.getFailedData((String)"\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return this.integrationShopService.getHomePageMemberInfo(memberCode, sysBrandId);
    }

    @RequestMapping(value={"/fullMerchandiseDisplay"}, method={RequestMethod.POST})
    public ResponseData fullMerchandiseDisplay(AllMerchandiseVo allMerchandiseVo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        allMerchandiseVo.setMemberCode(memberCode);
        return this.integrationShopService.fullMerchandiseDisplay(allMerchandiseVo);
    }

    @RequestMapping(value={"/commodityDetails"}, method={RequestMethod.POST})
    public ResponseData commodityDetails(String hostId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.commodityDetails(hostId);
    }

    @RequestMapping(value={"/classifiedGoods"}, method={RequestMethod.POST})
    public ResponseData classifiedGoods(@RequestHeader(value="sysCompanyId") Long sysCompanyId, classifiedGoodsVo classifiedGoodsVo2, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        classifiedGoodsVo2.setSysCompanyId(sysCompanyId);
        return this.integrationShopService.classifiedGoods(classifiedGoodsVo2);
    }

    @RequestMapping(value={"/tailForClassifiedGoods"}, method={RequestMethod.POST})
    public ResponseData tailForClassifiedGoods(AllMerchandiseVo allMerchandiseVo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        allMerchandiseVo.setMemberCode(memberCode);
        return this.integrationShopService.tailForClassifiedGoods(allMerchandiseVo);
    }

    @RequestMapping(value={"/activitySubjectGoods"}, method={RequestMethod.GET})
    public ResponseData activitySubjectGoods(AllMerchandiseVo allMerchandiseVo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        allMerchandiseVo.setMemberCode(memberCode);
        return this.integrationShopService.activitySubjectGoods(allMerchandiseVo);
    }

    @PostMapping(value={"/getFeight"})
    public ResponseData getFeight(@RequestBody IntegralOrderFeightVO integralOrderFeightVO) {
        ResponseData responseData = new ResponseData();
        logger.info("IntegrationShopController_getFeight:{}", (Object)JSON.toJSONString((Object)integralOrderFeightVO));
        responseData = this.integrationShopService.getFeight(integralOrderFeightVO);
        return responseData;
    }

    @RequestMapping(value={"/queryOfflineMemberInfo"}, method={RequestMethod.POST})
    public ResponseData<MemberInfoModel> queryOfflineMemberInfo(@RequestParam(value="sysCompanyId") Long sysCompanyId, @RequestParam(value="brandId") Long brandId, @RequestParam(value="memberCode") String memberCode) {
        logger.info("IntegrationShopController#brandId:{},memberCode:{}", (Object)brandId, (Object)memberCode);
        ResponseData modelResponseData = this.memberInfoApiService.queryOfflineMemberInfo(sysCompanyId, brandId, memberCode);
        logger.info("IntegrationShopController#modelResponseData:{}", (Object)JSON.toJSONString((Object)modelResponseData));
        return modelResponseData;
    }

    @RequestMapping(value={"/generateOrder"}, method={RequestMethod.POST})
    public ResponseData generateOrder(ConfirmGoodsVo confirmGoodsVo, HttpServletRequest request) {
        logger.info("IntegrationShopController#generateOrder#confirmGoodsVo :{}", JSONObject.toJSON((Object)confirmGoodsVo));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        try {
            logger.info("generateOrder\u7684redis\u83b7\u53d6memberCode:{}", (Object)memberCode);
            if (StringUtils.isEmpty((Object)memberCode)) {
                responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                responseData.setCode(-100);
                return responseData;
            }
            confirmGoodsVo.setMemberCode(memberCode);
            logger.info("\u79ef\u5206\u751f\u6210\u8ba2\u5355generateOrder\u7684memberCode:{},\u8fdb\u5165\u79ef\u5206\u5546\u57ce\u5165\u53c2:{}", (Object)memberCode, JSON.toJSON((Object)confirmGoodsVo));
            return this.integrationShopService.generateOrder(request, confirmGoodsVo);
        }
        catch (Exception e) {
            logger.error(memberCode + ":" + e.getMessage(), (Throwable)e);
            responseData.setMessage("\u64cd\u4f5c\u5f02\u5e38");
            responseData.setCode(1);
            return responseData;
        }
    }

    @RequestMapping(value={"/generateOrderCheckLable"}, method={RequestMethod.POST})
    public ResponseData generateOrderCheckLable(ConfirmGoodsVo confirmGoodsVo, HttpServletRequest request) {
        logger.info("IntegrationShopController#generateOrderCheckLable#confirmGoodsVo :{}", JSONObject.toJSON((Object)confirmGoodsVo));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        try {
            logger.info("generateOrderCheckLable\u7684redis\u83b7\u53d6memberCode:{}", (Object)memberCode);
            if (StringUtils.isEmpty((Object)memberCode)) {
                responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                responseData.setCode(-100);
                return responseData;
            }
            confirmGoodsVo.setMemberCode(memberCode);
            logger.info("\u79ef\u5206\u751f\u6210\u8ba2\u5355generateOrderCheckLable\u7684memberCode:{},\u8fdb\u5165\u79ef\u5206\u5546\u57ce\u5165\u53c2:{}", (Object)memberCode, JSON.toJSON((Object)confirmGoodsVo));
            return this.integrationShopService.generateOrderCheckLable(request, confirmGoodsVo);
        }
        catch (Exception e) {
            logger.error(memberCode + ":" + e.getMessage(), (Throwable)e);
            responseData.setMessage("\u64cd\u4f5c\u5f02\u5e38");
            responseData.setCode(1);
            return responseData;
        }
    }

    @RequestMapping(value={"/inventoryStatus"}, method={RequestMethod.POST})
    public ResponseData inventoryStatus(ConfirmGoodsVo confirmGoodsVo, String hostId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.inventoryStatus(confirmGoodsVo);
    }

    @RequestMapping(value={"/increaseReceivingAddress"}, method={RequestMethod.POST})
    public ResponseData increaseReceivingAddress(UserAddressPutVo UserAddressPutVo2, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        UserAddressPutVo2.setMemberCode(memberCode);
        return this.integrationShopService.increaseReceivingAddress(UserAddressPutVo2);
    }

    @RequestMapping(value={"/editReceivingAddress"}, method={RequestMethod.POST})
    public ResponseData editReceivingAddress(UserAddressPutVo UserAddressPutVo2, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        UserAddressPutVo2.setMemberCode(memberCode);
        return this.integrationShopService.editReceivingAddress(UserAddressPutVo2);
    }

    @RequestMapping(value={"/eliminateReceivingAddress"}, method={RequestMethod.POST})
    public ResponseData eliminateReceivingAddress(UserAddressPutVo UserAddressPutVo2, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        UserAddressPutVo2.setMemberCode(memberCode);
        return this.integrationShopService.eliminateReceivingAddress(UserAddressPutVo2);
    }

    @RequestMapping(value={"/addressuery"}, method={RequestMethod.POST})
    ResponseData addressuery(HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.addressuery(memberCode);
    }

    @RequestMapping(value={"/manualSign"}, method={RequestMethod.GET})
    public ResponseData manualSign(@RequestParam(value="orderNo") String orderNo) {
        try {
            log.info("WxIntegralOrdersController.manualSign,orderNo:{}", (Object)orderNo);
            return this.integrationShopService.manualSign(orderNo);
        }
        catch (Exception e) {
            log.error("WxIntegralOrdersController.manualSign,orderNo:{}", (Object)orderNo, (Object)e);
            ResponseData responseData = new ResponseData();
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(e.getMessage());
            return responseData;
        }
    }

    @RequestMapping(value={"/checkCanManualSign"}, method={RequestMethod.GET})
    public ResponseData checkCanManualSign(@RequestParam(value="orderNo") String orderNo) {
        try {
            log.info("WxIntegralOrdersController.checkCanManualSign,orderNo:{}", (Object)orderNo);
            return this.integrationShopService.checkCanManualSign(orderNo);
        }
        catch (Exception e) {
            log.error("WxIntegralOrdersController.checkCanManualSign,orderNo:{}", (Object)orderNo, (Object)e);
            ResponseData responseData = new ResponseData();
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(e.getMessage());
            return responseData;
        }
    }

    @RequestMapping(value={"/fullOrderDisplayNew"}, method={RequestMethod.POST})
    ResponseData fullOrderDisplay(Long sysCompanyId, String sysBrandId, String orderStatus, HttpServletRequest request, Integer pageNum, Integer pageSize) {
        log.info("---------------------------" + orderStatus);
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.fullOrderDisplay(sysCompanyId, sysBrandId, orderStatus, memberCode, pageNum, pageSize);
    }

    @RequestMapping(value={"/fullOrderDisplay"}, method={RequestMethod.POST})
    ResponseData fullOrderDisplay(Long sysCompanyId, String sysBrandId, String orderStatus, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.fullOrderDisplay(sysCompanyId, sysBrandId, orderStatus, memberCode);
    }

    @RequestMapping(value={"/fullCouponDisplay"}, method={RequestMethod.POST})
    ResponseData<PageInfo<MktConvertCouponRecordBo>> fullCouponDisplay(CouponRecordVO couponRecordVO, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        couponRecordVO.setMemberCode(memberCode);
        ResponseData pageInfoResponseData = this.integrationShopService.fullCouponDisplay(couponRecordVO);
        int code = pageInfoResponseData.getCode();
        if (code == 0) {
            return pageInfoResponseData;
        }
        responseData.setMessage("\u6682\u65f6\u8fd8\u6ca1\u6709\u4f60\u60f3\u8981\u7684\u6570\u636e\uff01");
        return responseData;
    }

    @RequestMapping(value={"/tailForFullCouponDisplay"}, method={RequestMethod.POST})
    ResponseData tailForFullCouponDisplay(Long convertCouponRecordId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.tailForFullCouponDisplay(convertCouponRecordId, memberCode);
    }

    @RequestMapping(value={"/viewOrder"}, method={RequestMethod.POST})
    ResponseData viewOrder(String orderId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.viewOrder(orderId);
    }

    @RequestMapping(value={"/integralAcquisition"}, method={RequestMethod.POST})
    ResponseData integralAcquisition(String sysBrandId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.integralAcquisition(sysBrandId);
    }

    @RequestMapping(value={"/storeSelfMention"}, method={RequestMethod.POST})
    ResponseData storeSelfMention(HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.storeSelfMention();
    }

    @RequestMapping(value={"/logisticsCompanyGroup"}, method={RequestMethod.POST})
    ResponseData logisticsCompanyGroup(HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.logisticsCompanyGroup();
    }

    @RequestMapping(value={"/displayLogistics"}, method={RequestMethod.POST})
    ResponseData displayLogistics(String companyCode, String num, String phone, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.displayLogistics(companyCode, num, phone);
    }

    @RequestMapping(value={"/applyeturnSubmission"}, method={RequestMethod.POST})
    ResponseData applyeturnSubmission(ReturnGoodsVo returnGoodsVo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        returnGoodsVo.setMemberCode(memberCode);
        return this.integrationShopService.applyeturnSubmission(returnGoodsVo);
    }

    @RequestMapping(value={"/applyeturnNotSubmitted"}, method={RequestMethod.POST})
    ResponseData applyeturnNotSubmitted(RefundLogisticsVo refundLogisticsVo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.applyeturnNotSubmitted(refundLogisticsVo);
    }

    @RequestMapping(value={"/instructions"}, method={RequestMethod.POST})
    ResponseData instructions(String sysBrandId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.instructions(sysBrandId);
    }

    @GetMapping(value={"/getConfig"})
    public ResponseData getConfig(String merchantId) throws IOException {
        log.info("IntegrationShopController#getConfig\u83b7\u53d6\u57fa\u7840\u914d\u7f6e:{}", (Object)merchantId);
        if (StringUtils.isEmpty((Object)merchantId)) {
            ResponseData responseData = new ResponseData();
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        try {
            Integer integer = Integer.valueOf(merchantId);
            return this.integrationShopService.getConfig(integer);
        }
        catch (NumberFormatException e) {
            ResponseData responseData = new ResponseData();
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
    }

    @GetMapping(value={"/getMemberLevelBySysBrandId"})
    public ResponseData getMemberLevelBySysBrandId(@RequestParam(value="brandid") Long brandId) {
        logger.info("getMemberLevelBySysBrandId\u5165\u53c2:[{}]", (Object)brandId);
        ResponseData listResponseData = this.memberLevelApiService.queryAllLevelList(brandId);
        return listResponseData;
    }

    @PostMapping(value={"getStoreListByBrandId"})
    public ResponseData getStoreListByBrandId(@RequestBody SysStoreVo vo) {
        logger.info("getStoreListByBrandId\u5165\u53c2:[{}]", JSON.toJSON((Object)vo));
        ResponseData sysStoreList = this.brandServiceRpc.getSysStoreList(vo);
        return sysStoreList;
    }

    @PostMapping(value={"integralOrdersByPage"})
    public ResponseData getIntegralOrdersByPage(int pageNum, int pageSize, Integer sysBrandId, HttpServletRequest request) {
        logger.info("integralOrdersByPage\u5165\u53c2:pageNum[{}],pageSize[{}],sysBrandId[{}]", new Object[]{pageNum, pageSize, sysBrandId});
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("\u83b7\u53d6\u5230\u7684bizvaneSessionId --------------- = {}", (Object)bizvaneSessionId);
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        logger.info("\u83b7\u53d6\u5230\u7684memberCode --------------- = {}", (Object)bizvaneSessionId);
        logger.info("\u67e5\u8be2memberCode \u7684key\u503c --------------- = {}", (Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isEmpty((Object)memberCode)) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.getAllOrdersPages(pageNum, pageSize, sysBrandId, memberCode);
    }

    @GetMapping(value={"payment"})
    public ResponseData payment(Integer ordersId, HttpServletRequest request) {
        logger.info("payment\u5165\u53c2:ordersId[{}]", (Object)ordersId);
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("\u83b7\u53d6\u5230\u7684bizvaneSessionId --------------- = {}", (Object)bizvaneSessionId);
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        return this.integrationShopService.payment(ordersId);
    }

    @GetMapping(value={"paymentWithCoupon"})
    public ResponseData paymentWithCoupon(Integer convertCouponRecordId, HttpServletRequest request) {
        logger.info("paymentWithCoupon\u5165\u53c2:convertCouponRecordId[{}]", (Object)convertCouponRecordId);
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("\u83b7\u53d6\u5230\u7684bizvaneSessionId --------------- = {}", (Object)bizvaneSessionId);
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        return this.integrationShopService.paymentWithCoupon(convertCouponRecordId, bizvaneSessionId);
    }

    @GetMapping(value={"payCouponSuccess"})
    public ResponseData payCouponSuccess(Integer convertCouponRecordId, HttpServletRequest request) {
        logger.info("payCouponSuccess\u5165\u53c2:convertCouponRecordId[{}]", (Object)convertCouponRecordId);
        String redisKey = "payCouponSuccess" + convertCouponRecordId;
        String doit = (String)this.redisTemplateService.stringGetStringByKey((Object)redisKey);
        if (doit != null) {
            ResponseData responseData = new ResponseData();
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8bf7\u4e0d\u8981\u91cd\u590d\u8bf7\u6c42");
            return responseData;
        }
        this.redisTemplateService.stringSetValueAndExpireTime((Object)redisKey, (Object)(convertCouponRecordId + ""), 3000L);
        ResponseData responseData = this.integrationShopService.payCouponSuccess(convertCouponRecordId);
        this.redisTemplateService.deleteFromRedis((Object)redisKey);
        return responseData;
    }

    @PostMapping(value={"/getIntegralClassifyQRCordUrl"})
    public ResponseData getIntegralClassifyQRCordUrl(@RequestBody IntegralQRCodeRequestVO integralQRCodeRequestVO) {
        logger.info("IntegrationShopController_getIntegralClassifyQRCordUrl:{}", (Object)JSON.toJSONString((Object)integralQRCodeRequestVO));
        ResponseData responseData = this.integrationShopService.getIntegralClassifyQRCord(integralQRCodeRequestVO);
        return responseData;
    }

    @RequestMapping(value={"/getGoodsClubInfo"}, method={RequestMethod.POST})
    public ResponseData getGoodsClubInfo(String goodsId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.getGoodsClubInfo(goodsId);
    }
}

