/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.teddy;

import com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.interfaces.LoginService;
import com.bizvane.appletservice.interfaces.teddy.TeddyGoodsVerifyService;
import com.bizvane.appletservice.models.bo.MemberResoucreBO;
import com.bizvane.appletservice.models.vo.TeddyGoodsDetailVo;
import com.bizvane.appletserviceimpl.impl.teddy.util.CheckResultUtil;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.customized.facade.interfaces.CusTeddyGoodsServiceFeign;
import com.bizvane.customized.facade.models.po.CusTeddyGoodsCodeDetailPO;
import com.bizvane.customized.facade.models.vo.teddy.CusTeddyGoodsVo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.utils.responseinfo.ResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TeddyGoodsVerifyServiceImpl
implements TeddyGoodsVerifyService {
    private static final Logger log = LoggerFactory.getLogger(TeddyGoodsVerifyServiceImpl.class);
    @Autowired
    private LoginService loginService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private CusTeddyGoodsServiceFeign cusTeddyGoodsServiceFeign;
    @Autowired
    private StoreServiceRpc storeServiceRpc;

    public ResponseData<CusTeddyGoodsVo> verify(String code, String verifyCode) {
        MemberResoucreBO memberResourceBO = this.loginService.getMemberResourceBO();
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberResourceBO.getMemberCode());
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        log.info("\u5546\u54c1\u6821\u9a8c\u8865\u767b\u4f1a\u5458\u6743\u76ca \u67e5\u8be2\u4f1a\u5458\u4fe1\u606f={}", (Object)JSON.toJSONString((Object)singleMemberModel));
        MemberInfoModel member = (MemberInfoModel)singleMemberModel.getData();
        ResponseData storePoResponseData = this.storeServiceRpc.getStoreById(member.getServiceStoreId());
        log.info("\u6839\u636e\u4f1a\u5458\u670d\u52a1\u95e8\u5e97id\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f={}", (Object)JSON.toJSONString((Object)storePoResponseData));
        SysStorePo storePo = (SysStorePo)CheckResultUtil.checkResponseData((ResponseData)storePoResponseData, (String)"\u95e8\u5e97\u4fe1\u606f\u9519\u8bef");
        CusTeddyGoodsVo vo = CusTeddyGoodsVo.builder().companyId(memberResourceBO.getSysCompanyId()).brandId(memberResourceBO.getBrandId()).erpId(member.getErpId()).memberCode(member.getMemberCode()).memberName(member.getName()).phone(member.getPhone()).storeCode(member.getServiceStoreCode()).storeName(storePo.getStoreName()).code(code).verifyCode(verifyCode).build();
        return this.cusTeddyGoodsServiceFeign.verify(vo);
    }

    public ResponseData<TeddyGoodsDetailVo> detail(String code) {
        MemberResoucreBO memberResourceBO = this.loginService.getMemberResourceBO();
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberResourceBO.getMemberCode());
        ResponseData memberInfoModelResponseData = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        log.info("\u6839\u636ecode\u67e5\u8be2\u5546\u54c1\u7801\u4fe1\u606f \u67e5\u8be2\u4f1a\u5458\u4fe1\u606f={}", (Object)JSON.toJSONString((Object)memberInfoModelResponseData));
        MemberInfoModel member = (MemberInfoModel)CheckResultUtil.checkResponseData((ResponseData)memberInfoModelResponseData, (String)"\u4f1a\u5458\u4fe1\u606f\u9519\u8bef");
        CusTeddyGoodsVo vo = CusTeddyGoodsVo.builder().companyId(memberResourceBO.getSysCompanyId()).brandId(memberResourceBO.getBrandId()).code(code).build();
        ResponseData detailPOResponseData = this.cusTeddyGoodsServiceFeign.detail(vo);
        log.info("\u6839\u636ecode\u67e5\u8be2\u5546\u54c1\u7801\u4fe1\u606f \u67e5\u8be2\u5546\u54c1\u7801\u4fe1\u606f={}", (Object)JSON.toJSONString((Object)detailPOResponseData));
        CusTeddyGoodsCodeDetailPO detailPO = (CusTeddyGoodsCodeDetailPO)CheckResultUtil.checkResponseData((ResponseData)detailPOResponseData, (String)"\u5546\u54c1\u7801\u9519\u8bef");
        TeddyGoodsDetailVo goodsDetailVo = TeddyGoodsDetailVo.builder().phone(member.getPhone()).skuCode(detailPO.getSkuCode()).skuName(detailPO.getSkuName()).verifyStatus(String.valueOf(detailPO.getVerifyStatus())).build();
        return new ResponseData((Object)goodsDetailVo);
    }
}

