/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.common.HttpUtil;
import com.bizvane.appletservice.interfaces.WxPayService;
import com.bizvane.appletservice.models.bo.AppletWxPayBo;
import com.bizvane.appletservice.models.bo.WxPayLevelBO;
import com.bizvane.appletservice.models.vo.CreateGitfCardOrderVo;
import com.bizvane.appletservice.models.vo.CreateRechargeVO;
import com.bizvane.appletservice.models.vo.WxpayCreateMpVO;
import com.bizvane.appletserviceimpl.common.RechargeTypeEnum;
import com.bizvane.appletserviceimpl.controllers.yw.StandardBSRechargeBrandIds;
import com.bizvane.appletserviceimpl.enums.OrderNoGeneratePrefixEnum;
import com.bizvane.appletserviceimpl.impl.yw.CrmOpenCardNotify2YZAndNXServiceImpl;
import com.bizvane.appletserviceimpl.impl.yw.YwHelper;
import com.bizvane.appletserviceimpl.utils.WXPayConstants;
import com.bizvane.appletserviceimpl.utils.WXPayUtil;
import com.bizvane.appletserviceimpl.utils.WxConfig;
import com.bizvane.centerstageservice.models.po.MbrRechargeRecordPo;
import com.bizvane.centerstageservice.models.po.SysStaffPo;
import com.bizvane.centerstageservice.models.po.WxPayConfigPo;
import com.bizvane.centerstageservice.rpc.MbrRechargeServiceRpc;
import com.bizvane.centerstageservice.rpc.StaffServiceRpc;
import com.bizvane.core.facade.interfaces.CoreTraceFeign;
import com.bizvane.core.facade.models.po.TraceRecordPO;
import com.bizvane.core.facade.models.vo.TraceRecordVo;
import com.bizvane.customized.facade.interfaces.CusYwRechargeServiceFeign;
import com.bizvane.customized.facade.interfaces.RechargeCardServiceFeign;
import com.bizvane.customized.facade.models.vo.UrRechargeCardVo;
import com.bizvane.customized.facade.models.vo.yiwen.YwRechargeQueryVo;
import com.bizvane.customized.facade.models.vo.yiwen.YwRechargeRecordVo;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberCardProgramApiService;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MemberLevelRechargeApiService;
import com.bizvane.members.facade.service.qywxapi.CompanyMemberApiService;
import com.bizvane.members.facade.service.qywxapi.WxMembersApiService;
import com.bizvane.members.facade.vo.BatchUpdateMemberInfoVo;
import com.bizvane.members.facade.vo.LevelRechargeCallBackRequestVO;
import com.bizvane.members.facade.vo.qywx.MemberFriendsKeyQueryVo;
import com.bizvane.mktcenterservice.models.vo.MemberInfoModelVOActivity;
import com.bizvane.mktcenterservice.rpc.ActivityPayServiceRpc;
import com.bizvane.serviceCard.interfaces.GiftCardStandardServiceFeign;
import com.bizvane.serviceCard.models.dto.giftCard.ReqGiftCardInfoDTO;
import com.bizvane.utils.commonutils.DateUtils;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.redisutils.RedissonTemplate;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class WxPayServiceImpl
implements WxPayService {
    private static final Logger log = LoggerFactory.getLogger(WxPayServiceImpl.class);
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private WxMembersApiService wxMembersApiService;
    @Autowired
    private ActivityPayServiceRpc activityPayServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private CompanyMemberApiService companyMemberApiService;
    @Autowired
    private RedissonTemplate redissonTemplate;
    @Autowired
    private RechargeCardServiceFeign rechargeCardServiceFeign;
    @Autowired
    private MemberLevelRechargeApiService memberLevelRechargeApiService;
    @Autowired
    private CoreTraceFeign coreTraceFeign;
    @Autowired
    private StaffServiceRpc staffServiceRpc;
    @Autowired
    private GiftCardStandardServiceFeign giftCardStandardServiceFeign;
    public static final String[] SOURCE_WAY = new String[]{"appletGuide2MbrPetCard", "wxqyGuide2friend"};
    @Value(value="${ur.brandId}")
    private Long brandId;
    private static final String PLACE_ORDER = "https://api.mch.weixin.qq.com/pay/unifiedorder";
    private static final String CHARSET = "UTF-8";
    @Autowired
    private MemberCardProgramApiService memberCardProgramApiService;
    @Autowired
    private MbrRechargeServiceRpc mbrRechargeServiceRpc;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private WxConfig wxConfig;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    @Autowired
    private CusYwRechargeServiceFeign cusYwRechargeServiceFeign;
    @Autowired
    private StandardBSRechargeBrandIds standardBSRechargeBrandIds;
    @Value(value="${yiWen.brandId}")
    private Long yiWenBrandId;
    @Autowired
    private YwHelper ywHelper;
    @Autowired
    private CrmOpenCardNotify2YZAndNXServiceImpl crmOpenCardNotify2YZAndNXService;

    public Map<String, String> createRecharge(CreateRechargeVO vo, WxPayConfigPo configPo) {
        String amount = vo.getMoney();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String billNumber = OrderNoGeneratePrefixEnum.CHUZHI_CARD_OTHER.getSufixValue() + sdf.format(new Date()) + (int)((Math.random() * 9.0 + 1.0) * 1000.0);
        String remark = StringUtils.isBlank((CharSequence)vo.getRemake()) ? "\u5145\u503c" : vo.getRemake();
        String notifyUrl = this.wxConfig.getBaseUrl() + "/wxPay/callback";
        Map map = this.createMp(vo.getGiveMoney(), vo.getOpenid(), vo.getAppId(), billNumber, amount, remark, notifyUrl, configPo, vo.getMemberCode(), vo.getActivityId(), vo);
        return map;
    }

    public Map<String, String> createGiftCardOrder(CreateGitfCardOrderVo vo, WxPayConfigPo configPo) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String billNumber = OrderNoGeneratePrefixEnum.SERVICE_GIFT.getSufixValue() + sdf.format(new Date()) + (int)((Math.random() * 9.0 + 1.0) * 1000.0);
        String remark = "\u793c\u54c1\u5361\u8d2d\u4e70";
        String notifyUrl = this.wxConfig.getBaseUrl() + "/wxPay/callback";
        Map map = this.createMp(vo.getOpenid(), vo.getAppId(), billNumber, vo.getSellPrice() + "", remark, notifyUrl, configPo, vo.getMemberCode(), vo);
        return map;
    }

    public String callback(HttpServletRequest req, HttpServletResponse res) {
        logger.info("enter callback:{}", (Object)JSON.toJSONString((Object)this.standardBSRechargeBrandIds));
        StringBuffer buffer = new StringBuffer();
        try {
            String content = IOUtils.toString((InputStream)req.getInputStream(), (String)CHARSET);
            logger.info("\u63a5\u6536\u5230\u5fae\u4fe1\u901a\u77e5,\u5185\u5bb9={}", (Object)content);
            String out_trade_no = this.read(content, "out_trade_no");
            String transaction_id = this.read(content, "transaction_id");
            String time_end = this.read(content, "time_end");
            String cash_fee = this.read(content, "cash_fee");
            String return_code = this.read(content, "return_code");
            String appid = this.read(content, "appid");
            String openid = this.read(content, "openid");
            String attachStr = this.read(content, "attach");
            String total_fee = this.read(content, "total_fee");
            logger.info("\u63a5\u6536\u5230\u5fae\u4fe1\u901a\u77e5,attachStr={}", (Object)attachStr);
            JSONObject attach = JSONObject.parseObject((String)attachStr);
            String giveMoney = "";
            String memberCode = "";
            String activityId = "";
            Long sysBrandId = null;
            Long sysCompanyId = null;
            String cardStyleCode = "";
            String name = "";
            Long cardType = null;
            String storedCardCode = null;
            Long mbrRechargeExplainId = null;
            if (attach != null) {
                Object mbrRechargeExplainIdObj;
                giveMoney = String.valueOf(attach.get((Object)"m"));
                memberCode = String.valueOf(attach.get((Object)"mC"));
                activityId = String.valueOf(attach.get((Object)"aid"));
                sysBrandId = Long.valueOf(String.valueOf(attach.get((Object)"bid")));
                sysCompanyId = Long.valueOf(String.valueOf(attach.get((Object)"cid")));
                String cardTypeString = attach.getString("c");
                if (StringUtils.isNotEmpty((CharSequence)cardTypeString)) {
                    cardType = Long.valueOf(cardTypeString);
                }
                storedCardCode = attach.getString("s");
                if (attach.get((Object)"p") != null) {
                    String params = String.valueOf(attach.get((Object)"p"));
                    String[] split = params.split(",");
                    if (split.length > 1) {
                        name = split[0];
                        cardStyleCode = split[1];
                    } else {
                        name = split[0];
                    }
                }
                if ((mbrRechargeExplainIdObj = attach.get((Object)"mbrRechargeExplainId")) != null && StringUtils.isNotBlank((CharSequence)mbrRechargeExplainIdObj.toString()) && !"null".equals(mbrRechargeExplainIdObj.toString())) {
                    mbrRechargeExplainId = Long.valueOf(attach.get((Object)"mbrRechargeExplainId").toString());
                }
            }
            logger.info("attach\u89e3\u6790\u7ed3\u675f");
            String sign = this.read(content, "sign");
            if (StringUtils.isBlank((CharSequence)sign)) {
                logger.info("WXPAY callback sign is null");
                return buffer.toString();
            }
            WxPayConfigPo po = new WxPayConfigPo();
            po.setSysCompanyId(sysCompanyId);
            po.setSysBrandId(sysBrandId);
            ResponseData data = this.mbrRechargeServiceRpc.getWxPayConfigRpc(po);
            WxPayConfigPo wxPayConfigPo = (WxPayConfigPo)data.getData();
            Map stringStringMap = WXPayUtil.xmlToMap((String)content);
            boolean signatureValid = WXPayUtil.isSignatureValid((Map)stringStringMap, (String)wxPayConfigPo.getSecretKey(), (WXPayConstants.SignType)WXPayConstants.SignType.MD5);
            if (!signatureValid) {
                return buffer.toString();
            }
            if ("SUCCESS".equals(return_code)) {
                List<String> ids;
                if (this.isGitfCard(out_trade_no)) {
                    log.info("\u8fdb\u5165\u793c\u54c1\u5361\u56de\u8c03\u6d41\u7a0b");
                    return this.execGitfCardService(out_trade_no, total_fee, transaction_id, memberCode, sysCompanyId, sysBrandId, attach);
                }
                AppletWxPayBo payBo = new AppletWxPayBo();
                payBo.setAppId(appid);
                payBo.setOpenId(openid);
                payBo.setMemberCode(memberCode);
                AppletWxPayBo wxPayBo = this.readSockt(payBo);
                DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
                LocalDateTime dateTime = LocalDateTime.parse(time_end, pattern);
                ZoneId zoneId = ZoneId.systemDefault();
                ZonedDateTime zonedDateTime = dateTime.atZone(zoneId);
                Date timeEnd = Date.from(zonedDateTime.toInstant());
                logger.info("PaymentDate={}", (Object)timeEnd);
                AppletWxPayBo appletWxPayBo = new AppletWxPayBo();
                appletWxPayBo.setMemberCode(wxPayBo.getMemberCode());
                appletWxPayBo.setMoney(Double.valueOf(Double.parseDouble(total_fee) / (double)this.wxConfig.getMoneyCode().intValue()));
                logger.info("testBrand start");
                String testBrand = this.wxConfig.getTestBrand();
                if (StringUtils.isNotEmpty((CharSequence)testBrand) && (ids = Arrays.asList(testBrand.split(","))).contains(appid)) {
                    appletWxPayBo.setMoney(Double.valueOf(appletWxPayBo.getMoney() * 100.0));
                }
                logger.info("testBrand end");
                appletWxPayBo.setPaymentDate(timeEnd);
                appletWxPayBo.setSysBrandId(wxPayBo.getSysBrandId());
                appletWxPayBo.setGiveMoney(Double.valueOf(giveMoney));
                appletWxPayBo.setWxPayVoucherNo(transaction_id);
                logger.info("\u5f00\u59cb\u5224\u65ad\u54c1\u724c:{}", (Object)wxPayBo.getSysBrandId());
                if (StringUtils.isNotEmpty((CharSequence)appletWxPayBo.getMemberCode())) {
                    Long sysStoreId = this.getSysStoreId(appletWxPayBo.getMemberCode());
                    appletWxPayBo.setSysStoreId(sysStoreId);
                }
                ResponseData responseData = null;
                if (this.brandId.equals(wxPayBo.getSysBrandId())) {
                    logger.info("\u54c1\u724cid\u662fur");
                    appletWxPayBo.setSysCompanyId(sysCompanyId);
                    appletWxPayBo.setCardStyleCode(cardStyleCode);
                    appletWxPayBo.setName(name);
                    appletWxPayBo.setOutTradeNo(out_trade_no);
                    responseData = this.urAddMbrRechargeRecord(appletWxPayBo);
                } else if (this.standardBSRechargeBrandIds.getBrandList().contains(wxPayBo.getSysBrandId())) {
                    logger.info("\u54c1\u724cid\u662f\u4f0a\u6587");
                    appletWxPayBo.setSysCompanyId(sysCompanyId);
                    appletWxPayBo.setCardType(cardType);
                    appletWxPayBo.setStoredCardCode(storedCardCode);
                    responseData = this.addMbrRechargeRecordYw(appletWxPayBo);
                } else {
                    appletWxPayBo.setOutTradeNo(out_trade_no);
                    appletWxPayBo.setMbrRechargeExplainId(mbrRechargeExplainId);
                    responseData = this.addMbrRechargeRecord(appletWxPayBo);
                }
                logger.info("\u5224\u65ad\u54c1\u724c\u7ed3\u675f");
                if (responseData == null || responseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
                    logger.info("\u8c03\u7528\u4e2d\u53f0\u63a5\u53e3\u62a5\u9519={}", (Object)JSON.toJSONString((Object)responseData));
                    buffer.append("<xml>").append("<return_code><![CDATA[FAIL]]></return_code>").append("<return_msg><![CDATA[NO]]></return_msg>").append("</xml>");
                    return buffer.toString();
                }
                logger.info("\u6267\u884c\u50a8\u503c\u6d3b\u52a8 ");
                if (!"null".equals(activityId) && StringUtils.isNotEmpty((CharSequence)activityId)) {
                    MemberInfoModel memberInfoModel = new MemberInfoModel();
                    memberInfoModel.setMemberCode(memberCode);
                    ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
                    MemberInfoModel member = (MemberInfoModel)singleMemberModel.getData();
                    MemberInfoModelVOActivity memberInfoVO = new MemberInfoModelVOActivity();
                    memberInfoVO.setMemberCode(memberCode);
                    memberInfoVO.setPayId(Integer.valueOf(activityId));
                    memberInfoVO.setLevelId(member.getLevelId());
                    memberInfoVO.setMbrRechargeExplainId(mbrRechargeExplainId);
                    BeanUtils.copyProperties((Object)member, (Object)memberInfoVO);
                    logger.info("\u8c03\u7528\u6267\u884c\u50a8\u503c\u6d3b\u52a8\u53c2\u6570={}", (Object)JSON.toJSONString((Object)memberInfoVO));
                    ResponseData result = this.activityPayServiceRpc.excuseActivityPay(memberInfoVO);
                    logger.info("\u8c03\u7528\u6267\u884c\u50a8\u503c\u6d3b\u52a8\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)result));
                }
            }
            logger.info("\u4e1a\u52a1\u8ba2\u5355={}, \u5fae\u4fe1\u8ba2\u5355={}, \u65f6\u95f4\u663e\u793a={}, \u652f\u4ed8\u91d1\u989d={} ,\u5145\u503c\u662f\u5426\u6210\u529f={},\u8d60\u9001\u91d1\u989d{}", new Object[]{out_trade_no, transaction_id, time_end, cash_fee, return_code, attach});
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn("\u5904\u7406\u5931\u8d25,\u5931\u8d25\u4fe1\u606f={}", (Object)e.getMessage());
            logger.debug("{}", (Throwable)e);
            buffer.append("<xml>").append("<return_code><![CDATA[FAIL]]></return_code>").append("<return_msg><![CDATA[NO]]></return_msg>").append("</xml>");
            return buffer.toString();
        }
        buffer.append("<xml>").append("<return_code><![CDATA[SUCCESS]]></return_code>").append("<return_msg><![CDATA[OK]]></return_msg>").append("</xml>");
        return buffer.toString();
    }

    public String execGitfCardService(String out_trade_no, String total_fee, String transaction_id, String memberCode, Long sysCompanyId, Long sysBrandId, JSONObject attach) {
        String serviceDefinitionId = attach.getString("did");
        String cardNo = attach.getString("Co");
        ReqGiftCardInfoDTO dto = new ReqGiftCardInfoDTO();
        dto.setSysCompanyId(sysCompanyId);
        dto.setSysBrandId(sysBrandId);
        dto.setMemberCode(memberCode);
        dto.setCardGiftDefinitionId(Long.valueOf(Long.parseLong(serviceDefinitionId)));
        dto.setGiftCardNo(cardNo);
        dto.setGiftCardId(Long.valueOf(Long.parseLong(attach.getString("gfcid"))));
        log.info("\u8bf7\u6c42service-card\u66f4\u65b0\u8ba2\u5355\u72b6\u6001:{}", (Object)JSON.toJSONString((Object)dto));
        ResponseData paied = this.giftCardStandardServiceFeign.paied(dto);
        if (paied.getCode() != 0) {
            throw new RuntimeException("\u793c\u54c1\u5361\u670d\u52a1\u5f02\u5e38");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<xml>").append("<return_code><![CDATA[SUCCESS]]></return_code>").append("<return_msg><![CDATA[OK]]></return_msg>").append("</xml>");
        return buffer.toString();
    }

    private boolean isGitfCard(String outTradeNo) {
        if (StringUtils.isNotEmpty((CharSequence)outTradeNo)) {
            String sufixValue = outTradeNo.substring(0, 2);
            return sufixValue.equals(OrderNoGeneratePrefixEnum.SERVICE_GIFT.getSufixValue());
        }
        throw new RuntimeException("\u8ba2\u5355\u53f7\u662f\u7a7a\u7684");
    }

    private Map<String, String> createMp(String giveMoney, String openid, String appId, String billNumber, String amount, String remark, String notifyUrl, WxPayConfigPo configPo, String memberCode, String activityId, CreateRechargeVO rechargeVO) {
        List<String> ids;
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("appid", appId);
        paramMap.put("mch_id", configPo.getMerchantNumber());
        paramMap.put("nonce_str", UUID.randomUUID().toString().replaceAll("[-]", ""));
        paramMap.put("out_trade_no", billNumber);
        paramMap.put("body", remark);
        paramMap.put("total_fee", this.getCentAmount(amount));
        String testBrand = this.wxConfig.getTestBrand();
        if (StringUtils.isNotEmpty((CharSequence)testBrand) && (ids = Arrays.asList(testBrand.split(","))).contains(appId)) {
            paramMap.put("total_fee", this.getAmount(amount));
        }
        HashMap<String, String> attach = new HashMap<String, String>();
        Long sysBrandId = configPo.getSysBrandId();
        attach.put("m", giveMoney);
        attach.put("mC", memberCode);
        attach.put("aid", activityId);
        attach.put("bid", configPo.getSysBrandId().toString());
        attach.put("cid", configPo.getSysCompanyId().toString());
        if (rechargeVO.getMbrRechargeExplainId() != null) {
            attach.put("mbrRechargeExplainId", rechargeVO.getMbrRechargeExplainId().toString());
        }
        if (this.standardBSRechargeBrandIds.getBrandList().contains(sysBrandId)) {
            String storedCardCode;
            Long cardType = rechargeVO.getCardType();
            if (cardType != null) {
                attach.put("c", String.valueOf(cardType));
            }
            if (StringUtils.isNotEmpty((CharSequence)(storedCardCode = rechargeVO.getStoredCardCode()))) {
                attach.put("s", storedCardCode);
            }
        } else {
            attach.put("p", rechargeVO.getName() + "," + (rechargeVO.getCardStyleCode() == null ? "" : rechargeVO.getCardStyleCode()));
        }
        paramMap.put("attach", JSON.toJSONString(attach));
        paramMap.put("notify_url", notifyUrl);
        paramMap.put("trade_type", "JSAPI");
        paramMap.put("openid", openid);
        paramMap.put("spbill_create_ip", this.wxConfig.getServiceUrl());
        logger.info("paramMap={}", (Object)JSON.toJSONString(paramMap));
        String requestXml = this.getRequstXml(paramMap, configPo.getSecretKey());
        logger.info("requestXml={}", (Object)JSON.toJSONString((Object)requestXml));
        WxpayCreateMpVO vo = this.invoke(requestXml);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", appId);
        map.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
        map.put("nonceStr", UUID.randomUUID().toString().replaceAll("[-]", ""));
        map.put("package", "prepay_id=" + vo.getPrepay_id());
        map.put("signType", "MD5");
        StringBuilder buffer = new StringBuilder();
        buffer.append("appId=").append((String)map.get("appId"));
        buffer.append("&nonceStr=").append((String)map.get("nonceStr"));
        buffer.append("&package=").append((String)map.get("package"));
        buffer.append("&signType=").append((String)map.get("signType"));
        buffer.append("&timeStamp=").append((String)map.get("timeStamp"));
        map.put("paySign", this.getSign(buffer.toString(), configPo.getSecretKey()));
        return map;
    }

    private Map<String, String> createMp(String openid, String appId, String billNumber, String amount, String remark, String notifyUrl, WxPayConfigPo configPo, String memberCode, CreateGitfCardOrderVo rechargeVO) {
        List<String> ids;
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("appid", appId);
        paramMap.put("mch_id", configPo.getMerchantNumber());
        paramMap.put("nonce_str", UUID.randomUUID().toString().replaceAll("[-]", ""));
        paramMap.put("out_trade_no", billNumber);
        paramMap.put("body", remark);
        paramMap.put("total_fee", this.getCentAmount(amount));
        String testBrand = this.wxConfig.getTestBrand();
        if (StringUtils.isNotEmpty((CharSequence)testBrand) && (ids = Arrays.asList(testBrand.split(","))).contains(appId)) {
            paramMap.put("total_fee", this.getAmount(amount));
        }
        HashMap<String, String> attach = new HashMap<String, String>();
        Long sysBrandId = configPo.getSysBrandId();
        attach.put("mC", memberCode);
        attach.put("did", rechargeVO.getServiceCardDefinitionId());
        attach.put("gfcid", rechargeVO.getGiftCardId() + "");
        attach.put("bid", configPo.getSysBrandId().toString());
        attach.put("cid", configPo.getSysCompanyId().toString());
        paramMap.put("attach", JSON.toJSONString(attach));
        paramMap.put("notify_url", notifyUrl);
        paramMap.put("trade_type", "JSAPI");
        paramMap.put("openid", openid);
        paramMap.put("spbill_create_ip", this.wxConfig.getServiceUrl());
        logger.info("paramMap={}", (Object)JSON.toJSONString(paramMap));
        String requestXml = this.getRequstXml(paramMap, configPo.getSecretKey());
        logger.info("requestXml={}", (Object)JSON.toJSONString((Object)requestXml));
        WxpayCreateMpVO vo = this.invoke(requestXml);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", appId);
        map.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
        map.put("nonceStr", UUID.randomUUID().toString().replaceAll("[-]", ""));
        map.put("package", "prepay_id=" + vo.getPrepay_id());
        map.put("signType", "MD5");
        map.put("giftCardId", "" + rechargeVO.getGiftCardId());
        StringBuilder buffer = new StringBuilder();
        buffer.append("appId=").append((String)map.get("appId"));
        buffer.append("&nonceStr=").append((String)map.get("nonceStr"));
        buffer.append("&package=").append((String)map.get("package"));
        buffer.append("&signType=").append((String)map.get("signType"));
        buffer.append("&timeStamp=").append((String)map.get("timeStamp"));
        map.put("paySign", this.getSign(buffer.toString(), configPo.getSecretKey()));
        return map;
    }

    private WxpayCreateMpVO invoke(String requestXml) {
        try {
            String outStr = HttpUtil.post((String)PLACE_ORDER, (String)requestXml);
            String result = this.getResponseData(outStr);
            logger.info("outStr={}", (Object)JSON.toJSONString((Object)outStr));
            logger.info("result={}", (Object)JSON.toJSONString((Object)result));
            WxpayCreateMpVO obj = (WxpayCreateMpVO)JSON.parseObject((String)result, WxpayCreateMpVO.class);
            return obj;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getResponseData(String outStr) {
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(IOUtils.toInputStream((String)outStr, (String)CHARSET));
            Element root = document.getRootElement();
            List list = root.elements();
            HashMap<String, String> dataMap = new HashMap<String, String>();
            for (Element element : list) {
                String name = element.getName();
                String value = element.getText();
                dataMap.put(name, value);
            }
            return JSON.toJSONString(dataMap);
        }
        catch (Exception e) {
            throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790\u5fae\u4fe1\u8fd4\u56de\u62a5\u6587,\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458");
        }
    }

    private String getRequstXml(Map<String, Object> paramMap, String key) {
        String tab = "\t";
        String line = "\n";
        String cdataStart = "<![CDATA[";
        String cdataEnd = "]]>";
        StringBuffer buffer = new StringBuffer("<xml>");
        StringBuffer stringA = new StringBuffer();
        Set<Map.Entry<String, Object>> set = paramMap.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (null == value || "".equals(value)) continue;
            buffer.append(tab).append("<").append(name).append(">").append(cdataStart).append(value).append(cdataEnd).append("</").append(name).append(">").append(line);
            stringA.append(name).append("=").append(value).append("&");
        }
        stringA.deleteCharAt(stringA.lastIndexOf("&"));
        String sign = this.getSign(stringA.toString(), key);
        buffer.append(tab).append("<sign>").append(sign).append("</sign>").append(line);
        buffer.append("</xml>");
        return buffer.toString();
    }

    private String getSign(String data, String key) {
        String stringSignTemp = data + "&key=" + key;
        return DigestUtils.md5Hex((String)stringSignTemp).toUpperCase();
    }

    private String getCentAmount(String amount) {
        Integer integer = Integer.valueOf(amount);
        integer = integer * this.wxConfig.getMoneyCode();
        logger.info("integer={}", (Object)integer);
        String valueOf = String.valueOf(integer);
        logger.info("amount={}", (Object)valueOf);
        return valueOf;
    }

    private String getAmount(String amount) {
        Integer integer = Integer.valueOf(amount);
        integer = integer * 1;
        logger.info("integer={}", (Object)integer);
        String valueOf = String.valueOf(integer);
        logger.info("amount={}", (Object)valueOf);
        return valueOf;
    }

    private ResponseData urAddMbrRechargeRecord(AppletWxPayBo appletWxPayBo) {
        logger.info("urAddMbrRechargeRecord param:{}", (Object)JacksonUtil.bean2Json((Object)appletWxPayBo));
        UrRechargeCardVo urRechargeCardVo = new UrRechargeCardVo();
        urRechargeCardVo.setCardStyleCode(appletWxPayBo.getCardStyleCode());
        urRechargeCardVo.setMemberCode(appletWxPayBo.getMemberCode());
        urRechargeCardVo.setAmount(BigDecimal.valueOf(appletWxPayBo.getMoney()));
        urRechargeCardVo.setGiveAmount(BigDecimal.valueOf(appletWxPayBo.getGiveMoney()));
        urRechargeCardVo.setCreateDate(appletWxPayBo.getPaymentDate());
        urRechargeCardVo.setMerchantNo(appletWxPayBo.getWxPayVoucherNo());
        urRechargeCardVo.setSysBrandId(appletWxPayBo.getSysBrandId());
        urRechargeCardVo.setSysCompanyId(appletWxPayBo.getSysCompanyId());
        urRechargeCardVo.setName(appletWxPayBo.getName());
        urRechargeCardVo.setSysStoreId(appletWxPayBo.getSysStoreId() == null ? null : appletWxPayBo.getSysStoreId());
        urRechargeCardVo.setBizTradeNo(appletWxPayBo.getOutTradeNo());
        ResponseData responseData = this.rechargeCardServiceFeign.addDebitCardRechargeRecord(urRechargeCardVo);
        logger.info("addMbrRechargeRecord={}", (Object)JSON.toJSONString((Object)responseData));
        return responseData;
    }

    private ResponseData addMbrRechargeRecord(AppletWxPayBo appletWxPayBo) {
        ResponseData memberInfoModelResponseData = this.memberCardProgramApiService.queryMemberIntegral(appletWxPayBo.getMemberCode());
        MemberInfoModel data = (MemberInfoModel)memberInfoModelResponseData.getData();
        MbrRechargeRecordPo mbrRechargeRecordPo = new MbrRechargeRecordPo();
        mbrRechargeRecordPo.setSysBrandId(appletWxPayBo.getSysBrandId());
        mbrRechargeRecordPo.setCardNo(data.getCardNo());
        mbrRechargeRecordPo.setName(data.getName());
        mbrRechargeRecordPo.setRechargeMoney(appletWxPayBo.getMoney());
        mbrRechargeRecordPo.setState(Long.valueOf(0L));
        mbrRechargeRecordPo.setGiveMoney((Double)ObjectUtils.defaultIfNull((Object)appletWxPayBo.getGiveMoney(), (Object)0.0));
        mbrRechargeRecordPo.setPayVoucherNo(appletWxPayBo.getWxPayVoucherNo());
        mbrRechargeRecordPo.setPaymentDate(appletWxPayBo.getPaymentDate());
        mbrRechargeRecordPo.setErpId(data.getErpId());
        mbrRechargeRecordPo.setRechargeType(RechargeTypeEnum.WECHAT_PAY.getCode());
        mbrRechargeRecordPo.setOutTradeNo(appletWxPayBo.getOutTradeNo());
        mbrRechargeRecordPo.setSysStoreId(appletWxPayBo.getSysStoreId());
        mbrRechargeRecordPo.setMbrRechargeExplainId(appletWxPayBo.getMbrRechargeExplainId());
        logger.info("\u5165\u53c2========mbrRechargeRecordBo========" + JSON.toJSONString((Object)mbrRechargeRecordPo));
        ResponseData responseData = this.mbrRechargeServiceRpc.addMbrRechargeRecord(mbrRechargeRecordPo);
        logger.info("addMbrRechargeRecord={}", (Object)JSON.toJSONString((Object)responseData));
        return responseData;
    }

    private ResponseData addMbrRechargeRecordYw(AppletWxPayBo appletWxPayBo) {
        logger.info("enter addMbrRechargeRecordYw:{}", (Object)JSON.toJSONString((Object)appletWxPayBo));
        YwRechargeRecordVo ywRechargeRecordVo = new YwRechargeRecordVo();
        String memberCode = appletWxPayBo.getMemberCode();
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setBrandId(appletWxPayBo.getSysBrandId());
        memberInfoModel.setMemberCode(memberCode);
        ywRechargeRecordVo.setSysStoreId(appletWxPayBo.getSysStoreId());
        YwRechargeQueryVo ywRechargeQueryVo = new YwRechargeQueryVo();
        ywRechargeQueryVo.setSysCompanyId(appletWxPayBo.getSysCompanyId());
        ywRechargeQueryVo.setSysBrandId(appletWxPayBo.getSysBrandId());
        ywRechargeQueryVo.setCardType(appletWxPayBo.getCardType());
        ywRechargeQueryVo.setRechargeMoney(appletWxPayBo.getMoney());
        ResponseData doubleResponseData = this.cusYwRechargeServiceFeign.judgeAndGetGiveAmount(ywRechargeQueryVo);
        if (doubleResponseData.getCode() == SysResponseEnum.SUCCESS.getCode() && doubleResponseData.getData() != null && !((Double)doubleResponseData.getData()).equals(appletWxPayBo.getGiveMoney())) {
            appletWxPayBo.setGiveMoney((Double)doubleResponseData.getData());
        }
        HashMap<String, String> storeMap = new HashMap<String, String>();
        storeMap.put("staffCode", "");
        storeMap.put("storeCode", "");
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        logger.info("\u6839\u636e\u4f01\u4e1aid,\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)singleMemberModel));
        if (singleMemberModel.getCode() == SysResponseEnum.SUCCESS.getCode() && singleMemberModel.getData() != null) {
            String ywShareGuideCode = this.ywHelper.getYwShareGuideCode(memberCode, null);
            if (StringUtils.isNotEmpty((CharSequence)ywShareGuideCode)) {
                String staffCode = this.dealWithGuideFromRedis(storeMap, singleMemberModel, ywShareGuideCode);
                storeMap.put("staffCode", staffCode);
            } else {
                this.dealWithGuideFromTrace(appletWxPayBo, memberCode, storeMap, singleMemberModel);
            }
        }
        String staffCode = (String)storeMap.get("staffCode");
        String storeCode = (String)storeMap.get("storeCode");
        ResponseData memberInfoModelResponseData = this.memberInfoApiService.getMemberModel(memberInfoModel);
        logger.info("memberInfoModelResponseData:{}", (Object)JSON.toJSONString((Object)memberInfoModelResponseData));
        if (memberInfoModelResponseData.getCode() == SysResponseEnum.SUCCESS.getCode() && memberInfoModelResponseData.getData() != null) {
            MemberInfoModel data = (MemberInfoModel)memberInfoModelResponseData.getData();
            ywRechargeRecordVo.setCardType(appletWxPayBo.getCardType());
            ywRechargeRecordVo.setName(data.getName());
            ywRechargeRecordVo.setErpId(data.getErpId());
            ywRechargeRecordVo.setCardNo(data.getCardNo());
            ywRechargeRecordVo.setPhone(data.getPhone());
            ywRechargeRecordVo.setRechargeMoney(appletWxPayBo.getMoney());
            ywRechargeRecordVo.setState(Long.valueOf(0L));
            ywRechargeRecordVo.setGiveMoney((Double)ObjectUtils.defaultIfNull((Object)appletWxPayBo.getGiveMoney(), (Object)0.0));
            ywRechargeRecordVo.setWxPayVoucherNo(appletWxPayBo.getWxPayVoucherNo());
            ywRechargeRecordVo.setPaymentDate(appletWxPayBo.getPaymentDate());
            ywRechargeRecordVo.setPetcard(appletWxPayBo.getStoredCardCode());
            ywRechargeRecordVo.setSysBrandId(appletWxPayBo.getSysBrandId());
            ywRechargeRecordVo.setSysCompanyId(appletWxPayBo.getSysCompanyId());
            ywRechargeRecordVo.setStaffCode(staffCode);
        }
        logger.info("\u8c03\u7528 sendMq:{}", (Object)JSON.toJSONString((Object)ywRechargeRecordVo));
        ResponseData responseData = this.cusYwRechargeServiceFeign.sendMq(ywRechargeRecordVo);
        return responseData;
    }

    private String dealWithGuideFromRedis(HashMap<String, String> storeMap, ResponseData<MemberInfoModel> singleMemberModel, String ywShareGuideCode) {
        MemberInfoModel memberModelData = (MemberInfoModel)singleMemberModel.getData();
        ResponseData staffInfoResponseData = this.staffServiceRpc.getStaffInfoByCode(ywShareGuideCode, memberModelData.getSysCompanyId());
        SysStaffPo sysStaffPo = (SysStaffPo)staffInfoResponseData.getData();
        if (staffInfoResponseData.getCode() != SysResponseEnum.SUCCESS.getCode() || sysStaffPo == null) {
            return "";
        }
        Long sysStaffId = sysStaffPo.getSysStaffId();
        String staffCode = sysStaffPo.getStaffCode();
        return staffCode;
    }

    private void dealWithGuideFromTrace(AppletWxPayBo appletWxPayBo, String memberCode, HashMap<String, String> storeMap, ResponseData<MemberInfoModel> singleMemberModel) {
        String staffCode = storeMap.get("staffCode");
        String storeCode = storeMap.get("storeCode");
        String wxUnionId = ((MemberInfoModel)singleMemberModel.getData()).getWxUnionId();
        TraceRecordPO traceRecordPO = this.getSceneInstance(wxUnionId, appletWxPayBo.getSysCompanyId(), appletWxPayBo.getSysBrandId());
        if (traceRecordPO != null) {
            JSONObject obj = JSON.parseObject((String)traceRecordPO.getTraceValue());
            String sourceWay = String.valueOf(obj.get((Object)"source_way") != null ? obj.get((Object)"source_way") : "");
            logger.info("unionID:{}, sourceWay:{}, TraceValue:{}", new Object[]{wxUnionId, sourceWay, traceRecordPO.getTraceValue()});
            if (Arrays.asList(SOURCE_WAY).contains(sourceWay)) {
                staffCode = String.valueOf(obj.get((Object)"guideId") != null ? obj.get((Object)"guideId") : "");
                storeCode = String.valueOf(obj.get((Object)"storeId") != null ? obj.get((Object)"storeId") : "");
                if (!"".equals(staffCode) && !"".equals(storeCode)) {
                    BatchUpdateMemberInfoVo batchUpdateMemberInfoVo = new BatchUpdateMemberInfoVo();
                    batchUpdateMemberInfoVo.setSysCompanyId(appletWxPayBo.getSysCompanyId());
                    batchUpdateMemberInfoVo.setMembersCode((List)Lists.newArrayList((Object[])new String[]{memberCode}));
                    batchUpdateMemberInfoVo.setServiceGuideId(Long.valueOf(Long.parseLong(staffCode)));
                    batchUpdateMemberInfoVo.setServiceStoreId(Long.valueOf(Long.parseLong(storeCode)));
                    this.companyMemberApiService.batchUpdateServiceGuide(batchUpdateMemberInfoVo);
                    ResponseData staffById = this.staffServiceRpc.getStaffById(Long.valueOf(Long.parseLong(staffCode)));
                    if (staffById.getCode() == SysResponseEnum.SUCCESS.getCode() && staffById.getData() != null) {
                        staffCode = ((SysStaffPo)staffById.getData()).getStaffCode();
                    }
                }
                storeMap.put("staffCode", staffCode);
                storeMap.put("storeCode", storeCode);
            }
        }
    }

    private String read(String content, String key) {
        String startStr = "<" + key + ">";
        String endStr = "</" + key + ">";
        int start = content.indexOf(startStr);
        int end = content.indexOf(endStr);
        if (start == -1 || end == -1) {
            return null;
        }
        if (start >= end) {
            return null;
        }
        String data = content.substring(start + startStr.length(), end);
        if (StringUtils.startsWith((CharSequence)data, (CharSequence)"<![CDATA[") && StringUtils.endsWith((CharSequence)data, (CharSequence)"]]>")) {
            return data.substring("<![CDATA[".length(), data.length() - "]]>".length());
        }
        return data;
    }

    private AppletWxPayBo readSockt(AppletWxPayBo wxPayBo) {
        AppletWxPayBo appletWxPayBo = new AppletWxPayBo();
        String appId = wxPayBo.getAppId();
        String openId = wxPayBo.getOpenId();
        ResponseData wxPublicPOByAppId = this.wxPublicServiceFeign.getWxPublicPOByAppId(appId);
        MemberFriendsKeyQueryVo memberFriendsKeyQueryVo = new MemberFriendsKeyQueryVo();
        memberFriendsKeyQueryVo.setMemberCode(wxPayBo.getMemberCode());
        ResponseData withMultiKeyWord = this.wxMembersApiService.getMemberFriendsWithMultiKeyWord(memberFriendsKeyQueryVo);
        if (StringUtils.isNotBlank((CharSequence)((MemberInfoModel)withMultiKeyWord.getData()).getMemberCode())) {
            appletWxPayBo.setSysBrandId(((WxPublicPO)wxPublicPOByAppId.getData()).getSysBrandId());
            appletWxPayBo.setMemberCode(((MemberInfoModel)withMultiKeyWord.getData()).getMemberCode());
        }
        return appletWxPayBo;
    }

    public Map<String, String> createPayLevelRecharge(MbrLevelModel levelModel, WxPayLevelBO wxPayLevelBO) {
        WxpayCreateMpVO vo = this.unifiedOrder(levelModel, wxPayLevelBO);
        Map map = this.paySign(wxPayLevelBO, vo);
        return map;
    }

    public String payLevelCallBack(HttpServletRequest request, HttpServletResponse response) {
        StringBuffer buffer = new StringBuffer();
        try {
            ResponseData responseData;
            String content = IOUtils.toString((InputStream)request.getInputStream(), (String)CHARSET);
            logger.info("\u63a5\u6536\u5230\u5fae\u4fe1\u901a\u77e5,\u5185\u5bb9={}", (Object)content);
            String out_trade_no = this.read(content, "out_trade_no");
            String transaction_id = this.read(content, "transaction_id");
            String time_end = this.read(content, "time_end");
            String cash_fee = this.read(content, "cash_fee");
            String return_code = this.read(content, "return_code");
            String appid = this.read(content, "appid");
            String openid = this.read(content, "openid");
            String attachStr = this.read(content, "attach");
            String total_fee = this.read(content, "total_fee");
            logger.info("\u63a5\u6536\u5230\u5fae\u4fe1\u901a\u77e5,attachStr={}", (Object)attachStr);
            JSONObject attach = JSONObject.parseObject((String)attachStr);
            String memberCode = String.valueOf(attach.get((Object)"m"));
            Long sysBrandId = Long.valueOf(String.valueOf(attach.get((Object)"b")));
            Long sysCompanyId = Long.valueOf(String.valueOf(attach.get((Object)"c")));
            Long levelId = Long.valueOf(String.valueOf(attach.get((Object)"l")));
            String sign = this.read(content, "sign");
            if (StringUtils.isBlank((CharSequence)sign)) {
                logger.info("WXPAY callback sign is null");
                return buffer.toString();
            }
            WxPayConfigPo po = new WxPayConfigPo();
            po.setSysCompanyId(sysCompanyId);
            po.setSysBrandId(sysBrandId);
            ResponseData data = this.mbrRechargeServiceRpc.getWxPayConfigRpc(po);
            WxPayConfigPo wxPayConfigPo = (WxPayConfigPo)data.getData();
            Map stringStringMap = WXPayUtil.xmlToMap((String)content);
            boolean signatureValid = WXPayUtil.isSignatureValid((Map)stringStringMap, (String)wxPayConfigPo.getSecretKey(), (WXPayConstants.SignType)WXPayConstants.SignType.MD5);
            if (!signatureValid) {
                return buffer.toString();
            }
            if ("SUCCESS".equals(return_code) && ((responseData = this.invokeLevelRechargeCallBack(out_trade_no, transaction_id, time_end, appid, total_fee, memberCode, sysBrandId, sysCompanyId, levelId)) == null || responseData.getCode() != SysResponseEnum.SUCCESS.getCode())) {
                logger.info("\u8c03\u7528\u4e2d\u53f0\u63a5\u53e3\u62a5\u9519={}", (Object)JSON.toJSONString((Object)responseData));
                buffer.append("<xml>").append("<return_code><![CDATA[FAIL]]></return_code>").append("<return_msg><![CDATA[NO]]></return_msg>").append("</xml>");
                return buffer.toString();
            }
            logger.info("\u4e1a\u52a1\u8ba2\u5355={}, \u5fae\u4fe1\u8ba2\u5355={}, \u65f6\u95f4\u663e\u793a={}, \u652f\u4ed8\u91d1\u989d={} ,\u5145\u503c\u662f\u5426\u6210\u529f={},\u8d60\u9001\u91d1\u989d{}", new Object[]{out_trade_no, transaction_id, time_end, cash_fee, return_code, attach});
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn("\u5904\u7406\u5931\u8d25,\u5931\u8d25\u4fe1\u606f={}", (Object)e.getMessage());
            logger.debug("{}", (Throwable)e);
            buffer.append("<xml>").append("<return_code><![CDATA[FAIL]]></return_code>").append("<return_msg><![CDATA[NO]]></return_msg>").append("</xml>");
            return buffer.toString();
        }
        buffer.append("<xml>").append("<return_code><![CDATA[SUCCESS]]></return_code>").append("<return_msg><![CDATA[OK]]></return_msg>").append("</xml>");
        return buffer.toString();
    }

    private ResponseData<String> invokeLevelRechargeCallBack(String out_trade_no, String transaction_id, String time_end, String appid, String total_fee, String memberCode, Long sysBrandId, Long sysCompanyId, Long levelId) {
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        LocalDateTime dateTime = LocalDateTime.parse(time_end, pattern);
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zonedDateTime = dateTime.atZone(zoneId);
        Date timeEnd = Date.from(zonedDateTime.toInstant());
        LevelRechargeCallBackRequestVO callBackRequestVO = new LevelRechargeCallBackRequestVO();
        callBackRequestVO.setSysCompanyId(sysCompanyId);
        callBackRequestVO.setBrandId(sysBrandId);
        callBackRequestVO.setMemberCode(memberCode);
        callBackRequestVO.setMbrLevelId(levelId);
        callBackRequestVO.setMemberCode(memberCode);
        callBackRequestVO.setOutTradeNo(out_trade_no);
        callBackRequestVO.setTransactionId(transaction_id);
        callBackRequestVO.setPayTime(timeEnd);
        if (this.yiWenBrandId != null && this.yiWenBrandId.equals(callBackRequestVO.getBrandId())) {
            String ywShareGuideCode = this.ywHelper.getYwShareGuideCode(callBackRequestVO.getMemberCode(), null);
            callBackRequestVO.setYwShareGuideCode(ywShareGuideCode);
        }
        callBackRequestVO.setTotalFee(new BigDecimal(Double.parseDouble(total_fee) / (double)this.wxConfig.getMoneyCode().intValue()));
        return this.memberLevelRechargeApiService.levelRechargeCallBack(callBackRequestVO);
    }

    private Map<String, String> paySign(WxPayLevelBO wxPayLevelBO, WxpayCreateMpVO vo) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", wxPayLevelBO.getAppId());
        map.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
        map.put("nonceStr", UUID.randomUUID().toString().replaceAll("[-]", ""));
        map.put("package", "prepay_id=" + vo.getPrepay_id());
        map.put("signType", "MD5");
        StringBuilder buffer = new StringBuilder();
        buffer.append("appId=").append((String)map.get("appId"));
        buffer.append("&nonceStr=").append((String)map.get("nonceStr"));
        buffer.append("&package=").append((String)map.get("package"));
        buffer.append("&signType=").append((String)map.get("signType"));
        buffer.append("&timeStamp=").append((String)map.get("timeStamp"));
        map.put("paySign", this.getSign(buffer.toString(), wxPayLevelBO.getSecretKey()));
        return map;
    }

    private WxpayCreateMpVO unifiedOrder(MbrLevelModel levelModel, WxPayLevelBO wxPayLevelBO) {
        String amount = String.valueOf(levelModel.getPayMoney().intValue());
        String billNumber = new SimpleDateFormat("yyyyMMddkkmmssS").format(new Date());
        String remark = String.format("\u4ed8\u8d39\u5361\u8d2d\u4e70:%s", levelModel.getLevelName());
        String notifyUrl = this.wxConfig.getBaseUrl() + "/payLevelCard/payLevelCallBack";
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("appid", wxPayLevelBO.getAppId());
        paramMap.put("mch_id", wxPayLevelBO.getMerchantNumber());
        paramMap.put("nonce_str", UUID.randomUUID().toString().replaceAll("[-]", ""));
        paramMap.put("out_trade_no", billNumber);
        paramMap.put("body", remark);
        paramMap.put("total_fee", String.valueOf(levelModel.getPayMoney().multiply(new BigDecimal(this.wxConfig.getMoneyCode())).intValue()));
        HashMap<String, String> attach = new HashMap<String, String>();
        attach.put("m", wxPayLevelBO.getMemberCode());
        attach.put("b", wxPayLevelBO.getSysBrandId().toString());
        attach.put("c", wxPayLevelBO.getSysCompanyId().toString());
        attach.put("l", levelModel.getMbrLevelId().toString());
        paramMap.put("attach", JSON.toJSONString(attach));
        paramMap.put("notify_url", notifyUrl);
        paramMap.put("trade_type", "JSAPI");
        paramMap.put("openid", wxPayLevelBO.getOpenId());
        paramMap.put("spbill_create_ip", this.wxConfig.getServiceUrl());
        logger.info("paramMap={}", (Object)JSON.toJSONString(paramMap));
        String requestXml = this.getRequstXml(paramMap, wxPayLevelBO.getSecretKey());
        logger.info("requestXml={}", (Object)JSON.toJSONString((Object)requestXml));
        return this.invoke(requestXml);
    }

    private TraceRecordPO getSceneInstance(String unionId, Long sysCompanyId, Long brandId) {
        TraceRecordVo traceRecordVo = new TraceRecordVo();
        traceRecordVo.setUnionId(unionId);
        traceRecordVo.setSysCompanyId(sysCompanyId);
        traceRecordVo.setBrandId(brandId);
        ResponseData data = null;
        try {
            data = this.coreTraceFeign.selectTraceRecord(traceRecordVo);
            logger.info("selectTraceRecord\u65b9\u6cd5\u8fd4\u56de:{}", (Object)JacksonUtil.bean2Json((Object)data));
            if (data == null) {
                logger.error("\u8c03\u7528bizvane-core\u6a21\u5757selectTraceRecord\u65b9\u6cd5\uff0cdata\u8fd4\u56de\u7a7a");
                return null;
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528bizvane-core\u5f02\u5e38" + e);
            return null;
        }
        return (TraceRecordPO)data.getData();
    }

    public Long getSysStoreId(String memberCode) {
        MemberInfoModel memberInfo;
        TraceRecordPO sceneInstance;
        logger.info("\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)memberCode);
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        logger.info("\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u8fd4\u56de\u503c\uff1a{}", (Object)JacksonUtil.bean2Json((Object)singleMemberModel));
        if (singleMemberModel.getData() != null && (sceneInstance = this.getSceneInstance((memberInfo = (MemberInfoModel)singleMemberModel.getData()).getWxUnionId(), memberInfo.getSysCompanyId(), memberInfo.getBrandId())) != null && StringUtils.isNotEmpty((CharSequence)sceneInstance.getTraceValue())) {
            JSONObject ob = JSONObject.parseObject((String)sceneInstance.getTraceValue());
            Long sysStoreId = ob.getLong("storeId");
            String sourceWay = ob.getString("source_way");
            Date createTime = sceneInstance.getCreateTime();
            try {
                int day = DateUtils.daysBetween((Date)createTime, (Date)new Date());
                if ("appletScanCodeRecharge".equals(sourceWay) && sysStoreId != null && day <= 1) {
                    return sysStoreId;
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Map<String, String> createPayLevelRechargeNew(MbrLevelModel levelModel, WxPayLevelBO wxPayLevelBO) {
        return null;
    }
}

