/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.bizvane.appletservice.interfaces.ShortchainService;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.centerstageservice.models.vo.SysBrandVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.messagebase.model.po.MsgShortchainPO;
import com.bizvane.messagefacade.interfaces.MsgShortchainServiceFeign;
import com.bizvane.utils.redisutils.RedisClient;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.interfaces.WxMiniprgmServiceFeign;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShortchainServiceImpl
implements ShortchainService {
    private static final Logger log = LoggerFactory.getLogger(ShortchainServiceImpl.class);
    @Autowired
    private MsgShortchainServiceFeign msgShortchainServiceFeign;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private WxMiniprgmServiceFeign wxMiniprgmServiceFeign;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private QiNiuConfig qiNiuConfig;

    public ResponseData<Map<String, Object>> selectByShortchainCode(String shortchainCode) {
        log.info("\u8fdb\u5165ShortchainServiceImpl\u5c42-----selectByShortchainCode()\u65b9\u6cd5  \u53c2\u6570\uff1ashortchainCode=" + shortchainCode);
        ResponseData responseData = new ResponseData(500, "\u83b7\u53d6\u5931\u8d25");
        HashMap<String, Object> map = new HashMap<String, Object>();
        responseData.setData(map);
        ResponseData data = this.msgShortchainServiceFeign.selectByShortchainCode(shortchainCode);
        if (data != null && data.getCode() == 0) {
            MsgShortchainPO po = (MsgShortchainPO)data.getData();
            String appId = po.getAppId();
            String appUrl = po.getAppUrl();
            Long sysTraceId = po.getSysTraceId();
            Boolean valid = po.getValid();
            map.put("valid", valid);
            map.put("sysTraceId", sysTraceId);
            map.put("appId", appId);
            map.put("appUrl", appUrl);
            map.put("shortchainUrl", po.getShortchainUrl());
            ResponseData jumpMiniprgm = this.wxMiniprgmServiceFeign.getWxPublicPOByAppId(appId);
            if (jumpMiniprgm != null && jumpMiniprgm.getData() != null) {
                WxPublicPO publicPO = (WxPublicPO)jumpMiniprgm.getData();
                Long sysBrandId = publicPO.getSysBrandId();
                map.put("miniProgramType", publicPO.getMiniProgramType());
                map.put("sysCompanyId", publicPO.getSysCompanyId());
                map.put("sysBrandId", sysBrandId);
                ResponseData voResponseData = this.brandServiceRpc.getBrandId(sysBrandId);
                if (voResponseData != null && voResponseData.getData() != null) {
                    SysBrandVo brandVo = (SysBrandVo)voResponseData.getData();
                    map.put("logo", brandVo.getBrandLogo());
                    map.put("domain", this.qiNiuConfig.getDomain());
                    log.info("\u8fdb\u5165ShortchainServiceImpl\u5c42-----selectByShortchainCode()\u65b9\u6cd5  \u4ecewxMiniprgmServiceFeign\u4e2d\u83b7\u53d6\u54c1\u724clogo  " + brandVo.getBrandLogo());
                }
            }
            if (valid.booleanValue()) {
                String key = "schemeUrl_" + po.getShortchainUrl() + "_" + sysTraceId;
                String openlinkRedis = (String)this.redisClient.get(key);
                if (openlinkRedis != null) {
                    log.info("\u8fdb\u5165ShortchainServiceImpl\u5c42-----selectByShortchainCode()\u65b9\u6cd5  \u4eceredis\u4e2d\u83b7\u53d6\u5c0f\u7a0b\u5e8fscheme\u7801  " + openlinkRedis);
                    map.put("schemeUrl", openlinkRedis);
                } else {
                    ResponseData responseDatastr = this.wxMiniprgmServiceFeign.getSchemeByAppId(appId, appUrl, String.valueOf(sysTraceId), shortchainCode);
                    if (responseDatastr != null && responseDatastr.getCode() == 0) {
                        String schemeUrl = (String)responseDatastr.getData();
                        log.info("\u8fdb\u5165ShortchainServiceImpl\u5c42-----selectByShortchainCode()\u65b9\u6cd5  \u4ecewxMiniprgmServiceFeign\u4e2d\u83b7\u53d6\u5c0f\u7a0b\u5e8fscheme\u7801  " + schemeUrl);
                        map.put("schemeUrl", schemeUrl);
                        Long expireTime = 2592000L;
                        this.redisClient.set(key, (Object)schemeUrl, expireTime);
                    } else if (responseDatastr != null) {
                        map.put("schemeError", responseDatastr.getMessage());
                    }
                }
                responseData.setCode(0);
                responseData.setMessage("\u83b7\u53d6\u6210\u529f");
            }
        }
        return responseData;
    }
}

