/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.bizvane.appletservice.interfaces.MemberPrivilegeService;
import com.bizvane.appletservice.models.bo.AppletVipCardBo;
import com.bizvane.appletservice.models.po.AppletVipCartPO;
import com.bizvane.appletservice.models.po.AppletVipCartPOExample;
import com.bizvane.appletservice.models.po.AppletVipPrivilegePO;
import com.bizvane.appletservice.models.po.AppletVipPrivilegePOExample;
import com.bizvane.appletserviceimpl.mappers.AppletVipCartPOMapper;
import com.bizvane.appletserviceimpl.mappers.AppletVipPrivilegePOMapper;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.fitmentservice.models.Rpc.AppletResourcesRpc;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.service.api.MemberCardProgramApiService;
import com.bizvane.members.facade.service.api.MemberLevelApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MemberPrivilegeServiceImpl
implements MemberPrivilegeService {
    @Autowired
    private MemberCardProgramApiService memberCardProgramApiService;
    @Autowired
    private AppletVipCartPOMapper appletVipCartPOMapper;
    @Autowired
    private AppletVipPrivilegePOMapper appletVipPrivilegePOMapper;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private MemberLevelApiService memberLevelApiService;
    @Autowired
    private AppletResourcesRpc appletResourcesRpc;

    public ResponseData<List<AppletVipCardBo>> getMemberPrivilege(Long sysBrandId) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        if (sysBrandId == null) {
            responseData.setMessage("\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        ArrayList<AppletVipCardBo> appletVipCardBoList = new ArrayList<AppletVipCardBo>();
        List mbrLevelModelList = (List)this.appletResourcesRpc.getAppletLevelCardList(sysBrandId).getData();
        if (mbrLevelModelList.size() > 0) {
            for (MbrLevelModel mbrLevelModel : mbrLevelModelList) {
                AppletVipCardBo appletVipCardBo = new AppletVipCardBo();
                appletVipCardBo.setMbrLevelId(mbrLevelModel.getMbrLevelId());
                appletVipCardBo.setLevelName(mbrLevelModel.getLevelName());
                appletVipCardBo.setLevelValue(mbrLevelModel.getLevelValue());
                Long mbrLevelId = mbrLevelModel.getMbrLevelId();
                ResponseData modelResponseData = this.memberLevelApiService.queryLevelModel(mbrLevelId);
                MbrLevelModel levelModel = (MbrLevelModel)modelResponseData.getData();
                if (StringUtils.isNotBlank((CharSequence)levelModel.getLevelRemark())) {
                    appletVipCardBo.setUpgradeInfo(levelModel.getLevelRemark());
                } else {
                    appletVipCardBo.setUpgradeInfo("");
                }
                AppletVipCartPOExample appletVipCartPOExample = new AppletVipCartPOExample();
                appletVipCartPOExample.createCriteria().andGradeIdEqualTo(mbrLevelModel.getMbrLevelId()).andSysBrandIdEqualTo(sysBrandId).andValidEqualTo(Boolean.valueOf(true));
                List appletVipCartPOList = this.appletVipCartPOMapper.selectByExample(appletVipCartPOExample);
                for (AppletVipCartPO appletVipCartPO : appletVipCartPOList) {
                    if (appletVipCartPO.getIsImg().booleanValue()) {
                        appletVipCardBo.setImg(appletVipCartPO.getIsImg());
                        appletVipCardBo.setCardStyle(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)appletVipCartPO.getCardStyle()));
                    } else {
                        appletVipCardBo.setCardStyle(appletVipCartPO.getCardStyle());
                    }
                    if (appletVipCartPOList.size() <= 0) continue;
                    AppletVipPrivilegePOExample example = new AppletVipPrivilegePOExample();
                    example.createCriteria().andAppletVipCardIdEqualTo(appletVipCartPO.getAppletVipCardId()).andValidEqualTo(Boolean.valueOf(true));
                    List appletVipPrivilegePOList = this.appletVipPrivilegePOMapper.selectByExample(example);
                    for (AppletVipPrivilegePO appletVipPrivilegePO : appletVipPrivilegePOList) {
                        appletVipPrivilegePO.setPrivilegeLogo(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)appletVipPrivilegePO.getPrivilegeLogo()));
                    }
                    appletVipCardBo.setAppletVipPrivilegePOList(appletVipPrivilegePOList);
                }
                appletVipCardBoList.add(appletVipCardBo);
            }
        }
        responseData.setData(appletVipCardBoList);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData<List<AppletVipPrivilegePO>> getMemberPrivilegebyGrder(Long appletVipCardId) {
        ResponseData responseData = new ResponseData();
        if (appletVipCardId == null) {
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        AppletVipPrivilegePOExample appletVipPrivilegePOExample = new AppletVipPrivilegePOExample();
        appletVipPrivilegePOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andAppletVipCardIdEqualTo(appletVipCardId);
        List list = this.appletVipPrivilegePOMapper.selectByExample(appletVipPrivilegePOExample);
        for (AppletVipPrivilegePO appletVipPrivilegePO : list) {
            appletVipPrivilegePO.setPrivilegeLogo(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)appletVipPrivilegePO.getPrivilegeLogo()));
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)list);
        return responseData;
    }

    public ResponseData<List<AppletVipPrivilegePO>> getMemberPrivilegeAll(Long appletVipPrivilegeId) {
        ResponseData responseData = new ResponseData();
        if (appletVipPrivilegeId == null) {
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        AppletVipPrivilegePOExample appletVipPrivilegePOExample = new AppletVipPrivilegePOExample();
        appletVipPrivilegePOExample.createCriteria().andAppletVipPrivilegeIdEqualTo(appletVipPrivilegeId).andValidEqualTo(Boolean.valueOf(true));
        List list = this.appletVipPrivilegePOMapper.selectByExample(appletVipPrivilegePOExample);
        for (AppletVipPrivilegePO appletVipPrivilegePO : list) {
            appletVipPrivilegePO.setPrivilegeLogo(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)appletVipPrivilegePO.getPrivilegeLogo()));
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)list);
        return responseData;
    }
}

