/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.interfaces.MemberOpenCardStoreService;
import com.bizvane.appletservice.models.bo.AppletRefreshtoInterfaceBo;
import com.bizvane.appletservice.models.bo.AppletSysStoreBo;
import com.bizvane.appletservice.models.vo.MemberOpenCardStoreVo;
import com.bizvane.centerstageservice.models.bo.SysStoreBo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.github.pagehelper.PageInfo;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MemberOpenCardStoreServiceImpl
implements MemberOpenCardStoreService {
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    DecimalFormat df = new DecimalFormat("###.#");

    public ResponseData searchStores(MemberOpenCardStoreVo memberOpenCardStoreVo) {
        logger.info("\u95e8\u5e97\u5bfc\u822a\u5165\u53c2memberOpenCardStoreVo={}", (Object)JSON.toJSONString((Object)memberOpenCardStoreVo));
        ResponseData responseData = new ResponseData();
        Long storeId = (Long)this.wxAppletApiService.getServiceStoreId(memberOpenCardStoreVo.getMemberCode()).getData();
        logger.info("MemberOpenCardStoreServiceImpl#searchStores storeId:{}", (Object)storeId);
        if (memberOpenCardStoreVo.getIsWholeStore() == 0) {
            ResponseData store1 = this.storeServiceRpc.getStoreById(storeId);
            SysStorePo data = (SysStorePo)store1.getData();
            AppletSysStoreBo appletSysStoreBo = new AppletSysStoreBo();
            BeanUtils.copyProperties((Object)data, (Object)appletSysStoreBo);
            ArrayList<AppletSysStoreBo> appletSysStoreBos = new ArrayList<AppletSysStoreBo>();
            appletSysStoreBos.add(appletSysStoreBo);
            AppletRefreshtoInterfaceBo appletRefreshtoInterfaceBo = new AppletRefreshtoInterfaceBo();
            appletRefreshtoInterfaceBo.setAppletSysStoreBos(appletSysStoreBos);
            logger.info("\u95e8\u5e97\u5bfc\u822a\u51fa\u53c2={},{},{},{}", new Object[]{JSON.toJSONString((Object)store1), JSONObject.toJSONString((Object)data), JSONObject.toJSONString((Object)appletSysStoreBo), JSONObject.toJSONString((Object)appletRefreshtoInterfaceBo)});
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setData((Object)appletRefreshtoInterfaceBo);
            return responseData;
        }
        memberOpenCardStoreVo.setSysStoreId(storeId);
        SysStoreBo vo = new SysStoreBo();
        BeanUtils.copyProperties((Object)memberOpenCardStoreVo, (Object)vo);
        ResponseData brandByIdSysStoreListPage = this.storeServiceRpc.getBrandByIdSysStoreListPage(vo);
        List sysStoreBoList = ((PageInfo)brandByIdSysStoreListPage.getData()).getList();
        ArrayList<AppletSysStoreBo> AppletSysStoreBos = new ArrayList<AppletSysStoreBo>();
        for (SysStoreBo sysStoreBo : sysStoreBoList) {
            AppletSysStoreBo appletSysStoreBo = new AppletSysStoreBo();
            String distance = sysStoreBo.getDistance();
            if (distance == null) {
                sysStoreBo.setDistance(distance);
            } else {
                Double aDouble = Double.valueOf(distance);
                if (aDouble == null) {
                    sysStoreBo.setDistance(distance);
                }
                double lod = aDouble / 1000.0;
                String format = this.df.format(lod);
                sysStoreBo.setDistance(format);
            }
            BeanUtils.copyProperties((Object)sysStoreBo, (Object)appletSysStoreBo);
            if (appletSysStoreBo != null) {
                AppletSysStoreBos.add(appletSysStoreBo);
                continue;
            }
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        AppletRefreshtoInterfaceBo appletRefreshtoInterfaceBo = new AppletRefreshtoInterfaceBo();
        ArrayList<AppletSysStoreBo> sysStoreBos = new ArrayList<AppletSysStoreBo>();
        ArrayList<AppletSysStoreBo> appletSysStoreBos = new ArrayList<AppletSysStoreBo>();
        if (AppletSysStoreBos != null) {
            for (AppletSysStoreBo appletSysStoreBo : AppletSysStoreBos) {
                if (appletSysStoreBo.getDistance() == null) {
                    sysStoreBos.add(appletSysStoreBo);
                }
                if (appletSysStoreBo.getDistance() == null) continue;
                appletSysStoreBos.add(appletSysStoreBo);
            }
        }
        if (appletSysStoreBos != null) {
            Collections.sort(appletSysStoreBos, new /* Unavailable Anonymous Inner Class!! */);
        }
        ArrayList<AppletSysStoreBo> appletSysStoreBoList = new ArrayList<AppletSysStoreBo>();
        appletSysStoreBoList.addAll(appletSysStoreBos);
        appletSysStoreBoList.addAll(sysStoreBos);
        appletRefreshtoInterfaceBo.setAppletSysStoreBos(appletSysStoreBoList);
        logger.info("\u95e8\u5e97\u5bfc\u822a\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)appletRefreshtoInterfaceBo));
        responseData.setData((Object)appletRefreshtoInterfaceBo);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData choosingStore(Long storeId, String memberCode) {
        return this.wxAppletApiService.updateOpenCardStoreIdByMemberCode(storeId, memberCode);
    }
}

