/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.interfaces.UnionPayService;
import com.bizvane.appletservice.models.vo.CreateRechargeVO;
import com.bizvane.appletservice.models.vo.UnionPayCallBackVO;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.MbrRechargeServiceRpc;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import java.math.BigDecimal;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/unionPay"})
public class UnionPayController {
    private static final Logger log = LoggerFactory.getLogger(UnionPayController.class);
    @Autowired
    private UnionPayService unionPayService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    BrandServiceRpc brandServiceRpc;
    @Autowired
    private MbrRechargeServiceRpc mbrRechargeServiceRpc;
    @Value(value="${unionPay.brands}")
    private String unionPayBrands;
    public static final String UUIDSIGN = "a4ad8ac4-4051-4659-9bb9-17f8ebc65f3d";

    @PostMapping(value={"/queryNewPayMethod"})
    public ResponseData<Boolean> queryNewPayMethod(HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String sysBrandId = request.getHeader("sysBrandId");
        String[] brands = this.unionPayBrands.split(",");
        responseData.setData((Object)Arrays.asList(brands).contains(sysBrandId));
        return responseData;
    }

    @PostMapping(value={"/createRechargeOrder"})
    public ResponseData createRechargeOrder(@RequestBody CreateRechargeVO vo, HttpServletRequest request) {
        log.info("createRechargeOrder vo:{}", JSONObject.toJSON((Object)vo));
        ResponseData responseData = new ResponseData();
        String sysBrandId = request.getHeader("sysBrandId");
        if (StringUtils.isBlank((CharSequence)sysBrandId)) {
            responseData.setCode(100);
            responseData.setMessage("\u83b7\u53d6\u54c1\u724cid\u9519\u8bef");
            return responseData;
        }
        String uid = (String)this.redisTemplateService.stringGetStringByKey((Object)vo.getSign().toUpperCase());
        if (!UUIDSIGN.equals(uid)) {
            responseData.setCode(100);
            responseData.setMessage("\u7b7e\u540d\u5f02\u5e38");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u65e0bizvaneSessionId");
            responseData.setCode(100);
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)vo.getMoney()) || new BigDecimal(vo.getMoney()).compareTo(new BigDecimal("0")) <= 0) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u6b63\u786e\u91d1\u989d");
            responseData.setCode(100);
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        memberInfoModel.setBrandId(Long.valueOf(sysBrandId));
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        MemberInfoModel model = (MemberInfoModel)singleMemberModel.getData();
        if (model == null) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        String appId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        vo.setOpenid(openId);
        vo.setAppId(appId);
        vo.setMemberCode(memberCode);
        ResponseData brandResp = this.brandServiceRpc.getBrandByID(Long.valueOf(sysBrandId));
        if (brandResp.getCode() == SysResponseEnum.FAILED.getCode() || brandResp.getData() == null) {
            responseData.setMessage("\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u5931\u8d25");
            responseData.setCode(-100);
            return responseData;
        }
        SysBrandPo brandPo = (SysBrandPo)brandResp.getData();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{brandPo.getBizvaneMid(), brandPo.getBizvaneSecretKey()})) {
            responseData.setMessage("\u5546\u6237\u94f6\u8054\u652f\u4ed8\u4fe1\u606f\u672a\u914d\u7f6e");
            responseData.setCode(-100);
            return responseData;
        }
        return this.unionPayService.createRechargeOrder(vo, brandPo, model, appId);
    }

    @PostMapping(value={"/unionRechargeCallBack"})
    public ResponseData<String> unionRechargeCallBack(@RequestBody UnionPayCallBackVO params) {
        log.info("unionRechargeCallBack params:{}", (Object)JSONObject.toJSONString((Object)params));
        ResponseData stringResponseData = new ResponseData();
        try {
            stringResponseData = this.unionPayService.unionRechargeCallBack(params);
        }
        catch (Exception e) {
            log.error("unionRechargeCallBack exception:{}", (Throwable)e);
            stringResponseData.setCode(SysResponseEnum.FAILED.getCode());
            stringResponseData.setMessage(SysResponseEnum.FAILED.getMessage());
            stringResponseData.setData((Object)"FAIL");
        }
        return stringResponseData;
    }
}

