/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.bizvane.appletservice.interfaces.LoginService;
import com.bizvane.appletservice.interfaces.MemberCenterService;
import com.bizvane.appletservice.models.bo.AppletBrandMenberBo;
import com.bizvane.appletservice.models.bo.AppletBtfBo;
import com.bizvane.appletservice.models.bo.MemberResoucreBO;
import com.bizvane.appletservice.models.po.AppletResourcesPO;
import com.bizvane.appletservice.models.vo.MemberBaseInfoVo;
import com.bizvane.centerstageservice.rpc.CenterStageServiceRpc;
import com.bizvane.centerstageservice.rpc.SysVipConfigsApiService;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/memberCenter"})
public class MemberCenterController {
    private static final Logger log = LoggerFactory.getLogger(MemberCenterController.class);
    @Autowired
    private MemberCenterService memberCardService;
    @Autowired
    private CenterStageServiceRpc centerStageServiceRpc;
    @Autowired
    private LoginService loginService;
    @Autowired
    private SysVipConfigsApiService sysVipConfigsApiService;

    @RequestMapping(value={"/getBtfRel"}, method={RequestMethod.POST})
    public ResponseData<AppletBtfBo> getBtfRel(AppletBrandMenberBo appletBrandMenberBo, HttpServletRequest request) {
        return this.memberCardService.getBtfRel(appletBrandMenberBo, request);
    }

    @RequestMapping(value={"/getHomePage"}, method={RequestMethod.POST})
    public ResponseData<AppletBtfBo> getHomePage(AppletBrandMenberBo appletBrandMenberBo, HttpServletRequest request, HttpServletResponse response) {
        return this.memberCardService.getHomePage(appletBrandMenberBo, request, response);
    }

    @RequestMapping(value={"/getSlideImg"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<List<AppletResourcesPO>> getSlideImg(Long sysBrandId, HttpServletRequest request, HttpServletResponse response) {
        return this.memberCardService.getSlideImg(sysBrandId, request, response);
    }

    @RequestMapping(value={"/getTemplateInfo"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<AppletBtfBo> getTemplateInfo(Long sysBrandId, HttpServletRequest request) {
        return this.memberCardService.getTemplateInfo(sysBrandId, request);
    }

    @PostMapping(value={"/getMemberInfo"})
    public ResponseData<MemberBaseInfoVo> getMemberInfo(MemberBaseInfoVo memberBaseInfoVo, HttpServletRequest httpServletRequest) {
        return this.memberCardService.getMemberInfo(memberBaseInfoVo, httpServletRequest);
    }

    @PostMapping(value={"/getVerificationCode"})
    public ResponseData<String> getVerificationCode(@RequestParam(value="petCard") String petCard) {
        return this.centerStageServiceRpc.getVerificationCode(petCard);
    }

    @PostMapping(value={"/processTraceForStore"})
    public ResponseData processTraceForStore(@RequestParam(value="traceId") String traceId, @RequestParam(value="memberCode") String memberCode, HttpServletRequest request) {
        return this.memberCardService.processTraceForStore(traceId, memberCode, request);
    }

    @GetMapping(value={"/getBannerConfig"})
    public ResponseData getBannerConfig() {
        MemberResoucreBO memberResoucreBO = this.loginService.getMemberResourceBO();
        return this.sysVipConfigsApiService.queryBannerConfig(memberResoucreBO.getSysCompanyId(), memberResoucreBO.getBrandId());
    }

    @GetMapping(value={"/getConsumptionInfo"})
    public ResponseData getConsumptionInfo() {
        MemberResoucreBO memberResoucreBO = this.loginService.getMemberResourceBO();
        return this.memberCardService.getConsumptionInfo(memberResoucreBO);
    }
}

