/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.recharge361;

import com.alibaba.fastjson.JSON;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.Recharge361.Recharge361Service;
import com.bizvane.appletservice.models.bo.MbrRechargeRecordBo;
import com.bizvane.appletservice.models.vo.RechargeCard361ResponseVo;
import com.bizvane.appletservice.models.vo.RechargeCardList361ResponseVo;
import com.bizvane.appletservice.models.vo.RechargeRecord361ResponseVo;
import com.bizvane.appletservice.models.vo.RechargeRecordList361ResponseVo;
import com.bizvane.centerstageservice.models.po.MbrRechargeRecordPo;
import com.bizvane.customized.facade.interfaces.Cus361RpcServiceFeign;
import com.bizvane.customized.facade.models.vo.Cus361RechargeCardListResponseVO;
import com.bizvane.customized.facade.models.vo.Cus361RechargeCardVO;
import com.bizvane.customized.facade.models.vo.Cus361RechargeInfoRequestVo;
import com.bizvane.customized.facade.models.vo.Cus361RechargeRecordListResponseVo;
import com.bizvane.customized.facade.models.vo.Cus361RechargeRecordRequestVo;
import com.bizvane.customized.facade.models.vo.Cus361RechargeRecordResponseVo;
import com.bizvane.members.facade.models.MemberCardLevelModel;
import com.bizvane.members.facade.service.api.MemberCardProgramApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Recharge361ServiceImpl
implements Recharge361Service {
    @Autowired
    private MemberCardProgramApiService memberCardProgramApiService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private Cus361RpcServiceFeign cus361RpcServiceFeign;
    public static final Logger logger = LoggerFactory.getLogger(Recharge361ServiceImpl.class);

    public ResponseData<RechargeCardList361ResponseVo> getCardNoRechargeList(MbrRechargeRecordBo mbrRechargeRecordBo, HttpServletRequest request) {
        Integer pageSize;
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        Long brandId = mbrRechargeRecordBo.getSysBrandId();
        if (brandId == null) {
            responseData.setMessage("\u54c1\u724c\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        MemberCardLevelModel memberCardLevelModel = (MemberCardLevelModel)modelResponseData.getData();
        String cardNo = memberCardLevelModel.getCardNo();
        MbrRechargeRecordPo mbrRechargeRecordPo = new MbrRechargeRecordPo();
        mbrRechargeRecordPo.setSysBrandId(mbrRechargeRecordBo.getSysBrandId());
        mbrRechargeRecordPo.setCardNo(cardNo);
        Cus361RechargeInfoRequestVo cus361RechargeInfoRequestVo = new Cus361RechargeInfoRequestVo();
        cus361RechargeInfoRequestVo.setBrandId(brandId);
        cus361RechargeInfoRequestVo.setCardNo(cardNo);
        Integer pageNum = mbrRechargeRecordBo.getPageNum();
        if (pageNum != null) {
            cus361RechargeInfoRequestVo.setPageNum(pageNum.intValue());
        }
        if ((pageSize = mbrRechargeRecordBo.getNum()) != null) {
            cus361RechargeInfoRequestVo.setPageSize(pageSize.intValue());
        }
        cus361RechargeInfoRequestVo.setPetCard(mbrRechargeRecordBo.getPetCard());
        logger.info("\u8c03\u7528getCardNoRechargeList,request:" + JSON.toJSONString((Object)cus361RechargeInfoRequestVo));
        ResponseData cardNoRechargeList = this.cus361RpcServiceFeign.getCardNoRechargeList(cus361RechargeInfoRequestVo);
        logger.info("\u8c03\u7528getCardNoRechargeList,response:" + JSON.toJSONString((Object)cardNoRechargeList));
        if (SysResponseEnum.SUCCESS.getCode() == cardNoRechargeList.getCode()) {
            Cus361RechargeCardListResponseVO list = (Cus361RechargeCardListResponseVO)cardNoRechargeList.getData();
            ArrayList<RechargeCard361ResponseVo> list2 = new ArrayList<RechargeCard361ResponseVo>();
            for (Cus361RechargeCardVO vo : list.getCus361RechargeCardVOList()) {
                RechargeCard361ResponseVo rechargeCard361ResponseVo = new RechargeCard361ResponseVo();
                rechargeCard361ResponseVo.setPetCard(vo.getPetCard());
                rechargeCard361ResponseVo.setBalance(vo.getBalance());
                rechargeCard361ResponseVo.setCardNo(cardNo);
                rechargeCard361ResponseVo.setCountIntegral(vo.getIntegral());
                list2.add(rechargeCard361ResponseVo);
            }
            RechargeCardList361ResponseVo rechargeCardList361ResponseVo = new RechargeCardList361ResponseVo();
            rechargeCardList361ResponseVo.setRechargeCardResponse361VoList(list2);
            responseData.setData((Object)rechargeCardList361ResponseVo);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            logger.info("getCardNoRechargeList,response:" + JSON.toJSONString((Object)responseData));
            return responseData;
        }
        if (SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode() == cardNoRechargeList.getCode()) {
            responseData.setCode(SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode());
            responseData.setMessage(SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getMessage());
            logger.info("getCardNoRechargeList,response:" + JSON.toJSONString((Object)responseData));
        } else {
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            logger.info("getCardNoRechargeList,response:" + JSON.toJSONString((Object)responseData));
        }
        return responseData;
    }

    public ResponseData<RechargeRecordList361ResponseVo> getCardNoRechargeRecordList(MbrRechargeRecordBo mbrRechargeRecordBo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        Long brandId = mbrRechargeRecordBo.getSysBrandId();
        String petCard = mbrRechargeRecordBo.getPetCard();
        if (brandId == null || StringUtils.isBlank((CharSequence)petCard)) {
            responseData.setMessage("\u50a8\u503c\u5361\u53f7\u6216\u54c1\u724c\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        MemberCardLevelModel memberCardLevelModel = (MemberCardLevelModel)modelResponseData.getData();
        String cardNo = memberCardLevelModel.getCardNo();
        Cus361RechargeRecordRequestVo cus361RechargeRecordRequestVo = new Cus361RechargeRecordRequestVo();
        cus361RechargeRecordRequestVo.setBrandId(mbrRechargeRecordBo.getSysBrandId());
        cus361RechargeRecordRequestVo.setPetCard(mbrRechargeRecordBo.getPetCard());
        cus361RechargeRecordRequestVo.setCardNo(cardNo);
        cus361RechargeRecordRequestVo.setNum(mbrRechargeRecordBo.getNum());
        cus361RechargeRecordRequestVo.setPageNum(mbrRechargeRecordBo.getPageNum());
        logger.info("\u8c03\u7528getRechargeRecordListByPetCard,request:" + JSON.toJSONString((Object)cus361RechargeRecordRequestVo));
        ResponseData result = this.cus361RpcServiceFeign.getRechargeRecordListByPetCard(cus361RechargeRecordRequestVo);
        logger.info("\u8c03\u7528getRechargeRecordListByPetCard,response:" + JSON.toJSONString((Object)result));
        if (SysResponseEnum.SUCCESS.getCode() == result.getCode()) {
            RechargeRecordList361ResponseVo rechargeRecordList361ResponseVo = new RechargeRecordList361ResponseVo();
            ArrayList<RechargeRecord361ResponseVo> list = new ArrayList<RechargeRecord361ResponseVo>();
            List cus361RechargeRecordResponseVoList = ((Cus361RechargeRecordListResponseVo)result.getData()).getCus361RechargeRecordResponseVoList();
            for (Cus361RechargeRecordResponseVo vo : cus361RechargeRecordResponseVoList) {
                RechargeRecord361ResponseVo rechargeRecord361ResponseVo = new RechargeRecord361ResponseVo();
                rechargeRecord361ResponseVo.setBalance(vo.getBalance());
                rechargeRecord361ResponseVo.setChangeBalance(vo.getChangeBalance());
                rechargeRecord361ResponseVo.setChangeTime(vo.getChangeTime());
                rechargeRecord361ResponseVo.setChangeType(vo.getMoneyChangeType());
                rechargeRecord361ResponseVo.setPetCard(vo.getPetCard());
                rechargeRecord361ResponseVo.setChangeDesc(vo.getChangeType());
                list.add(rechargeRecord361ResponseVo);
            }
            rechargeRecordList361ResponseVo.setBalance(((Cus361RechargeRecordListResponseVo)result.getData()).getBalance());
            rechargeRecordList361ResponseVo.setCount(((Cus361RechargeRecordListResponseVo)result.getData()).getCount());
            rechargeRecordList361ResponseVo.setCountPage(((Cus361RechargeRecordListResponseVo)result.getData()).getCountPage());
            rechargeRecordList361ResponseVo.setNum(((Cus361RechargeRecordListResponseVo)result.getData()).getNum());
            rechargeRecordList361ResponseVo.setPageNum(((Cus361RechargeRecordListResponseVo)result.getData()).getPageNum());
            rechargeRecordList361ResponseVo.setPetCard(((Cus361RechargeRecordListResponseVo)result.getData()).getPetCard());
            rechargeRecordList361ResponseVo.setRechargeRecord361ResponseVoList(list);
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)rechargeRecordList361ResponseVo);
            logger.info("getCardNoRechargeRecordList,response:" + JSON.toJSONString((Object)responseData));
            return responseData;
        }
        responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        logger.info("getCardNoRechargeRecordList,response:" + JSON.toJSONString((Object)responseData));
        return responseData;
    }
}

