/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers.alipay;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.interfaces.AliPayService;
import com.bizvane.appletservice.models.vo.AlipayCallBackVO;
import com.bizvane.appletservice.models.vo.CreateRechargeVO;
import com.bizvane.appletserviceimpl.utils.MD5Util;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5145\u503c", tags={"\u652f\u4ed8\u5b9d\u5145\u503c"})
@RestController
@RequestMapping(value={"/aliPay"})
public class AliPayController {
    private static final Logger log = LoggerFactory.getLogger(AliPayController.class);
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Value(value="${ur.brandId}")
    private Long brandId;
    @Value(value="${unionPay.brands}")
    private String unionPayBrands;
    @Value(value="${pay.salt}")
    private String paySalt;
    @Autowired
    private AliPayService aliPayService;
    @Autowired
    private BrandServiceRpc brandServiceRpc;

    @PostMapping(value={"/createRechargeOrder"})
    public ResponseData createRechargeOrder(@RequestBody CreateRechargeVO vo, HttpServletRequest request) {
        log.info("createRechargeOrder vo:{}", JSONObject.toJSON((Object)vo));
        ResponseData responseData = new ResponseData();
        String sign = vo.getSign();
        vo.setSign(null);
        String params = com.alibaba.fastjson.JSONObject.toJSONString((Object)vo);
        log.info("createRechargeOrder params:{}", (Object)(params + this.paySalt));
        String check = MD5Util.md5((String)(params + this.paySalt)).toUpperCase();
        log.info("createRechargeNew check:{}", (Object)check);
        if (!sign.equals(check)) {
            responseData.setMessage("\u6076\u610f\u8bbf\u95ee");
            responseData.setCode(100);
            return responseData;
        }
        String sysBrandId = request.getHeader("sysBrandId");
        if (StringUtils.isBlank((CharSequence)sysBrandId)) {
            responseData.setCode(100);
            responseData.setMessage("\u83b7\u53d6\u54c1\u724cid\u9519\u8bef");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u65e0bizvaneSessionId");
            responseData.setCode(100);
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)vo.getMoney()) || new BigDecimal(vo.getMoney()).compareTo(new BigDecimal("0")) <= 0) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u6b63\u786e\u91d1\u989d");
            responseData.setCode(100);
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        memberInfoModel.setBrandId(Long.valueOf(sysBrandId));
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        MemberInfoModel model = (MemberInfoModel)singleMemberModel.getData();
        if (model == null) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        String appId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        String userId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getUserId" + bizvaneSessionId));
        vo.setOpenid(openId);
        vo.setAppId(appId);
        vo.setMemberCode(memberCode);
        vo.setUserId(userId);
        ResponseData brandResp = this.brandServiceRpc.getBrandByID(Long.valueOf(sysBrandId));
        if (brandResp.getCode() == SysResponseEnum.FAILED.getCode() || brandResp.getData() == null) {
            responseData.setMessage("\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u5931\u8d25");
            responseData.setCode(-100);
            return responseData;
        }
        SysBrandPo brandPo = (SysBrandPo)brandResp.getData();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{brandPo.getBizvaneMid(), brandPo.getBizvaneSecretKey()})) {
            responseData.setMessage("\u5546\u6237\u94f6\u8054\u652f\u4ed8\u4fe1\u606f\u672a\u914d\u7f6e");
            responseData.setCode(-100);
            return responseData;
        }
        return this.aliPayService.createRechargeOrder(vo, brandPo, model, appId);
    }

    @PostMapping(value={"/createRechargeNew"})
    public ResponseData createRechargeNew(CreateRechargeVO vo, HttpServletRequest request) {
        log.info("createRechargeOrder vo:{}", JSONObject.toJSON((Object)vo));
        ResponseData responseData = new ResponseData();
        String sign = vo.getSign();
        vo.setSign(null);
        String params = com.alibaba.fastjson.JSONObject.toJSONString((Object)vo);
        log.info("createRechargeOrder params:{}", (Object)(params + this.paySalt));
        String check = MD5Util.md5((String)(params + this.paySalt)).toUpperCase();
        log.info("createRechargeNew check:{}", (Object)check);
        if (!sign.equals(check)) {
            responseData.setMessage("\u6076\u610f\u8bbf\u95ee");
            responseData.setCode(100);
            return responseData;
        }
        String sysBrandId = request.getHeader("sysBrandId");
        if (StringUtils.isBlank((CharSequence)sysBrandId)) {
            responseData.setCode(100);
            responseData.setMessage("\u83b7\u53d6\u54c1\u724cid\u9519\u8bef");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u65e0bizvaneSessionId");
            responseData.setCode(100);
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)vo.getMoney()) || new BigDecimal(vo.getMoney()).compareTo(new BigDecimal("0")) <= 0) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u6b63\u786e\u91d1\u989d");
            responseData.setCode(100);
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        memberInfoModel.setBrandId(Long.valueOf(sysBrandId));
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        MemberInfoModel model = (MemberInfoModel)singleMemberModel.getData();
        if (model == null) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        String appId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        String userId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getUserId" + bizvaneSessionId));
        vo.setOpenid(openId);
        vo.setAppId(appId);
        vo.setMemberCode(memberCode);
        vo.setUserId(userId);
        ResponseData brandResp = this.brandServiceRpc.getBrandByID(Long.valueOf(sysBrandId));
        if (brandResp.getCode() == SysResponseEnum.FAILED.getCode() || brandResp.getData() == null) {
            responseData.setMessage("\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u5931\u8d25");
            responseData.setCode(-100);
            return responseData;
        }
        SysBrandPo brandPo = (SysBrandPo)brandResp.getData();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{brandPo.getBizvaneMid(), brandPo.getBizvaneSecretKey()})) {
            responseData.setMessage("\u5546\u6237\u94f6\u8054\u652f\u4ed8\u4fe1\u606f\u672a\u914d\u7f6e");
            responseData.setCode(-100);
            return responseData;
        }
        return this.aliPayService.createRechargeOrder(vo, brandPo, model, appId);
    }

    @PostMapping(value={"/alipayRechargeCallBack"})
    public ResponseData<String> unionRechargeCallBack(@RequestBody AlipayCallBackVO params) {
        log.info("unionRechargeCallBack params:{}", (Object)JacksonUtil.bean2Json((Object)params));
        ResponseData stringResponseData = new ResponseData();
        try {
            stringResponseData = this.aliPayService.alipayRechargeCallBack(params);
        }
        catch (Exception e) {
            log.error("unionRechargeCallBack exception:{}", (Throwable)e);
            stringResponseData.setCode(SysResponseEnum.FAILED.getCode());
            stringResponseData.setMessage(SysResponseEnum.FAILED.getMessage());
            stringResponseData.setData((Object)"FAIL");
        }
        return stringResponseData;
    }

    public static void main(String[] args) {
        String s = "{\"appId\":\"wxdbcca5299c27edff\",\"memberCode\":\"f5baf6778a534fad\",\"openid\":\"o19L94yo8F965Yn7okjtsKzYLXPI\",\"serviceCardDefinitionId\":\"240\",\"sysBrandId\":96,\"sysCompanyId\":3841}";
        String check = MD5Util.md5((String)(s + "1qaz2wsx3edc")).toUpperCase();
        System.out.println(check);
    }
}

