/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.bizvane.appletservice.interfaces.WxPayService;
import com.bizvane.appletservice.models.bo.WxPayLevelBO;
import com.bizvane.appletservice.models.vo.WxPayLevelCardRechargeRequestVO;
import com.bizvane.appletserviceimpl.handler.AppletBizvaneException;
import com.bizvane.appletserviceimpl.utils.WxConfig;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.WxPayConfigPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.MbrRechargeServiceRpc;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MemberLevelApiService;
import com.bizvane.members.facade.vo.PayLevelCardRequestVO;
import com.bizvane.members.facade.vo.PayLevelCardResponseVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import io.jsonwebtoken.lang.Collections;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/payLevelCard"})
public class WxPayLevelCardController {
    private static final Logger log = LoggerFactory.getLogger(WxPayLevelCardController.class);
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private MbrRechargeServiceRpc mbrRechargeServiceRpc;
    @Autowired
    private MemberLevelApiService memberLevelApiService;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private WxConfig wxConfig;
    @Autowired
    private WxPayService wxPayService;

    @PostMapping(value={"/createPayLevelRecharge"})
    public ResponseData<Map<String, String>> createPayLevelRecharge(@RequestBody @Valid WxPayLevelCardRechargeRequestVO rechargeRequestVO, HttpServletRequest request) {
        log.info("enter createPayLevelRecharge rechargeRequestVO:{}", (Object)JacksonUtil.bean2Json((Object)rechargeRequestVO));
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        Long sysBrandId = null;
        Long sysCompanyId = null;
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        String appId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)memberCode)) {
            sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
            sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        }
        ResponseData mapResponseData = new ResponseData();
        MemberInfoModel singleMember = this.queryMemberInfo(memberCode);
        Map levelMap = this.getlevelMap(sysBrandId);
        this.validateStatus(rechargeRequestVO, singleMember, levelMap);
        log.info("singleMemberInfo:{}", (Object)JacksonUtil.bean2Json((Object)singleMember));
        WxPayConfigPo wxPayConfig = this.queryWxPayConfig(sysBrandId, sysCompanyId);
        log.info("wxPayConfig:{}", (Object)JacksonUtil.bean2Json((Object)wxPayConfig));
        MbrLevelModel levelModel = this.queryMbrLevelModel(rechargeRequestVO, levelMap, singleMember);
        WxPayLevelBO wxPayLevelBO = WxPayLevelBO.builder().appId(appId).sysCompanyId(sysCompanyId).sysBrandId(sysBrandId).memberCode(memberCode).merchantNumber(wxPayConfig.getMerchantNumber()).openId(openId).secretKey(wxPayConfig.getSecretKey()).build();
        Map map = this.wxPayService.createPayLevelRecharge(levelModel, wxPayLevelBO);
        log.info("createPayLevelRecharge map:{}", (Object)JacksonUtil.bean2Json((Object)map));
        mapResponseData.setCode(SysResponseEnum.SUCCESS.getCode());
        mapResponseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        mapResponseData.setData((Object)map);
        return mapResponseData;
    }

    @PostMapping(value={"/createPayLevelRechargeNew"})
    public ResponseData<Map<String, String>> createPayLevelRechargeNew(@RequestBody @Valid WxPayLevelCardRechargeRequestVO rechargeRequestVO, HttpServletRequest request) {
        log.info("enter#createPayLevelRechargeNew,rechargeRequestVO:{}", (Object)JacksonUtil.bean2Json((Object)rechargeRequestVO));
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        String appId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        Long sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        Long sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bizvaneSessionId) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)memberCode) || openId == null || appId == null || sysBrandId == null || sysCompanyId == null) {
            log.info("enter#createPayLevelRechargeNew,\u5fc5\u4f20\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7,bizvaneSessionId={},memberCode={},openId={},appId={},sysBrandId={},sysCompanyId={}", new Object[]{bizvaneSessionId, memberCode, openId, appId, sysBrandId, sysCompanyId});
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u5fc5\u4f20\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7");
        }
        MemberInfoModel singleMember = this.queryMemberInfo(memberCode);
        Map levelMap = this.getlevelMap(sysBrandId);
        this.validateStatus(rechargeRequestVO, singleMember, levelMap);
        log.info("singleMemberInfo:{}", (Object)JacksonUtil.bean2Json((Object)singleMember));
        ResponseData sysBrandPoResponseData = this.brandServiceRpc.getBrandByID(sysBrandId);
        if (sysBrandPoResponseData == null || sysBrandPoResponseData.getData() == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((SysBrandPo)sysBrandPoResponseData.getData()).getBizvaneMid()) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((SysBrandPo)sysBrandPoResponseData.getData()).getBizvaneSecretKey())) {
            log.info("brandServiceRpc#getBrandByID,\u83b7\u53d6\u54c1\u724c\u5546\u6237\u53f7\u652f\u4ed8\u4fe1\u606f\u914d\u7f6e\u4e3a\u7a7a,sysBrandId={}", (Object)sysBrandId);
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u83b7\u53d6\u54c1\u724c\u5546\u6237\u53f7\u4fe1\u606f\u4e3a\u7a7a");
        }
        MbrLevelModel levelModel = this.queryMbrLevelModel(rechargeRequestVO, levelMap, singleMember);
        WxPayLevelBO wxPayLevelBO = WxPayLevelBO.builder().appId(appId).sysCompanyId(sysCompanyId).sysBrandId(sysBrandId).memberCode(memberCode).openId(openId).build();
        Map map = this.wxPayService.createPayLevelRechargeNew(levelModel, wxPayLevelBO);
        return null;
    }

    private Map<Long, MbrLevelModel> getlevelMap(Long sysBrandId) {
        ResponseData levelModelResponseData = this.memberLevelApiService.queryAllLevelList(sysBrandId);
        if (levelModelResponseData == null || SysResponseEnum.SUCCESS.getCode() != levelModelResponseData.getCode()) {
            throw new AppletBizvaneException("\u67e5\u8be2\u4ed8\u8d39\u5361\u4fe1\u606f\u5931\u8d25");
        }
        Map<Long, MbrLevelModel> levelMap = ((List)levelModelResponseData.getData()).stream().collect(Collectors.toMap(MbrLevelModel::getMbrLevelId, Function.identity()));
        if (Collections.isEmpty(levelMap)) {
            throw new AppletBizvaneException("\u8bf7\u914d\u7f6e\u4ed8\u8d39\u5361\u63cf\u8ff0\u4fe1\u606f");
        }
        return levelMap;
    }

    private void validateStatus(@RequestBody @Valid WxPayLevelCardRechargeRequestVO rechargeRequestVO, MemberInfoModel singleMember, Map<Long, MbrLevelModel> levelMap) {
        if (rechargeRequestVO.getStatus() != null) {
            if (rechargeRequestVO.getStatus().equals(0) && levelMap.containsKey(singleMember.getLevelId()) && levelMap.get(singleMember.getLevelId()).getPayFlag().equals(1)) {
                throw new AppletBizvaneException("\u5f53\u524d\u4f1a\u5458\u5df2\u7ecf\u662f\u4ed8\u8d39\u4f1a\u5458\u5361\u7b49\u7ea7");
            }
            if (rechargeRequestVO.getStatus().equals(2) && !rechargeRequestVO.getMbrLevelId().equals(singleMember.getLevelId())) {
                throw new AppletBizvaneException("\u7eed\u8d39\u4f1a\u5458\u5361\u7b49\u7ea7\u9a8c\u8bc1\u5931\u8d25");
            }
        }
    }

    private ResponseData<PayLevelCardResponseVO> queryPayLevelCardInfo(Long sysBrandId, Long sysCompanyId) {
        PayLevelCardRequestVO payLevelCardRequestVO = new PayLevelCardRequestVO();
        payLevelCardRequestVO.setSysCompanyId(sysCompanyId);
        payLevelCardRequestVO.setBrandId(sysBrandId);
        return this.memberLevelApiService.queryPayLevelCard(payLevelCardRequestVO);
    }

    private MbrLevelModel queryMbrLimitLevelModel(Long payBuyLimitLevel) {
        ResponseData levelModelResponseData = this.memberLevelApiService.queryLevelModel(payBuyLimitLevel);
        if (levelModelResponseData == null || levelModelResponseData.getData() == null) {
            return null;
        }
        if (SysResponseEnum.SUCCESS.getCode() != levelModelResponseData.getCode()) {
            throw new AppletBizvaneException("\u67e5\u8be2\u4ed8\u8d39\u5361\u4fe1\u606f\u5931\u8d25");
        }
        return (MbrLevelModel)levelModelResponseData.getData();
    }

    private MbrLevelModel queryMbrLevelModel(@RequestBody @Valid WxPayLevelCardRechargeRequestVO rechargeRequestVO, Map<Long, MbrLevelModel> levelMap, MemberInfoModel singleMember) {
        MbrLevelModel levelModel = levelMap.get(rechargeRequestVO.getMbrLevelId());
        if (levelModel.getPayFlag() == null || levelModel.getPayFlag() == 0) {
            throw new AppletBizvaneException("\u8be5\u7b49\u7ea7\u4e0d\u662f\u4ed8\u8d39\u5361\u7b49\u7ea7");
        }
        if (levelModel.getPayMoney() == null || levelModel.getPayMoney().compareTo(new BigDecimal(0)) <= 0) {
            throw new AppletBizvaneException("\u4ed8\u8d39\u5361\u7b49\u7ea7\u914d\u7f6e\u65e0\u6548");
        }
        if (levelModel.getEffectiveYear() == null || levelModel.getEffectiveYear() <= 0) {
            throw new AppletBizvaneException("\u4ed8\u8d39\u5361\u7b49\u7ea7\u6709\u6548\u671f\u65e0\u6548");
        }
        if (levelModel.getLevelChangeType() == null) {
            throw new AppletBizvaneException("\u4ed8\u8d39\u5361\u7b49\u7ea7\u5230\u671f\u540e\u5982\u4f55\u5904\u7406\u65e0\u6548");
        }
        if (levelModel.getPayBuyLimitEnable() == null || !levelModel.getPayBuyLimitEnable().equals(1)) {
            return levelModel;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)levelModel.getPayBuyLimitLevel())) {
            throw new AppletBizvaneException("\u5f53\u524d\u5361\u7b49\u7ea7\u6682\u4e0d\u53ef\u8d2d\u4e70");
        }
        String[] payBuyLimitLevel = StringUtils.commaDelimitedListToStringArray((String)levelModel.getPayBuyLimitLevel());
        List<String> payBuyLevelList = Arrays.asList(payBuyLimitLevel);
        if (!payBuyLevelList.contains(singleMember.getLevelId().toString())) {
            throw new AppletBizvaneException("\u5f53\u524d\u5361\u7b49\u7ea7\u6682\u4e0d\u53ef\u8d2d\u4e70");
        }
        return levelModel;
    }

    private WxPayConfigPo queryWxPayConfig(Long sysBrandId, Long sysCompanyId) {
        WxPayConfigPo po = new WxPayConfigPo();
        po.setSysCompanyId(sysCompanyId);
        po.setSysBrandId(sysBrandId);
        ResponseData payConfigRes = this.mbrRechargeServiceRpc.getWxPayConfigRpc(po);
        if (payConfigRes == null || SysResponseEnum.SUCCESS.getCode() != payConfigRes.getCode() || payConfigRes.getData() == null) {
            throw new AppletBizvaneException("\u5546\u6237\u4fe1\u606f\u65e0\u6548");
        }
        return (WxPayConfigPo)payConfigRes.getData();
    }

    private MemberInfoModel queryMemberInfo(String memberCode) {
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberRes = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        if (singleMemberRes == null || singleMemberRes.getCode() != SysResponseEnum.SUCCESS.getCode() || singleMemberRes.getData() == null) {
            throw new AppletBizvaneException("\u4f1a\u5458\u4fe1\u606f\u65e0\u6548");
        }
        return (MemberInfoModel)singleMemberRes.getData();
    }

    @PostMapping(value={"/payLevelCallBack"})
    public String payLevelCallBack(HttpServletRequest req, HttpServletResponse res) {
        return this.wxPayService.payLevelCallBack(req, res);
    }
}

