/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.SmashingGoldenEggsService;
import com.bizvane.appletserviceimpl.utils.UUIDUtils;
import com.bizvane.mktcenterservice.common.ConvertCouponAndIntegralTypeEnum;
import com.bizvane.mktcenterservice.models.bo.ActivityGoldenStatisticsBo;
import com.bizvane.mktcenterservice.models.bo.MktActivityDetailAndPicture;
import com.bizvane.mktcenterservice.models.po.MktActivityPOWithBLOBs;
import com.bizvane.mktcenterservice.models.po.MktActivityPrizeRecordPO;
import com.bizvane.mktcenterservice.models.vo.ProbabilityVO;
import com.bizvane.mktcenterservice.rpc.ActivityEGServiceRpc;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/smashingGoldenEggs"}, method={RequestMethod.POST})
public class SmashingGoldenEggsController {
    private static final Logger log = LoggerFactory.getLogger(SmashingGoldenEggsController.class);
    @Autowired
    private SmashingGoldenEggsService smashingGoldenEggsService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private ActivityEGServiceRpc activityEGServiceRpc;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/wheelPlanting"}, method={RequestMethod.POST})
    ResponseData<List<MktActivityPrizeRecordPO>> wheelPlanting(MktActivityPrizeRecordPO mktActivityPrizeRecordPO, HttpServletRequest request) {
        List recordeList;
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("bizvaneSessionId={}", (Object)bizvaneSessionId);
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        ResponseData prizeRecords = this.smashingGoldenEggsService.wheelPlanting(mktActivityPrizeRecordPO);
        if (((List)prizeRecords.getData()).size() > 0 && ((List)prizeRecords.getData()).size() >= 20) {
            recordeList = ((List)prizeRecords.getData()).subList(0, 20);
            prizeRecords.setData((Object)recordeList);
        }
        if (((List)prizeRecords.getData()).size() > 0 && ((List)prizeRecords.getData()).size() <= 20) {
            recordeList = (List)prizeRecords.getData();
            prizeRecords.setData((Object)recordeList);
        }
        if (((List)prizeRecords.getData()).size() == 0) {
            prizeRecords.setData(null);
        }
        return prizeRecords;
    }

    @RequestMapping(value={"/records"}, method={RequestMethod.POST})
    ResponseData<List<MktActivityPrizeRecordPO>> records(MktActivityPrizeRecordPO mktActivityPrizeRecordPO, HttpServletRequest request) {
        log.info("records \u83b7\u53d6\u62bd\u5956\u8bb0\u5f55\u5165\u53c2\uff1a{}", (Object)JacksonUtil.bean2Json((Object)mktActivityPrizeRecordPO));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("bizvaneSessionId={}", (Object)bizvaneSessionId);
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        mktActivityPrizeRecordPO.setMemberCode(memberCode);
        ResponseData records = this.smashingGoldenEggsService.records(mktActivityPrizeRecordPO);
        log.info("records \u83b7\u53d6\u62bd\u5956\u8bb0\u5f55\u51fa\u53c2\uff1a{}", (Object)JacksonUtil.bean2Json((Object)records));
        return records;
    }

    @RequestMapping(value={"/details"}, method={RequestMethod.POST})
    ResponseData<MktActivityPOWithBLOBs> details(ProbabilityVO probabilityVO, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("bizvaneSessionId={}", (Object)bizvaneSessionId);
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        logger.info("details getMktActivityBO2C memberCode = {}", (Object)memberCode);
        if (StringUtils.isEmpty((CharSequence)bizvaneSessionId) || StringUtils.isEmpty((CharSequence)memberCode)) {
            String uuid = UUIDUtils.getUUID();
            logger.info("uuid={}", (Object)uuid);
            JSONObject jsonObject = new JSONObject();
            String integralType = ConvertCouponAndIntegralTypeEnum.getConvertCouponAndIntegralTypeEnumByCode((int)probabilityVO.getActivityType()).getIntegralType();
            logger.info("details+activityCode={}", (Object)integralType);
            jsonObject.put("activityType", (Object)integralType);
            jsonObject.put("mktActivityId", (Object)probabilityVO.getMktActivityId());
            this.redisTemplateService.stringSetValueAndExpireTime((Object)uuid, (Object)jsonObject.toString(), 86400000L);
            JSONObject jsonObject1 = new JSONObject();
            if (probabilityVO.getActivityType() != 3) {
                String getStringByKey = (String)this.redisTemplateService.stringGetStringByKey((Object)uuid);
                logger.info("getStringByKey+UUID={}", (Object)getStringByKey);
                jsonObject1.put("uuid", (Object)uuid);
            }
            MktActivityDetailAndPicture mktActivityDetailAndPicture = (MktActivityDetailAndPicture)this.activityEGServiceRpc.getMktActivityBO2C(probabilityVO).getData();
            Integer activityType = mktActivityDetailAndPicture.getActivityType();
            jsonObject1.put("activityType", (Object)activityType);
            if (probabilityVO.getActivityType() != 3) {
                jsonObject1.put("mktTraceId", (Object)mktActivityDetailAndPicture.getMktTraceId());
            }
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            responseData.setData((Object)jsonObject1);
            return responseData;
        }
        probabilityVO.setMemberCode(memberCode);
        return this.smashingGoldenEggsService.details(probabilityVO);
    }

    @RequestMapping(value={"/smashEggs"}, method={RequestMethod.POST})
    public ResponseData smashEggs(ProbabilityVO probabilityVO, HttpServletRequest request) throws ParseException, IOException {
        log.info("\u62bd\u5956\u6d3b\u52a8\u5165\u53c2\uff1a{}", (Object)JacksonUtil.bean2Json((Object)probabilityVO));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("bizvaneSessionId={}", (Object)bizvaneSessionId);
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            memberCode = probabilityVO.getMemberCode();
        }
        this.redisTemplateService.stringSetString((Object)(bizvaneSessionId + "memberCode"), (Object)memberCode);
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        probabilityVO.setMemberCode(memberCode);
        ResponseData result = this.smashingGoldenEggsService.smashEggs(probabilityVO);
        log.info("\u62bd\u5956\u6d3b\u52a8\u51fa\u53c2\uff1a{}", (Object)JacksonUtil.bean2Json((Object)result));
        return result;
    }

    @RequestMapping(value={"/share"}, method={RequestMethod.POST})
    ResponseData<Map<String, Integer>> share(ProbabilityVO probabilityVO, HttpServletRequest request) throws ParseException {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("bizvaneSessionId={}", (Object)bizvaneSessionId);
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        probabilityVO.setMemberCode(memberCode);
        return this.smashingGoldenEggsService.share(probabilityVO);
    }

    @RequestMapping(value={"/openShare"}, method={RequestMethod.POST})
    ResponseData<Integer> openShare(ActivityGoldenStatisticsBo goldenStatisticsBo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        this.smashingGoldenEggsService.openShare(goldenStatisticsBo);
        return responseData;
    }
}

