/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.LoginService;
import com.bizvane.appletservice.interfaces.MenberCenterPersonalService;
import com.bizvane.appletservice.models.bo.AppletBrandMenberBo;
import com.bizvane.appletservice.models.bo.UserAddressBO;
import com.bizvane.appletserviceimpl.constant.EditConstant;
import com.bizvane.appletserviceimpl.utils.HttpClient;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.members.facade.vo.ExtendPropertyFormVO;
import com.bizvane.members.facade.vo.ExtendPropertySingleVO;
import com.bizvane.members.facade.vo.ExtendPropertyValueVO;
import com.bizvane.members.facade.vo.PersonalDataVo;
import com.bizvane.mktcenterservice.models.bo.TaskDetailBO;
import com.bizvane.mktcenterservice.models.vo.ProfileSuccessVO;
import com.bizvane.mktcenterservice.rpc.TaskProfileServiceRpc;
import com.bizvane.unifiedreg.rpc.AppletServiceFeign;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/menberCenterPersonal"})
public class MenberCenterPersonalController {
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private AppletServiceFeign appletServiceFeign;
    @Autowired
    private LoginService loginService;
    @Autowired
    private MenberCenterPersonalService menberCenterPersonalService;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private TaskProfileServiceRpc taskProfileServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    HttpClient httpClient;
    @Value(value="${admin.mall.userAddress.domain}")
    private String domain;
    private final String methodName = "/getDefault?mbrMemberId=";
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/getBaseAndExtendPropertyValue"}, method={RequestMethod.POST})
    public ResponseData getBaseAndExtendPropertyValue(MemberInfoModel memberInfoModel, String mktTaskId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        if (memberInfoModel.getBrandId() == null) {
            responseData.setMessage("\u54c1\u724c\u7f16\u53f7\u672a\u83b7\u53d6");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("\u83b7\u53d6\u5230\u7684bizvaneSessionId --------------- = {}", (Object)bizvaneSessionId);
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u672a\u83b7\u53d6bizvaneSessionId");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        logger.info("\u83b7\u53d6\u5230\u7684memberCode --------------- = {}", (Object)bizvaneSessionId);
        logger.info("\u67e5\u8be2memberCode \u7684key\u503c --------------- = {}", (Object)(bizvaneSessionId + "memberCode"));
        memberInfoModel.setMemberCode(memberCode);
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        logger.info("\u4e2a\u4eba\u8d44\u6599\u5165\u53c2={}", (Object)JSON.toJSONString((Object)memberInfoModel));
        ResponseData baseAndExtendPropertyValue = this.wxAppletApiService.getBaseAndExtendPropertyValue(memberInfoModel);
        logger.info("\u4e2a\u4eba\u8d44\u6599\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)baseAndExtendPropertyValue));
        if (baseAndExtendPropertyValue.getData() == null || baseAndExtendPropertyValue == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u4e2a\u4eba\u8d44\u6599\u51fa\u73b0\u95ee\u9898");
            return responseData;
        }
        if (mktTaskId == null) {
            mktTaskId = "0";
        }
        this.redisTemplateService.stringSetString((Object)(bizvaneSessionId + "mktTaskId"), (Object)mktTaskId);
        AppletBrandMenberBo appletBrandMenberBo = new AppletBrandMenberBo();
        appletBrandMenberBo.setSysBrandId(memberInfoModel.getBrandId());
        appletBrandMenberBo.setMemberCode(memberInfoModel.getMemberCode());
        PersonalDataVo data = (PersonalDataVo)baseAndExtendPropertyValue.getData();
        MemberInfoModel infoModel = new MemberInfoModel();
        infoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(infoModel);
        MemberInfoModel memberModelData = (MemberInfoModel)singleMemberModel.getData();
        ProfileSuccessVO profileSuccessVO = new ProfileSuccessVO();
        profileSuccessVO.setSysBrandId(memberModelData.getBrandId());
        profileSuccessVO.setSysCompanyId(memberModelData.getSysCompanyId());
        profileSuccessVO.setServiceStoreId(memberModelData.getServiceStoreId());
        ResponseData taskProfileListApp = this.taskProfileServiceRpc.getTaskProfileListApp(profileSuccessVO);
        logger.info("\u4efb\u52a1\u95e8\u5e97\u8fd4\u56de\u6570\u636e={}", (Object)JSON.toJSONString((Object)taskProfileListApp));
        List listAppData = (List)taskProfileListApp.getData();
        List base = data.getBase();
        List extend = data.getExtend();
        for (ExtendPropertyValueVO extendPropertyValueVO : base) {
            String propertyValue;
            JSONObject jsonValue;
            String name;
            String propertyValue2;
            extendPropertyValueVO.setPerfectFieldTask("0");
            if (extendPropertyValueVO.getPropertyCode().indexOf("gender_") != -1 && StringUtils.isNotBlank((CharSequence)(propertyValue2 = extendPropertyValueVO.getPropertyValue())) && "3".equals(propertyValue2)) {
                extendPropertyValueVO.setPropertyValue("");
            }
            if (extendPropertyValueVO.getPropertyCode().indexOf("opencard_") != -1 && StringUtils.isNotBlank((CharSequence)extendPropertyValueVO.getStatus()) && "1".equals(extendPropertyValueVO.getStatus()) && StringUtils.isNotBlank((CharSequence)extendPropertyValueVO.getPropertyValue())) {
                extendPropertyValueVO.setEdit("1");
            }
            if (EditConstant.PROP_LIST.contains(name = extendPropertyValueVO.getPropertyName())) {
                extendPropertyValueVO.setEdit("3");
                extendPropertyValueVO.setRequired("3");
            }
            String code = extendPropertyValueVO.getPropertyCode();
            if (listAppData.size() > 0) {
                for (TaskDetailBO taskDetailBO : listAppData) {
                    String[] split;
                    String propertyCode = taskDetailBO.getPropertyCode();
                    if (!StringUtils.isNotBlank((CharSequence)propertyCode)) continue;
                    for (String splitList : split = propertyCode.split(",")) {
                        logger.info("propertyCode={},code={}", (Object)splitList, (Object)code);
                        if (!splitList.equals(code)) continue;
                        extendPropertyValueVO.setPerfectFieldTask("1");
                    }
                }
            }
            if (!extendPropertyValueVO.getPropertyCode().startsWith("addresses_") || !this.checkAddressesIsNull(jsonValue = JSONObject.parseObject((String)(propertyValue = extendPropertyValueVO.getPropertyValue())))) continue;
            logger.info("\u8c03\u7528\u5fae\u5546\u57ce\u67e5\u8be2\u9ed8\u8ba4\u5730\u5740 getUserAddress mbrMemberId:{}", (Object)memberModelData.getMbrMemberId());
            JSONObject paramJson = new JSONObject();
            paramJson.put("mbrMemberId", (Object)memberModelData.getMbrMemberId());
            try {
                String res = this.httpClient.doPostJson(this.domain + "/getDefault?mbrMemberId=" + memberModelData.getMbrMemberId(), paramJson.toJSONString());
                logger.info("\u8c03\u7528\u5fae\u5546\u57ce\u67e5\u8be2\u9ed8\u8ba4\u5730\u5740 \u8fd4\u56de:{}", (Object)res);
                JSONObject jsonObject = JSONObject.parseObject((String)res);
                UserAddressBO userAddressBO = (UserAddressBO)JSONObject.parseObject((String)String.valueOf(jsonObject.get((Object)"data")), UserAddressBO.class);
                jsonValue.put("address", (Object)userAddressBO.getAddress());
                jsonValue.put("province", (Object)userAddressBO.getProvince());
                jsonValue.put("city", (Object)userAddressBO.getCity());
                jsonValue.put("county", (Object)userAddressBO.getDistrict());
                logger.info("\u8c03\u7528\u5fae\u5546\u57ce\u67e5\u8be2\u9ed8\u8ba4\u5730\u5740\u7ec4\u88c5\u540ejson:{}", (Object)jsonValue.toJSONString());
                extendPropertyValueVO.setPropertyValue(jsonValue.toJSONString());
            }
            catch (Exception e) {
                logger.warn("\u8c03\u7528\u5fae\u5546\u57ce\u67e5\u8be2\u9ed8\u8ba4\u5730\u5740\u5f02\u5e38" + e);
                e.printStackTrace();
            }
        }
        for (ExtendPropertyValueVO extendPropertyValueVO : extend) {
            extendPropertyValueVO.setPerfectFieldTask("0");
            String code = extendPropertyValueVO.getPropertyCode();
            if (listAppData.size() <= 0) continue;
            for (TaskDetailBO taskDetailBO : listAppData) {
                String[] split;
                String propertyCode = taskDetailBO.getPropertyCode();
                if (!StringUtils.isNotBlank((CharSequence)propertyCode)) continue;
                for (String splitList : split = propertyCode.split(",")) {
                    logger.info("propertyCode={},code={}", (Object)splitList, (Object)code);
                    if (!splitList.equals(code)) continue;
                    extendPropertyValueVO.setPerfectFieldTask("1");
                }
            }
        }
        this.menberCenterPersonalService.designatedPerfectData(appletBrandMenberBo, bizvaneSessionId);
        logger.info("\u4e2a\u4eba\u8d44\u6599\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)data));
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)data);
        return responseData;
    }

    private boolean checkAddressesIsNull(JSONObject jsonValue) {
        if (jsonValue.get((Object)"address") != null && StringUtils.isNotEmpty((CharSequence)jsonValue.get((Object)"address").toString())) {
            return false;
        }
        if (jsonValue.get((Object)"province") != null && StringUtils.isNotEmpty((CharSequence)jsonValue.get((Object)"province").toString())) {
            return false;
        }
        if (jsonValue.get((Object)"city") != null && StringUtils.isNotEmpty((CharSequence)jsonValue.get((Object)"city").toString())) {
            return false;
        }
        return jsonValue.get((Object)"county") == null || !StringUtils.isNotEmpty((CharSequence)jsonValue.get((Object)"county").toString());
    }

    @RequestMapping(value={"/updateBaseAndExtendPropertyValue"}, method={RequestMethod.POST})
    public ResponseData<MemberInfoModel> updateBaseAndExtendPropertyValue(ExtendPropertyValueVO extendPropertyValueVO, String code, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        logger.info("\u66f4\u6539\u4e2a\u4eba\u8d44\u6599\u5165\u53c2={}", (Object)JSON.toJSONString((Object)extendPropertyValueVO));
        logger.info("\u5165\u53c2code={}", (Object)code);
        String appid = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        ResponseData wxPublicPOByAppId = this.wxPublicServiceFeign.getWxPublicPOByAppId(appid);
        Long sysBrandId = ((WxPublicPO)wxPublicPOByAppId.getData()).getSysBrandId();
        Long sysCompanyId = ((WxPublicPO)wxPublicPOByAppId.getData()).getSysCompanyId();
        String pName = extendPropertyValueVO.getPropertyName();
        logger.info("extendPropertyValueVO.getPropertyValue()={}", (Object)extendPropertyValueVO.getPropertyValue());
        String redisCode = (String)this.redisTemplateService.stringGetStringByKey((Object)extendPropertyValueVO.getPropertyValue());
        if ("\u624b\u673a".equals(pName) && !code.equals(redisCode)) {
            responseData.setMessage("\u9a8c\u8bc1\u7801\u8d85\u65f6\u6216\u8005\u8f93\u5165\u9519\u8bef");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        extendPropertyValueVO.setMemberCode(memberCode);
        extendPropertyValueVO.setBrandId(sysBrandId);
        extendPropertyValueVO.setSysCompanyId(sysCompanyId);
        ResponseData extendPropertyValue = this.wxAppletApiService.updateBaseAndExtendPropertyValue(extendPropertyValueVO);
        if (extendPropertyValue.getCode() == 0) {
            AppletBrandMenberBo appletBrandMenberBo = new AppletBrandMenberBo();
            appletBrandMenberBo.setMemberCode(memberCode);
            appletBrandMenberBo.setSysBrandId(sysBrandId);
            appletBrandMenberBo.setPropertyCode(extendPropertyValueVO.getPropertyCode());
            if (sysCompanyId != null) {
                appletBrandMenberBo.setSysCompanyId(sysCompanyId);
            }
            this.menberCenterPersonalService.designatedPerfectData(appletBrandMenberBo, bizvaneSessionId);
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            return responseData;
        }
        responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        return responseData;
    }

    @RequestMapping(value={"/updatePropertyValueForm"}, method={RequestMethod.POST})
    public ResponseData<MemberInfoModel> updatePropertyValueForm(String extendPropertySingleVOList, HttpServletRequest request) {
        ExtendPropertyFormVO extendPropertyFormVO = new ExtendPropertyFormVO();
        List eList = JSONObject.parseArray((String)extendPropertySingleVOList, ExtendPropertySingleVO.class);
        logger.info("\u89e3\u6790\u540e\u7684list = {}", (Object)JSON.toJSONString((Object)eList));
        extendPropertyFormVO.setExtendPropertySingleVOList(eList);
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        logger.info("\u66f4\u6539\u4e2a\u4eba\u8d44\u6599\u5165\u53c2\uff08\u591a\u9879\uff09={}", (Object)JSON.toJSONString((Object)extendPropertyFormVO));
        String appid = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        ResponseData wxPublicPOByAppId = this.wxPublicServiceFeign.getWxPublicPOByAppId(appid);
        Long sysBrandId = ((WxPublicPO)wxPublicPOByAppId.getData()).getSysBrandId();
        Long sysCompanyId = ((WxPublicPO)wxPublicPOByAppId.getData()).getSysCompanyId();
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        logger.info("\u66f4\u6539\u4e2a\u4eba\u8d44\u6599\u5165\u53c2\uff08\u591a\u9879\uff09#memberCode:{}", (Object)memberCode);
        extendPropertyFormVO.setBrandId(sysBrandId);
        extendPropertyFormVO.setSysCompanyId(sysCompanyId);
        extendPropertyFormVO.setMemberCode(memberCode);
        StringBuilder code = new StringBuilder();
        for (ExtendPropertySingleVO e : eList) {
            if (!StringUtils.isNotEmpty((CharSequence)e.getPropertyValue())) continue;
            code.append(",").append(e.getPropertyCode());
        }
        String propertyCode = code.substring(1, code.length());
        ResponseData updatePropertyValueForm = this.wxAppletApiService.updatePropertyValueForm(extendPropertyFormVO);
        logger.info("wxAppletApiService#updatePropertyValueForm() result:{}", (Object)JSONObject.toJSONString((Object)updatePropertyValueForm));
        if (updatePropertyValueForm.getCode() == 0) {
            AppletBrandMenberBo appletBrandMenberBo = new AppletBrandMenberBo();
            appletBrandMenberBo.setMemberCode(memberCode);
            appletBrandMenberBo.setSysBrandId(sysBrandId);
            if (sysCompanyId != null) {
                appletBrandMenberBo.setSysCompanyId(sysCompanyId);
            }
            appletBrandMenberBo.setPropertyCode(propertyCode);
            this.menberCenterPersonalService.designatedPerfectData(appletBrandMenberBo, bizvaneSessionId);
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            return responseData;
        }
        responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        return responseData;
    }

    @RequestMapping(value={"/sendVerificationCode"})
    public ResponseData<Integer> sendVerificationCode(String areaCode, String phone, String sign, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("bizvaneSessionId\u6ca1\u6709");
            responseData.setCode(100);
            return responseData;
        }
        String sysBrandId = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "sysBrandId"));
        return this.loginService.sendVerificationCode(sign, "a4ad8ac4-4051-4659-9bb9-17f8ebc65f3d", phone, sysBrandId, areaCode);
    }

    @RequestMapping(value={"/doAwardInvite"})
    public void doAwardInvite(ProfileSuccessVO profileSuccessVO) {
        this.menberCenterPersonalService.doAwardInvite(profileSuccessVO);
    }

    @RequestMapping(value={"/validatePhone"})
    public ResponseData<Integer> validatePhone(String phone, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (StringUtils.isEmpty((CharSequence)phone)) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        MemberInfoModel member = (MemberInfoModel)singleMemberModel.getData();
        logger.info("\u7528\u6237\u4fe1\u606f={}", (Object)JSON.toJSONString((Object)member));
        if (phone.equals(member.getPhone())) {
            responseData.setMessage("\u624b\u673a\u53f7\u4e00\u81f4\u65e0\u9700\u4fee\u6539");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        ResponseData existsPhone = this.wxAppletApiService.existsPhone(member.getBrandId(), phone);
        Boolean flag = (Boolean)existsPhone.getData();
        if (flag.booleanValue()) {
            responseData.setMessage("\u8be5\u624b\u673a\u53f7\u5df2\u5b58\u5728");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    @RequestMapping(value={"/memberIsHaveUnfilledProperty"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<Boolean> memberIsHaveUnfilledProperty(String memberCode, Long sysBrandId) {
        logger.info("memberIsHaveUnfilledProperty memberCode:{},sysBrandId:{}", (Object)memberCode, (Object)sysBrandId);
        ResponseData responseData = this.appletServiceFeign.memberIsHaveUnfilledProperty(memberCode, sysBrandId);
        if (responseData.getCode() == SysResponseEnum.FAILED.getCode()) {
            logger.info("memberIsHaveUnfilledProperty\u67e5\u8be2\u51fa\u9519");
        }
        return responseData;
    }

    @RequestMapping(value={"/sendVerificationEmail"}, method={RequestMethod.POST})
    public ResponseData sendVerificationEmail(String memberCode, Long sysCompanyId, Long sysBrandId, String email) {
        logger.info("sendVerificationEmail memberCode:{},sysBrandId:{},sysCompanyId:{},email:{}", new Object[]{memberCode, sysBrandId, sysCompanyId, email});
        return this.wxAppletApiService.sendVerificationEmail(memberCode, sysCompanyId, sysBrandId, email);
    }
}

