/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.IntegrationShopService;
import com.bizvane.appletservice.interfaces.MemberOpenCardStoreService;
import com.bizvane.appletservice.models.vo.MemberOpenCardStoreVo;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/memberOpenCardStore"}, method={RequestMethod.POST})
public class MemberOpenCardStoreController {
    @Autowired
    private MemberOpenCardStoreService memberOpenCardStoreService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    @Autowired
    private IntegrationShopService integrationShopService;

    @RequestMapping(value={"/searchStores"}, method={RequestMethod.POST})
    public ResponseData searchStores(MemberOpenCardStoreVo memberOpenCardStoreVo, HttpServletRequest request) throws Exception {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        ResponseData configData = this.integrationShopService.getConfig(Integer.valueOf(memberOpenCardStoreVo.getSysBrandId().intValue()));
        logger.info("\u6240\u83b7\u53d6\u7684\u914d\u7f6e:{}", (Object)JSONObject.toJSONString((Object)configData));
        Object data = configData.getData();
        JSONObject json = (JSONObject)JSON.toJSON((Object)data);
        String isWhole = json.getString("isWholeStore");
        memberOpenCardStoreVo.setIsWholeStore(Integer.valueOf(Integer.parseInt(isWhole)));
        memberOpenCardStoreVo.setMemberCode(memberCode);
        logger.info("\u67e5\u8be2\u95e8\u5e97memberOpenCardStoreVo={}", (Object)JSON.toJSONString((Object)memberOpenCardStoreVo));
        return this.memberOpenCardStoreService.searchStores(memberOpenCardStoreVo);
    }

    @RequestMapping(value={"/searchStoresByMemberCode"}, method={RequestMethod.POST})
    public ResponseData searchStoresByMemberCode(@RequestBody MemberOpenCardStoreVo memberOpenCardStoreVo, HttpServletRequest request) {
        logger.info("\u67e5\u8be2\u95e8\u5e97memberOpenCardStoreVo={}", (Object)JSON.toJSONString((Object)memberOpenCardStoreVo));
        return this.memberOpenCardStoreService.searchStores(memberOpenCardStoreVo);
    }

    @RequestMapping(value={"/choosingStore"}, method={RequestMethod.POST})
    public ResponseData choosingStore(Long storeId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        logger.info("\u66f4\u6539\u95e8\u5e97={}", (Object)JSON.toJSONString((Object)storeId));
        return this.memberOpenCardStoreService.choosingStore(storeId, memberCode);
    }
}

